/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import androidx.annotation.Nullable;
import com.mixpanel.android.util.MPLog;
import com.mixpanel.android.util.OfflineMode;
import com.mixpanel.android.util.ProxyServerInteractor;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public class MPConfig {
    public static final String VERSION = "8.2.4";
    public static boolean DEBUG = false;
    static final String REFERRER_PREFS_NAME = "com.mixpanel.android.mpmetrics.ReferralInfo";
    private final int mBulkUploadLimit;
    private final int mFlushInterval;
    private final boolean mFlushOnBackground;
    private final long mDataExpiration;
    private final int mMinimumDatabaseLimit;
    private int mMaximumDatabaseLimit;
    private String mInstanceName;
    private final boolean mDisableAppOpenEvent;
    private final boolean mDisableExceptionHandler;
    private boolean mTrackAutomaticEvents;
    private String mEventsEndpoint;
    private String mPeopleEndpoint;
    private String mGroupsEndpoint;
    private String mFlagsEndpoint;
    private int mFlushBatchSize;
    private boolean shouldGzipRequestPayload;
    private final String mResourcePackageName;
    private final int mMinSessionDuration;
    private final int mSessionTimeoutDuration;
    private boolean mUseIpAddressForGeolocation;
    private final boolean mRemoveLegacyResidualFiles;
    private String mBackupHost;
    private SSLSocketFactory mSSLSocketFactory;
    private OfflineMode mOfflineMode;
    private ProxyServerInteractor serverCallbacks;
    private static final String LOGTAG = "MixpanelAPI.Conf";

    public static MPConfig getInstance(Context context, @Nullable String instanceName) {
        return MPConfig.readConfig(context.getApplicationContext(), instanceName);
    }

    public synchronized void setSSLSocketFactory(SSLSocketFactory factory) {
        this.mSSLSocketFactory = factory;
    }

    public synchronized void setOfflineMode(OfflineMode offlineMode) {
        this.mOfflineMode = offlineMode;
    }

    MPConfig(Bundle metaData, Context context, String instanceName) {
        long dataExpirationLong;
        block17: {
            SSLSocketFactory foundSSLFactory;
            this.mTrackAutomaticEvents = true;
            this.serverCallbacks = null;
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, null, null);
                foundSSLFactory = sslContext.getSocketFactory();
            }
            catch (GeneralSecurityException e) {
                MPLog.i(LOGTAG, "System has no SSL support. Built-in events editor will not be available", e);
                foundSSLFactory = null;
            }
            this.mSSLSocketFactory = foundSSLFactory;
            this.mInstanceName = instanceName;
            DEBUG = metaData.getBoolean("com.mixpanel.android.MPConfig.EnableDebugLogging", false);
            if (DEBUG) {
                MPLog.setLevel(2);
            }
            if (metaData.containsKey("com.mixpanel.android.MPConfig.DebugFlushInterval")) {
                MPLog.w(LOGTAG, "We do not support com.mixpanel.android.MPConfig.DebugFlushInterval anymore. There will only be one flush interval. Please, update your AndroidManifest.xml.");
            }
            this.mBulkUploadLimit = metaData.getInt("com.mixpanel.android.MPConfig.BulkUploadLimit", 40);
            this.mFlushInterval = metaData.getInt("com.mixpanel.android.MPConfig.FlushInterval", 60000);
            this.mFlushBatchSize = metaData.getInt("com.mixpanel.android.MPConfig.FlushBatchSize", 50);
            this.shouldGzipRequestPayload = metaData.getBoolean("com.mixpanel.android.MPConfig.GzipRequestPayload", false);
            this.mFlushOnBackground = metaData.getBoolean("com.mixpanel.android.MPConfig.FlushOnBackground", true);
            this.mMinimumDatabaseLimit = metaData.getInt("com.mixpanel.android.MPConfig.MinimumDatabaseLimit", 0x1400000);
            this.mMaximumDatabaseLimit = metaData.getInt("com.mixpanel.android.MPConfig.MaximumDatabaseLimit", Integer.MAX_VALUE);
            this.mResourcePackageName = metaData.getString("com.mixpanel.android.MPConfig.ResourcePackageName");
            this.mDisableAppOpenEvent = metaData.getBoolean("com.mixpanel.android.MPConfig.DisableAppOpenEvent", true);
            this.mDisableExceptionHandler = metaData.getBoolean("com.mixpanel.android.MPConfig.DisableExceptionHandler", false);
            this.mMinSessionDuration = metaData.getInt("com.mixpanel.android.MPConfig.MinimumSessionDuration", 10000);
            this.mSessionTimeoutDuration = metaData.getInt("com.mixpanel.android.MPConfig.SessionTimeoutDuration", Integer.MAX_VALUE);
            this.mUseIpAddressForGeolocation = metaData.getBoolean("com.mixpanel.android.MPConfig.UseIpAddressForGeolocation", true);
            this.mRemoveLegacyResidualFiles = metaData.getBoolean("com.mixpanel.android.MPConfig.RemoveLegacyResidualFiles", false);
            Object dataExpirationMetaData = metaData.get("com.mixpanel.android.MPConfig.DataExpiration");
            dataExpirationLong = 432000000L;
            if (dataExpirationMetaData != null) {
                try {
                    if (dataExpirationMetaData instanceof Integer) {
                        dataExpirationLong = ((Integer)dataExpirationMetaData).intValue();
                        break block17;
                    }
                    if (dataExpirationMetaData instanceof Float) {
                        dataExpirationLong = (long)((Float)dataExpirationMetaData).floatValue();
                        break block17;
                    }
                    throw new NumberFormatException(dataExpirationMetaData.toString() + " is not a number.");
                }
                catch (Exception e) {
                    MPLog.e(LOGTAG, "Error parsing com.mixpanel.android.MPConfig.DataExpiration meta-data value", e);
                }
            }
        }
        this.mDataExpiration = dataExpirationLong;
        boolean noUseIpAddressForGeolocationSetting = !metaData.containsKey("com.mixpanel.android.MPConfig.UseIpAddressForGeolocation");
        String eventsEndpoint = metaData.getString("com.mixpanel.android.MPConfig.EventsEndpoint");
        if (eventsEndpoint != null) {
            this.setEventsEndpoint(noUseIpAddressForGeolocationSetting ? eventsEndpoint : this.getEndPointWithIpTrackingParam(eventsEndpoint, this.getUseIpAddressForGeolocation()));
        } else {
            this.setEventsEndpointWithBaseURL("https://api.mixpanel.com");
        }
        String peopleEndpoint = metaData.getString("com.mixpanel.android.MPConfig.PeopleEndpoint");
        if (peopleEndpoint != null) {
            this.setPeopleEndpoint(noUseIpAddressForGeolocationSetting ? peopleEndpoint : this.getEndPointWithIpTrackingParam(peopleEndpoint, this.getUseIpAddressForGeolocation()));
        } else {
            this.setPeopleEndpointWithBaseURL("https://api.mixpanel.com");
        }
        String groupsEndpoint = metaData.getString("com.mixpanel.android.MPConfig.GroupsEndpoint");
        if (groupsEndpoint != null) {
            this.setGroupsEndpoint(noUseIpAddressForGeolocationSetting ? groupsEndpoint : this.getEndPointWithIpTrackingParam(groupsEndpoint, this.getUseIpAddressForGeolocation()));
        } else {
            this.setGroupsEndpointWithBaseURL("https://api.mixpanel.com");
        }
        String flagsEndpoint = metaData.getString("com.mixpanel.android.MPConfig.FlagsEndpoint");
        if (flagsEndpoint != null) {
            this.setFlagsEndpoint(flagsEndpoint);
        } else {
            this.setFlagsEndpointWithBaseURL("https://api.mixpanel.com");
        }
        this.mBackupHost = metaData.getString("com.mixpanel.android.MPConfig.BackupHost");
        MPLog.v(LOGTAG, this.toString());
    }

    public int getBulkUploadLimit() {
        return this.mBulkUploadLimit;
    }

    public int getFlushInterval() {
        return this.mFlushInterval;
    }

    public boolean getFlushOnBackground() {
        return this.mFlushOnBackground;
    }

    public int getFlushBatchSize() {
        return this.mFlushBatchSize;
    }

    public void setFlushBatchSize(int flushBatchSize) {
        this.mFlushBatchSize = flushBatchSize;
    }

    public boolean shouldGzipRequestPayload() {
        return this.shouldGzipRequestPayload;
    }

    public void setShouldGzipRequestPayload(Boolean shouldGzip) {
        this.shouldGzipRequestPayload = shouldGzip;
    }

    public long getDataExpiration() {
        return this.mDataExpiration;
    }

    public int getMinimumDatabaseLimit() {
        return this.mMinimumDatabaseLimit;
    }

    public int getMaximumDatabaseLimit() {
        return this.mMaximumDatabaseLimit;
    }

    public void setMaximumDatabaseLimit(int maximumDatabaseLimit) {
        this.mMaximumDatabaseLimit = maximumDatabaseLimit;
    }

    public String getInstanceName() {
        return this.mInstanceName;
    }

    public boolean getDisableAppOpenEvent() {
        return this.mDisableAppOpenEvent;
    }

    public String getEventsEndpoint() {
        return this.mEventsEndpoint;
    }

    public String getBackupHost() {
        return this.mBackupHost;
    }

    public void setBackupHost(String backupHost) {
        this.mBackupHost = backupHost;
    }

    public String getFlagsEndpoint() {
        return this.mFlagsEndpoint;
    }

    public boolean getTrackAutomaticEvents() {
        return this.mTrackAutomaticEvents;
    }

    public void setServerURL(String serverURL, ProxyServerInteractor interactor) {
        this.setServerURL(serverURL);
        this.setProxyServerInteractor(interactor);
    }

    public void setServerURL(String serverURL) {
        this.setEventsEndpointWithBaseURL(serverURL);
        this.setPeopleEndpointWithBaseURL(serverURL);
        this.setGroupsEndpointWithBaseURL(serverURL);
        this.setFlagsEndpointWithBaseURL(serverURL);
    }

    private String getEndPointWithIpTrackingParam(String endPoint, boolean ifUseIpAddressForGeolocation) {
        if (endPoint.contains("?ip=")) {
            return endPoint.substring(0, endPoint.indexOf("?ip=")) + "?ip=" + (ifUseIpAddressForGeolocation ? "1" : "0");
        }
        return endPoint + "?ip=" + (ifUseIpAddressForGeolocation ? "1" : "0");
    }

    private void setEventsEndpointWithBaseURL(String baseURL) {
        this.setEventsEndpoint(this.getEndPointWithIpTrackingParam(baseURL + "/track/", this.getUseIpAddressForGeolocation()));
    }

    private void setEventsEndpoint(String eventsEndpoint) {
        this.mEventsEndpoint = eventsEndpoint;
    }

    public String getPeopleEndpoint() {
        return this.mPeopleEndpoint;
    }

    private void setPeopleEndpointWithBaseURL(String baseURL) {
        this.setPeopleEndpoint(this.getEndPointWithIpTrackingParam(baseURL + "/engage/", this.getUseIpAddressForGeolocation()));
    }

    private void setPeopleEndpoint(String peopleEndpoint) {
        this.mPeopleEndpoint = peopleEndpoint;
    }

    public String getGroupsEndpoint() {
        return this.mGroupsEndpoint;
    }

    private void setGroupsEndpointWithBaseURL(String baseURL) {
        this.setGroupsEndpoint(this.getEndPointWithIpTrackingParam(baseURL + "/groups/", this.getUseIpAddressForGeolocation()));
    }

    private void setGroupsEndpoint(String groupsEndpoint) {
        this.mGroupsEndpoint = groupsEndpoint;
    }

    private void setFlagsEndpointWithBaseURL(String baseURL) {
        this.setFlagsEndpoint(baseURL + "/flags/");
    }

    private void setFlagsEndpoint(String flagsEndpoint) {
        this.mFlagsEndpoint = flagsEndpoint;
    }

    public int getMinimumSessionDuration() {
        return this.mMinSessionDuration;
    }

    public int getSessionTimeoutDuration() {
        return this.mSessionTimeoutDuration;
    }

    public boolean getDisableExceptionHandler() {
        return this.mDisableExceptionHandler;
    }

    private boolean getUseIpAddressForGeolocation() {
        return this.mUseIpAddressForGeolocation;
    }

    public boolean getRemoveLegacyResidualFiles() {
        return this.mRemoveLegacyResidualFiles;
    }

    public void setUseIpAddressForGeolocation(boolean useIpAddressForGeolocation) {
        this.mUseIpAddressForGeolocation = useIpAddressForGeolocation;
        this.setEventsEndpoint(this.getEndPointWithIpTrackingParam(this.getEventsEndpoint(), useIpAddressForGeolocation));
        this.setPeopleEndpoint(this.getEndPointWithIpTrackingParam(this.getPeopleEndpoint(), useIpAddressForGeolocation));
        this.setGroupsEndpoint(this.getEndPointWithIpTrackingParam(this.getGroupsEndpoint(), useIpAddressForGeolocation));
    }

    public void setEnableLogging(boolean enableLogging) {
        DEBUG = enableLogging;
        MPLog.setLevel(DEBUG ? 2 : Integer.MAX_VALUE);
    }

    public void setTrackAutomaticEvents(boolean trackAutomaticEvents) {
        this.mTrackAutomaticEvents = trackAutomaticEvents;
    }

    public String getResourcePackageName() {
        return this.mResourcePackageName;
    }

    public synchronized SSLSocketFactory getSSLSocketFactory() {
        return this.mSSLSocketFactory;
    }

    public synchronized OfflineMode getOfflineMode() {
        return this.mOfflineMode;
    }

    public ProxyServerInteractor getProxyServerInteractor() {
        return this.serverCallbacks;
    }

    public void setProxyServerInteractor(ProxyServerInteractor interactor) {
        this.serverCallbacks = interactor;
    }

    static MPConfig readConfig(Context appContext, String instanceName) {
        String packageName = appContext.getPackageName();
        try {
            ApplicationInfo appInfo = appContext.getPackageManager().getApplicationInfo(packageName, 128);
            Bundle configBundle = appInfo.metaData;
            if (null == configBundle) {
                configBundle = new Bundle();
            }
            return new MPConfig(configBundle, appContext, instanceName);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Can't configure Mixpanel with package name " + packageName, e);
        }
    }

    public String toString() {
        return "Mixpanel (8.2.4) configured with:\n    TrackAutomaticEvents: " + this.getTrackAutomaticEvents() + "\n    BulkUploadLimit " + this.getBulkUploadLimit() + "\n    FlushInterval " + this.getFlushInterval() + "\n    FlushInterval " + this.getFlushBatchSize() + "\n    DataExpiration " + this.getDataExpiration() + "\n    MinimumDatabaseLimit " + this.getMinimumDatabaseLimit() + "\n    MaximumDatabaseLimit " + this.getMaximumDatabaseLimit() + "\n    DisableAppOpenEvent " + this.getDisableAppOpenEvent() + "\n    EnableDebugLogging " + DEBUG + "\n    EventsEndpoint " + this.getEventsEndpoint() + "\n    PeopleEndpoint " + this.getPeopleEndpoint() + "\n    GroupsEndpoint " + this.getGroupsEndpoint() + "\n    FlagsEndpoint " + this.getFlagsEndpoint() + "\n    MinimumSessionDuration: " + this.getMinimumSessionDuration() + "\n    SessionTimeoutDuration: " + this.getSessionTimeoutDuration() + "\n    DisableExceptionHandler: " + this.getDisableExceptionHandler() + "\n    FlushOnBackground: " + this.getFlushOnBackground();
    }
}

