/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mixpanel.android.util.MPLog;
import com.mixpanel.android.util.MixpanelNetworkErrorListener;
import com.mixpanel.android.util.OfflineMode;
import com.mixpanel.android.util.ProxyServerInteractor;
import com.mixpanel.android.util.RemoteService;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class HttpService
implements RemoteService {
    private final boolean shouldGzipRequestPayload;
    private final MixpanelNetworkErrorListener networkErrorListener;
    private String mBackupHost;
    private static boolean sIsMixpanelBlocked;
    private static final int MIN_UNAVAILABLE_HTTP_RESPONSE_CODE = 500;
    private static final int MAX_UNAVAILABLE_HTTP_RESPONSE_CODE = 599;
    private static final String LOGTAG = "MixpanelAPI.Message";
    private static final int HTTP_OUTPUT_STREAM_BUFFER_SIZE = 8192;
    private static final String CONTENT_ENCODING_HEADER = "Content-Encoding";
    private static final String GZIP_CONTENT_TYPE_HEADER = "gzip";

    public HttpService(boolean shouldGzipRequestPayload, MixpanelNetworkErrorListener networkErrorListener, String backupHost) {
        this.shouldGzipRequestPayload = shouldGzipRequestPayload;
        this.networkErrorListener = networkErrorListener;
        this.mBackupHost = backupHost;
    }

    public HttpService(boolean shouldGzipRequestPayload, MixpanelNetworkErrorListener networkErrorListener) {
        this(shouldGzipRequestPayload, networkErrorListener, null);
    }

    public HttpService() {
        this(false, null, null);
    }

    public void setBackupHost(String backupHost) {
        this.mBackupHost = backupHost;
    }

    @Override
    public void checkIsMixpanelBlocked() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    long startTimeNanos = System.nanoTime();
                    String host = "api.mixpanel.com";
                    InetAddress apiMixpanelInet = InetAddress.getByName(host);
                    boolean bl = sIsMixpanelBlocked = apiMixpanelInet.isLoopbackAddress() || apiMixpanelInet.isAnyLocalAddress();
                    if (sIsMixpanelBlocked) {
                        MPLog.v(HttpService.LOGTAG, "AdBlocker is enabled. Won't be able to use Mixpanel services.");
                        HttpService.this.onNetworkError(null, host, apiMixpanelInet.getHostAddress(), startTimeNanos, -1L, -1L, new IOException(host + " is blocked"));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        t.start();
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public boolean isOnline(Context context, OfflineMode offlineMode) {
        boolean isOnline;
        if (sIsMixpanelBlocked) {
            return false;
        }
        if (this.onOfflineMode(offlineMode)) {
            return false;
        }
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo netInfo = cm.getActiveNetworkInfo();
            if (netInfo == null) {
                isOnline = true;
                MPLog.v(LOGTAG, "A default network has not been set so we cannot be certain whether we are offline");
            } else {
                isOnline = netInfo.isConnectedOrConnecting();
                MPLog.v(LOGTAG, "ConnectivityManager says we " + (isOnline ? "are" : "are not") + " online");
            }
        }
        catch (SecurityException e) {
            isOnline = true;
            MPLog.v(LOGTAG, "Don't have permission to check connectivity, will assume we are online");
        }
        return isOnline;
    }

    private boolean onOfflineMode(OfflineMode offlineMode) {
        boolean onOfflineMode;
        try {
            onOfflineMode = offlineMode != null && offlineMode.isOffline();
        }
        catch (Exception e) {
            onOfflineMode = false;
            MPLog.v(LOGTAG, "Client State should not throw exception, will assume is not on offline mode", e);
        }
        return onOfflineMode;
    }

    @Override
    public RemoteService.RequestResult performRequest(@NonNull String endpointUrl, @Nullable ProxyServerInteractor interactor, @Nullable Map<String, Object> params, @Nullable Map<String, String> headers, @Nullable byte[] requestBodyBytes, @Nullable SSLSocketFactory socketFactory) throws RemoteService.ServiceUnavailableException, IOException {
        int retries = 0;
        Exception lastException = null;
        while (retries < 3) {
            InternalRequestResult primaryResult = this.tryRequestWithHost(endpointUrl, "Primary", interactor, params, headers, requestBodyBytes, socketFactory);
            if (primaryResult.success) {
                return RemoteService.RequestResult.success(primaryResult.response, primaryResult.requestUrl);
            }
            if (primaryResult.isClientError) {
                throw (RemoteService.ClientErrorException)primaryResult.exception;
            }
            lastException = primaryResult.exception;
            if (this.mBackupHost != null && !this.mBackupHost.isEmpty()) {
                String backupUrl = this.replaceHost(endpointUrl, this.mBackupHost);
                if (backupUrl.equals(endpointUrl)) {
                    MPLog.w(LOGTAG, "Failed to replace host for backup, skipping backup attempt");
                } else {
                    MPLog.v(LOGTAG, "Primary failed, trying backup: " + backupUrl);
                    InternalRequestResult backupResult = this.tryRequestWithHost(backupUrl, "Backup", interactor, params, headers, requestBodyBytes, socketFactory);
                    if (backupResult.success) {
                        return RemoteService.RequestResult.success(backupResult.response, backupResult.requestUrl);
                    }
                    if (backupResult.isClientError) {
                        throw (RemoteService.ClientErrorException)backupResult.exception;
                    }
                    lastException = backupResult.exception;
                    MPLog.w(LOGTAG, "Backup also failed: " + backupResult.exception.getMessage());
                }
            }
            if (++retries >= 3) continue;
            MPLog.d(LOGTAG, "Attempt " + retries + " failed, retrying...");
            try {
                Thread.sleep(100 * retries);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        MPLog.e(LOGTAG, "Request to " + endpointUrl + " failed after " + retries + " attempts");
        if (lastException instanceof RemoteService.ServiceUnavailableException) {
            throw (RemoteService.ServiceUnavailableException)lastException;
        }
        if (lastException instanceof IOException) {
            throw (IOException)lastException;
        }
        if (lastException != null) {
            throw new IOException("Request failed after " + retries + " attempts", lastException);
        }
        throw new IOException("Request failed after " + retries + " attempts");
    }

    private String replaceHost(String url, String newHost) {
        try {
            URL originalUrl = new URL(url);
            URL newUrl = new URL(originalUrl.getProtocol(), newHost, originalUrl.getPort(), originalUrl.getFile());
            return newUrl.toString();
        }
        catch (Exception e) {
            MPLog.e(LOGTAG, "Failed to replace host", e);
            return url;
        }
    }

    private InternalRequestResult tryRequestWithHost(@NonNull String url, @NonNull String hostLabel, @Nullable ProxyServerInteractor interactor, @Nullable Map<String, Object> params, @Nullable Map<String, String> headers, @Nullable byte[] requestBodyBytes, @Nullable SSLSocketFactory socketFactory) {
        try {
            byte[] response = this.performSingleRequest(url, interactor, params, headers, requestBodyBytes, socketFactory);
            if (response == null) {
                MPLog.v(LOGTAG, hostLabel + " request returned null response");
                return InternalRequestResult.failure(new IOException(hostLabel + " host returned null response"), false, url);
            }
            return InternalRequestResult.success(response, url);
        }
        catch (RemoteService.ClientErrorException e) {
            MPLog.w(LOGTAG, "Client error from " + hostLabel + " host, not attempting backup: " + e.getMessage());
            return InternalRequestResult.failure(e, true, url);
        }
        catch (IOException e) {
            MPLog.v(LOGTAG, hostLabel + " request failed: " + e.getMessage());
            return InternalRequestResult.failure(e, false, url);
        }
        catch (Exception e) {
            MPLog.v(LOGTAG, hostLabel + " request failed with exception: " + e.getMessage());
            return InternalRequestResult.failure(e, false, url);
        }
    }

    /*
     * WARNING - void declaration
     */
    private byte[] performSingleRequest(@NonNull String endpointUrl, @Nullable ProxyServerInteractor interactor, @Nullable Map<String, Object> params, @Nullable Map<String, String> headers, @Nullable byte[] requestBodyBytes, @Nullable SSLSocketFactory socketFactory) throws RemoteService.ServiceUnavailableException, IOException {
        byte[] response;
        block44: {
            MPLog.v(LOGTAG, "Attempting request to " + endpointUrl + (requestBodyBytes == null ? " (URL params)" : " (Raw Body)"));
            response = null;
            InputStream in = null;
            OutputStream out = null;
            HttpURLConnection connection = null;
            String targetIpAddress = null;
            long startTimeNanos = System.nanoTime();
            long uncompressedBodySize = -1L;
            long compressedBodySize = -1L;
            try {
                void var23_40;
                byte[] bytesToWrite;
                Map<String, String> proxyHeaders;
                String contentType;
                URL url = new URL(endpointUrl);
                try {
                    InetAddress inetAddress = InetAddress.getByName(url.getHost());
                    targetIpAddress = inetAddress.getHostAddress();
                }
                catch (Exception e) {
                    MPLog.v(LOGTAG, "Could not resolve IP address for " + url.getHost(), e);
                    targetIpAddress = "N/A";
                }
                connection = (HttpURLConnection)url.openConnection();
                if (null != socketFactory && connection instanceof HttpsURLConnection) {
                    ((HttpsURLConnection)connection).setSSLSocketFactory(socketFactory);
                }
                connection.setConnectTimeout(2000);
                connection.setReadTimeout(30000);
                connection.setRequestMethod("POST");
                connection.setDoOutput(true);
                String string = contentType = requestBodyBytes != null ? "application/json; charset=utf-8" : "application/x-www-form-urlencoded; charset=utf-8";
                if (headers != null) {
                    for (Map.Entry<String, String> entry : headers.entrySet()) {
                        connection.setRequestProperty(entry.getKey(), entry.getValue());
                        if (!entry.getKey().equalsIgnoreCase("Content-Type")) continue;
                        contentType = entry.getValue();
                    }
                }
                connection.setRequestProperty("Content-Type", contentType);
                if (interactor != null && HttpService.isProxyRequest(endpointUrl) && (proxyHeaders = interactor.getProxyRequestHeaders()) != null) {
                    for (Map.Entry<String, String> entry : proxyHeaders.entrySet()) {
                        connection.setRequestProperty(entry.getKey(), entry.getValue());
                    }
                }
                connection.setConnectTimeout(15000);
                connection.setReadTimeout(60000);
                if (requestBodyBytes != null) {
                    bytesToWrite = requestBodyBytes;
                    uncompressedBodySize = bytesToWrite.length;
                    connection.setFixedLengthStreamingMode(uncompressedBodySize);
                    MPLog.v(LOGTAG, "Sending raw body of size: " + uncompressedBodySize);
                } else if (params != null) {
                    Uri.Builder builder = new Uri.Builder();
                    for (Map.Entry<String, Object> entry : params.entrySet()) {
                        builder.appendQueryParameter(entry.getKey(), entry.getValue().toString());
                    }
                    String string2 = builder.build().getEncodedQuery();
                    byte[] byArray = Objects.requireNonNull(string2).getBytes(StandardCharsets.UTF_8);
                    uncompressedBodySize = byArray.length;
                    MPLog.v(LOGTAG, "Sending URL params (raw size): " + uncompressedBodySize);
                    if (this.shouldGzipRequestPayload) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        try (GZIPOutputStream gzipOut = new GZIPOutputStream(baos);){
                            gzipOut.write(byArray);
                        }
                        bytesToWrite = baos.toByteArray();
                        compressedBodySize = bytesToWrite.length;
                        connection.setRequestProperty(CONTENT_ENCODING_HEADER, GZIP_CONTENT_TYPE_HEADER);
                        connection.setFixedLengthStreamingMode(compressedBodySize);
                        MPLog.v(LOGTAG, "Gzipping params, compressed size: " + compressedBodySize);
                    } else {
                        bytesToWrite = byArray;
                        connection.setFixedLengthStreamingMode(uncompressedBodySize);
                    }
                } else {
                    bytesToWrite = new byte[]{};
                    uncompressedBodySize = 0L;
                    connection.setFixedLengthStreamingMode(0);
                    MPLog.v(LOGTAG, "Sending POST request with empty body.");
                }
                out = new BufferedOutputStream(connection.getOutputStream());
                out.write(bytesToWrite);
                out.flush();
                out.close();
                out = null;
                int n = connection.getResponseCode();
                String string3 = connection.getResponseMessage();
                MPLog.v(LOGTAG, "Response Code: " + n);
                if (interactor != null && HttpService.isProxyRequest(endpointUrl)) {
                    interactor.onProxyResponse(endpointUrl, n);
                }
                if (n >= 200 && n < 300) {
                    in = connection.getInputStream();
                    response = HttpService.slurp(in);
                    break block44;
                }
                if (n >= 500 && n <= 599) {
                    MPLog.w(LOGTAG, "Server error " + n + " (" + string3 + ") for URL: " + endpointUrl);
                    RemoteService.ServiceUnavailableException serviceUnavailableException = new RemoteService.ServiceUnavailableException("Service Unavailable: " + n, connection.getHeaderField("Retry-After"));
                    this.onNetworkError(connection, endpointUrl, targetIpAddress, startTimeNanos, uncompressedBodySize, compressedBodySize, serviceUnavailableException);
                    throw serviceUnavailableException;
                }
                MPLog.w(LOGTAG, "Client error " + n + " (" + string3 + ") for URL: " + endpointUrl);
                Object var23_38 = null;
                try {
                    in = connection.getErrorStream();
                    if (in != null) {
                        byte[] errorBytes = HttpService.slurp(in);
                        String string4 = new String(errorBytes, StandardCharsets.UTF_8);
                        MPLog.w(LOGTAG, "Error Body: " + string4);
                    }
                }
                catch (Exception e) {
                    MPLog.w(LOGTAG, "Could not read error stream.", e);
                }
                this.onNetworkError(connection, endpointUrl, targetIpAddress, startTimeNanos, uncompressedBodySize, compressedBodySize, new IOException("HTTP error response: " + n + " " + string3 + (var23_40 != null ? " - Body: " + (String)var23_40 : "")));
                throw new RemoteService.ClientErrorException(n, string3);
            }
            catch (EOFException e) {
                this.onNetworkError(connection, endpointUrl, targetIpAddress, startTimeNanos, uncompressedBodySize, compressedBodySize, e);
                MPLog.d(LOGTAG, "EOFException, likely network issue for request to " + endpointUrl);
                throw new IOException("EOFException during network request", e);
            }
            catch (IOException e) {
                this.onNetworkError(connection, endpointUrl, targetIpAddress, startTimeNanos, uncompressedBodySize, compressedBodySize, e);
                throw e;
            }
            catch (Exception e) {
                this.onNetworkError(connection, endpointUrl, targetIpAddress, startTimeNanos, uncompressedBodySize, compressedBodySize, e);
                throw new IOException("Unexpected exception during network request", e);
            }
            finally {
                if (null != out) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                if (null != in) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (null != connection) {
                    connection.disconnect();
                }
            }
        }
        return response;
    }

    private void onNetworkError(HttpURLConnection connection, String endpointUrl, String targetIpAddress, long startTimeNanos, long uncompressedBodySize, long compressedBodySize, Exception e) {
        if (this.networkErrorListener != null) {
            long endTimeNanos = System.nanoTime();
            long durationNanos = Math.max(0L, endTimeNanos - startTimeNanos);
            long durationMillis = TimeUnit.NANOSECONDS.toMillis(durationNanos);
            int responseCode = -1;
            String responseMessage = "";
            if (connection != null) {
                try {
                    responseCode = connection.getResponseCode();
                    responseMessage = connection.getResponseMessage();
                }
                catch (Exception respExc) {
                    MPLog.w(LOGTAG, "Could not retrieve response code/message after error", respExc);
                }
            }
            String ip = targetIpAddress == null ? "N/A" : targetIpAddress;
            long finalUncompressedSize = Math.max(-1L, uncompressedBodySize);
            long finalCompressedSize = Math.max(-1L, compressedBodySize);
            try {
                this.networkErrorListener.onNetworkError(endpointUrl, ip, durationMillis, finalUncompressedSize, finalCompressedSize, responseCode, responseMessage, e);
            }
            catch (Exception listenerException) {
                MPLog.e(LOGTAG, "Network error listener threw an exception", listenerException);
            }
        }
    }

    private OutputStream getBufferedOutputStream(OutputStream out) throws IOException {
        if (this.shouldGzipRequestPayload) {
            return new GZIPOutputStream((OutputStream)new BufferedOutputStream(out), 8192);
        }
        return new BufferedOutputStream(out);
    }

    private static boolean isProxyRequest(String endpointUrl) {
        return !endpointUrl.toLowerCase().contains("https://api.mixpanel.com".toLowerCase());
    }

    private static byte[] slurp(InputStream inputStream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[8192];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    private static class InternalRequestResult {
        final byte[] response;
        final Exception exception;
        final boolean isClientError;
        final boolean success;
        final String requestUrl;

        private InternalRequestResult(byte[] response, String requestUrl) {
            this.response = response;
            this.requestUrl = requestUrl;
            this.exception = null;
            this.isClientError = false;
            this.success = true;
        }

        private InternalRequestResult(Exception exception, boolean isClientError, String requestUrl) {
            this.response = null;
            this.requestUrl = requestUrl;
            this.exception = exception;
            this.isClientError = isClientError;
            this.success = false;
        }

        static InternalRequestResult success(byte[] response, String requestUrl) {
            return new InternalRequestResult(response, requestUrl);
        }

        static InternalRequestResult failure(Exception exception, boolean isClientError, String requestUrl) {
            return new InternalRequestResult(exception, isClientError, requestUrl);
        }
    }
}

