/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.util;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mixpanel.android.util.OfflineMode;
import com.mixpanel.android.util.ProxyServerInteractor;
import java.io.IOException;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;

public interface RemoteService {
    public boolean isOnline(Context var1, OfflineMode var2);

    public void checkIsMixpanelBlocked();

    public byte[] performRequest(@NonNull String var1, @Nullable ProxyServerInteractor var2, @Nullable Map<String, Object> var3, @Nullable Map<String, String> var4, @Nullable byte[] var5, @Nullable SSLSocketFactory var6) throws ServiceUnavailableException, IOException;

    public static class ServiceUnavailableException
    extends Exception {
        private final int mRetryAfter;

        public ServiceUnavailableException(String message, String strRetryAfter) {
            super(message);
            int retry;
            try {
                retry = Integer.parseInt(strRetryAfter);
            }
            catch (NumberFormatException e) {
                retry = 0;
            }
            this.mRetryAfter = retry;
        }

        public int getRetryAfter() {
            return this.mRetryAfter;
        }
    }
}

