/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import com.mixpanel.android.mpmetrics.AnalyticsMessages;
import com.mixpanel.android.mpmetrics.ConfigurationChecker;
import com.mixpanel.android.mpmetrics.DecideMessages;
import com.mixpanel.android.mpmetrics.ExceptionHandler;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.mpmetrics.MPDbAdapter;
import com.mixpanel.android.mpmetrics.MixpanelActivityLifecycleCallbacks;
import com.mixpanel.android.mpmetrics.PersistentIdentity;
import com.mixpanel.android.mpmetrics.SessionMetadata;
import com.mixpanel.android.mpmetrics.SharedPreferencesLoader;
import com.mixpanel.android.mpmetrics.SuperPropertyUpdate;
import com.mixpanel.android.util.MPLog;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Future;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MixpanelAPI {
    public static final String VERSION = "6.4.0";
    private final Context mContext;
    private final AnalyticsMessages mMessages;
    private final MPConfig mConfig;
    private final String mToken;
    private final PeopleImpl mPeople;
    private final Map<String, GroupImpl> mGroups;
    private final PersistentIdentity mPersistentIdentity;
    private final DecideMessages mDecideMessages;
    private final Map<String, String> mDeviceInfo;
    private final Map<String, Long> mEventTimings;
    private MixpanelActivityLifecycleCallbacks mMixpanelActivityLifecycleCallbacks;
    private final SessionMetadata mSessionMetadata;
    private static final Map<String, Map<Context, MixpanelAPI>> sInstanceMap = new HashMap<String, Map<Context, MixpanelAPI>>();
    private static final SharedPreferencesLoader sPrefsLoader = new SharedPreferencesLoader();
    private static Future<SharedPreferences> sReferrerPrefs;
    private static final String LOGTAG = "MixpanelAPI.API";
    private static final String APP_LINKS_LOGTAG = "MixpanelAPI.AL";
    private static final String ENGAGE_DATE_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ss";

    MixpanelAPI(Context context, Future<SharedPreferences> referrerPreferences, String token, boolean optOutTrackingDefault, JSONObject superProperties) {
        this(context, referrerPreferences, token, MPConfig.getInstance(context), optOutTrackingDefault, superProperties, null);
    }

    MixpanelAPI(Context context, Future<SharedPreferences> referrerPreferences, String token, boolean optOutTrackingDefault, JSONObject superProperties, String instanceName) {
        this(context, referrerPreferences, token, MPConfig.getInstance(context), optOutTrackingDefault, superProperties, instanceName);
    }

    MixpanelAPI(Context context, Future<SharedPreferences> referrerPreferences, String token, MPConfig config, boolean optOutTrackingDefault, JSONObject superProperties, String instanceName) {
        this.mContext = context;
        this.mToken = token;
        this.mPeople = new PeopleImpl();
        this.mGroups = new HashMap<String, GroupImpl>();
        this.mConfig = config;
        HashMap<String, String> deviceInfo = new HashMap<String, String>();
        deviceInfo.put("$android_lib_version", VERSION);
        deviceInfo.put("$android_os", "Android");
        deviceInfo.put("$android_os_version", Build.VERSION.RELEASE == null ? "UNKNOWN" : Build.VERSION.RELEASE);
        deviceInfo.put("$android_manufacturer", Build.MANUFACTURER == null ? "UNKNOWN" : Build.MANUFACTURER);
        deviceInfo.put("$android_brand", Build.BRAND == null ? "UNKNOWN" : Build.BRAND);
        deviceInfo.put("$android_model", Build.MODEL == null ? "UNKNOWN" : Build.MODEL);
        try {
            PackageManager manager = this.mContext.getPackageManager();
            PackageInfo info = manager.getPackageInfo(this.mContext.getPackageName(), 0);
            deviceInfo.put("$android_app_version", info.versionName);
            deviceInfo.put("$android_app_version_code", Integer.toString(info.versionCode));
        }
        catch (PackageManager.NameNotFoundException e) {
            MPLog.e(LOGTAG, "Exception getting app version name", e);
        }
        this.mDeviceInfo = Collections.unmodifiableMap(deviceInfo);
        this.mSessionMetadata = new SessionMetadata();
        this.mMessages = this.getAnalyticsMessages();
        this.mPersistentIdentity = this.getPersistentIdentity(context, referrerPreferences, token, instanceName);
        this.mEventTimings = this.mPersistentIdentity.getTimeEvents();
        if (optOutTrackingDefault && (this.hasOptedOutTracking() || !this.mPersistentIdentity.hasOptOutFlag(token))) {
            this.optOutTracking();
        }
        if (superProperties != null) {
            this.registerSuperProperties(superProperties);
        }
        this.mDecideMessages = this.constructDecideUpdates(token);
        String decideId = this.mPersistentIdentity.getPeopleDistinctId();
        if (null == decideId) {
            decideId = this.mPersistentIdentity.getEventsDistinctId();
        }
        this.mDecideMessages.setDistinctId(decideId);
        boolean dbExists = MPDbAdapter.getInstance(this.mContext).getDatabaseFile().exists();
        this.registerMixpanelActivityLifecycleCallbacks();
        if (this.mPersistentIdentity.isFirstLaunch(dbExists, this.mToken)) {
            this.track("$ae_first_open", null, true);
            this.mPersistentIdentity.setHasLaunched(this.mToken);
        }
        if (!this.mConfig.getDisableDecideChecker()) {
            this.mMessages.installDecideCheck(this.mDecideMessages);
        }
        if (this.sendAppOpen()) {
            this.track("$app_open", null);
        }
        if (!this.mPersistentIdentity.isFirstIntegration(this.mToken)) {
            try {
                this.sendHttpEvent("Integration", "85053bf24bba75239b16a601d9387e17", token, null, false);
                this.mPersistentIdentity.setIsIntegrated(this.mToken);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        if (this.mPersistentIdentity.isNewVersion((String)deviceInfo.get("$android_app_version_code"))) {
            try {
                JSONObject messageProps = new JSONObject();
                messageProps.put("$ae_updated_version", deviceInfo.get("$android_app_version"));
                this.track("$ae_updated", messageProps, true);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        if (this.isDebuggingMode()) {
            try {
                if (this.mToken.length() == 32) {
                    this.trackMixpanelDevX();
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        if (!this.mConfig.getDisableExceptionHandler()) {
            ExceptionHandler.init();
        }
    }

    private boolean isDebuggingMode() {
        return (this.getContext().getApplicationInfo().flags & 2) != 0;
    }

    private void trackMixpanelDevX() throws JSONException {
        this.trackDebugLaunch();
        this.trackMixpanelImplemented();
    }

    private void trackDebugLaunch() throws JSONException {
        int debugInitCount = this.mPersistentIdentity.debugInitCount(this.mToken);
        this.mPersistentIdentity.setDebugInitCount(this.mToken, ++debugInitCount);
        JSONObject debugProps = new JSONObject();
        debugProps.put("Debug Launch Count", debugInitCount);
        this.sendHttpEvent("SDK Debug Launch", "metrics-1", this.mToken, debugProps, true);
    }

    private void trackMixpanelImplemented() throws JSONException {
        if (this.mPersistentIdentity.hasImplemented(this.mToken)) {
            return;
        }
        int implementationScore = 0;
        implementationScore += this.mPersistentIdentity.hasMPDebugTracked(this.mToken) ? 1 : 0;
        implementationScore += this.mPersistentIdentity.hasMPDebugIdentified(this.mToken) ? 1 : 0;
        implementationScore += this.mPersistentIdentity.hasMPDebugAliased(this.mToken) ? 1 : 0;
        implementationScore += this.mPersistentIdentity.hasMPDebugUsedPeople(this.mToken) ? 1 : 0;
        JSONObject implementedProps = new JSONObject();
        implementedProps.put("Tracked", this.mPersistentIdentity.hasMPDebugTracked(this.mToken));
        implementedProps.put("Identified", this.mPersistentIdentity.hasMPDebugIdentified(this.mToken));
        implementedProps.put("Aliased", this.mPersistentIdentity.hasMPDebugAliased(this.mToken));
        implementedProps.put("Used People", this.mPersistentIdentity.hasMPDebugUsedPeople(this.mToken));
        if (implementationScore >= 3) {
            this.sendHttpEvent("SDK Implemented", "metrics-1", this.mToken, implementedProps, true);
            this.mPersistentIdentity.setHasImplemented(this.mToken);
        }
    }

    private void sendHttpEvent(String eventName, String token, String distinctId, JSONObject properties, boolean updatePeople) throws JSONException {
        JSONObject superProperties = this.getSuperProperties();
        String lib = null;
        String libVersion = null;
        try {
            if (superProperties != null) {
                lib = (String)superProperties.get("mp_lib");
                libVersion = (String)superProperties.get("$lib_version");
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        JSONObject messageProps = new JSONObject();
        messageProps.put("mp_lib", (Object)(null != lib ? lib : "Android"));
        messageProps.put("distinct_id", (Object)distinctId);
        messageProps.put("$lib_version", (Object)(null != libVersion ? libVersion : VERSION));
        messageProps.put("DevX", true);
        messageProps.put("Project Token", (Object)distinctId);
        if (null != properties) {
            Iterator propIter = properties.keys();
            while (propIter.hasNext()) {
                String key = (String)propIter.next();
                messageProps.put(key, properties.get(key));
            }
        }
        AnalyticsMessages.EventDescription eventDescription = new AnalyticsMessages.EventDescription(eventName, messageProps, token);
        this.mMessages.eventsMessage(eventDescription);
        if (updatePeople) {
            JSONObject peopleMessageProps = new JSONObject();
            JSONObject addProperties = new JSONObject();
            addProperties.put(eventName, 1);
            peopleMessageProps.put("$add", (Object)addProperties);
            peopleMessageProps.put("$token", (Object)token);
            peopleMessageProps.put("$distinct_id", (Object)distinctId);
            this.mMessages.peopleMessage(new AnalyticsMessages.PeopleDescription(peopleMessageProps, token));
        }
        this.mMessages.postToServer(new AnalyticsMessages.FlushDescription(token, false));
    }

    public static MixpanelAPI getInstance(Context context, String token) {
        return MixpanelAPI.getInstance(context, token, false, null, null);
    }

    public static MixpanelAPI getInstance(Context context, String token, String instanceName) {
        return MixpanelAPI.getInstance(context, token, false, null, instanceName);
    }

    public static MixpanelAPI getInstance(Context context, String token, boolean optOutTrackingDefault) {
        return MixpanelAPI.getInstance(context, token, optOutTrackingDefault, null, null);
    }

    public static MixpanelAPI getInstance(Context context, String token, boolean optOutTrackingDefault, String instanceName) {
        return MixpanelAPI.getInstance(context, token, optOutTrackingDefault, null, instanceName);
    }

    public static MixpanelAPI getInstance(Context context, String token, JSONObject superProperties) {
        return MixpanelAPI.getInstance(context, token, false, superProperties, null);
    }

    public static MixpanelAPI getInstance(Context context, String token, JSONObject superProperties, String instanceName) {
        return MixpanelAPI.getInstance(context, token, false, superProperties, instanceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MixpanelAPI getInstance(Context context, String token, boolean optOutTrackingDefault, JSONObject superProperties, String instanceName) {
        if (null == token || null == context) {
            return null;
        }
        Map<String, Map<Context, MixpanelAPI>> map = sInstanceMap;
        synchronized (map) {
            MixpanelAPI instance;
            String instanceKey;
            Map<Context, MixpanelAPI> instances;
            Context appContext = context.getApplicationContext();
            if (null == sReferrerPrefs) {
                sReferrerPrefs = sPrefsLoader.loadPreferences(context, "com.mixpanel.android.mpmetrics.ReferralInfo", null);
            }
            if (null == (instances = sInstanceMap.get(instanceKey = instanceName != null ? instanceName : token))) {
                instances = new HashMap<Context, MixpanelAPI>();
                sInstanceMap.put(instanceKey, instances);
            }
            if (null == (instance = instances.get(appContext)) && ConfigurationChecker.checkBasicConfiguration(appContext)) {
                instance = new MixpanelAPI(appContext, sReferrerPrefs, token, optOutTrackingDefault, superProperties, instanceName);
                MixpanelAPI.registerAppLinksListeners(context, instance);
                instances.put(appContext, instance);
            }
            MixpanelAPI.checkIntentForInboundAppLink(context);
            return instance;
        }
    }

    public void setUseIpAddressForGeolocation(boolean useIpAddressForGeolocation) {
        this.mConfig.setUseIpAddressForGeolocation(useIpAddressForGeolocation);
    }

    public void setEnableLogging(boolean enableLogging) {
        this.mConfig.setEnableLogging(enableLogging);
        JSONObject debugProps = new JSONObject();
        if (this.isDebuggingMode()) {
            try {
                debugProps.put("Logging Enabled", enableLogging);
                this.sendHttpEvent("Toggle SDK Logging", "metrics-1", this.mToken, debugProps, true);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public void setServerURL(String serverURL) {
        this.mConfig.setServerURL(serverURL);
    }

    public void alias(String alias, String original) {
        if (this.hasOptedOutTracking()) {
            return;
        }
        if (original == null) {
            original = this.getDistinctId();
        }
        if (alias.equals(original)) {
            MPLog.w(LOGTAG, "Attempted to alias identical distinct_ids " + alias + ". Alias message will not be sent.");
            return;
        }
        try {
            JSONObject j = new JSONObject();
            j.put("alias", (Object)alias);
            j.put("original", (Object)original);
            this.track("$create_alias", j);
            if (this.isDebuggingMode()) {
                this.mPersistentIdentity.setHasMPDebugAliased(this.mToken);
            }
        }
        catch (JSONException e) {
            MPLog.e(LOGTAG, "Failed to alias", e);
        }
        this.flush();
    }

    public void identify(String distinctId) {
        this.identify(distinctId, true, true);
    }

    public void identify(String distinctId, boolean usePeople) {
        this.identify(distinctId, true, usePeople);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void identify(String distinctId, boolean markAsUserId, boolean usePeople) {
        if (this.hasOptedOutTracking()) {
            return;
        }
        if (distinctId == null) {
            MPLog.e(LOGTAG, "Can't identify with null distinct_id.");
            return;
        }
        PersistentIdentity persistentIdentity = this.mPersistentIdentity;
        synchronized (persistentIdentity) {
            String decideId;
            String currentEventsDistinctId = this.mPersistentIdentity.getEventsDistinctId();
            this.mPersistentIdentity.setAnonymousIdIfAbsent(currentEventsDistinctId);
            this.mPersistentIdentity.setEventsDistinctId(distinctId);
            if (markAsUserId) {
                this.mPersistentIdentity.markEventsUserIdPresent();
            }
            if (null == (decideId = this.mPersistentIdentity.getPeopleDistinctId())) {
                decideId = this.mPersistentIdentity.getEventsDistinctId();
            }
            this.mDecideMessages.setDistinctId(decideId);
            if (!distinctId.equals(currentEventsDistinctId)) {
                try {
                    JSONObject identifyPayload = new JSONObject();
                    identifyPayload.put("$anon_distinct_id", (Object)currentEventsDistinctId);
                    this.track("$identify", identifyPayload);
                    if (this.isDebuggingMode()) {
                        this.mPersistentIdentity.setHasMPDebugIdentified(this.mToken);
                    }
                }
                catch (JSONException e) {
                    MPLog.e(LOGTAG, "Could not track $identify event");
                }
            }
            if (usePeople) {
                this.mPeople.identify_people(distinctId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeEvent(String eventName) {
        if (this.hasOptedOutTracking()) {
            return;
        }
        long writeTime = System.currentTimeMillis();
        Map<String, Long> map = this.mEventTimings;
        synchronized (map) {
            this.mEventTimings.put(eventName, writeTime);
            this.mPersistentIdentity.addTimeEvent(eventName, writeTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTimedEvents() {
        Map<String, Long> map = this.mEventTimings;
        synchronized (map) {
            this.mEventTimings.clear();
            this.mPersistentIdentity.clearTimedEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTimedEvent(String eventName) {
        Map<String, Long> map = this.mEventTimings;
        synchronized (map) {
            this.mEventTimings.remove(eventName);
            this.mPersistentIdentity.removeTimedEvent(eventName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double eventElapsedTime(String eventName) {
        Long startTime;
        long currentTime = System.currentTimeMillis();
        Map<String, Long> map = this.mEventTimings;
        synchronized (map) {
            startTime = this.mEventTimings.get(eventName);
        }
        return startTime == null ? 0.0 : (double)((currentTime - startTime) / 1000L);
    }

    public void trackMap(String eventName, Map<String, Object> properties) {
        if (this.hasOptedOutTracking()) {
            return;
        }
        if (null == properties) {
            this.track(eventName, null);
        } else {
            try {
                this.track(eventName, new JSONObject(properties));
            }
            catch (NullPointerException e) {
                MPLog.w(LOGTAG, "Can't have null keys in the properties of trackMap!");
            }
        }
    }

    public void trackWithGroups(String eventName, Map<String, Object> properties, Map<String, Object> groups) {
        if (this.hasOptedOutTracking()) {
            return;
        }
        if (null == groups) {
            this.trackMap(eventName, properties);
        } else if (null == properties) {
            this.trackMap(eventName, groups);
        } else {
            for (Map.Entry<String, Object> e : groups.entrySet()) {
                if (e.getValue() == null) continue;
                properties.put(e.getKey(), e.getValue());
            }
            this.trackMap(eventName, properties);
        }
    }

    public void track(String eventName, JSONObject properties) {
        if (this.hasOptedOutTracking()) {
            return;
        }
        this.track(eventName, properties, false);
    }

    public void track(String eventName) {
        if (this.hasOptedOutTracking()) {
            return;
        }
        this.track(eventName, null);
    }

    public void flush() {
        if (this.hasOptedOutTracking()) {
            return;
        }
        this.mMessages.postToServer(new AnalyticsMessages.FlushDescription(this.mToken));
    }

    public JSONObject getSuperProperties() {
        JSONObject ret = new JSONObject();
        this.mPersistentIdentity.addSuperPropertiesToObject(ret);
        return ret;
    }

    public String getDistinctId() {
        return this.mPersistentIdentity.getEventsDistinctId();
    }

    public String getAnonymousId() {
        return this.mPersistentIdentity.getAnonymousId();
    }

    protected String getUserId() {
        return this.mPersistentIdentity.getEventsUserId();
    }

    public void registerSuperPropertiesMap(Map<String, Object> superProperties) {
        if (this.hasOptedOutTracking()) {
            return;
        }
        if (null == superProperties) {
            MPLog.e(LOGTAG, "registerSuperPropertiesMap does not accept null properties");
            return;
        }
        try {
            this.registerSuperProperties(new JSONObject(superProperties));
        }
        catch (NullPointerException e) {
            MPLog.w(LOGTAG, "Can't have null keys in the properties of registerSuperPropertiesMap");
        }
    }

    public void registerSuperProperties(JSONObject superProperties) {
        if (this.hasOptedOutTracking()) {
            return;
        }
        this.mPersistentIdentity.registerSuperProperties(superProperties);
    }

    public void unregisterSuperProperty(String superPropertyName) {
        if (this.hasOptedOutTracking()) {
            return;
        }
        this.mPersistentIdentity.unregisterSuperProperty(superPropertyName);
    }

    public void registerSuperPropertiesOnceMap(Map<String, Object> superProperties) {
        if (this.hasOptedOutTracking()) {
            return;
        }
        if (null == superProperties) {
            MPLog.e(LOGTAG, "registerSuperPropertiesOnceMap does not accept null properties");
            return;
        }
        try {
            this.registerSuperPropertiesOnce(new JSONObject(superProperties));
        }
        catch (NullPointerException e) {
            MPLog.w(LOGTAG, "Can't have null keys in the properties of registerSuperPropertiesOnce!");
        }
    }

    public void registerSuperPropertiesOnce(JSONObject superProperties) {
        if (this.hasOptedOutTracking()) {
            return;
        }
        this.mPersistentIdentity.registerSuperPropertiesOnce(superProperties);
    }

    public void clearSuperProperties() {
        this.mPersistentIdentity.clearSuperProperties();
    }

    public void updateSuperProperties(SuperPropertyUpdate update) {
        if (this.hasOptedOutTracking()) {
            return;
        }
        this.mPersistentIdentity.updateSuperProperties(update);
    }

    public void setGroup(String groupKey, Object groupID) {
        if (this.hasOptedOutTracking()) {
            return;
        }
        ArrayList<Object> groupIDs = new ArrayList<Object>(1);
        groupIDs.add(groupID);
        this.setGroup(groupKey, groupIDs);
    }

    public void setGroup(String groupKey, List<Object> groupIDs) {
        if (this.hasOptedOutTracking()) {
            return;
        }
        JSONArray vals = new JSONArray();
        for (Object s : groupIDs) {
            if (s == null) {
                MPLog.w(LOGTAG, "groupID must be non-null");
                continue;
            }
            vals.put(s);
        }
        try {
            this.registerSuperProperties(new JSONObject().put(groupKey, (Object)vals));
            this.mPeople.set(groupKey, vals);
        }
        catch (JSONException e) {
            MPLog.w(LOGTAG, "groupKey must be non-null");
        }
    }

    public void addGroup(final String groupKey, final Object groupID) {
        if (this.hasOptedOutTracking()) {
            return;
        }
        this.updateSuperProperties(new SuperPropertyUpdate(){

            @Override
            public JSONObject update(JSONObject in) {
                try {
                    in.accumulate(groupKey, groupID);
                }
                catch (JSONException e) {
                    MPLog.e(MixpanelAPI.LOGTAG, "Failed to add groups superProperty", e);
                }
                return in;
            }
        });
        this.mPeople.union(groupKey, new JSONArray().put(groupID));
    }

    public void removeGroup(final String groupKey, final Object groupID) {
        if (this.hasOptedOutTracking()) {
            return;
        }
        this.updateSuperProperties(new SuperPropertyUpdate(){

            @Override
            public JSONObject update(JSONObject in) {
                try {
                    JSONArray vals = in.getJSONArray(groupKey);
                    JSONArray newVals = new JSONArray();
                    if (vals.length() <= 1) {
                        in.remove(groupKey);
                        MixpanelAPI.this.mPeople.unset(groupKey);
                    } else {
                        for (int i = 0; i < vals.length(); ++i) {
                            if (vals.get(i).equals(groupID)) continue;
                            newVals.put(vals.get(i));
                        }
                        in.put(groupKey, (Object)newVals);
                        MixpanelAPI.this.mPeople.remove(groupKey, groupID);
                    }
                }
                catch (JSONException e) {
                    in.remove(groupKey);
                    MixpanelAPI.this.mPeople.unset(groupKey);
                }
                return in;
            }
        });
    }

    public People getPeople() {
        return this.mPeople;
    }

    public Group getGroup(String groupKey, Object groupID) {
        String mapKey = this.makeMapKey(groupKey, groupID);
        GroupImpl group = this.mGroups.get(mapKey);
        if (group == null) {
            group = new GroupImpl(groupKey, groupID);
            this.mGroups.put(mapKey, group);
        }
        if (!group.mGroupKey.equals(groupKey) || !group.mGroupID.equals(groupID)) {
            MPLog.i(LOGTAG, "groups map key collision " + mapKey);
            group = new GroupImpl(groupKey, groupID);
            this.mGroups.put(mapKey, group);
        }
        return group;
    }

    private String makeMapKey(String groupKey, Object groupID) {
        return groupKey + '_' + groupID;
    }

    public void reset() {
        this.mPersistentIdentity.clearPreferences();
        this.getAnalyticsMessages().clearAnonymousUpdatesMessage(new AnalyticsMessages.MixpanelDescription(this.mToken));
        this.identify(this.getDistinctId(), false);
        this.flush();
    }

    public Map<String, String> getDeviceInfo() {
        return this.mDeviceInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optOutTracking() {
        this.getAnalyticsMessages().emptyTrackingQueues(new AnalyticsMessages.MixpanelDescription(this.mToken));
        if (this.getPeople().isIdentified()) {
            this.getPeople().deleteUser();
            this.getPeople().clearCharges();
        }
        this.mPersistentIdentity.clearPreferences();
        Map<String, Long> map = this.mEventTimings;
        synchronized (map) {
            this.mEventTimings.clear();
            this.mPersistentIdentity.clearTimedEvents();
        }
        this.mPersistentIdentity.clearReferrerProperties();
        this.mPersistentIdentity.setOptOutTracking(true, this.mToken);
    }

    public void optInTracking() {
        this.optInTracking(null, null);
    }

    public void optInTracking(String distinctId) {
        this.optInTracking(distinctId, null);
    }

    public void optInTracking(String distinctId, JSONObject properties) {
        this.mPersistentIdentity.setOptOutTracking(false, this.mToken);
        if (distinctId != null) {
            this.identify(distinctId);
        }
        this.track("$opt_in", properties);
    }

    public boolean hasOptedOutTracking() {
        return this.mPersistentIdentity.getOptOutTracking(this.mToken);
    }

    @TargetApi(value=14)
    void registerMixpanelActivityLifecycleCallbacks() {
        if (Build.VERSION.SDK_INT >= 14) {
            if (this.mContext.getApplicationContext() instanceof Application) {
                Application app = (Application)this.mContext.getApplicationContext();
                this.mMixpanelActivityLifecycleCallbacks = new MixpanelActivityLifecycleCallbacks(this, this.mConfig);
                app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.mMixpanelActivityLifecycleCallbacks);
            } else {
                MPLog.i(LOGTAG, "Context is not an Application, Mixpanel won't be able to automatically flush on an app background.");
            }
        }
    }

    public boolean isAppInForeground() {
        if (Build.VERSION.SDK_INT >= 14) {
            if (this.mMixpanelActivityLifecycleCallbacks != null) {
                return this.mMixpanelActivityLifecycleCallbacks.isInForeground();
            }
        } else {
            MPLog.e(LOGTAG, "Your build version is below 14. This method will always return false.");
        }
        return false;
    }

    void onBackground() {
        if (this.mConfig.getFlushOnBackground()) {
            this.flush();
        }
    }

    void onForeground() {
        this.mSessionMetadata.initSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void allInstances(InstanceProcessor processor) {
        Map<String, Map<Context, MixpanelAPI>> map = sInstanceMap;
        synchronized (map) {
            for (Map<Context, MixpanelAPI> contextInstances : sInstanceMap.values()) {
                for (MixpanelAPI instance : contextInstances.values()) {
                    processor.process(instance);
                }
            }
        }
    }

    AnalyticsMessages getAnalyticsMessages() {
        return AnalyticsMessages.getInstance(this.mContext);
    }

    DecideMessages getDecideMessages() {
        return this.mDecideMessages;
    }

    PersistentIdentity getPersistentIdentity(Context context, Future<SharedPreferences> referrerPreferences, String token) {
        return this.getPersistentIdentity(context, referrerPreferences, token, null);
    }

    PersistentIdentity getPersistentIdentity(Context context, Future<SharedPreferences> referrerPreferences, String token, String instanceName) {
        SharedPreferencesLoader.OnPrefsLoadedListener listener = new SharedPreferencesLoader.OnPrefsLoadedListener(){

            @Override
            public void onPrefsLoaded(SharedPreferences preferences) {
                String distinctId = PersistentIdentity.getPeopleDistinctId(preferences);
                if (null != distinctId) {
                    MixpanelAPI.this.pushWaitingPeopleRecord(distinctId);
                }
            }
        };
        String instanceKey = instanceName != null ? instanceName : token;
        String prefsName = "com.mixpanel.android.mpmetrics.MixpanelAPI_" + instanceKey;
        Future<SharedPreferences> storedPreferences = sPrefsLoader.loadPreferences(context, prefsName, listener);
        String timeEventsPrefsName = "com.mixpanel.android.mpmetrics.MixpanelAPI.TimeEvents_" + instanceKey;
        Future<SharedPreferences> timeEventsPrefs = sPrefsLoader.loadPreferences(context, timeEventsPrefsName, null);
        String mixpanelPrefsName = "com.mixpanel.android.mpmetrics.Mixpanel";
        Future<SharedPreferences> mixpanelPrefs = sPrefsLoader.loadPreferences(context, "com.mixpanel.android.mpmetrics.Mixpanel", null);
        return new PersistentIdentity(referrerPreferences, storedPreferences, timeEventsPrefs, mixpanelPrefs);
    }

    DecideMessages constructDecideUpdates(String token) {
        return new DecideMessages(this.mContext, token);
    }

    boolean sendAppOpen() {
        return !this.mConfig.getDisableAppOpenEvent();
    }

    protected void flushNoDecideCheck() {
        if (this.hasOptedOutTracking()) {
            return;
        }
        this.mMessages.postToServer(new AnalyticsMessages.FlushDescription(this.mToken, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void track(String eventName, JSONObject properties, boolean isAutomaticEvent) {
        Long eventBegin;
        if (this.hasOptedOutTracking() || isAutomaticEvent && !this.mDecideMessages.shouldTrackAutomaticEvent()) {
            return;
        }
        Map<String, Long> map = this.mEventTimings;
        synchronized (map) {
            eventBegin = this.mEventTimings.get(eventName);
            this.mEventTimings.remove(eventName);
            this.mPersistentIdentity.removeTimedEvent(eventName);
        }
        try {
            JSONObject messageProps = new JSONObject();
            Map<String, String> referrerProperties = this.mPersistentIdentity.getReferrerProperties();
            for (Map.Entry<String, String> entry : referrerProperties.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                messageProps.put(key, (Object)value);
            }
            this.mPersistentIdentity.addSuperPropertiesToObject(messageProps);
            double timeSecondsDouble = (double)System.currentTimeMillis() / 1000.0;
            String distinctId = this.getDistinctId();
            String anonymousId = this.getAnonymousId();
            String userId = this.getUserId();
            messageProps.put("time", System.currentTimeMillis());
            messageProps.put("distinct_id", (Object)distinctId);
            messageProps.put("$had_persisted_distinct_id", this.mPersistentIdentity.getHadPersistedDistinctId());
            if (anonymousId != null) {
                messageProps.put("$device_id", (Object)anonymousId);
            }
            if (userId != null) {
                messageProps.put("$user_id", (Object)userId);
            }
            if (null != eventBegin) {
                double eventBeginDouble = (double)eventBegin.longValue() / 1000.0;
                double secondsElapsed = timeSecondsDouble - eventBeginDouble;
                messageProps.put("$duration", secondsElapsed);
            }
            if (null != properties) {
                Iterator propIter = properties.keys();
                while (propIter.hasNext()) {
                    String key = (String)propIter.next();
                    messageProps.put(key, properties.get(key));
                }
            }
            AnalyticsMessages.EventDescription eventDescription = new AnalyticsMessages.EventDescription(eventName, messageProps, this.mToken, isAutomaticEvent, this.mSessionMetadata.getMetadataForEvent());
            this.mMessages.eventsMessage(eventDescription);
            if (this.isDebuggingMode() && !eventName.startsWith("$")) {
                this.mPersistentIdentity.setHasMPDebugTracked(this.mToken);
            }
        }
        catch (JSONException e) {
            MPLog.e(LOGTAG, "Exception tracking event " + eventName, e);
        }
    }

    private void recordPeopleMessage(JSONObject message) {
        if (this.hasOptedOutTracking()) {
            return;
        }
        this.mMessages.peopleMessage(new AnalyticsMessages.PeopleDescription(message, this.mToken));
    }

    private void recordGroupMessage(JSONObject message) {
        if (this.hasOptedOutTracking()) {
            return;
        }
        if (message.has("$group_key") && message.has("$group_id")) {
            this.mMessages.groupMessage(new AnalyticsMessages.GroupDescription(message, this.mToken));
        } else {
            MPLog.e(LOGTAG, "Attempt to update group without key and value--this should not happen.");
        }
    }

    private void pushWaitingPeopleRecord(String distinctId) {
        this.mMessages.pushAnonymousPeopleMessage(new AnalyticsMessages.PushAnonymousPeopleDescription(distinctId, this.mToken));
    }

    private static void registerAppLinksListeners(Context context, MixpanelAPI mixpanel) {
        try {
            Class<?> clazz = Class.forName("androidx.localbroadcastmanager.content.LocalBroadcastManager");
            Method methodGetInstance = clazz.getMethod("getInstance", Context.class);
            Method methodRegisterReceiver = clazz.getMethod("registerReceiver", BroadcastReceiver.class, IntentFilter.class);
            Object localBroadcastManager = methodGetInstance.invoke(null, context);
            methodRegisterReceiver.invoke(localBroadcastManager, new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    JSONObject properties = new JSONObject();
                    Bundle args = intent.getBundleExtra("event_args");
                    if (args != null) {
                        for (String key : args.keySet()) {
                            try {
                                properties.put(key, args.get(key));
                            }
                            catch (JSONException e) {
                                MPLog.e(MixpanelAPI.APP_LINKS_LOGTAG, "failed to add key \"" + key + "\" to properties for tracking bolts event", e);
                            }
                        }
                    }
                    MixpanelAPI.this.track("$" + intent.getStringExtra("event_name"), properties);
                }
            }, new IntentFilter("com.parse.bolts.measurement_event"));
        }
        catch (InvocationTargetException e) {
            MPLog.d(APP_LINKS_LOGTAG, "Failed to invoke LocalBroadcastManager.registerReceiver() -- App Links tracking will not be enabled due to this exception", e);
        }
        catch (ClassNotFoundException e) {
            MPLog.d(APP_LINKS_LOGTAG, "To enable App Links tracking, add implementation 'androidx.localbroadcastmanager:localbroadcastmanager:1.0.0': " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            MPLog.d(APP_LINKS_LOGTAG, "To enable App Links tracking, add implementation 'androidx.localbroadcastmanager:localbroadcastmanager:1.0.0': " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            MPLog.d(APP_LINKS_LOGTAG, "App Links tracking will not be enabled due to this exception: " + e.getMessage());
        }
    }

    private static void checkIntentForInboundAppLink(Context context) {
        if (context instanceof Activity) {
            try {
                Class<?> clazz = Class.forName("bolts.AppLinks");
                Intent intent = ((Activity)context).getIntent();
                Method getTargetUrlFromInboundIntent = clazz.getMethod("getTargetUrlFromInboundIntent", Context.class, Intent.class);
                getTargetUrlFromInboundIntent.invoke(null, context, intent);
            }
            catch (InvocationTargetException e) {
                MPLog.d(APP_LINKS_LOGTAG, "Failed to invoke bolts.AppLinks.getTargetUrlFromInboundIntent() -- Unable to detect inbound App Links", e);
            }
            catch (ClassNotFoundException e) {
                MPLog.d(APP_LINKS_LOGTAG, "Please install the Bolts library >= 1.1.2 to track App Links: " + e.getMessage());
            }
            catch (NoSuchMethodException e) {
                MPLog.d(APP_LINKS_LOGTAG, "Please install the Bolts library >= 1.1.2 to track App Links: " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                MPLog.d(APP_LINKS_LOGTAG, "Unable to detect inbound App Links: " + e.getMessage());
            }
        } else {
            MPLog.d(APP_LINKS_LOGTAG, "Context is not an instance of Activity. To detect inbound App Links, pass an instance of an Activity to getInstance.");
        }
    }

    Context getContext() {
        return this.mContext;
    }

    private class GroupImpl
    implements Group {
        private final String mGroupKey;
        private final Object mGroupID;

        public GroupImpl(String groupKey, Object groupID) {
            this.mGroupKey = groupKey;
            this.mGroupID = groupID;
        }

        @Override
        public void setMap(Map<String, Object> properties) {
            if (MixpanelAPI.this.hasOptedOutTracking()) {
                return;
            }
            if (null == properties) {
                MPLog.e(MixpanelAPI.LOGTAG, "setMap does not accept null properties");
                return;
            }
            this.set(new JSONObject(properties));
        }

        @Override
        public void set(JSONObject properties) {
            if (MixpanelAPI.this.hasOptedOutTracking()) {
                return;
            }
            try {
                JSONObject sendProperties = new JSONObject();
                Iterator iter = properties.keys();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    sendProperties.put(key, properties.get(key));
                }
                JSONObject message = this.stdGroupMessage("$set", sendProperties);
                MixpanelAPI.this.recordGroupMessage(message);
            }
            catch (JSONException e) {
                MPLog.e(MixpanelAPI.LOGTAG, "Exception setting group properties", e);
            }
        }

        @Override
        public void set(String property, Object value) {
            if (MixpanelAPI.this.hasOptedOutTracking()) {
                return;
            }
            try {
                this.set(new JSONObject().put(property, value));
            }
            catch (JSONException e) {
                MPLog.e(MixpanelAPI.LOGTAG, "set", e);
            }
        }

        @Override
        public void setOnceMap(Map<String, Object> properties) {
            if (MixpanelAPI.this.hasOptedOutTracking()) {
                return;
            }
            if (null == properties) {
                MPLog.e(MixpanelAPI.LOGTAG, "setOnceMap does not accept null properties");
                return;
            }
            try {
                this.setOnce(new JSONObject(properties));
            }
            catch (NullPointerException e) {
                MPLog.w(MixpanelAPI.LOGTAG, "Can't have null keys in the properties for setOnceMap!");
            }
        }

        @Override
        public void setOnce(JSONObject properties) {
            if (MixpanelAPI.this.hasOptedOutTracking()) {
                return;
            }
            try {
                JSONObject message = this.stdGroupMessage("$set_once", properties);
                MixpanelAPI.this.recordGroupMessage(message);
            }
            catch (JSONException e) {
                MPLog.e(MixpanelAPI.LOGTAG, "Exception setting group properties");
            }
        }

        @Override
        public void setOnce(String property, Object value) {
            if (MixpanelAPI.this.hasOptedOutTracking()) {
                return;
            }
            try {
                this.setOnce(new JSONObject().put(property, value));
            }
            catch (JSONException e) {
                MPLog.e(MixpanelAPI.LOGTAG, "Property name cannot be null", e);
            }
        }

        @Override
        public void union(String name, JSONArray value) {
            if (MixpanelAPI.this.hasOptedOutTracking()) {
                return;
            }
            try {
                JSONObject properties = new JSONObject();
                properties.put(name, (Object)value);
                JSONObject message = this.stdGroupMessage("$union", properties);
                MixpanelAPI.this.recordGroupMessage(message);
            }
            catch (JSONException e) {
                MPLog.e(MixpanelAPI.LOGTAG, "Exception unioning a property", e);
            }
        }

        @Override
        public void remove(String name, Object value) {
            if (MixpanelAPI.this.hasOptedOutTracking()) {
                return;
            }
            try {
                JSONObject properties = new JSONObject();
                properties.put(name, value);
                JSONObject message = this.stdGroupMessage("$remove", properties);
                MixpanelAPI.this.recordGroupMessage(message);
            }
            catch (JSONException e) {
                MPLog.e(MixpanelAPI.LOGTAG, "Exception removing a property", e);
            }
        }

        @Override
        public void unset(String name) {
            if (MixpanelAPI.this.hasOptedOutTracking()) {
                return;
            }
            try {
                JSONArray names = new JSONArray();
                names.put((Object)name);
                JSONObject message = this.stdGroupMessage("$unset", names);
                MixpanelAPI.this.recordGroupMessage(message);
            }
            catch (JSONException e) {
                MPLog.e(MixpanelAPI.LOGTAG, "Exception unsetting a property", e);
            }
        }

        @Override
        public void deleteGroup() {
            try {
                JSONObject message = this.stdGroupMessage("$delete", JSONObject.NULL);
                MixpanelAPI.this.recordGroupMessage(message);
                MixpanelAPI.this.mGroups.remove(MixpanelAPI.this.makeMapKey(this.mGroupKey, this.mGroupID));
            }
            catch (JSONException e) {
                MPLog.e(MixpanelAPI.LOGTAG, "Exception deleting a group", e);
            }
        }

        private JSONObject stdGroupMessage(String actionType, Object properties) throws JSONException {
            JSONObject dataObj = new JSONObject();
            dataObj.put(actionType, properties);
            dataObj.put("$token", (Object)MixpanelAPI.this.mToken);
            dataObj.put("$time", System.currentTimeMillis());
            dataObj.put("$group_key", (Object)this.mGroupKey);
            dataObj.put("$group_id", this.mGroupID);
            dataObj.put("$mp_metadata", (Object)MixpanelAPI.this.mSessionMetadata.getMetadataForPeople());
            return dataObj;
        }
    }

    private class PeopleImpl
    implements People {
        private PeopleImpl() {
        }

        @Override
        public void identify(String distinctId) {
            if (MixpanelAPI.this.hasOptedOutTracking()) {
                return;
            }
            MPLog.w(MixpanelAPI.LOGTAG, "People.identify() is deprecated and calling it is no longer necessary, please use MixpanelAPI.identify() and set 'usePeople' to true instead");
            if (distinctId == null) {
                MPLog.e(MixpanelAPI.LOGTAG, "Can't identify with null distinct_id.");
                return;
            }
            if (distinctId != MixpanelAPI.this.mPersistentIdentity.getEventsDistinctId()) {
                MPLog.w(MixpanelAPI.LOGTAG, "Identifying with a distinct_id different from the one being set by MixpanelAPI.identify() is not supported.");
                return;
            }
            this.identify_people(distinctId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void identify_people(String distinctId) {
            PersistentIdentity persistentIdentity = MixpanelAPI.this.mPersistentIdentity;
            synchronized (persistentIdentity) {
                MixpanelAPI.this.mPersistentIdentity.setPeopleDistinctId(distinctId);
                MixpanelAPI.this.mDecideMessages.setDistinctId(distinctId);
            }
            MixpanelAPI.this.pushWaitingPeopleRecord(distinctId);
        }

        @Override
        public void setMap(Map<String, Object> properties) {
            if (MixpanelAPI.this.hasOptedOutTracking()) {
                return;
            }
            if (null == properties) {
                MPLog.e(MixpanelAPI.LOGTAG, "setMap does not accept null properties");
                return;
            }
            try {
                this.set(new JSONObject(properties));
            }
            catch (NullPointerException e) {
                MPLog.w(MixpanelAPI.LOGTAG, "Can't have null keys in the properties of setMap!");
            }
        }

        @Override
        public void set(JSONObject properties) {
            if (MixpanelAPI.this.hasOptedOutTracking()) {
                return;
            }
            try {
                JSONObject sendProperties = new JSONObject(MixpanelAPI.this.mDeviceInfo);
                Iterator iter = properties.keys();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    sendProperties.put(key, properties.get(key));
                }
                JSONObject message = this.stdPeopleMessage("$set", sendProperties);
                MixpanelAPI.this.recordPeopleMessage(message);
            }
            catch (JSONException e) {
                MPLog.e(MixpanelAPI.LOGTAG, "Exception setting people properties", e);
            }
        }

        @Override
        public void set(String property, Object value) {
            if (MixpanelAPI.this.hasOptedOutTracking()) {
                return;
            }
            try {
                this.set(new JSONObject().put(property, value));
            }
            catch (JSONException e) {
                MPLog.e(MixpanelAPI.LOGTAG, "set", e);
            }
        }

        @Override
        public void setOnceMap(Map<String, Object> properties) {
            if (MixpanelAPI.this.hasOptedOutTracking()) {
                return;
            }
            if (null == properties) {
                MPLog.e(MixpanelAPI.LOGTAG, "setOnceMap does not accept null properties");
                return;
            }
            try {
                this.setOnce(new JSONObject(properties));
            }
            catch (NullPointerException e) {
                MPLog.w(MixpanelAPI.LOGTAG, "Can't have null keys in the properties setOnceMap!");
            }
        }

        @Override
        public void setOnce(JSONObject properties) {
            if (MixpanelAPI.this.hasOptedOutTracking()) {
                return;
            }
            try {
                JSONObject message = this.stdPeopleMessage("$set_once", properties);
                MixpanelAPI.this.recordPeopleMessage(message);
            }
            catch (JSONException e) {
                MPLog.e(MixpanelAPI.LOGTAG, "Exception setting people properties");
            }
        }

        @Override
        public void setOnce(String property, Object value) {
            if (MixpanelAPI.this.hasOptedOutTracking()) {
                return;
            }
            try {
                this.setOnce(new JSONObject().put(property, value));
            }
            catch (JSONException e) {
                MPLog.e(MixpanelAPI.LOGTAG, "set", e);
            }
        }

        @Override
        public void increment(Map<String, ? extends Number> properties) {
            if (MixpanelAPI.this.hasOptedOutTracking()) {
                return;
            }
            JSONObject json = new JSONObject(properties);
            try {
                JSONObject message = this.stdPeopleMessage("$add", json);
                MixpanelAPI.this.recordPeopleMessage(message);
            }
            catch (JSONException e) {
                MPLog.e(MixpanelAPI.LOGTAG, "Exception incrementing properties", e);
            }
        }

        @Override
        public void merge(String property, JSONObject updates) {
            if (MixpanelAPI.this.hasOptedOutTracking()) {
                return;
            }
            JSONObject mergeMessage = new JSONObject();
            try {
                mergeMessage.put(property, (Object)updates);
                JSONObject message = this.stdPeopleMessage("$merge", mergeMessage);
                MixpanelAPI.this.recordPeopleMessage(message);
            }
            catch (JSONException e) {
                MPLog.e(MixpanelAPI.LOGTAG, "Exception merging a property", e);
            }
        }

        @Override
        public void increment(String property, double value) {
            if (MixpanelAPI.this.hasOptedOutTracking()) {
                return;
            }
            HashMap<String, Double> map = new HashMap<String, Double>();
            map.put(property, value);
            this.increment(map);
        }

        @Override
        public void append(String name, Object value) {
            if (MixpanelAPI.this.hasOptedOutTracking()) {
                return;
            }
            try {
                JSONObject properties = new JSONObject();
                properties.put(name, value);
                JSONObject message = this.stdPeopleMessage("$append", properties);
                MixpanelAPI.this.recordPeopleMessage(message);
            }
            catch (JSONException e) {
                MPLog.e(MixpanelAPI.LOGTAG, "Exception appending a property", e);
            }
        }

        @Override
        public void union(String name, JSONArray value) {
            if (MixpanelAPI.this.hasOptedOutTracking()) {
                return;
            }
            try {
                JSONObject properties = new JSONObject();
                properties.put(name, (Object)value);
                JSONObject message = this.stdPeopleMessage("$union", properties);
                MixpanelAPI.this.recordPeopleMessage(message);
            }
            catch (JSONException e) {
                MPLog.e(MixpanelAPI.LOGTAG, "Exception unioning a property");
            }
        }

        @Override
        public void remove(String name, Object value) {
            if (MixpanelAPI.this.hasOptedOutTracking()) {
                return;
            }
            try {
                JSONObject properties = new JSONObject();
                properties.put(name, value);
                JSONObject message = this.stdPeopleMessage("$remove", properties);
                MixpanelAPI.this.recordPeopleMessage(message);
            }
            catch (JSONException e) {
                MPLog.e(MixpanelAPI.LOGTAG, "Exception appending a property", e);
            }
        }

        @Override
        public void unset(String name) {
            if (MixpanelAPI.this.hasOptedOutTracking()) {
                return;
            }
            try {
                JSONArray names = new JSONArray();
                names.put((Object)name);
                JSONObject message = this.stdPeopleMessage("$unset", names);
                MixpanelAPI.this.recordPeopleMessage(message);
            }
            catch (JSONException e) {
                MPLog.e(MixpanelAPI.LOGTAG, "Exception unsetting a property", e);
            }
        }

        @Override
        public void trackCharge(double amount, JSONObject properties) {
            if (MixpanelAPI.this.hasOptedOutTracking()) {
                return;
            }
            Date now = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat(MixpanelAPI.ENGAGE_DATE_FORMAT_STRING, Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            try {
                JSONObject transactionValue = new JSONObject();
                transactionValue.put("$amount", amount);
                transactionValue.put("$time", (Object)dateFormat.format(now));
                if (null != properties) {
                    Iterator iter = properties.keys();
                    while (iter.hasNext()) {
                        String key = (String)iter.next();
                        transactionValue.put(key, properties.get(key));
                    }
                }
                this.append("$transactions", transactionValue);
            }
            catch (JSONException e) {
                MPLog.e(MixpanelAPI.LOGTAG, "Exception creating new charge", e);
            }
        }

        @Override
        public void clearCharges() {
            this.unset("$transactions");
        }

        @Override
        public void deleteUser() {
            try {
                JSONObject message = this.stdPeopleMessage("$delete", JSONObject.NULL);
                MixpanelAPI.this.recordPeopleMessage(message);
            }
            catch (JSONException e) {
                MPLog.e(MixpanelAPI.LOGTAG, "Exception deleting a user");
            }
        }

        @Override
        public String getDistinctId() {
            return MixpanelAPI.this.mPersistentIdentity.getPeopleDistinctId();
        }

        @Override
        public People withIdentity(final String distinctId) {
            if (null == distinctId) {
                return null;
            }
            return new PeopleImpl(){

                @Override
                public String getDistinctId() {
                    return distinctId;
                }

                @Override
                public void identify(String distinctId2) {
                    throw new RuntimeException("This MixpanelPeople object has a fixed, constant distinctId");
                }
            };
        }

        private JSONObject stdPeopleMessage(String actionType, Object properties) throws JSONException {
            JSONObject dataObj = new JSONObject();
            String distinctId = this.getDistinctId();
            String anonymousId = MixpanelAPI.this.getAnonymousId();
            dataObj.put(actionType, properties);
            dataObj.put("$token", (Object)MixpanelAPI.this.mToken);
            dataObj.put("$time", System.currentTimeMillis());
            dataObj.put("$had_persisted_distinct_id", MixpanelAPI.this.mPersistentIdentity.getHadPersistedDistinctId());
            if (null != anonymousId) {
                dataObj.put("$device_id", (Object)anonymousId);
            }
            if (null != distinctId) {
                dataObj.put("$distinct_id", (Object)distinctId);
                dataObj.put("$user_id", (Object)distinctId);
            }
            dataObj.put("$mp_metadata", (Object)MixpanelAPI.this.mSessionMetadata.getMetadataForPeople());
            if ((MixpanelAPI.this.getContext().getApplicationInfo().flags & 2) != 0 && properties instanceof JSONObject && !((String)((JSONObject)properties).keys().next()).startsWith("$ae_")) {
                MixpanelAPI.this.mPersistentIdentity.setHasMPDebugUsedPeople(MixpanelAPI.this.mToken);
            }
            return dataObj;
        }

        @Override
        public boolean isIdentified() {
            return this.getDistinctId() != null;
        }
    }

    static interface InstanceProcessor {
        public void process(MixpanelAPI var1);
    }

    public static interface Group {
        public void set(String var1, Object var2);

        public void setMap(Map<String, Object> var1);

        public void set(JSONObject var1);

        public void setOnce(String var1, Object var2);

        public void setOnceMap(Map<String, Object> var1);

        public void setOnce(JSONObject var1);

        public void union(String var1, JSONArray var2);

        public void remove(String var1, Object var2);

        public void unset(String var1);

        public void deleteGroup();
    }

    public static interface People {
        @Deprecated
        public void identify(String var1);

        public void set(String var1, Object var2);

        public void setMap(Map<String, Object> var1);

        public void set(JSONObject var1);

        public void setOnce(String var1, Object var2);

        public void setOnceMap(Map<String, Object> var1);

        public void setOnce(JSONObject var1);

        public void increment(String var1, double var2);

        public void merge(String var1, JSONObject var2);

        public void increment(Map<String, ? extends Number> var1);

        public void append(String var1, Object var2);

        public void union(String var1, JSONArray var2);

        public void remove(String var1, Object var2);

        public void unset(String var1);

        public void trackCharge(double var1, JSONObject var3);

        public void clearCharges();

        public void deleteUser();

        public boolean isIdentified();

        @Deprecated
        public String getDistinctId();

        public People withIdentity(String var1);
    }
}

