/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.os.Process;
import com.mixpanel.android.mpmetrics.MixpanelAPI;
import org.json.JSONException;
import org.json.JSONObject;

public class ExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final int SLEEP_TIMEOUT_MS = 400;
    private static ExceptionHandler sInstance;
    private final Thread.UncaughtExceptionHandler mDefaultExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();

    public ExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init() {
        if (sInstance != null) return;
        Class<ExceptionHandler> clazz = ExceptionHandler.class;
        synchronized (ExceptionHandler.class) {
            if (sInstance != null) return;
            sInstance = new ExceptionHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void uncaughtException(Thread t, final Throwable e) {
        MixpanelAPI.allInstances(new MixpanelAPI.InstanceProcessor(){

            @Override
            public void process(MixpanelAPI mixpanel) {
                try {
                    JSONObject messageProp = new JSONObject();
                    messageProp.put("$ae_crashed_reason", (Object)e.toString());
                    mixpanel.track("$ae_crashed", messageProp, true);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
        });
        MixpanelAPI.allInstances(new MixpanelAPI.InstanceProcessor(){

            @Override
            public void process(MixpanelAPI mixpanel) {
                mixpanel.flushNoDecideCheck();
            }
        });
        if (this.mDefaultExceptionHandler != null) {
            this.mDefaultExceptionHandler.uncaughtException(t, e);
        } else {
            this.killProcessAndExit();
        }
    }

    private void killProcessAndExit() {
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        Process.killProcess((int)Process.myPid());
        System.exit(10);
    }
}

