/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.util.MPLog;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jacoco.agent.rt.internal_8ff85ea.Offline;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class MPDbAdapter {
    private static final String LOGTAG = "MixpanelAPI.Database";
    private static final Map<Context, MPDbAdapter> sInstances;
    public static final String KEY_DATA = "data";
    public static final String KEY_CREATED_AT = "created_at";
    public static final String KEY_AUTOMATIC_DATA = "automatic_data";
    public static final String KEY_TOKEN = "token";
    public static final int ID_COLUMN_INDEX = 0;
    public static final int DATA_COLUMN_INDEX = 1;
    public static final int CREATED_AT_COLUMN_INDEX = 2;
    public static final int AUTOMATIC_DATA_COLUMN_INDEX = 3;
    public static final int TOKEN_COLUMN_INDEX = 4;
    public static final int DB_UPDATE_ERROR = -1;
    public static final int DB_OUT_OF_MEMORY_ERROR = -2;
    public static final int DB_UNDEFINED_CODE = -3;
    private static final String DATABASE_NAME = "mixpanel";
    private static final int MIN_DB_VERSION = 4;
    private static final int DATABASE_VERSION = 7;
    private static final int MAX_DB_VERSION = 7;
    private static final String CREATE_EVENTS_TABLE;
    private static final String CREATE_PEOPLE_TABLE;
    private static final String CREATE_GROUPS_TABLE;
    private static final String CREATE_ANONYMOUS_PEOPLE_TABLE;
    private static final String EVENTS_TIME_INDEX;
    private static final String PEOPLE_TIME_INDEX;
    private static final String GROUPS_TIME_INDEX;
    private static final String ANONYMOUS_PEOPLE_TIME_INDEX;
    private final MPDatabaseHelper mDb;
    private static transient /* synthetic */ boolean[] $jacocoData;

    /*
     * WARNING - void declaration
     */
    public MPDbAdapter(Context context) {
        void context2;
        boolean[] blArray = MPDbAdapter.$jacocoInit();
        this((Context)context2, DATABASE_NAME);
        blArray[0] = true;
    }

    /*
     * WARNING - void declaration
     */
    public MPDbAdapter(Context context, String string) {
        void dbName;
        void context2;
        boolean[] blArray = MPDbAdapter.$jacocoInit();
        blArray[1] = true;
        this.mDb = new MPDatabaseHelper((Context)context2, (String)dbName);
        blArray[2] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static MPDbAdapter getInstance(Context context) {
        boolean[] blArray = MPDbAdapter.$jacocoInit();
        Map<Context, MPDbAdapter> map = sInstances;
        synchronized (map) {
            try {
                MPDbAdapter ret;
                void appContext;
                Context context2;
                blArray[3] = true;
                Context context3 = context2.getApplicationContext();
                blArray[4] = true;
                if (!sInstances.containsKey(appContext)) {
                    blArray[5] = true;
                    MPDbAdapter mPDbAdapter = new MPDbAdapter((Context)appContext);
                    blArray[6] = true;
                    sInstances.put((Context)appContext, ret);
                    blArray[7] = true;
                } else {
                    ret = sInstances.get(appContext);
                    blArray[8] = true;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl18 : MonitorExitStatement: MONITOREXIT : var2_2
                blArray[9] = true;
                return ret;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl22 : MonitorExitStatement: MONITOREXIT : var2_2
                blArray[10] = true;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    public int addJSON(JSONObject jSONObject, String string, Table table, boolean bl) {
        int count;
        block14: {
            void table2;
            boolean[] blArray = MPDbAdapter.$jacocoInit();
            if (!this.belowMemThreshold()) {
                blArray[11] = true;
                MPLog.e(LOGTAG, "There is not enough space left on the device to store Mixpanel data, so data was discarded");
                blArray[12] = true;
                return -2;
            }
            String tableName = table2.getName();
            Cursor c = null;
            int n = -1;
            try {
                void db;
                void token;
                void isAutomaticRecord;
                void j;
                void cv;
                blArray[13] = true;
                SQLiteDatabase sQLiteDatabase = this.mDb.getWritableDatabase();
                blArray[14] = true;
                ContentValues contentValues = new ContentValues();
                blArray[15] = true;
                cv.put(KEY_DATA, j.toString());
                blArray[16] = true;
                cv.put(KEY_CREATED_AT, Long.valueOf(System.currentTimeMillis()));
                blArray[17] = true;
                cv.put(KEY_AUTOMATIC_DATA, Boolean.valueOf((boolean)isAutomaticRecord));
                blArray[18] = true;
                cv.put(KEY_TOKEN, (String)token);
                blArray[19] = true;
                db.insert(tableName, null, (ContentValues)cv);
                blArray[20] = true;
                c = db.rawQuery("SELECT COUNT(*) FROM " + tableName + " WHERE token='" + (String)token + "'", null);
                blArray[21] = true;
                c.moveToFirst();
                blArray[22] = true;
                count = c.getInt(0);
                if (c == null) {
                    blArray[23] = true;
                    break block14;
                }
                blArray[24] = true;
            }
            catch (SQLiteException db) {
                block15: {
                    blArray[27] = true;
                    MPLog.e(LOGTAG, "Could not add Mixpanel data to table");
                    if (c == null) {
                        blArray[28] = true;
                    } else {
                        blArray[29] = true;
                        c.close();
                        c = null;
                        blArray[30] = true;
                    }
                    this.mDb.deleteDatabase();
                    if (c == null) {
                        blArray[31] = true;
                        break block15;
                    }
                    blArray[32] = true;
                    c.close();
                    blArray[33] = true;
                }
                this.mDb.close();
                blArray[34] = true;
            }
            catch (OutOfMemoryError e) {
                block16: {
                    blArray[35] = true;
                    MPLog.e(LOGTAG, "Out of memory when adding Mixpanel data to table");
                    if (c == null) {
                        blArray[36] = true;
                        break block16;
                    }
                    blArray[37] = true;
                    {
                        catch (Throwable throwable) {
                            if (c == null) {
                                blArray[40] = true;
                            } else {
                                blArray[41] = true;
                                c.close();
                                blArray[42] = true;
                            }
                            this.mDb.close();
                            blArray[43] = true;
                            throw throwable;
                        }
                    }
                    c.close();
                    blArray[38] = true;
                }
                this.mDb.close();
                blArray[39] = true;
            }
            c.close();
            blArray[25] = true;
        }
        this.mDb.close();
        blArray[26] = true;
        blArray[44] = true;
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    int pushAnonymousUpdatesToPeopleDb(String string, String string2) {
        void count;
        block26: {
            boolean[] blArray = MPDbAdapter.$jacocoInit();
            if (!this.belowMemThreshold()) {
                blArray[45] = true;
                MPLog.e(LOGTAG, "There is not enough space left on the device to store Mixpanel data, so data was discarded");
                blArray[46] = true;
                return -2;
            }
            Cursor selectCursor = null;
            int n = -1;
            try {
                void allAnonymousQuery;
                void db;
                void token;
                blArray[47] = true;
                SQLiteDatabase sQLiteDatabase = this.mDb.getWritableDatabase();
                blArray[48] = true;
                StringBuffer stringBuffer = new StringBuffer("SELECT * FROM " + Table.ANONYMOUS_PEOPLE.getName() + " WHERE " + KEY_TOKEN + " = '" + (String)token + "'");
                blArray[49] = true;
                selectCursor = db.rawQuery(allAnonymousQuery.toString(), null);
                blArray[50] = true;
                db.beginTransaction();
                try {
                    blArray[51] = true;
                    while (selectCursor.moveToNext()) {
                        try {
                            void rowId;
                            void idColumnIndex;
                            int n2;
                            void distinctId;
                            void updatedData;
                            void dataColumnIndex;
                            int n3;
                            void tokenColumnIndex;
                            int n4;
                            void automaticDataColumnIndex;
                            int n5;
                            void createdAtColumnIndex;
                            void values;
                            int n6;
                            blArray[52] = true;
                            ContentValues contentValues = new ContentValues();
                            blArray[53] = true;
                            if (selectCursor.getColumnIndex(KEY_CREATED_AT) >= 0) {
                                n6 = selectCursor.getColumnIndex(KEY_CREATED_AT);
                                blArray[54] = true;
                            } else {
                                n6 = 2;
                                blArray[55] = true;
                            }
                            int n7 = n6;
                            blArray[56] = true;
                            values.put(KEY_CREATED_AT, Long.valueOf(selectCursor.getLong((int)createdAtColumnIndex)));
                            blArray[57] = true;
                            if (selectCursor.getColumnIndex(KEY_AUTOMATIC_DATA) >= 0) {
                                n5 = selectCursor.getColumnIndex(KEY_AUTOMATIC_DATA);
                                blArray[58] = true;
                            } else {
                                n5 = 3;
                                blArray[59] = true;
                            }
                            int n8 = n5;
                            blArray[60] = true;
                            values.put(KEY_AUTOMATIC_DATA, Integer.valueOf(selectCursor.getInt((int)automaticDataColumnIndex)));
                            blArray[61] = true;
                            if (selectCursor.getColumnIndex(KEY_TOKEN) >= 0) {
                                n4 = selectCursor.getColumnIndex(KEY_TOKEN);
                                blArray[62] = true;
                            } else {
                                n4 = 4;
                                blArray[63] = true;
                            }
                            int n9 = n4;
                            blArray[64] = true;
                            values.put(KEY_TOKEN, selectCursor.getString((int)tokenColumnIndex));
                            blArray[65] = true;
                            if (selectCursor.getColumnIndex(KEY_DATA) >= 0) {
                                n3 = selectCursor.getColumnIndex(KEY_DATA);
                                blArray[66] = true;
                            } else {
                                n3 = blArray[67] = 1;
                            }
                            int n10 = n3;
                            blArray[68] = true;
                            JSONObject jSONObject = new JSONObject(selectCursor.getString((int)dataColumnIndex));
                            blArray[69] = true;
                            updatedData.put("$distinct_id", (Object)distinctId);
                            blArray[70] = true;
                            values.put(KEY_DATA, updatedData.toString());
                            blArray[71] = true;
                            db.insert(Table.PEOPLE.getName(), null, (ContentValues)values);
                            blArray[72] = true;
                            if (selectCursor.getColumnIndex("_id") >= 0) {
                                n2 = selectCursor.getColumnIndex("_id");
                                blArray[73] = true;
                            } else {
                                n2 = 0;
                                blArray[74] = true;
                            }
                            int n11 = n2;
                            blArray[75] = true;
                            int n12 = selectCursor.getInt((int)idColumnIndex);
                            blArray[76] = true;
                            db.delete(Table.ANONYMOUS_PEOPLE.getName(), "_id = " + (int)rowId, null);
                            ++count;
                            blArray[77] = true;
                        }
                        catch (JSONException jSONException) {
                            blArray[78] = true;
                        }
                    }
                    db.setTransactionSuccessful();
                    blArray[79] = true;
                }
                catch (Throwable throwable) {
                    db.endTransaction();
                    blArray[80] = true;
                    throw throwable;
                }
                db.endTransaction();
                if (selectCursor == null) {
                    blArray[81] = true;
                    break block26;
                }
                blArray[82] = true;
            }
            catch (SQLiteException db) {
                block27: {
                    try {
                        void e;
                        blArray[85] = true;
                        MPLog.e(LOGTAG, "Could not push anonymous updates records from " + Table.ANONYMOUS_PEOPLE.getName() + ". Re-initializing database.", (Throwable)e);
                        if (selectCursor == null) {
                            blArray[86] = true;
                        } else {
                            blArray[87] = true;
                            selectCursor.close();
                            selectCursor = null;
                            blArray[88] = true;
                        }
                        this.mDb.deleteDatabase();
                        if (selectCursor == null) {
                            blArray[89] = true;
                            break block27;
                        }
                        blArray[90] = true;
                    }
                    catch (Throwable throwable) {
                        if (selectCursor == null) {
                            blArray[93] = true;
                        } else {
                            blArray[94] = true;
                            selectCursor.close();
                            blArray[95] = true;
                        }
                        this.mDb.close();
                        blArray[96] = true;
                        throw throwable;
                    }
                    selectCursor.close();
                    blArray[91] = true;
                }
                this.mDb.close();
                blArray[92] = true;
            }
            selectCursor.close();
            blArray[83] = true;
        }
        this.mDb.close();
        blArray[84] = true;
        blArray[97] = true;
        return (int)count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    int rewriteEventDataWithProperties(Map<String, String> map, String string) {
        void count;
        block21: {
            boolean[] blArray = MPDbAdapter.$jacocoInit();
            if (!this.belowMemThreshold()) {
                blArray[98] = true;
                MPLog.e(LOGTAG, "There is not enough space left on the device to store Mixpanel data, so data was discarded");
                blArray[99] = true;
                return -2;
            }
            Cursor selectCursor = null;
            boolean bl = false;
            try {
                void allAnonymousQuery;
                void db;
                void token;
                blArray[100] = true;
                SQLiteDatabase sQLiteDatabase = this.mDb.getWritableDatabase();
                blArray[101] = true;
                StringBuffer stringBuffer = new StringBuffer("SELECT * FROM " + Table.EVENTS.getName() + " WHERE " + KEY_TOKEN + " = '" + (String)token + "'");
                blArray[102] = true;
                selectCursor = db.rawQuery(allAnonymousQuery.toString(), null);
                blArray[103] = true;
                db.beginTransaction();
                try {
                    blArray[104] = true;
                    while (selectCursor.moveToNext()) {
                        try {
                            void rowId;
                            void idColumnIndex;
                            int n;
                            void values;
                            void existingProps;
                            void properties;
                            void updatedData;
                            void dataColumnIndex;
                            int n2;
                            blArray[105] = true;
                            ContentValues contentValues = new ContentValues();
                            blArray[106] = true;
                            if (selectCursor.getColumnIndex(KEY_DATA) >= 0) {
                                n2 = selectCursor.getColumnIndex(KEY_DATA);
                                blArray[107] = true;
                            } else {
                                n2 = blArray[108] = 1;
                            }
                            int n3 = n2;
                            blArray[109] = true;
                            JSONObject jSONObject = new JSONObject(selectCursor.getString((int)dataColumnIndex));
                            blArray[110] = true;
                            JSONObject jSONObject2 = updatedData.getJSONObject("properties");
                            blArray[111] = true;
                            Iterator iterator = properties.entrySet().iterator();
                            blArray[112] = true;
                            while (iterator.hasNext()) {
                                void value;
                                void key;
                                void entry;
                                Map.Entry entry2 = iterator.next();
                                blArray[113] = true;
                                String string2 = (String)entry.getKey();
                                blArray[114] = true;
                                String string3 = (String)entry.getValue();
                                blArray[115] = true;
                                existingProps.put((String)key, (Object)value);
                                blArray[116] = true;
                            }
                            updatedData.put("properties", (Object)existingProps);
                            blArray[117] = true;
                            values.put(KEY_DATA, updatedData.toString());
                            blArray[118] = true;
                            if (selectCursor.getColumnIndex("_id") >= 0) {
                                n = selectCursor.getColumnIndex("_id");
                                blArray[119] = true;
                            } else {
                                n = 0;
                                blArray[120] = true;
                            }
                            int n4 = n;
                            blArray[121] = true;
                            int entry = selectCursor.getInt((int)idColumnIndex);
                            blArray[122] = true;
                            db.update(Table.EVENTS.getName(), (ContentValues)values, "_id = " + (int)rowId, null);
                            ++count;
                            blArray[123] = true;
                        }
                        catch (JSONException jSONException) {
                            blArray[124] = true;
                        }
                    }
                    db.setTransactionSuccessful();
                    blArray[125] = true;
                }
                catch (Throwable throwable) {
                    db.endTransaction();
                    blArray[126] = true;
                    throw throwable;
                }
                db.endTransaction();
                if (selectCursor == null) {
                    blArray[127] = true;
                    break block21;
                }
                blArray[128] = true;
            }
            catch (SQLiteException db) {
                block22: {
                    try {
                        void e;
                        blArray[131] = true;
                        MPLog.e(LOGTAG, "Could not re-write events history. Re-initializing database.", (Throwable)e);
                        if (selectCursor == null) {
                            blArray[132] = true;
                        } else {
                            blArray[133] = true;
                            selectCursor.close();
                            selectCursor = null;
                            blArray[134] = true;
                        }
                        this.mDb.deleteDatabase();
                        if (selectCursor == null) {
                            blArray[135] = true;
                            break block22;
                        }
                        blArray[136] = true;
                    }
                    catch (Throwable throwable) {
                        if (selectCursor == null) {
                            blArray[139] = true;
                        } else {
                            blArray[140] = true;
                            selectCursor.close();
                            blArray[141] = true;
                        }
                        this.mDb.close();
                        blArray[142] = true;
                        throw throwable;
                    }
                    selectCursor.close();
                    blArray[137] = true;
                }
                this.mDb.close();
                blArray[138] = true;
            }
            selectCursor.close();
            blArray[129] = true;
        }
        this.mDb.close();
        blArray[130] = true;
        blArray[143] = true;
        return (int)count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    public void cleanupEvents(String string, Table table, String string2, boolean bl) {
        void tableName;
        void table2;
        boolean[] blArray = MPDbAdapter.$jacocoInit();
        String string3 = table2.getName();
        try {
            void db;
            void includeAutomaticEvents;
            void token;
            void last_id;
            blArray[144] = true;
            SQLiteDatabase sQLiteDatabase = this.mDb.getWritableDatabase();
            blArray[145] = true;
            StringBuffer deleteQuery = new StringBuffer("_id <= " + (String)last_id + " AND " + KEY_TOKEN + " = '" + (String)token + "'");
            if (includeAutomaticEvents != false) {
                blArray[146] = true;
            } else {
                blArray[147] = true;
                deleteQuery.append(" AND automatic_data=0");
                blArray[148] = true;
            }
            db.delete((String)tableName, deleteQuery.toString(), null);
            blArray[149] = true;
        }
        catch (SQLiteException db) {
            void e2333332;
            blArray[151] = true;
            MPLog.e(LOGTAG, "Could not clean sent Mixpanel records from " + (String)tableName + ". Re-initializing database.", (Throwable)e2333332);
            blArray[152] = true;
            this.mDb.deleteDatabase();
            blArray[153] = true;
            this.mDb.close();
            blArray[154] = true;
        }
        catch (Exception e2333332) {
            blArray[155] = true;
            MPLog.e(LOGTAG, "Unknown exception. Could not clean sent Mixpanel records from " + (String)tableName + ".Re-initializing database.", e2333332);
            blArray[156] = true;
            this.mDb.deleteDatabase();
            blArray[157] = true;
            {
                catch (Throwable throwable) {
                    this.mDb.close();
                    blArray[159] = true;
                    throw throwable;
                }
            }
            this.mDb.close();
            blArray[158] = true;
        }
        this.mDb.close();
        blArray[150] = true;
        blArray[160] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void cleanupEvents(long l, Table table) {
        void tableName;
        void table2;
        boolean[] blArray = MPDbAdapter.$jacocoInit();
        String string = table2.getName();
        try {
            void time;
            void db;
            blArray[161] = true;
            SQLiteDatabase sQLiteDatabase = this.mDb.getWritableDatabase();
            blArray[162] = true;
            db.delete((String)tableName, "created_at <= " + (long)time, null);
            blArray[163] = true;
        }
        catch (SQLiteException db) {
            try {
                void e;
                blArray[165] = true;
                MPLog.e(LOGTAG, "Could not clean timed-out Mixpanel records from " + (String)tableName + ". Re-initializing database.", (Throwable)e);
                blArray[166] = true;
                this.mDb.deleteDatabase();
                blArray[167] = true;
            }
            catch (Throwable throwable) {
                this.mDb.close();
                blArray[169] = true;
                throw throwable;
            }
            this.mDb.close();
            blArray[168] = true;
        }
        this.mDb.close();
        blArray[164] = true;
        blArray[170] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void cleanupAllEvents(Table table, String string) {
        void tableName;
        void table2;
        boolean[] blArray = MPDbAdapter.$jacocoInit();
        String string2 = table2.getName();
        try {
            void token;
            void db;
            blArray[171] = true;
            SQLiteDatabase sQLiteDatabase = this.mDb.getWritableDatabase();
            blArray[172] = true;
            db.delete((String)tableName, "token = '" + (String)token + "'", null);
            blArray[173] = true;
        }
        catch (SQLiteException db) {
            try {
                void e;
                blArray[175] = true;
                MPLog.e(LOGTAG, "Could not clean timed-out Mixpanel records from " + (String)tableName + ". Re-initializing database.", (Throwable)e);
                blArray[176] = true;
                this.mDb.deleteDatabase();
                blArray[177] = true;
            }
            catch (Throwable throwable) {
                this.mDb.close();
                blArray[179] = true;
                throw throwable;
            }
            this.mDb.close();
            blArray[178] = true;
        }
        this.mDb.close();
        blArray[174] = true;
        blArray[180] = true;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void cleanupAutomaticEvents(String string) {
        void token;
        boolean[] blArray = MPDbAdapter.$jacocoInit();
        this.cleanupAutomaticEvents(Table.EVENTS, (String)token);
        blArray[181] = true;
        this.cleanupAutomaticEvents(Table.PEOPLE, (String)token);
        blArray[182] = true;
        this.cleanupAutomaticEvents(Table.GROUPS, (String)token);
        blArray[183] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void cleanupAutomaticEvents(Table table, String string) {
        void tableName;
        void table2;
        boolean[] blArray = MPDbAdapter.$jacocoInit();
        String string2 = table2.getName();
        try {
            void token;
            void db;
            blArray[184] = true;
            SQLiteDatabase sQLiteDatabase = this.mDb.getWritableDatabase();
            blArray[185] = true;
            db.delete((String)tableName, "automatic_data = 1 AND token = '" + (String)token + "'", null);
            blArray[186] = true;
        }
        catch (SQLiteException db) {
            try {
                void e;
                blArray[188] = true;
                MPLog.e(LOGTAG, "Could not clean automatic Mixpanel records from " + (String)tableName + ". Re-initializing database.", (Throwable)e);
                blArray[189] = true;
                this.mDb.deleteDatabase();
                blArray[190] = true;
            }
            catch (Throwable throwable) {
                this.mDb.close();
                blArray[192] = true;
                throw throwable;
            }
            this.mDb.close();
            blArray[191] = true;
        }
        this.mDb.close();
        blArray[187] = true;
        blArray[193] = true;
    }

    public void deleteDB() {
        boolean[] blArray = MPDbAdapter.$jacocoInit();
        this.mDb.deleteDatabase();
        blArray[194] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String[] generateDataString(Table var1_1, String var2_2, boolean var3_3) {
        block30: {
            var4_4 = MPDbAdapter.$jacocoInit();
            c = null;
            queueCountCursor = null;
            data = null;
            last_id = null;
            var9_9 = null;
            var4_4[195] = true;
            var10_10 = table.getName();
            var4_4[196] = true;
            var11_11 = this.mDb.getReadableDatabase();
            try {
                var4_4[197] = true;
                var12_12 = new StringBuffer("SELECT * FROM " + (String)tableName + " WHERE " + "token" + " = '" + (String)token + "' ");
                var4_4[198] = true;
                queueCountQuery = new StringBuffer("SELECT COUNT(*) FROM " + (String)tableName + " WHERE " + "token" + " = '" + (String)token + "' ");
                if (includeAutomaticEvents != false) {
                    var4_4[199] = true;
                } else {
                    var4_4[200] = true;
                    rawDataQuery.append("AND automatic_data = 0 ");
                    var4_4[201] = true;
                    queueCountQuery.append(" AND automatic_data = 0");
                    var4_4[202] = true;
                }
                rawDataQuery.append("ORDER BY created_at ASC LIMIT 50");
                var4_4[203] = true;
                c = db.rawQuery(rawDataQuery.toString(), null);
                var4_4[204] = true;
                queueCountCursor = db.rawQuery(queueCountQuery.toString(), null);
                var4_4[205] = true;
                queueCountCursor.moveToFirst();
                var4_4[206] = true;
                queueCount = String.valueOf(queueCountCursor.getInt(0));
                var4_4[207] = true;
                var14_15 = new JSONArray();
                var4_4[208] = true;
                while (c.moveToNext()) {
                    block31: {
                        var4_4[209] = true;
                        if (c.isLast()) break block31;
                        var4_4[210] = true;
                        ** GOTO lbl58
                    }
                    var4_4[211] = true;
                    if (c.getColumnIndex("_id") >= 0) {
                        v0 = c.getColumnIndex("_id");
                        var4_4[212] = true;
                    } else {
                        v0 = 0;
                        var4_4[213] = true;
                    }
                    var15_16 = v0;
                    var4_4[214] = true;
                    last_id = c.getString(idColumnIndex);
                    try {
                        var4_4[215] = true;
lbl58:
                        // 2 sources

                        if (c.getColumnIndex("data") >= 0) {
                            v1 = c.getColumnIndex("data");
                            var4_4[216] = true;
                        } else {
                            v1 = var4_4[217] = 1;
                        }
                        idColumnIndex = v1;
                        var4_4[218] = true;
                        var16_18 = new JSONObject(c.getString((int)dataColumnIndex));
                        var4_4[219] = true;
                        arr.put((Object)j);
                        var4_4[220] = true;
                    }
                    catch (JSONException var15_17) {
                        var4_4[221] = true;
                    }
                }
                if (arr.length() <= 0) {
                    var4_4[222] = true;
                    break block30;
                }
                var4_4[223] = true;
                data = arr.toString();
                var4_4[224] = true;
            }
            catch (SQLiteException rawDataQuery) {
                try {
                    var4_4[231] = true;
                    MPLog.e("MixpanelAPI.Database", "Could not pull records for Mixpanel out of database " + (String)tableName + ". Waiting to send.", (Throwable)e);
                    last_id = null;
                    data = null;
                    var4_4[232] = true;
                }
                catch (Throwable var17_19) {
                    this.mDb.close();
                    if (c == null) {
                        var4_4[239] = true;
                    } else {
                        var4_4[240] = true;
                        c.close();
                        var4_4[241] = true;
                    }
                    if (queueCountCursor == null) {
                        var4_4[242] = true;
                    } else {
                        var4_4[243] = true;
                        queueCountCursor.close();
                        var4_4[244] = true;
                    }
                    var4_4[245] = true;
                    throw var17_19;
                }
                this.mDb.close();
                if (c == null) {
                    var4_4[233] = true;
                } else {
                    var4_4[234] = true;
                    c.close();
                    var4_4[235] = true;
                }
                if (queueCountCursor == null) {
                    var4_4[236] = true;
                } else {
                    var4_4[237] = true;
                    queueCountCursor.close();
                    var4_4[238] = true;
                }
            }
        }
        this.mDb.close();
        if (c == null) {
            var4_4[225] = true;
        } else {
            var4_4[226] = true;
            c.close();
            var4_4[227] = true;
        }
        if (queueCountCursor == null) {
            var4_4[228] = true;
        } else {
            var4_4[229] = true;
            queueCountCursor.close();
            var4_4[230] = true;
        }
        if (last_id == null) {
            var4_4[246] = true;
        } else if (data == null) {
            var4_4[247] = true;
        } else {
            ret = new String[]{last_id, data, queueCount};
            var4_4[248] = true;
            return ret;
        }
        var4_4[249] = true;
        return null;
    }

    public File getDatabaseFile() {
        boolean[] blArray = MPDbAdapter.$jacocoInit();
        blArray[250] = true;
        return MPDatabaseHelper.access$800(this.mDb);
    }

    protected boolean belowMemThreshold() {
        boolean[] blArray = MPDbAdapter.$jacocoInit();
        blArray[251] = true;
        return this.mDb.belowMemThreshold();
    }

    static /* synthetic */ String access$000() {
        boolean[] blArray = MPDbAdapter.$jacocoInit();
        blArray[252] = true;
        return CREATE_EVENTS_TABLE;
    }

    static /* synthetic */ String access$100() {
        boolean[] blArray = MPDbAdapter.$jacocoInit();
        blArray[253] = true;
        return CREATE_PEOPLE_TABLE;
    }

    static /* synthetic */ String access$200() {
        boolean[] blArray = MPDbAdapter.$jacocoInit();
        blArray[254] = true;
        return CREATE_GROUPS_TABLE;
    }

    static /* synthetic */ String access$300() {
        boolean[] blArray = MPDbAdapter.$jacocoInit();
        blArray[255] = true;
        return CREATE_ANONYMOUS_PEOPLE_TABLE;
    }

    static /* synthetic */ String access$400() {
        boolean[] blArray = MPDbAdapter.$jacocoInit();
        blArray[256] = true;
        return EVENTS_TIME_INDEX;
    }

    static /* synthetic */ String access$500() {
        boolean[] blArray = MPDbAdapter.$jacocoInit();
        blArray[257] = true;
        return PEOPLE_TIME_INDEX;
    }

    static /* synthetic */ String access$600() {
        boolean[] blArray = MPDbAdapter.$jacocoInit();
        blArray[258] = true;
        return GROUPS_TIME_INDEX;
    }

    static /* synthetic */ String access$700() {
        boolean[] blArray = MPDbAdapter.$jacocoInit();
        blArray[259] = true;
        return ANONYMOUS_PEOPLE_TIME_INDEX;
    }

    static {
        boolean[] blArray = MPDbAdapter.$jacocoInit();
        sInstances = new HashMap<Context, MPDbAdapter>();
        blArray[260] = true;
        blArray[261] = true;
        CREATE_EVENTS_TABLE = "CREATE TABLE " + Table.EVENTS.getName() + " (_id INTEGER PRIMARY KEY AUTOINCREMENT, " + KEY_DATA + " STRING NOT NULL, " + KEY_CREATED_AT + " INTEGER NOT NULL, " + KEY_AUTOMATIC_DATA + " INTEGER DEFAULT 0, " + KEY_TOKEN + " STRING NOT NULL DEFAULT '')";
        blArray[262] = true;
        blArray[263] = true;
        CREATE_PEOPLE_TABLE = "CREATE TABLE " + Table.PEOPLE.getName() + " (_id INTEGER PRIMARY KEY AUTOINCREMENT, " + KEY_DATA + " STRING NOT NULL, " + KEY_CREATED_AT + " INTEGER NOT NULL, " + KEY_AUTOMATIC_DATA + " INTEGER DEFAULT 0, " + KEY_TOKEN + " STRING NOT NULL DEFAULT '')";
        blArray[264] = true;
        blArray[265] = true;
        CREATE_GROUPS_TABLE = "CREATE TABLE " + Table.GROUPS.getName() + " (_id INTEGER PRIMARY KEY AUTOINCREMENT, " + KEY_DATA + " STRING NOT NULL, " + KEY_CREATED_AT + " INTEGER NOT NULL, " + KEY_AUTOMATIC_DATA + " INTEGER DEFAULT 0, " + KEY_TOKEN + " STRING NOT NULL DEFAULT '')";
        blArray[266] = true;
        blArray[267] = true;
        CREATE_ANONYMOUS_PEOPLE_TABLE = "CREATE TABLE " + Table.ANONYMOUS_PEOPLE.getName() + " (_id INTEGER PRIMARY KEY AUTOINCREMENT, " + KEY_DATA + " STRING NOT NULL, " + KEY_CREATED_AT + " INTEGER NOT NULL, " + KEY_AUTOMATIC_DATA + " INTEGER DEFAULT 0, " + KEY_TOKEN + " STRING NOT NULL DEFAULT '')";
        blArray[268] = true;
        blArray[269] = true;
        EVENTS_TIME_INDEX = "CREATE INDEX IF NOT EXISTS time_idx ON " + Table.EVENTS.getName() + " (" + KEY_CREATED_AT + ");";
        blArray[270] = true;
        blArray[271] = true;
        PEOPLE_TIME_INDEX = "CREATE INDEX IF NOT EXISTS time_idx ON " + Table.PEOPLE.getName() + " (" + KEY_CREATED_AT + ");";
        blArray[272] = true;
        blArray[273] = true;
        GROUPS_TIME_INDEX = "CREATE INDEX IF NOT EXISTS time_idx ON " + Table.GROUPS.getName() + " (" + KEY_CREATED_AT + ");";
        blArray[274] = true;
        blArray[275] = true;
        ANONYMOUS_PEOPLE_TIME_INDEX = "CREATE INDEX IF NOT EXISTS time_idx ON " + Table.ANONYMOUS_PEOPLE.getName() + " (" + KEY_CREATED_AT + ");";
        blArray[276] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)8843241272774341141L, (String)"com/mixpanel/android/mpmetrics/MPDbAdapter", (int)277);
        }
        return blArray;
    }

    private static class MPDatabaseHelper
    extends SQLiteOpenHelper {
        private final File mDatabaseFile;
        private final MPConfig mConfig;
        private final Context mContext;
        private static transient /* synthetic */ boolean[] $jacocoData;

        /*
         * WARNING - void declaration
         */
        MPDatabaseHelper(Context context, String string) {
            void dbName;
            void context2;
            boolean[] blArray = MPDatabaseHelper.$jacocoInit();
            super((Context)context2, (String)dbName, null, 7);
            blArray[0] = true;
            this.mDatabaseFile = context2.getDatabasePath((String)dbName);
            blArray[1] = true;
            this.mConfig = MPConfig.getInstance((Context)context2);
            this.mContext = context2;
            blArray[2] = true;
        }

        public void deleteDatabase() {
            boolean[] blArray = MPDatabaseHelper.$jacocoInit();
            this.close();
            blArray[3] = true;
            this.mDatabaseFile.delete();
            blArray[4] = true;
        }

        /*
         * WARNING - void declaration
         */
        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            void db;
            boolean[] blArray = MPDatabaseHelper.$jacocoInit();
            MPLog.v(MPDbAdapter.LOGTAG, "Creating a new Mixpanel events DB");
            blArray[5] = true;
            db.execSQL(MPDbAdapter.access$000());
            blArray[6] = true;
            db.execSQL(MPDbAdapter.access$100());
            blArray[7] = true;
            db.execSQL(MPDbAdapter.access$200());
            blArray[8] = true;
            db.execSQL(MPDbAdapter.access$300());
            blArray[9] = true;
            db.execSQL(MPDbAdapter.access$400());
            blArray[10] = true;
            db.execSQL(MPDbAdapter.access$500());
            blArray[11] = true;
            db.execSQL(MPDbAdapter.access$600());
            blArray[12] = true;
            db.execSQL(MPDbAdapter.access$700());
            blArray[13] = true;
        }

        /*
         * Unable to fully structure code
         */
        public void onUpgrade(SQLiteDatabase var1_1, int var2_2, int var3_3) {
            block8: {
                var4_4 = MPDatabaseHelper.$jacocoInit();
                MPLog.v("MixpanelAPI.Database", "Upgrading app, replacing Mixpanel events DB");
                if (oldVersion >= 4) break block8;
                var4_4[14] = true;
                ** GOTO lbl34
            }
            if (newVersion <= 7) {
                if (oldVersion != 4) {
                    var4_4[16] = true;
                } else {
                    var4_4[17] = true;
                    this.migrateTableFrom4To5((SQLiteDatabase)db);
                    var4_4[18] = true;
                    this.migrateTableFrom5To6((SQLiteDatabase)db);
                    var4_4[19] = true;
                    this.migrateTableFrom6To7((SQLiteDatabase)db);
                    var4_4[20] = true;
                }
                if (oldVersion != 5) {
                    var4_4[21] = true;
                } else {
                    var4_4[22] = true;
                    this.migrateTableFrom5To6((SQLiteDatabase)db);
                    var4_4[23] = true;
                    this.migrateTableFrom6To7((SQLiteDatabase)db);
                    var4_4[24] = true;
                }
                if (oldVersion != 6) {
                    var4_4[25] = true;
                } else {
                    var4_4[26] = true;
                    this.migrateTableFrom6To7((SQLiteDatabase)db);
                    var4_4[27] = true;
                }
            } else {
                var4_4[15] = true;
lbl34:
                // 2 sources

                db.execSQL("DROP TABLE IF EXISTS " + Table.EVENTS.getName());
                var4_4[28] = true;
                db.execSQL("DROP TABLE IF EXISTS " + Table.PEOPLE.getName());
                var4_4[29] = true;
                db.execSQL("DROP TABLE IF EXISTS " + Table.GROUPS.getName());
                var4_4[30] = true;
                db.execSQL("DROP TABLE IF EXISTS " + Table.ANONYMOUS_PEOPLE.getName());
                var4_4[31] = true;
                db.execSQL(MPDbAdapter.access$000());
                var4_4[32] = true;
                db.execSQL(MPDbAdapter.access$100());
                var4_4[33] = true;
                db.execSQL(MPDbAdapter.access$200());
                var4_4[34] = true;
                db.execSQL(MPDbAdapter.access$300());
                var4_4[35] = true;
                db.execSQL(MPDbAdapter.access$400());
                var4_4[36] = true;
                db.execSQL(MPDbAdapter.access$500());
                var4_4[37] = true;
                db.execSQL(MPDbAdapter.access$600());
                var4_4[38] = true;
                db.execSQL(MPDbAdapter.access$700());
                var4_4[39] = true;
            }
            var4_4[40] = true;
        }

        public boolean belowMemThreshold() {
            boolean[] blArray = MPDatabaseHelper.$jacocoInit();
            if (this.mDatabaseFile.exists()) {
                boolean bl;
                blArray[41] = true;
                if (Math.max(this.mDatabaseFile.getUsableSpace(), (long)this.mConfig.getMinimumDatabaseLimit()) >= this.mDatabaseFile.length()) {
                    bl = blArray[42] = true;
                } else {
                    bl = false;
                    blArray[43] = true;
                }
                blArray[44] = true;
                return bl;
            }
            blArray[45] = true;
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private void migrateTableFrom4To5(SQLiteDatabase sQLiteDatabase) {
            void peopleCursor;
            JSONObject token;
            void eventsCursor;
            void db;
            boolean[] blArray = MPDatabaseHelper.$jacocoInit();
            db.execSQL("ALTER TABLE " + Table.EVENTS.getName() + " ADD COLUMN " + MPDbAdapter.KEY_AUTOMATIC_DATA + " INTEGER DEFAULT 0");
            blArray[46] = true;
            db.execSQL("ALTER TABLE " + Table.PEOPLE.getName() + " ADD COLUMN " + MPDbAdapter.KEY_AUTOMATIC_DATA + " INTEGER DEFAULT 0");
            blArray[47] = true;
            db.execSQL("ALTER TABLE " + Table.EVENTS.getName() + " ADD COLUMN " + MPDbAdapter.KEY_TOKEN + " STRING NOT NULL DEFAULT ''");
            blArray[48] = true;
            db.execSQL("ALTER TABLE " + Table.PEOPLE.getName() + " ADD COLUMN " + MPDbAdapter.KEY_TOKEN + " STRING NOT NULL DEFAULT ''");
            blArray[49] = true;
            Cursor cursor = db.rawQuery("SELECT * FROM " + Table.EVENTS.getName(), null);
            blArray[50] = true;
            while (eventsCursor.moveToNext()) {
                int rowId;
                boolean bl = false;
                try {
                    void idColumnIndex2;
                    int n;
                    void j2;
                    void dataColumnIndex;
                    int n2;
                    blArray[51] = true;
                    if (eventsCursor.getColumnIndex(MPDbAdapter.KEY_DATA) >= 0) {
                        n2 = eventsCursor.getColumnIndex(MPDbAdapter.KEY_DATA);
                        blArray[52] = true;
                    } else {
                        n2 = blArray[53] = 1;
                    }
                    int n3 = n2;
                    blArray[54] = true;
                    JSONObject jSONObject = new JSONObject(eventsCursor.getString((int)dataColumnIndex));
                    blArray[55] = true;
                    String string = j2.getJSONObject("properties").getString(MPDbAdapter.KEY_TOKEN);
                    blArray[56] = true;
                    if (eventsCursor.getColumnIndex("_id") >= 0) {
                        n = eventsCursor.getColumnIndex("_id");
                        blArray[57] = true;
                    } else {
                        n = 0;
                        blArray[58] = true;
                    }
                    int n4 = n;
                    blArray[59] = true;
                    rowId = eventsCursor.getInt((int)idColumnIndex2);
                    blArray[60] = true;
                    db.execSQL("UPDATE " + Table.EVENTS.getName() + " SET " + MPDbAdapter.KEY_TOKEN + " = '" + (String)token + "' WHERE _id = " + rowId);
                    blArray[61] = true;
                }
                catch (JSONException dataColumnIndex) {
                    blArray[62] = true;
                    db.delete(Table.EVENTS.getName(), "_id = " + rowId, null);
                    blArray[63] = true;
                }
                blArray[64] = true;
            }
            Cursor rowId = db.rawQuery("SELECT * FROM " + Table.PEOPLE.getName(), null);
            blArray[65] = true;
            while (peopleCursor.moveToNext()) {
                int rowId2;
                boolean e = false;
                try {
                    void token2;
                    void idColumnIndex;
                    int n;
                    void j;
                    void dataColumnIndex;
                    int n5;
                    blArray[66] = true;
                    if (peopleCursor.getColumnIndex(MPDbAdapter.KEY_DATA) >= 0) {
                        n5 = peopleCursor.getColumnIndex(MPDbAdapter.KEY_DATA);
                        blArray[67] = true;
                    } else {
                        n5 = blArray[68] = 1;
                    }
                    int j2 = n5;
                    blArray[69] = true;
                    token = new JSONObject(peopleCursor.getString((int)dataColumnIndex));
                    blArray[70] = true;
                    String idColumnIndex2 = j.getString("$token");
                    blArray[71] = true;
                    if (peopleCursor.getColumnIndex("_id") >= 0) {
                        n = peopleCursor.getColumnIndex("_id");
                        blArray[72] = true;
                    } else {
                        n = 0;
                        blArray[73] = true;
                    }
                    int n6 = n;
                    blArray[74] = true;
                    rowId2 = peopleCursor.getInt((int)idColumnIndex);
                    blArray[75] = true;
                    db.execSQL("UPDATE " + Table.PEOPLE.getName() + " SET " + MPDbAdapter.KEY_TOKEN + " = '" + (String)token2 + "' WHERE _id = " + rowId2);
                    blArray[76] = true;
                }
                catch (JSONException dataColumnIndex) {
                    blArray[77] = true;
                    db.delete(Table.PEOPLE.getName(), "_id = " + rowId2, null);
                    blArray[78] = true;
                }
                blArray[79] = true;
            }
            blArray[80] = true;
        }

        /*
         * WARNING - void declaration
         */
        private void migrateTableFrom5To6(SQLiteDatabase sQLiteDatabase) {
            void db;
            boolean[] blArray = MPDatabaseHelper.$jacocoInit();
            db.execSQL(MPDbAdapter.access$200());
            blArray[81] = true;
            db.execSQL(MPDbAdapter.access$600());
            blArray[82] = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private void migrateTableFrom6To7(SQLiteDatabase sQLiteDatabase) {
            block10: {
                String[] storedPrefsFiles;
                void prefsDir;
                void db;
                block11: {
                    block9: {
                        boolean[] blArray = MPDatabaseHelper.$jacocoInit();
                        db.execSQL(MPDbAdapter.access$300());
                        blArray[83] = true;
                        db.execSQL(MPDbAdapter.access$700());
                        blArray[84] = true;
                        File file = new File(this.mContext.getApplicationInfo().dataDir, "shared_prefs");
                        blArray[85] = true;
                        if (prefsDir.exists()) break block9;
                        blArray[86] = true;
                        break block10;
                    }
                    if (prefsDir.isDirectory()) break block11;
                    blArray[87] = true;
                    break block10;
                }
                blArray[88] = true;
                String[] stringArray = storedPrefsFiles = prefsDir.list(new FilenameFilter(this){
                    final /* synthetic */ MPDatabaseHelper this$0;
                    private static transient /* synthetic */ boolean[] $jacocoData;
                    {
                        void this$0;
                        boolean[] blArray = 1.$jacocoInit();
                        this.this$0 = this$0;
                        blArray[0] = true;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public boolean accept(File file, String string) {
                        void name;
                        boolean[] blArray = 1.$jacocoInit();
                        blArray[1] = true;
                        return name.startsWith("com.mixpanel.android.mpmetrics.MixpanelAPI_");
                    }

                    private static /* synthetic */ boolean[] $jacocoInit() {
                        boolean[] blArray = $jacocoData;
                        if ($jacocoData == null) {
                            blArray = $jacocoData = Offline.getProbes((long)1654810455774769653L, (String)"com/mixpanel/android/mpmetrics/MPDbAdapter$MPDatabaseHelper$1", (int)2);
                        }
                        return blArray;
                    }
                });
                int n = stringArray.length;
                int n2 = 0;
                blArray[89] = true;
                while (true) {
                    block13: {
                        void e;
                        SharedPreferences.Editor waitingObjects2;
                        String waitingPeopleUpdates;
                        void s;
                        block12: {
                            void storedPrefName;
                            void storedPrefFile;
                            if (n2 >= n) {
                                blArray[90] = true;
                                break;
                            }
                            String string = stringArray[n2];
                            blArray[91] = true;
                            String string2 = storedPrefFile.split("\\.xml")[0];
                            blArray[92] = true;
                            SharedPreferences sharedPreferences = this.mContext.getSharedPreferences((String)storedPrefName, 0);
                            blArray[93] = true;
                            waitingPeopleUpdates = s.getString("waiting_array", null);
                            if (waitingPeopleUpdates != null) break block12;
                            blArray[94] = true;
                            break block13;
                        }
                        try {
                            blArray[95] = true;
                            JSONArray jSONArray = new JSONArray(waitingPeopleUpdates);
                            blArray[96] = true;
                            db.beginTransaction();
                            try {
                                void i;
                                blArray[97] = true;
                                boolean bl = false;
                                blArray[98] = true;
                                while (i < waitingObjects2.length()) {
                                    try {
                                        void token;
                                        void cv;
                                        void j;
                                        blArray[99] = true;
                                        JSONObject jSONObject = waitingObjects2.getJSONObject((int)i);
                                        blArray[100] = true;
                                        String string = j.getString("$token");
                                        blArray[101] = true;
                                        ContentValues contentValues = new ContentValues();
                                        blArray[102] = true;
                                        cv.put(MPDbAdapter.KEY_DATA, j.toString());
                                        blArray[103] = true;
                                        cv.put(MPDbAdapter.KEY_CREATED_AT, Long.valueOf(System.currentTimeMillis()));
                                        blArray[104] = true;
                                        cv.put(MPDbAdapter.KEY_AUTOMATIC_DATA, Boolean.valueOf(false));
                                        blArray[105] = true;
                                        cv.put(MPDbAdapter.KEY_TOKEN, (String)token);
                                        blArray[106] = true;
                                        db.insert(Table.ANONYMOUS_PEOPLE.getName(), null, (ContentValues)cv);
                                        blArray[107] = true;
                                    }
                                    catch (JSONException jSONException) {
                                        blArray[108] = true;
                                    }
                                    ++i;
                                    blArray[109] = true;
                                }
                                db.setTransactionSuccessful();
                                blArray[110] = true;
                            }
                            catch (Throwable throwable) {
                                db.endTransaction();
                                blArray[111] = true;
                                throw throwable;
                            }
                            db.endTransaction();
                            blArray[112] = true;
                        }
                        catch (JSONException waitingObjects2) {
                            blArray[113] = true;
                        }
                        waitingObjects2 = s.edit();
                        blArray[114] = true;
                        e.remove("waiting_array");
                        blArray[115] = true;
                        e.apply();
                        blArray[116] = true;
                    }
                    ++n2;
                    blArray[117] = true;
                }
            }
            blArray[118] = true;
        }

        static /* synthetic */ File access$800(MPDatabaseHelper mPDatabaseHelper) {
            MPDatabaseHelper x0;
            boolean[] blArray = MPDatabaseHelper.$jacocoInit();
            blArray[119] = true;
            return x0.mDatabaseFile;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)7175332835669073482L, (String)"com/mixpanel/android/mpmetrics/MPDbAdapter$MPDatabaseHelper", (int)120);
            }
            return blArray;
        }
    }

    public static final class Table
    extends Enum<Table> {
        public static final /* enum */ Table EVENTS;
        public static final /* enum */ Table PEOPLE;
        public static final /* enum */ Table ANONYMOUS_PEOPLE;
        public static final /* enum */ Table GROUPS;
        private final String mTableName;
        private static final /* synthetic */ Table[] $VALUES;
        private static transient /* synthetic */ boolean[] $jacocoData;

        public static Table[] values() {
            boolean[] blArray = Table.$jacocoInit();
            blArray[0] = true;
            return (Table[])$VALUES.clone();
        }

        public static Table valueOf(String string) {
            String name;
            boolean[] blArray = Table.$jacocoInit();
            blArray[1] = true;
            return Enum.valueOf(Table.class, name);
        }

        /*
         * WARNING - void declaration
         */
        private Table(String string2) {
            void name;
            boolean[] blArray = Table.$jacocoInit();
            this.mTableName = name;
            blArray[2] = true;
        }

        public String getName() {
            boolean[] blArray = Table.$jacocoInit();
            blArray[3] = true;
            return this.mTableName;
        }

        static {
            boolean[] blArray = Table.$jacocoInit();
            EVENTS = new Table("events");
            blArray[4] = true;
            PEOPLE = new Table("people");
            blArray[5] = true;
            ANONYMOUS_PEOPLE = new Table("anonymous_people");
            blArray[6] = true;
            GROUPS = new Table("groups");
            $VALUES = new Table[]{EVENTS, PEOPLE, ANONYMOUS_PEOPLE, GROUPS};
            blArray[7] = true;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)-8857894931965764161L, (String)"com/mixpanel/android/mpmetrics/MPDbAdapter$Table", (int)8);
            }
            return blArray;
        }
    }
}

