/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.content.Context;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.android.installreferrer.api.ReferrerDetails;
import com.mixpanel.android.mpmetrics.PersistentIdentity;
import com.mixpanel.android.util.MPLog;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jacoco.agent.rt.internal_8ff85ea.Offline;

class InstallReferrerPlay
implements InstallReferrerStateListener {
    private static String TAG;
    private static final int MAX_INSTALL_REFERRER_RETRIES = 5;
    private static final int TIME_MS_BETWEEN_RETRIES = 2500;
    protected static final Pattern UTM_SOURCE_PATTERN;
    private final Pattern UTM_MEDIUM_PATTERN;
    private final Pattern UTM_CAMPAIGN_PATTERN;
    private final Pattern UTM_CONTENT_PATTERN;
    private final Pattern UTM_TERM_PATTERN;
    private static boolean sHasStartedConnection;
    private Context mContext;
    private ReferrerCallback mCallBack;
    private InstallReferrerClient mReferrerClient;
    private int mRetryCount;
    private Timer mTimer;
    private static transient /* synthetic */ boolean[] $jacocoData;

    /*
     * WARNING - void declaration
     */
    public InstallReferrerPlay(Context context, ReferrerCallback referrerCallback) {
        void callback;
        void appContext;
        boolean[] blArray = InstallReferrerPlay.$jacocoInit();
        blArray[0] = true;
        this.UTM_MEDIUM_PATTERN = Pattern.compile("(^|&)utm_medium=([^&#=]*)([#&]|$)");
        blArray[1] = true;
        this.UTM_CAMPAIGN_PATTERN = Pattern.compile("(^|&)utm_campaign=([^&#=]*)([#&]|$)");
        blArray[2] = true;
        this.UTM_CONTENT_PATTERN = Pattern.compile("(^|&)utm_content=([^&#=]*)([#&]|$)");
        blArray[3] = true;
        this.UTM_TERM_PATTERN = Pattern.compile("(^|&)utm_term=([^&#=]*)([#&]|$)");
        this.mContext = appContext;
        this.mCallBack = callback;
        this.mRetryCount = 0;
        blArray[4] = true;
        this.mTimer = new Timer();
        blArray[5] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void onInstallReferrerSetupFinished(int n) {
        void responseCode;
        boolean[] blArray = InstallReferrerPlay.$jacocoInit();
        boolean shouldRetry = false;
        switch (responseCode) {
            default: {
                blArray[6] = true;
                break;
            }
            case 0: {
                blArray[7] = true;
                try {
                    void referrer;
                    void details;
                    ReferrerDetails referrerDetails = this.mReferrerClient.getInstallReferrer();
                    blArray[8] = true;
                    String string = details.getInstallReferrer();
                    blArray[9] = true;
                    this.saveReferrerDetails((String)referrer);
                    blArray[10] = true;
                }
                catch (Exception details) {
                    void e;
                    blArray[11] = true;
                    MPLog.d(TAG, "There was an error fetching your referrer details.", (Throwable)e);
                    shouldRetry = true;
                    blArray[12] = true;
                }
                break;
            }
            case 1: {
                shouldRetry = true;
                blArray[13] = true;
                MPLog.d(TAG, "Service is currently unavailable.");
                blArray[14] = true;
                break;
            }
            case -1: {
                shouldRetry = true;
                blArray[15] = true;
                MPLog.d(TAG, "Service was disconnected unexpectedly.");
                blArray[16] = true;
                break;
            }
            case 2: {
                MPLog.d(TAG, "API not available on the current Play Store app.");
                blArray[17] = true;
                break;
            }
            case 3: {
                MPLog.d(TAG, "Unexpected error.");
                blArray[18] = true;
                break;
            }
        }
        if (shouldRetry) {
            blArray[19] = true;
            this.retryConnection();
            blArray[20] = true;
        } else {
            this.disconnect();
            blArray[21] = true;
        }
        blArray[22] = true;
    }

    public void onInstallReferrerServiceDisconnected() {
        boolean[] blArray = InstallReferrerPlay.$jacocoInit();
        MPLog.d(TAG, "Install Referrer Service Disconnected.");
        blArray[23] = true;
        this.retryConnection();
        blArray[24] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void connect() {
        boolean[] blArray = InstallReferrerPlay.$jacocoInit();
        try {
            this.mReferrerClient = InstallReferrerClient.newBuilder((Context)this.mContext).build();
            blArray[25] = true;
            this.mReferrerClient.startConnection((InstallReferrerStateListener)this);
            sHasStartedConnection = true;
        }
        catch (SecurityException securityException) {
            void e;
            blArray[27] = true;
            MPLog.e(TAG, "Install referrer client could not start connection", (Throwable)e);
            blArray[28] = true;
        }
        blArray[26] = true;
        blArray[29] = true;
    }

    private void retryConnection() {
        boolean[] blArray = InstallReferrerPlay.$jacocoInit();
        if (this.mRetryCount > 5) {
            blArray[30] = true;
            MPLog.d(TAG, "Already retried 5 times. Disconnecting...");
            blArray[31] = true;
            this.disconnect();
            blArray[32] = true;
            return;
        }
        this.mTimer.schedule(new TimerTask(this){
            final /* synthetic */ InstallReferrerPlay this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 1.$jacocoInit();
                this.this$0 = this$0;
                blArray[0] = true;
            }

            @Override
            public void run() {
                boolean[] blArray = 1.$jacocoInit();
                this.this$0.connect();
                blArray[1] = true;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)-8779263208564188635L, (String)"com/mixpanel/android/mpmetrics/InstallReferrerPlay$1", (int)2);
                }
                return blArray;
            }
        }, 2500L);
        ++this.mRetryCount;
        blArray[33] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void disconnect() {
        boolean[] blArray = InstallReferrerPlay.$jacocoInit();
        if (this.mReferrerClient == null) {
            blArray[34] = true;
        } else if (!this.mReferrerClient.isReady()) {
            blArray[35] = true;
        } else {
            try {
                blArray[36] = true;
                this.mReferrerClient.endConnection();
                blArray[37] = true;
            }
            catch (Exception exception) {
                void e;
                blArray[38] = true;
                MPLog.e(TAG, "Error closing referrer connection", (Throwable)e);
                blArray[39] = true;
            }
        }
        blArray[40] = true;
    }

    public static boolean hasStartedConnection() {
        boolean[] blArray = InstallReferrerPlay.$jacocoInit();
        blArray[41] = true;
        return sHasStartedConnection;
    }

    /*
     * WARNING - void declaration
     */
    void saveReferrerDetails(String string) {
        void termMatcher;
        void contentMatcher;
        void campaignMatcher;
        void mediumMatcher;
        void sourceMatcher;
        void newPrefs;
        void referrer;
        boolean[] blArray = InstallReferrerPlay.$jacocoInit();
        if (referrer == null) {
            blArray[42] = true;
            return;
        }
        HashMap hashMap = new HashMap();
        blArray[43] = true;
        newPrefs.put("referrer", referrer);
        blArray[44] = true;
        Matcher matcher = UTM_SOURCE_PATTERN.matcher((CharSequence)referrer);
        blArray[45] = true;
        String source = this.find((Matcher)sourceMatcher);
        if (null == source) {
            blArray[46] = true;
        } else {
            blArray[47] = true;
            newPrefs.put("utm_source", source);
            blArray[48] = true;
        }
        Matcher matcher2 = this.UTM_MEDIUM_PATTERN.matcher((CharSequence)referrer);
        blArray[49] = true;
        String medium = this.find((Matcher)mediumMatcher);
        if (null == medium) {
            blArray[50] = true;
        } else {
            blArray[51] = true;
            newPrefs.put("utm_medium", medium);
            blArray[52] = true;
        }
        Matcher matcher3 = this.UTM_CAMPAIGN_PATTERN.matcher((CharSequence)referrer);
        blArray[53] = true;
        String campaign = this.find((Matcher)campaignMatcher);
        if (null == campaign) {
            blArray[54] = true;
        } else {
            blArray[55] = true;
            newPrefs.put("utm_campaign", campaign);
            blArray[56] = true;
        }
        Matcher matcher4 = this.UTM_CONTENT_PATTERN.matcher((CharSequence)referrer);
        blArray[57] = true;
        String content = this.find((Matcher)contentMatcher);
        if (null == content) {
            blArray[58] = true;
        } else {
            blArray[59] = true;
            newPrefs.put("utm_content", content);
            blArray[60] = true;
        }
        Matcher matcher5 = this.UTM_TERM_PATTERN.matcher((CharSequence)referrer);
        blArray[61] = true;
        String term = this.find((Matcher)termMatcher);
        if (null == term) {
            blArray[62] = true;
        } else {
            blArray[63] = true;
            newPrefs.put("utm_term", term);
            blArray[64] = true;
        }
        PersistentIdentity.writeReferrerPrefs(this.mContext, "com.mixpanel.android.mpmetrics.ReferralInfo", (Map<String, String>)newPrefs);
        if (this.mCallBack == null) {
            blArray[65] = true;
        } else {
            blArray[66] = true;
            this.mCallBack.onReferrerReadSuccess();
            blArray[67] = true;
        }
        blArray[68] = true;
    }

    /*
     * WARNING - void declaration
     */
    private String find(Matcher matcher) {
        void matcher2;
        boolean[] blArray = InstallReferrerPlay.$jacocoInit();
        if (!matcher2.find()) {
            blArray[69] = true;
        } else {
            blArray[70] = true;
            String encoded = matcher2.group(2);
            if (null == encoded) {
                blArray[71] = true;
            } else {
                try {
                    blArray[72] = true;
                    blArray[73] = true;
                    return URLDecoder.decode(encoded, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    blArray[74] = true;
                    MPLog.e(TAG, "Could not decode a parameter into UTF-8");
                    blArray[75] = true;
                }
            }
        }
        blArray[76] = true;
        return null;
    }

    static {
        boolean[] blArray = InstallReferrerPlay.$jacocoInit();
        TAG = "MixpanelAPI.InstallReferrerPlay";
        blArray[77] = true;
        UTM_SOURCE_PATTERN = Pattern.compile("(^|&)utm_source=([^&#=]*)([#&]|$)");
        sHasStartedConnection = false;
        blArray[78] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)2726198329649544557L, (String)"com/mixpanel/android/mpmetrics/InstallReferrerPlay", (int)79);
        }
        return blArray;
    }

    static interface ReferrerCallback {
        public void onReferrerReadSuccess();
    }
}

