/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import com.mixpanel.android.mpmetrics.ConfigurationChecker;
import com.mixpanel.android.util.MPLog;
import java.util.Random;
import org.json.JSONException;
import org.json.JSONObject;

class SessionMetadata {
    private long mEventsCounter;
    private long mPeopleCounter;
    private long mSessionStartEpoch;
    private String mSessionID;
    private Random mRandom;

    SessionMetadata() {
        this.initSession();
        this.mRandom = new Random();
    }

    protected void initSession() {
        this.mEventsCounter = 0L;
        this.mPeopleCounter = 0L;
        this.mSessionID = Long.toHexString(new Random().nextLong());
        this.mSessionStartEpoch = System.currentTimeMillis() / 1000L;
    }

    public JSONObject getMetadataForEvent() {
        return this.getNewMetadata(true);
    }

    public JSONObject getMetadataForPeople() {
        return this.getNewMetadata(false);
    }

    private JSONObject getNewMetadata(boolean isEvent) {
        JSONObject metadataJson = new JSONObject();
        try {
            metadataJson.put("$mp_event_id", (Object)Long.toHexString(this.mRandom.nextLong()));
            metadataJson.put("$mp_session_id", (Object)this.mSessionID);
            metadataJson.put("$mp_session_seq_id", isEvent ? this.mEventsCounter : this.mPeopleCounter);
            metadataJson.put("$mp_session_start_sec", this.mSessionStartEpoch);
            if (isEvent) {
                ++this.mEventsCounter;
            } else {
                ++this.mPeopleCounter;
            }
        }
        catch (JSONException e) {
            MPLog.e(ConfigurationChecker.LOGTAG, "Cannot create session metadata JSON object", e);
        }
        return metadataJson;
    }
}

