/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.mpmetrics.MixpanelAPI;
import com.mixpanel.android.viewcrawler.GestureTracker;
import java.lang.ref.WeakReference;
import org.json.JSONException;
import org.json.JSONObject;

@TargetApi(value=14)
class MixpanelActivityLifecycleCallbacks
implements Application.ActivityLifecycleCallbacks {
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private Runnable check;
    private boolean mIsForeground = true;
    private boolean mPaused = true;
    private static Double sStartSessionTime;
    public static final int CHECK_DELAY = 500;
    private final MixpanelAPI mMpInstance;
    private final MPConfig mConfig;
    private WeakReference<Activity> mCurrentActivity;

    public MixpanelActivityLifecycleCallbacks(MixpanelAPI mpInstance, MPConfig config) {
        this.mMpInstance = mpInstance;
        this.mConfig = config;
        if (sStartSessionTime == null) {
            sStartSessionTime = System.currentTimeMillis();
        }
    }

    public void onActivityStarted(Activity activity) {
        this.trackCampaignOpenedIfNeeded(activity.getIntent());
        if (Build.VERSION.SDK_INT >= 16 && this.mConfig.getAutoShowMixpanelUpdates()) {
            this.mMpInstance.getPeople().showNotificationIfAvailable(activity);
        }
        new GestureTracker(this.mMpInstance, activity);
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityPaused(Activity activity) {
        this.mPaused = true;
        if (this.check != null) {
            this.mHandler.removeCallbacks(this.check);
        }
        this.mCurrentActivity = null;
        this.check = new Runnable(){

            @Override
            public void run() {
                if (MixpanelActivityLifecycleCallbacks.this.mIsForeground && MixpanelActivityLifecycleCallbacks.this.mPaused) {
                    MixpanelActivityLifecycleCallbacks.this.mIsForeground = false;
                    try {
                        double sessionLength = (double)System.currentTimeMillis() - sStartSessionTime;
                        if (sessionLength >= (double)MixpanelActivityLifecycleCallbacks.this.mConfig.getMinimumSessionDuration() && sessionLength < (double)MixpanelActivityLifecycleCallbacks.this.mConfig.getSessionTimeoutDuration()) {
                            double elapsedTime = sessionLength / 1000.0;
                            double elapsedTimeRounded = (double)Math.round(elapsedTime * 10.0) / 10.0;
                            JSONObject sessionProperties = new JSONObject();
                            sessionProperties.put("$ae_session_length", elapsedTimeRounded);
                            MixpanelActivityLifecycleCallbacks.this.mMpInstance.getPeople().increment("$ae_total_app_sessions", 1.0);
                            MixpanelActivityLifecycleCallbacks.this.mMpInstance.getPeople().increment("$ae_total_app_session_length", elapsedTimeRounded);
                            MixpanelActivityLifecycleCallbacks.this.mMpInstance.track("$ae_session", sessionProperties, true);
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    MixpanelActivityLifecycleCallbacks.this.mMpInstance.onBackground();
                }
            }
        };
        this.mHandler.postDelayed(this.check, 500L);
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityResumed(Activity activity) {
        if (Build.VERSION.SDK_INT >= 16 && this.mConfig.getAutoShowMixpanelUpdates()) {
            this.mMpInstance.getPeople().joinExperimentIfAvailable();
        }
        this.mCurrentActivity = new WeakReference<Activity>(activity);
        this.mPaused = false;
        boolean wasBackground = !this.mIsForeground;
        this.mIsForeground = true;
        if (this.check != null) {
            this.mHandler.removeCallbacks(this.check);
        }
        if (wasBackground) {
            sStartSessionTime = System.currentTimeMillis();
            this.mMpInstance.onForeground();
        }
    }

    public void onActivityStopped(Activity activity) {
    }

    protected boolean isInForeground() {
        return this.mIsForeground;
    }

    protected Activity getCurrentActivity() {
        return this.mCurrentActivity != null ? (Activity)this.mCurrentActivity.get() : null;
    }

    private void trackCampaignOpenedIfNeeded(Intent intent) {
        if (intent == null) {
            return;
        }
        if (intent.hasExtra("mp_campaign_id") && intent.hasExtra("mp_message_id")) {
            MixpanelAPI.trackPushNotificationEventFromIntent(this.mMpInstance.getContext(), intent, "$app_open");
        }
    }
}

