/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.viewcrawler;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import com.mixpanel.android.mpmetrics.ResourceIds;
import com.mixpanel.android.util.ImageStore;
import com.mixpanel.android.util.JSONUtils;
import com.mixpanel.android.util.MPLog;
import com.mixpanel.android.util.MPPair;
import com.mixpanel.android.viewcrawler.Caller;
import com.mixpanel.android.viewcrawler.Pathfinder;
import com.mixpanel.android.viewcrawler.PropertyDescription;
import com.mixpanel.android.viewcrawler.ViewSnapshot;
import com.mixpanel.android.viewcrawler.ViewVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class EditProtocol {
    private final Context mContext;
    private final ResourceIds mResourceIds;
    private final ImageStore mImageStore;
    private final ViewVisitor.OnLayoutErrorListener mLayoutErrorListener;
    private static final Class<?>[] NO_PARAMS = new Class[0];
    private static final List<Pathfinder.PathElement> NEVER_MATCH_PATH = Collections.emptyList();
    private static final String LOGTAG = "MixpanelAPI.EProtocol";

    public EditProtocol(Context context, ResourceIds resourceIds, ImageStore imageStore, ViewVisitor.OnLayoutErrorListener layoutErrorListener) {
        this.mContext = context;
        this.mResourceIds = resourceIds;
        this.mImageStore = imageStore;
        this.mLayoutErrorListener = layoutErrorListener;
    }

    public ViewVisitor readEventBinding(JSONObject source, ViewVisitor.OnEventListener listener) throws BadInstructionsException {
        try {
            String eventName = source.getString("event_name");
            String eventType = source.getString("event_type");
            JSONArray pathDesc = source.getJSONArray("path");
            List<Pathfinder.PathElement> path = this.readPath(pathDesc, this.mResourceIds);
            if (path.size() == 0) {
                throw new InapplicableInstructionsException("event '" + eventName + "' will not be bound to any element in the UI.");
            }
            if ("click".equals(eventType)) {
                return new ViewVisitor.AddAccessibilityEventVisitor(path, 1, eventName, listener);
            }
            if ("selected".equals(eventType)) {
                return new ViewVisitor.AddAccessibilityEventVisitor(path, 4, eventName, listener);
            }
            if ("text_changed".equals(eventType)) {
                return new ViewVisitor.AddTextChangeListener(path, eventName, listener);
            }
            if ("detected".equals(eventType)) {
                return new ViewVisitor.ViewDetectorVisitor(path, eventName, listener);
            }
            throw new BadInstructionsException("Mixpanel can't track event type \"" + eventType + "\"");
        }
        catch (JSONException e) {
            throw new BadInstructionsException("Can't interpret instructions due to JSONException", e);
        }
    }

    public Edit readEdit(JSONObject source) throws BadInstructionsException, CantGetEditAssetsException {
        ViewVisitor visitor;
        ArrayList<String> assetsLoaded;
        block13: {
            assetsLoaded = new ArrayList<String>();
            try {
                JSONArray pathDesc = source.getJSONArray("path");
                List<Pathfinder.PathElement> path = this.readPath(pathDesc, this.mResourceIds);
                if (path.size() == 0) {
                    throw new InapplicableInstructionsException("Edit will not be bound to any element in the UI.");
                }
                if (source.getString("change_type").equals("property")) {
                    Class<?> targetClass;
                    JSONObject propertyDesc = source.getJSONObject("property");
                    String targetClassName = propertyDesc.getString("classname");
                    if (null == targetClassName) {
                        throw new BadInstructionsException("Can't bind an edit property without a target class");
                    }
                    try {
                        targetClass = Class.forName(targetClassName);
                    }
                    catch (ClassNotFoundException e) {
                        throw new BadInstructionsException("Can't find class for visit path: " + targetClassName, e);
                    }
                    PropertyDescription prop = this.readPropertyDescription(targetClass, source.getJSONObject("property"));
                    JSONArray argsAndTypes = source.getJSONArray("args");
                    Object[] methodArgs = new Object[argsAndTypes.length()];
                    for (int i = 0; i < argsAndTypes.length(); ++i) {
                        JSONArray argPlusType = argsAndTypes.getJSONArray(i);
                        Object jsonArg = argPlusType.get(0);
                        String argType = argPlusType.getString(1);
                        methodArgs[i] = this.convertArgument(jsonArg, argType, assetsLoaded);
                    }
                    Caller mutator = prop.makeMutator(methodArgs);
                    if (null == mutator) {
                        throw new BadInstructionsException("Can't update a read-only property " + prop.name + " (add a mutator to make this work)");
                    }
                    visitor = new ViewVisitor.PropertySetVisitor(path, mutator, prop.accessor);
                    break block13;
                }
                if (source.getString("change_type").equals("layout")) {
                    JSONArray args = source.getJSONArray("args");
                    ArrayList<ViewVisitor.LayoutRule> newParams = new ArrayList<ViewVisitor.LayoutRule>();
                    int length = args.length();
                    for (int i = 0; i < length; ++i) {
                        JSONObject layout_info = args.optJSONObject(i);
                        String view_id_name = layout_info.getString("view_id_name");
                        String anchor_id_name = layout_info.getString("anchor_id_name");
                        Integer view_id = this.reconcileIds(-1, view_id_name, this.mResourceIds);
                        Integer anchor_id = anchor_id_name.equals("0") ? Integer.valueOf(0) : (anchor_id_name.equals("-1") ? Integer.valueOf(-1) : this.reconcileIds(-1, anchor_id_name, this.mResourceIds));
                        if (view_id == null || anchor_id == null) {
                            MPLog.w(LOGTAG, "View (" + view_id_name + ") or anchor (" + anchor_id_name + ") not found.");
                            continue;
                        }
                        ViewVisitor.LayoutRule params = new ViewVisitor.LayoutRule(view_id, layout_info.getInt("verb"), anchor_id);
                        newParams.add(params);
                    }
                    visitor = new ViewVisitor.LayoutUpdateVisitor(path, newParams, source.getString("name"), this.mLayoutErrorListener);
                    break block13;
                }
                throw new BadInstructionsException("Can't figure out the edit type");
            }
            catch (NoSuchMethodException e) {
                throw new BadInstructionsException("Can't create property mutator", e);
            }
            catch (JSONException e) {
                throw new BadInstructionsException("Can't interpret instructions due to JSONException", e);
            }
        }
        return new Edit(visitor, assetsLoaded);
    }

    public ViewSnapshot readSnapshotConfig(JSONObject source) throws BadInstructionsException {
        ArrayList<PropertyDescription> properties = new ArrayList<PropertyDescription>();
        try {
            JSONObject config = source.getJSONObject("config");
            JSONArray classes = config.getJSONArray("classes");
            for (int classIx = 0; classIx < classes.length(); ++classIx) {
                JSONObject classDesc = classes.getJSONObject(classIx);
                String targetClassName = classDesc.getString("name");
                Class<?> targetClass = Class.forName(targetClassName);
                JSONArray propertyDescs = classDesc.getJSONArray("properties");
                for (int i = 0; i < propertyDescs.length(); ++i) {
                    JSONObject propertyDesc = propertyDescs.getJSONObject(i);
                    PropertyDescription desc = this.readPropertyDescription(targetClass, propertyDesc);
                    properties.add(desc);
                }
            }
            return new ViewSnapshot(this.mContext, properties, this.mResourceIds);
        }
        catch (JSONException e) {
            throw new BadInstructionsException("Can't read snapshot configuration", e);
        }
        catch (ClassNotFoundException e) {
            throw new BadInstructionsException("Can't resolve types for snapshot configuration", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MPPair<String, Object> readTweak(JSONObject tweakDesc) throws BadInstructionsException {
        try {
            Object value;
            String tweakName = tweakDesc.getString("name");
            String type = tweakDesc.getString("type");
            if ("number".equals(type)) {
                String encoding = tweakDesc.getString("encoding");
                if ("d".equals(encoding)) {
                    value = tweakDesc.getDouble("value");
                    return new MPPair<String, Object>(tweakName, value);
                } else {
                    if (!"l".equals(encoding)) throw new BadInstructionsException("number must have encoding of type \"l\" for long or \"d\" for double in: " + tweakDesc);
                    value = tweakDesc.getLong("value");
                }
                return new MPPair<String, Object>(tweakName, value);
            } else if ("boolean".equals(type)) {
                value = tweakDesc.getBoolean("value");
                return new MPPair<String, Object>(tweakName, value);
            } else {
                if (!"string".equals(type)) throw new BadInstructionsException("Unrecognized tweak type " + type + " in: " + tweakDesc);
                value = tweakDesc.getString("value");
            }
            return new MPPair<String, Object>(tweakName, value);
        }
        catch (JSONException e) {
            throw new BadInstructionsException("Can't read tweak update", e);
        }
    }

    List<Pathfinder.PathElement> readPath(JSONArray pathDesc, ResourceIds idNameToId) throws JSONException {
        ArrayList<Pathfinder.PathElement> path = new ArrayList<Pathfinder.PathElement>();
        for (int i = 0; i < pathDesc.length(); ++i) {
            int prefix;
            JSONObject targetView = pathDesc.getJSONObject(i);
            String prefixCode = JSONUtils.optionalStringKey(targetView, "prefix");
            String targetViewClass = JSONUtils.optionalStringKey(targetView, "view_class");
            int targetIndex = targetView.optInt("index", -1);
            String targetDescription = JSONUtils.optionalStringKey(targetView, "contentDescription");
            int targetExplicitId = targetView.optInt("id", -1);
            String targetIdName = JSONUtils.optionalStringKey(targetView, "mp_id_name");
            String targetTag = JSONUtils.optionalStringKey(targetView, "tag");
            if ("shortest".equals(prefixCode)) {
                prefix = 1;
            } else if (null == prefixCode) {
                prefix = 0;
            } else {
                MPLog.w(LOGTAG, "Unrecognized prefix type \"" + prefixCode + "\". No views will be matched");
                return NEVER_MATCH_PATH;
            }
            Integer targetIdOrNull = this.reconcileIds(targetExplicitId, targetIdName, idNameToId);
            if (null == targetIdOrNull) {
                return NEVER_MATCH_PATH;
            }
            int targetId = targetIdOrNull;
            path.add(new Pathfinder.PathElement(prefix, targetViewClass, targetIndex, targetId, targetDescription, targetTag));
        }
        return path;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Integer reconcileIds(int explicitId, String idName, ResourceIds idNameToId) {
        int idFromName;
        if (null != idName) {
            if (!idNameToId.knownIdName(idName)) {
                MPLog.w(LOGTAG, "Path element contains an id name not known to the system. No views will be matched.\nMake sure that you're not stripping your packages R class out with proguard.\nid name was \"" + idName + "\"");
                return null;
            }
            idFromName = idNameToId.idFromName(idName);
        } else {
            idFromName = -1;
        }
        if (-1 != idFromName && -1 != explicitId && idFromName != explicitId) {
            MPLog.e(LOGTAG, "Path contains both a named and an explicit id, and they don't match. No views will be matched.");
            return null;
        }
        if (-1 != idFromName) {
            return idFromName;
        }
        return explicitId;
    }

    private PropertyDescription readPropertyDescription(Class<?> targetClass, JSONObject propertyDesc) throws BadInstructionsException {
        try {
            String mutatorName;
            String propName = propertyDesc.getString("name");
            Caller accessor = null;
            if (propertyDesc.has("get")) {
                JSONObject accessorConfig = propertyDesc.getJSONObject("get");
                String accessorName = accessorConfig.getString("selector");
                String accessorResultTypeName = accessorConfig.getJSONObject("result").getString("type");
                Class<?> accessorResultType = Class.forName(accessorResultTypeName);
                accessor = new Caller(targetClass, accessorName, NO_PARAMS, accessorResultType);
            }
            if (propertyDesc.has("set")) {
                JSONObject mutatorConfig = propertyDesc.getJSONObject("set");
                mutatorName = mutatorConfig.getString("selector");
            } else {
                mutatorName = null;
            }
            return new PropertyDescription(propName, targetClass, accessor, mutatorName);
        }
        catch (NoSuchMethodException e) {
            throw new BadInstructionsException("Can't create property reader", e);
        }
        catch (JSONException e) {
            throw new BadInstructionsException("Can't read property JSON", e);
        }
        catch (ClassNotFoundException e) {
            throw new BadInstructionsException("Can't read property JSON, relevant arg/return class not found", e);
        }
    }

    private Object convertArgument(Object jsonArgument, String type, List<String> assetsLoaded) throws BadInstructionsException, CantGetEditAssetsException {
        try {
            if ("java.lang.CharSequence".equals(type)) {
                return jsonArgument;
            }
            if ("boolean".equals(type) || "java.lang.Boolean".equals(type)) {
                return jsonArgument;
            }
            if ("int".equals(type) || "java.lang.Integer".equals(type)) {
                return ((Number)jsonArgument).intValue();
            }
            if ("float".equals(type) || "java.lang.Float".equals(type)) {
                return Float.valueOf(((Number)jsonArgument).floatValue());
            }
            if ("android.graphics.drawable.Drawable".equals(type)) {
                return this.readBitmapDrawable((JSONObject)jsonArgument, assetsLoaded);
            }
            if ("android.graphics.drawable.BitmapDrawable".equals(type)) {
                return this.readBitmapDrawable((JSONObject)jsonArgument, assetsLoaded);
            }
            if ("android.graphics.drawable.ColorDrawable".equals(type)) {
                int colorValue = ((Number)jsonArgument).intValue();
                return new ColorDrawable(colorValue);
            }
            throw new BadInstructionsException("Don't know how to interpret type " + type + " (arg was " + jsonArgument + ")");
        }
        catch (ClassCastException e) {
            throw new BadInstructionsException("Couldn't interpret <" + jsonArgument + "> as " + type);
        }
    }

    private Drawable readBitmapDrawable(JSONObject description, List<String> assetsLoaded) throws BadInstructionsException, CantGetEditAssetsException {
        try {
            Bitmap image;
            boolean useBounds;
            int left;
            int right;
            int top;
            int bottom;
            if (description.isNull("url")) {
                throw new BadInstructionsException("Can't construct a BitmapDrawable with a null url");
            }
            String url = description.getString("url");
            if (description.isNull("dimensions")) {
                bottom = 0;
                top = 0;
                right = 0;
                left = 0;
                useBounds = false;
            } else {
                JSONObject dimensions = description.getJSONObject("dimensions");
                left = dimensions.getInt("left");
                right = dimensions.getInt("right");
                top = dimensions.getInt("top");
                bottom = dimensions.getInt("bottom");
                useBounds = true;
            }
            try {
                image = this.mImageStore.getImage(url);
                assetsLoaded.add(url);
            }
            catch (ImageStore.CantGetImageException e) {
                throw new CantGetEditAssetsException(e.getMessage(), e.getCause());
            }
            BitmapDrawable ret = new BitmapDrawable(Resources.getSystem(), image);
            if (useBounds) {
                ret.setBounds(left, top, right, bottom);
            }
            return ret;
        }
        catch (JSONException e) {
            throw new BadInstructionsException("Couldn't read drawable description", e);
        }
    }

    public static class Edit {
        public final ViewVisitor visitor;
        public final List<String> imageUrls;

        private Edit(ViewVisitor aVisitor, List<String> someUrls) {
            this.visitor = aVisitor;
            this.imageUrls = someUrls;
        }
    }

    public static class CantGetEditAssetsException
    extends Exception {
        public CantGetEditAssetsException(String message) {
            super(message);
        }

        public CantGetEditAssetsException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class InapplicableInstructionsException
    extends BadInstructionsException {
        private static final long serialVersionUID = 3977056710817909104L;

        public InapplicableInstructionsException(String message) {
            super(message);
        }
    }

    public static class BadInstructionsException
    extends Exception {
        private static final long serialVersionUID = -4062004792184145311L;

        public BadInstructionsException(String message) {
            super(message);
        }

        public BadInstructionsException(String message, Throwable e) {
            super(message, e);
        }
    }
}

