/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.viewcrawler;

import android.view.View;
import android.view.ViewGroup;
import com.mixpanel.android.util.MPLog;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

class Pathfinder {
    private final IntStack mIndexStack = new IntStack();
    private static final String LOGTAG = "MixpanelAPI.PathFinder";

    public void findTargetsInRoot(View givenRootView, List<PathElement> path, Accumulator accumulator) {
        if (path.isEmpty()) {
            return;
        }
        if (this.mIndexStack.full()) {
            MPLog.w(LOGTAG, "There appears to be a concurrency issue in the pathfinding code. Path will not be matched.");
            return;
        }
        PathElement rootPathElement = path.get(0);
        List<PathElement> childPath = path.subList(1, path.size());
        int indexKey = this.mIndexStack.alloc();
        View rootView = this.findPrefixedMatch(rootPathElement, givenRootView, indexKey);
        this.mIndexStack.free();
        if (null != rootView) {
            this.findTargetsInMatchedView(rootView, childPath, accumulator);
        }
    }

    private void findTargetsInMatchedView(View alreadyMatched, List<PathElement> remainingPath, Accumulator accumulator) {
        if (remainingPath.isEmpty()) {
            accumulator.accumulate(alreadyMatched);
            return;
        }
        if (!(alreadyMatched instanceof ViewGroup)) {
            return;
        }
        if (this.mIndexStack.full()) {
            MPLog.v(LOGTAG, "Path is too deep, will not match");
            return;
        }
        ViewGroup parent = (ViewGroup)alreadyMatched;
        PathElement matchElement = remainingPath.get(0);
        List<PathElement> nextPath = remainingPath.subList(1, remainingPath.size());
        int childCount = parent.getChildCount();
        int indexKey = this.mIndexStack.alloc();
        for (int i = 0; i < childCount; ++i) {
            View givenChild = parent.getChildAt(i);
            View child = this.findPrefixedMatch(matchElement, givenChild, indexKey);
            if (null != child) {
                this.findTargetsInMatchedView(child, nextPath, accumulator);
            }
            if (matchElement.index >= 0 && this.mIndexStack.read(indexKey) > matchElement.index) break;
        }
        this.mIndexStack.free();
    }

    private View findPrefixedMatch(PathElement findElement, View subject, int indexKey) {
        int currentIndex = this.mIndexStack.read(indexKey);
        if (this.matches(findElement, subject)) {
            this.mIndexStack.increment(indexKey);
            if (findElement.index == -1 || findElement.index == currentIndex) {
                return subject;
            }
        }
        if (findElement.prefix == 1 && subject instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)subject;
            int childCount = group.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = group.getChildAt(i);
                View result = this.findPrefixedMatch(findElement, child, indexKey);
                if (null == result) continue;
                return result;
            }
        }
        return null;
    }

    private boolean matches(PathElement matchElement, View subject) {
        Object subjectTag;
        if (null != matchElement.viewClassName && !Pathfinder.hasClassName(subject, matchElement.viewClassName)) {
            return false;
        }
        if (-1 != matchElement.viewId && subject.getId() != matchElement.viewId) {
            return false;
        }
        if (null != matchElement.contentDescription && !matchElement.contentDescription.equals(subject.getContentDescription())) {
            return false;
        }
        String matchTag = matchElement.tag;
        return null == matchElement.tag || null != (subjectTag = subject.getTag()) && matchTag.equals(subject.getTag().toString());
    }

    private static boolean hasClassName(Object o, String className) {
        Class<?> klass = o.getClass();
        while (!klass.getCanonicalName().equals(className)) {
            if (klass == Object.class) {
                return false;
            }
            klass = klass.getSuperclass();
        }
        return true;
    }

    private static class IntStack {
        private final int[] mStack = new int[256];
        private int mStackSize = 0;
        private static final int MAX_INDEX_STACK_SIZE = 256;

        public boolean full() {
            return this.mStack.length == this.mStackSize;
        }

        public int alloc() {
            int index = this.mStackSize++;
            this.mStack[index] = 0;
            return index;
        }

        public int read(int index) {
            return this.mStack[index];
        }

        public void increment(int index) {
            int n = index;
            this.mStack[n] = this.mStack[n] + 1;
        }

        public void free() {
            --this.mStackSize;
            if (this.mStackSize < 0) {
                throw new ArrayIndexOutOfBoundsException(this.mStackSize);
            }
        }
    }

    public static interface Accumulator {
        public void accumulate(View var1);
    }

    public static class PathElement {
        public final int prefix;
        public final String viewClassName;
        public final int index;
        public final int viewId;
        public final String contentDescription;
        public final String tag;
        public static final int ZERO_LENGTH_PREFIX = 0;
        public static final int SHORTEST_PREFIX = 1;

        public PathElement(int usePrefix, String vClass, int ix, int vId, String cDesc, String vTag) {
            this.prefix = usePrefix;
            this.viewClassName = vClass;
            this.index = ix;
            this.viewId = vId;
            this.contentDescription = cDesc;
            this.tag = vTag;
        }

        public String toString() {
            try {
                JSONObject ret = new JSONObject();
                if (this.prefix == 1) {
                    ret.put("prefix", (Object)"shortest");
                }
                if (null != this.viewClassName) {
                    ret.put("view_class", (Object)this.viewClassName);
                }
                if (this.index > -1) {
                    ret.put("index", this.index);
                }
                if (this.viewId > -1) {
                    ret.put("id", this.viewId);
                }
                if (null != this.contentDescription) {
                    ret.put("contentDescription", (Object)this.contentDescription);
                }
                if (null != this.tag) {
                    ret.put("tag", (Object)this.tag);
                }
                return ret.toString();
            }
            catch (JSONException e) {
                throw new RuntimeException("Can't serialize PathElement to String", e);
            }
        }
    }
}

