/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.content.Context;
import android.os.Handler;
import com.mixpanel.android.mpmetrics.MixpanelAPI;
import com.mixpanel.android.util.MPLog;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;

class ConnectIntegrations {
    private final MixpanelAPI mMixpanel;
    private Context mContext;
    private String mSavedUrbanAirshipChannelID;
    private int mUrbanAirshipRetries;
    private static final String LOGTAG = "MixpanelAPI.CnctInts";
    private static final int UA_MAX_RETRIES = 3;

    public ConnectIntegrations(MixpanelAPI mixpanel, Context context) {
        this.mMixpanel = mixpanel;
        this.mContext = context;
    }

    public void reset() {
        this.mSavedUrbanAirshipChannelID = null;
        this.mUrbanAirshipRetries = 0;
    }

    public synchronized void setupIntegrations(Set<String> integrations) {
        if (integrations.contains("urbanairship")) {
            this.setUrbanAirshipPeopleProp();
        }
        if (integrations.contains("braze")) {
            this.setBrazePeopleProp();
        }
    }

    private synchronized void setUrbanAirshipPeopleProp() {
        String urbanAirshipClassName = "com.urbanairship.UAirship";
        try {
            Class<?> urbanAirshipClass = Class.forName(urbanAirshipClassName);
            Object sharedUAirship = urbanAirshipClass.getMethod("shared", null).invoke(null, new Object[0]);
            Object pushManager = sharedUAirship.getClass().getMethod("getPushManager", null).invoke(sharedUAirship, new Object[0]);
            String channelID = (String)pushManager.getClass().getMethod("getChannelId", null).invoke(pushManager, new Object[0]);
            if (channelID != null && !channelID.isEmpty()) {
                this.mUrbanAirshipRetries = 0;
                if (this.mSavedUrbanAirshipChannelID == null || !this.mSavedUrbanAirshipChannelID.equals(channelID)) {
                    this.mMixpanel.getPeople().set("$android_urban_airship_channel_id", channelID);
                    this.mSavedUrbanAirshipChannelID = channelID;
                }
            } else {
                ++this.mUrbanAirshipRetries;
                if (this.mUrbanAirshipRetries <= 3) {
                    Handler delayedHandler = new Handler();
                    delayedHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            ConnectIntegrations.this.setUrbanAirshipPeopleProp();
                        }
                    }, 2000L);
                }
            }
        }
        catch (ClassNotFoundException e) {
            MPLog.w(LOGTAG, "Urban Airship SDK not found but Urban Airship is integrated on Mixpanel", e);
        }
        catch (NoSuchMethodException e) {
            MPLog.e(LOGTAG, "Urban Airship SDK class exists but methods do not", e);
        }
        catch (InvocationTargetException e) {
            MPLog.e(LOGTAG, "method invocation failed", e);
        }
        catch (IllegalAccessException e) {
            MPLog.e(LOGTAG, "method invocation failed", e);
        }
    }

    private void setBrazePeopleProp() {
        String urbanAirshipClassName = "com.appboy.Appboy";
        try {
            Class<?> brazeClass = Class.forName(urbanAirshipClassName);
            Object brazeInstance = brazeClass.getMethod("getInstance", Context.class).invoke(null, this.mContext);
            String deviceId = (String)brazeInstance.getClass().getMethod("getDeviceId", null).invoke(brazeInstance, new Object[0]);
            Object currentUser = brazeInstance.getClass().getMethod("getCurrentUser", null).invoke(brazeInstance, new Object[0]);
            String externalUserId = (String)currentUser.getClass().getMethod("getUserId", null).invoke(currentUser, new Object[0]);
            if (deviceId != null) {
                this.mMixpanel.alias(deviceId, this.mMixpanel.getDistinctId());
                this.mMixpanel.getPeople().set("$braze_device_id", deviceId);
            }
            if (externalUserId != null) {
                this.mMixpanel.alias(externalUserId, this.mMixpanel.getDistinctId());
                this.mMixpanel.getPeople().set("$braze_external_id", externalUserId);
            }
        }
        catch (ClassNotFoundException e) {
            MPLog.w(LOGTAG, "Braze SDK not found but Braze is integrated on Mixpanel", e);
        }
        catch (NoSuchMethodException e) {
            MPLog.e(LOGTAG, "Braze SDK class exists but methods do not", e);
        }
        catch (InvocationTargetException e) {
            MPLog.e(LOGTAG, "method invocation failed", e);
        }
        catch (IllegalAccessException e) {
            MPLog.e(LOGTAG, "method invocation failed", e);
        }
    }
}

