/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.Parcelable;
import com.mixpanel.android.mpmetrics.BadDecideObjectException;
import com.mixpanel.android.util.JSONUtils;
import com.mixpanel.android.util.MPLog;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class InAppNotification
implements Parcelable {
    private static final String LOGTAG = "MixpanelAPI.InAppNotif";
    private static final Pattern FILE_EXTENSION_PATTERN = Pattern.compile("(\\.[^./]+$)");
    protected final JSONObject mDescription;
    protected final JSONObject mExtras;
    protected final int mId;
    protected final int mMessageId;
    private final int mBackgroundColor;
    private final String mBody;
    private final int mBodyColor;
    private final String mImageUrl;
    private Bitmap mImage;

    public InAppNotification() {
        this.mDescription = null;
        this.mExtras = null;
        this.mId = 0;
        this.mMessageId = 0;
        this.mBackgroundColor = 0;
        this.mBody = null;
        this.mBodyColor = 0;
        this.mImageUrl = null;
    }

    public InAppNotification(Parcel in) {
        JSONObject tempDescription = new JSONObject();
        JSONObject tempExtras = new JSONObject();
        try {
            tempDescription = new JSONObject(in.readString());
            tempExtras = new JSONObject(in.readString());
        }
        catch (JSONException e) {
            MPLog.e(LOGTAG, "Error reading JSON when creating InAppNotification from Parcel");
        }
        this.mDescription = tempDescription;
        this.mExtras = tempExtras;
        this.mId = in.readInt();
        this.mMessageId = in.readInt();
        this.mBackgroundColor = in.readInt();
        this.mBody = in.readString();
        this.mBodyColor = in.readInt();
        this.mImageUrl = in.readString();
        this.mImage = (Bitmap)in.readParcelable(Bitmap.class.getClassLoader());
    }

    InAppNotification(JSONObject description) throws BadDecideObjectException {
        try {
            this.mDescription = description;
            this.mExtras = description.getJSONObject("extras");
            this.mId = description.getInt("id");
            this.mMessageId = description.getInt("message_id");
            this.mBackgroundColor = description.getInt("bg_color");
            this.mBody = JSONUtils.optionalStringKey(description, "body");
            this.mBodyColor = description.optInt("body_color");
            this.mImageUrl = description.getString("image_url");
            this.mImage = Bitmap.createBitmap((int)500, (int)500, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        catch (JSONException e) {
            throw new BadDecideObjectException("Notification JSON was unexpected or bad", e);
        }
    }

    String toJSON() {
        return this.mDescription.toString();
    }

    JSONObject getCampaignProperties() {
        JSONObject ret = new JSONObject();
        try {
            ret.put("campaign_id", this.getId());
            ret.put("message_id", this.getMessageId());
            ret.put("message_type", (Object)"inapp");
            ret.put("message_subtype", (Object)this.getType().toString());
        }
        catch (JSONException e) {
            MPLog.e(LOGTAG, "Impossible JSON Exception", e);
        }
        return ret;
    }

    public int getId() {
        return this.mId;
    }

    public int getMessageId() {
        return this.mMessageId;
    }

    public abstract Type getType();

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public boolean hasBody() {
        return this.mBody != null;
    }

    public String getBody() {
        return this.mBody;
    }

    public int getBodyColor() {
        return this.mBodyColor;
    }

    public String getImageUrl() {
        return this.mImageUrl;
    }

    public String getImage2xUrl() {
        return InAppNotification.sizeSuffixUrl(this.mImageUrl, "@2x");
    }

    public String getImage4xUrl() {
        return InAppNotification.sizeSuffixUrl(this.mImageUrl, "@4x");
    }

    void setImage(Bitmap image) {
        this.mImage = image;
    }

    public Bitmap getImage() {
        return this.mImage;
    }

    static String sizeSuffixUrl(String url, String sizeSuffix) {
        Matcher matcher = FILE_EXTENSION_PATTERN.matcher(url);
        if (matcher.find()) {
            return matcher.replaceFirst(sizeSuffix + "$1");
        }
        return url;
    }

    protected JSONObject getExtras() {
        return this.mExtras;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mDescription.toString());
        dest.writeString(this.mExtras.toString());
        dest.writeInt(this.mId);
        dest.writeInt(this.mMessageId);
        dest.writeInt(this.mBackgroundColor);
        dest.writeString(this.mBody);
        dest.writeInt(this.mBodyColor);
        dest.writeString(this.mImageUrl);
        dest.writeParcelable((Parcelable)this.mImage, flags);
    }

    public String toString() {
        return this.mDescription.toString();
    }

    public static enum Type {
        UNKNOWN{

            public String toString() {
                return "*unknown_type*";
            }
        }
        ,
        MINI{

            public String toString() {
                return "mini";
            }
        }
        ,
        TAKEOVER{

            public String toString() {
                return "takeover";
            }
        };

    }
}

