/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.surveys;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import android.widget.CheckedTextView;

public class SurveyChoiceView
extends CheckedTextView {
    private Drawable mSurveyChoiceCheckMark;
    private float mCheckmarkLeftOffset;
    private float mTextLeftOffset;
    private static final int ANIMATION_DURATION = 300;
    private static final int CHECKMARK_HEIGHT_DP = 14;
    private static final int BOX_PADDING_LEFT_DP = 22;
    private static final int BOX_PADDING_TOP_DP = 12;

    public SurveyChoiceView(Context context) {
        super(context);
        this.initSurveyChoiceView();
    }

    public SurveyChoiceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initSurveyChoiceView();
    }

    public SurveyChoiceView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initSurveyChoiceView();
    }

    public void setCheckMarkDrawable(Drawable d) {
        super.setCheckMarkDrawable(d);
        this.mSurveyChoiceCheckMark = d;
    }

    public void setChecked(boolean checked) {
        boolean wasChecked = this.isChecked();
        super.setChecked(checked);
        if (this.isChecked() && !wasChecked) {
            SetCheckAnimation transition = new SetCheckAnimation();
            transition.setDuration(300L);
            this.startAnimation(transition);
        }
    }

    protected void onDraw(Canvas canvas) {
        Drawable checkMarkDrawable = this.mSurveyChoiceCheckMark;
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        float density = metrics.density;
        int checkmarkWidth = 0;
        if (null != checkMarkDrawable && this.isChecked()) {
            checkmarkWidth = (int)(14.0f * density);
        }
        int checkmarkHeight = checkmarkWidth;
        int boxPaddingTop = (int)(12.0f * density);
        int boxPaddingLeft = (int)(22.0f * density);
        this.setCheckMarkDrawable(null);
        int textPaddingLeft = (int)((float)boxPaddingLeft + this.mTextLeftOffset * (float)checkmarkWidth);
        this.setPadding(textPaddingLeft, boxPaddingTop, boxPaddingLeft, boxPaddingTop);
        super.onDraw(canvas);
        int checkPaddingLeft = (int)((float)boxPaddingLeft + this.mCheckmarkLeftOffset * (float)checkmarkWidth);
        this.setPadding(checkPaddingLeft, boxPaddingTop, boxPaddingLeft, boxPaddingTop);
        this.setCheckMarkDrawable(checkMarkDrawable);
        if (null != checkMarkDrawable) {
            int verticalGravity = this.getGravity() & 0x70;
            int y = 0;
            switch (verticalGravity) {
                case 80: {
                    y = this.getHeight() - checkmarkHeight;
                    break;
                }
                case 16: {
                    y = (this.getHeight() - checkmarkHeight) / 2;
                }
            }
            int top = y;
            int bottom = top + checkmarkHeight;
            int left = checkPaddingLeft;
            int right = left + checkmarkWidth;
            checkMarkDrawable.setBounds(this.getScrollX() + left, top, this.getScrollX() + right, bottom);
            checkMarkDrawable.draw(canvas);
        }
        this.setPadding(boxPaddingLeft, boxPaddingTop, boxPaddingLeft, boxPaddingTop);
    }

    private void initSurveyChoiceView() {
        this.mCheckmarkLeftOffset = 0.0f;
        this.mTextLeftOffset = 1.5f;
    }

    private class SetCheckAnimation
    extends Animation {
        private SetCheckAnimation() {
        }

        public boolean willChangeTransformationMatrix() {
            return false;
        }

        public boolean willChangeBounds() {
            return false;
        }

        protected void applyTransformation(float interpolatedTime, Transformation t) {
            float checkmarkOffset = 0.0f;
            float textOffset = 1.0f;
            if (interpolatedTime <= 0.5f) {
                checkmarkOffset = interpolatedTime - 0.5f;
            } else {
                textOffset += (interpolatedTime - 0.5f) * 2.0f;
            }
            SurveyChoiceView.this.mCheckmarkLeftOffset = checkmarkOffset;
            SurveyChoiceView.this.mTextLeftOffset = textOffset;
            SurveyChoiceView.this.requestLayout();
        }
    }
}

