/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class SystemInformation {
    private final Context mContext;
    private final Boolean mHasNFC;
    private final Boolean mHasTelephony;
    private final DisplayMetrics mDisplayMetrics;
    private final String mAppVersionName;
    private final Integer mAppVersionCode;
    private static final String LOGTAG = "MixpanelAPI.SysInfo";

    public SystemInformation(Context context) {
        this.mContext = context;
        PackageManager packageManager = this.mContext.getPackageManager();
        String foundAppVersionName = null;
        Integer foundAppVersionCode = null;
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(this.mContext.getPackageName(), 0);
            foundAppVersionName = packageInfo.versionName;
            foundAppVersionCode = packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w((String)LOGTAG, (String)"System information constructed with a context that apparently doesn't exist.");
        }
        this.mAppVersionName = foundAppVersionName;
        this.mAppVersionCode = foundAppVersionCode;
        Class<?> packageManagerClass = packageManager.getClass();
        Method hasSystemFeatureMethod = null;
        try {
            hasSystemFeatureMethod = packageManagerClass.getMethod("hasSystemFeature", String.class);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        Boolean foundNFC = null;
        Boolean foundTelephony = null;
        if (null != hasSystemFeatureMethod) {
            try {
                foundNFC = (Boolean)hasSystemFeatureMethod.invoke((Object)packageManager, "android.hardware.nfc");
                foundTelephony = (Boolean)hasSystemFeatureMethod.invoke((Object)packageManager, "android.hardware.telephony");
            }
            catch (InvocationTargetException e) {
                Log.w((String)LOGTAG, (String)"System version appeared to support PackageManager.hasSystemFeature, but we were unable to call it.");
            }
            catch (IllegalAccessException e) {
                Log.w((String)LOGTAG, (String)"System version appeared to support PackageManager.hasSystemFeature, but we were unable to call it.");
            }
        }
        this.mHasNFC = foundNFC;
        this.mHasTelephony = foundTelephony;
        this.mDisplayMetrics = new DisplayMetrics();
        Display display = ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay();
        display.getMetrics(this.mDisplayMetrics);
    }

    public String getAppVersionName() {
        return this.mAppVersionName;
    }

    public Integer getAppVersionCode() {
        return this.mAppVersionCode;
    }

    public boolean hasNFC() {
        return this.mHasNFC;
    }

    public boolean hasTelephony() {
        return this.mHasTelephony;
    }

    public DisplayMetrics getDisplayMetrics() {
        return this.mDisplayMetrics;
    }

    public String getPhoneRadioType() {
        String ret = null;
        TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        if (null != telephonyManager) {
            switch (telephonyManager.getPhoneType()) {
                case 0: {
                    ret = "none";
                    break;
                }
                case 1: {
                    ret = "gsm";
                    break;
                }
                case 2: {
                    ret = "cdma";
                    break;
                }
                case 3: {
                    ret = "sip";
                    break;
                }
                default: {
                    ret = null;
                }
            }
        }
        return ret;
    }

    public String getCurrentNetworkOperator() {
        String ret = null;
        TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        if (null != telephonyManager) {
            ret = telephonyManager.getNetworkOperatorName();
        }
        return ret;
    }

    public Boolean isWifiConnected() {
        Boolean ret = null;
        if (0 == this.mContext.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE")) {
            ConnectivityManager connManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
            NetworkInfo networkInfo = connManager.getActiveNetworkInfo();
            ret = networkInfo != null && networkInfo.getType() == 1 && networkInfo.isConnected();
        }
        return ret;
    }

    public Boolean isBluetoothEnabled() {
        Boolean isBluetoothEnabled = null;
        try {
            BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            if (bluetoothAdapter != null) {
                isBluetoothEnabled = bluetoothAdapter.isEnabled();
            }
        }
        catch (SecurityException e) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return isBluetoothEnabled;
    }

    public String getBluetoothVersion() {
        String bluetoothVersion = null;
        if (Build.VERSION.SDK_INT >= 8) {
            bluetoothVersion = "none";
            if (Build.VERSION.SDK_INT >= 18 && this.mContext.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
                bluetoothVersion = "ble";
            } else if (this.mContext.getPackageManager().hasSystemFeature("android.hardware.bluetooth")) {
                bluetoothVersion = "classic";
            }
        }
        return bluetoothVersion;
    }
}

