/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.viewcrawler;

import android.util.Log;
import android.view.View;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class Caller {
    private final String mMethodName;
    private final Object[] mMethodArgs;
    private final Class<?> mMethodResultType;
    private final Class<?> mTargetClass;
    private final Method mTargetMethod;
    private static final String LOGTAG = "MixpanelABTest.Caller";

    public Caller(Class<?> targetClass, String methodName, Object[] methodArgs, Class<?> resultType) throws NoSuchMethodException {
        this.mMethodName = methodName;
        this.mMethodArgs = methodArgs;
        this.mMethodResultType = resultType;
        this.mTargetMethod = this.pickMethod(targetClass);
        if (null == this.mTargetMethod) {
            throw new NoSuchMethodException("Method " + targetClass.getName() + "." + this.mMethodName + " doesn't exit");
        }
        this.mTargetClass = this.mTargetMethod.getDeclaringClass();
    }

    public String toString() {
        return "[Caller " + this.mMethodName + "(" + this.mMethodArgs + ")]";
    }

    public Object[] getArgs() {
        return this.mMethodArgs;
    }

    public Object applyMethod(View target) {
        return this.applyMethodWithArguments(target, this.mMethodArgs);
    }

    public Object applyMethodWithArguments(View target, Object[] arguments) {
        Class<?> klass = target.getClass();
        if (this.mTargetClass.isAssignableFrom(klass)) {
            try {
                return this.mTargetMethod.invoke((Object)target, arguments);
            }
            catch (IllegalAccessException e) {
                Log.e((String)LOGTAG, (String)("Method " + this.mTargetMethod.getName() + " appears not to be public"), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                Log.e((String)LOGTAG, (String)("Method " + this.mTargetMethod.getName() + " called with arguments of the wrong type"), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                Log.e((String)LOGTAG, (String)("Method " + this.mTargetMethod.getName() + " threw an exception"), (Throwable)e);
            }
        }
        return null;
    }

    public boolean argsAreApplicable(Object[] proposedArgs) {
        Class<?>[] paramTypes = this.mTargetMethod.getParameterTypes();
        if (proposedArgs.length != paramTypes.length) {
            return false;
        }
        for (int i = 0; i < proposedArgs.length; ++i) {
            Class<?> argumentType;
            Class<?> paramType = Caller.assignableArgType(paramTypes[i]);
            if (!(null == proposedArgs[i] ? paramType == Byte.TYPE || paramType == Short.TYPE || paramType == Integer.TYPE || paramType == Long.TYPE || paramType == Float.TYPE || paramType == Double.TYPE || paramType == Boolean.TYPE || paramType == Character.TYPE : !paramType.isAssignableFrom(argumentType = Caller.assignableArgType(proposedArgs[i].getClass())))) continue;
            return false;
        }
        return true;
    }

    private static Class<?> assignableArgType(Class<?> type) {
        if (type == Byte.class) {
            type = Byte.TYPE;
        } else if (type == Short.class) {
            type = Short.TYPE;
        } else if (type == Integer.class) {
            type = Integer.TYPE;
        } else if (type == Long.class) {
            type = Long.TYPE;
        } else if (type == Float.class) {
            type = Float.TYPE;
        } else if (type == Double.class) {
            type = Double.TYPE;
        } else if (type == Boolean.class) {
            type = Boolean.TYPE;
        } else if (type == Character.class) {
            type = Character.TYPE;
        }
        return type;
    }

    private Method pickMethod(Class<?> klass) {
        Class[] argumentTypes = new Class[this.mMethodArgs.length];
        for (int i = 0; i < this.mMethodArgs.length; ++i) {
            argumentTypes[i] = this.mMethodArgs[i].getClass();
        }
        for (Method method : klass.getMethods()) {
            Class<?> resultType;
            Class<?> assignType;
            String foundName = method.getName();
            Class<?>[] params = method.getParameterTypes();
            if (!foundName.equals(this.mMethodName) || params.length != this.mMethodArgs.length || !(assignType = Caller.assignableArgType(this.mMethodResultType)).isAssignableFrom(resultType = Caller.assignableArgType(method.getReturnType()))) continue;
            boolean assignable = true;
            for (int i = 0; i < params.length && assignable; ++i) {
                Class<?> argumentType = Caller.assignableArgType(argumentTypes[i]);
                Class<?> paramType = Caller.assignableArgType(params[i]);
                assignable = paramType.isAssignableFrom(argumentType);
            }
            if (!assignable) continue;
            return method;
        }
        return null;
    }
}

