/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.viewcrawler;

import android.R;
import android.content.Context;
import android.graphics.BitmapFactory;
import android.util.Base64;
import android.util.Log;
import android.util.SparseArray;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.util.JSONUtils;
import com.mixpanel.android.viewcrawler.Caller;
import com.mixpanel.android.viewcrawler.Pathfinder;
import com.mixpanel.android.viewcrawler.PropertyDescription;
import com.mixpanel.android.viewcrawler.ViewSnapshot;
import com.mixpanel.android.viewcrawler.ViewVisitor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class EditProtocol {
    private final Map<String, Integer> mIdNameToId = new HashMap<String, Integer>();
    private final SparseArray<String> mIdToIdName = new SparseArray();
    private static final Class[] NO_PARAMS = new Class[0];
    private static final List<Pathfinder.PathElement> NEVER_MATCH_PATH = Collections.emptyList();
    private static final String LOGTAG = "MixpanelAPI.EditProtocol";

    public EditProtocol(Context context) {
        this.buildIdMap(context);
    }

    public ViewVisitor readEventBinding(JSONObject source, ViewVisitor.OnEventListener listener) throws BadInstructionsException {
        try {
            String eventName = source.getString("event_name");
            String eventType = source.getString("event_type");
            JSONArray pathDesc = source.getJSONArray("path");
            List<Pathfinder.PathElement> path = this.readPath(pathDesc, this.mIdNameToId);
            if (path.size() == 0) {
                throw new InapplicableInstructionsException("event '" + eventName + "' will not be bound to any element in the UI.");
            }
            if ("click".equals(eventType)) {
                return new ViewVisitor.AddAccessibilityEventVisitor(path, 1, eventName, listener);
            }
            if ("selected".equals(eventType)) {
                return new ViewVisitor.AddAccessibilityEventVisitor(path, 4, eventName, listener);
            }
            if ("text_changed".equals(eventType)) {
                return new ViewVisitor.AddTextChangeListener(path, eventName, listener);
            }
            if ("detected".equals(eventType)) {
                return new ViewVisitor.ViewDetectorVisitor(path, eventName, listener);
            }
            throw new BadInstructionsException("Mixpanel can't track event type \"" + eventType + "\"");
        }
        catch (JSONException e) {
            throw new BadInstructionsException("Can't interpret instructions due to JSONException", (Exception)((Object)e));
        }
    }

    public ViewVisitor readEdit(JSONObject source) throws BadInstructionsException {
        try {
            Class<?> targetClass;
            JSONArray pathDesc = source.getJSONArray("path");
            List<Pathfinder.PathElement> path = this.readPath(pathDesc, this.mIdNameToId);
            if (path.size() == 0) {
                throw new InapplicableInstructionsException("Edit will not be bound to any element in the UI.");
            }
            Pathfinder.PathElement pathEnd = path.get(path.size() - 1);
            String targetClassName = pathEnd.viewClassName;
            try {
                targetClass = Class.forName(targetClassName);
            }
            catch (ClassNotFoundException e) {
                throw new BadInstructionsException("Can't find class for visit path: " + targetClassName, e);
            }
            PropertyDescription prop = this.readPropertyDescription(targetClass, source.getJSONObject("property"));
            JSONArray argsAndTypes = source.getJSONArray("args");
            Object[] methodArgs = new Object[argsAndTypes.length()];
            for (int i = 0; i < argsAndTypes.length(); ++i) {
                JSONArray argPlusType = argsAndTypes.getJSONArray(i);
                Object jsonArg = argPlusType.get(0);
                String argType = argPlusType.getString(1);
                methodArgs[i] = this.convertArgument(jsonArg, argType);
            }
            Caller mutator = prop.makeMutator(methodArgs);
            if (null == mutator) {
                throw new BadInstructionsException("Can't update a read-only property " + prop.name + " (add a mutator to make this work)");
            }
            return new ViewVisitor.PropertySetVisitor(path, mutator, prop.accessor);
        }
        catch (NoSuchMethodException e) {
            throw new BadInstructionsException("Can't create property mutator", e);
        }
        catch (JSONException e) {
            throw new BadInstructionsException("Can't interpret instructions due to JSONException", (Exception)((Object)e));
        }
    }

    public ViewSnapshot readSnapshotConfig(JSONObject source) throws BadInstructionsException {
        ArrayList<PropertyDescription> properties = new ArrayList<PropertyDescription>();
        try {
            JSONObject config = source.getJSONObject("config");
            JSONArray classes = config.getJSONArray("classes");
            for (int classIx = 0; classIx < classes.length(); ++classIx) {
                JSONObject classDesc = classes.getJSONObject(classIx);
                String targetClassName = classDesc.getString("name");
                Class<?> targetClass = Class.forName(targetClassName);
                JSONArray propertyDescs = classDesc.getJSONArray("properties");
                for (int i = 0; i < propertyDescs.length(); ++i) {
                    JSONObject propertyDesc = propertyDescs.getJSONObject(i);
                    PropertyDescription desc = this.readPropertyDescription(targetClass, propertyDesc);
                    properties.add(desc);
                }
            }
            return new ViewSnapshot(properties, this.mIdToIdName);
        }
        catch (JSONException e) {
            throw new BadInstructionsException("Can't read snapshot configuration", (Exception)((Object)e));
        }
        catch (ClassNotFoundException e) {
            throw new BadInstructionsException("Can't resolve types for snapshot configuration", e);
        }
    }

    List<Pathfinder.PathElement> readPath(JSONArray pathDesc, Map<String, Integer> idNameToId) throws JSONException {
        ArrayList<Pathfinder.PathElement> path = new ArrayList<Pathfinder.PathElement>();
        for (int i = 0; i < pathDesc.length(); ++i) {
            int prefix;
            JSONObject targetView = pathDesc.getJSONObject(i);
            String prefixCode = JSONUtils.optionalStringKey(targetView, "prefix");
            String targetViewClass = JSONUtils.optionalStringKey(targetView, "view_class");
            int targetIndex = targetView.optInt("index", -1);
            String targetDescription = JSONUtils.optionalStringKey(targetView, "contentDescription");
            int targetExplicitId = targetView.optInt("id", -1);
            String targetIdName = JSONUtils.optionalStringKey(targetView, "mp_id_name");
            String targetTag = JSONUtils.optionalStringKey(targetView, "tag");
            if ("shortest".equals(prefixCode)) {
                prefix = 1;
            } else if (null == prefixCode) {
                prefix = 0;
            } else {
                Log.w((String)LOGTAG, (String)("Unrecognized prefix type \"" + prefixCode + "\". No views will be matched"));
                return NEVER_MATCH_PATH;
            }
            Integer targetIdOrNull = this.reconcileIdsInPath(targetExplicitId, targetIdName, idNameToId);
            if (null == targetIdOrNull) {
                return NEVER_MATCH_PATH;
            }
            int targetId = targetIdOrNull;
            path.add(new Pathfinder.PathElement(prefix, targetViewClass, targetIndex, targetId, targetDescription, targetTag));
        }
        return path;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Integer reconcileIdsInPath(int explicitId, String idName, Map<String, Integer> idNameToId) {
        int idFromName;
        if (null != idName) {
            if (!idNameToId.containsKey(idName)) {
                Log.w((String)LOGTAG, (String)("Path element contains an id name not known to the system. No views will be matched.\nMake sure that you're not stripping your packages R class out with proguard.\nid name was \"" + idName + "\""));
                return null;
            }
            idFromName = idNameToId.get(idName);
        } else {
            idFromName = -1;
        }
        if (-1 != idFromName && -1 != explicitId && idFromName != explicitId) {
            Log.e((String)LOGTAG, (String)"Path contains both a named and an explicit id, and they don't match. No views will be matched.");
            return null;
        }
        if (-1 != idFromName) {
            return idFromName;
        }
        return explicitId;
    }

    private void buildIdMap(Context context) {
        MPConfig config = MPConfig.getInstance(context.getApplicationContext());
        this.mIdNameToId.clear();
        this.mIdToIdName.clear();
        try {
            Class<R.id> platformIdClass = R.id.class;
            Field[] fields = platformIdClass.getFields();
            for (int i = 0; i < fields.length; ++i) {
                Class<?> fieldType;
                Field field = fields[i];
                int modifiers = field.getModifiers();
                if (!Modifier.isStatic(modifiers) || (fieldType = field.getType()) != Integer.TYPE) continue;
                String name = field.getName();
                int value = field.getInt(null);
                String namespacedName = "android:" + name;
                this.mIdNameToId.put(namespacedName, value);
                this.mIdToIdName.put(value, (Object)namespacedName);
            }
        }
        catch (IllegalAccessException e) {
            Log.e((String)LOGTAG, (String)"Can't read built-in id names from platform library", (Throwable)e);
        }
        String resourcePackage = config.getResourcePackageName();
        if (null == resourcePackage) {
            resourcePackage = context.getPackageName();
        }
        String rIdClassName = resourcePackage + ".R$id";
        try {
            Class<?> rIdClass = Class.forName(rIdClassName);
            Field[] fields = rIdClass.getFields();
            for (int i = 0; i < fields.length; ++i) {
                Class<?> fieldType;
                Field field = fields[i];
                int modifiers = field.getModifiers();
                if (!Modifier.isStatic(modifiers) || (fieldType = field.getType()) != Integer.TYPE) continue;
                String name = field.getName();
                int value = field.getInt(null);
                this.mIdNameToId.put(name, value);
                this.mIdToIdName.put(value, (Object)name);
            }
        }
        catch (ClassNotFoundException e) {
            Log.w((String)LOGTAG, (String)("Can't load names for Android view ids from class " + rIdClassName + ", ids by name will not be available in the events editor."));
            Log.i((String)LOGTAG, (String)"You may be missing a Resources class for your package due to your proguard configuration, or you may be using an applicationId in your build that isn't the same as the package declared in your AndroidManifest.xml file.\nIf you're using proguard, you can fix this issue by adding the following to your proguard configuration:\n\n-keep class **.R$* {\n    <fields>;\n}\n\nIf you're not using proguard, or if your proguard configuration already contains the directive above, you can add the following to your AndroidManifest.xml file to explicitly point the Mixpanel library to the appropriate library for your resources class:\n\n<meta-data android:name=\"com.mixpanel.android.MPConfig.ResourcePackageName\" android:value=\"YOUR_PACKAGE_NAME\" />\n\nwhere YOUR_PACKAGE_NAME is the same string you use for the \"package\" attribute in your <manifest> tag.");
        }
        catch (IllegalAccessException e) {
            Log.e((String)LOGTAG, (String)"Can't read id names for local resources");
        }
    }

    private PropertyDescription readPropertyDescription(Class targetClass, JSONObject propertyDesc) throws BadInstructionsException {
        try {
            String mutatorName;
            String propName = propertyDesc.getString("name");
            Caller accessor = null;
            if (propertyDesc.has("get")) {
                JSONObject accessorConfig = propertyDesc.getJSONObject("get");
                String accessorName = accessorConfig.getString("selector");
                String accessorResultTypeName = accessorConfig.getJSONObject("result").getString("type");
                Class<?> accessorResultType = Class.forName(accessorResultTypeName);
                accessor = new Caller(targetClass, accessorName, NO_PARAMS, accessorResultType);
            }
            if (propertyDesc.has("set")) {
                JSONObject mutatorConfig = propertyDesc.getJSONObject("set");
                mutatorName = mutatorConfig.getString("selector");
            } else {
                mutatorName = null;
            }
            return new PropertyDescription(propName, targetClass, accessor, mutatorName);
        }
        catch (NoSuchMethodException e) {
            throw new BadInstructionsException("Can't create property reader", e);
        }
        catch (JSONException e) {
            throw new BadInstructionsException("Can't read property JSON", (Exception)((Object)e));
        }
        catch (ClassNotFoundException e) {
            throw new BadInstructionsException("Can't read property JSON, relevant arg/return class not found", e);
        }
    }

    private Object convertArgument(Object jsonArgument, String type) throws BadInstructionsException {
        try {
            if ("java.lang.CharSequence".equals(type)) {
                return (String)jsonArgument;
            }
            if ("boolean".equals(type) || "java.lang.Boolean".equals(type)) {
                return (Boolean)jsonArgument;
            }
            if ("int".equals(type) || "java.lang.Integer".equals(type)) {
                return ((Number)jsonArgument).intValue();
            }
            if ("float".equals(type) || "java.lang.Float".equals(type)) {
                return Float.valueOf(((Number)jsonArgument).floatValue());
            }
            if ("android.graphics.Bitmap".equals(type)) {
                byte[] bytes = Base64.decode((String)((String)jsonArgument), (int)0);
                return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
            }
            throw new BadInstructionsException("Don't know how to interpret type " + type + " (arg was " + jsonArgument + ")");
        }
        catch (ClassCastException e) {
            throw new BadInstructionsException("Couldn't interpret <" + jsonArgument + "> as " + type);
        }
    }

    public static class InapplicableInstructionsException
    extends BadInstructionsException {
        public InapplicableInstructionsException(String message) {
            super(message);
        }
    }

    public static class BadInstructionsException
    extends Exception {
        public BadInstructionsException(String message) {
            super(message);
        }

        public BadInstructionsException(String message, Exception e) {
            super(message, e);
        }
    }
}

