/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.viewcrawler;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.viewcrawler.Caller;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@TargetApi(value=14)
abstract class ViewVisitor {
    private final List<PathElement> mPath;
    private static final String LOGTAG = "MixpanelAPI.ViewVisitor";

    public ViewVisitor(List<PathElement> path) {
        this.mPath = path;
    }

    public void visit(View rootView) {
        if (this.mPath.isEmpty()) {
            return;
        }
        PathElement rootPathElement = this.mPath.get(0);
        List<PathElement> childPath = this.mPath.subList(1, this.mPath.size());
        if (rootPathElement.index <= 0 && this.matches(rootPathElement, rootView)) {
            if (childPath.isEmpty()) {
                this.accumulate(rootView);
            } else if (rootView instanceof ViewGroup) {
                ViewGroup rootParent = (ViewGroup)rootView;
                this.findTargetsInChildren(rootParent, childPath);
            }
        }
    }

    protected abstract void accumulate(View var1);

    private void findTargetsInChildren(ViewGroup parent, List<PathElement> path) {
        if (path.isEmpty()) {
            Log.e((String)LOGTAG, (String)"Children will never match an empty path");
            return;
        }
        PathElement matchElement = path.get(0);
        List<PathElement> nextPath = path.subList(1, path.size());
        int matchIndex = matchElement.index;
        int childCount = parent.getChildCount();
        int matchCount = 0;
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            if (!this.matches(matchElement, child)) continue;
            if (matchCount == matchIndex || -1 == matchIndex) {
                if (nextPath.isEmpty()) {
                    this.accumulate(child);
                } else if (child instanceof ViewGroup) {
                    ViewGroup childGroup = (ViewGroup)child;
                    this.findTargetsInChildren(childGroup, nextPath);
                }
            }
            if (matchIndex < 0 || ++matchCount <= matchIndex) continue;
            return;
        }
    }

    private boolean matches(PathElement matchElement, View subject) {
        Object subjectTag;
        int subjectId;
        int matchId;
        String matchClassName = matchElement.viewClassName;
        if (null != matchClassName) {
            Class<?> klass = subject.getClass();
            while (!klass.getCanonicalName().equals(matchClassName)) {
                if (klass == Object.class) {
                    return false;
                }
                klass = klass.getSuperclass();
            }
        }
        if (-1 != (matchId = matchElement.viewId) && (subjectId = subject.getId()) != matchId) {
            return false;
        }
        String matchTag = matchElement.tag;
        return null == matchTag || matchTag.equals((subjectTag = subject.getTag()).toString());
    }

    public static class ViewDetectorVisitor
    extends ViewVisitor {
        private boolean mSeen = false;
        private final OnVisitedListener mListener;
        private final String mEventName;

        public ViewDetectorVisitor(List<PathElement> path, String eventName, OnVisitedListener listener) {
            super(path);
            this.mListener = listener;
            this.mEventName = eventName;
        }

        @Override
        protected void accumulate(View found) {
            if (found != null && !this.mSeen) {
                this.mListener.OnVisited(this.mEventName);
            }
            this.mSeen = found != null;
        }
    }

    public static class AddListenerVisitor
    extends ViewVisitor {
        private final String mEventName;
        private final OnVisitedListener mListener;

        public AddListenerVisitor(List<PathElement> path, String eventName, OnVisitedListener listener) {
            super(path);
            this.mEventName = eventName;
            this.mListener = listener;
        }

        @Override
        public void accumulate(View found) {
            View.AccessibilityDelegate realDelegate = this.getOldDelegate(found);
            if (realDelegate instanceof TrackingAccessibilityDelegate) {
                TrackingAccessibilityDelegate oldTrackingDelegate = (TrackingAccessibilityDelegate)realDelegate;
                String oldEventName = oldTrackingDelegate.getEventName();
                if (null != this.mEventName && this.mEventName.equals(oldEventName)) {
                    return;
                }
                realDelegate = null;
            }
            TrackingAccessibilityDelegate newDelegate = new TrackingAccessibilityDelegate(this.mEventName, realDelegate);
            found.setAccessibilityDelegate((View.AccessibilityDelegate)newDelegate);
        }

        private View.AccessibilityDelegate getOldDelegate(View v) {
            View.AccessibilityDelegate ret = null;
            try {
                Class<?> klass = v.getClass();
                Method m = klass.getMethod("getAccessibilityDelegate", new Class[0]);
                ret = (View.AccessibilityDelegate)m.invoke((Object)v, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                if (MPConfig.DEBUG) {
                    Log.d((String)ViewVisitor.LOGTAG, (String)"View has no getAccessibilityDelegate method - we may be overwriting an existing delegate");
                }
            }
            catch (IllegalAccessException e) {
                if (MPConfig.DEBUG) {
                    Log.d((String)ViewVisitor.LOGTAG, (String)"View does not have a public getAccessibilityDelegate method - overwriting any existing delegate");
                }
            }
            catch (InvocationTargetException e) {
                Log.w((String)ViewVisitor.LOGTAG, (String)"getAccessibilityDelegate threw an exception when called.", (Throwable)e);
            }
            return ret;
        }

        private class TrackingAccessibilityDelegate
        extends View.AccessibilityDelegate {
            private final String mEventName;
            private final View.AccessibilityDelegate mRealDelegate;

            public TrackingAccessibilityDelegate(String eventName, View.AccessibilityDelegate realDelegate) {
                this.mEventName = eventName;
                this.mRealDelegate = realDelegate;
            }

            public String getEventName() {
                return this.mEventName;
            }

            public void sendAccessibilityEvent(View host, int eventType) {
                if (eventType == 1) {
                    AddListenerVisitor.this.mListener.OnVisited(this.mEventName);
                }
                if (null != this.mRealDelegate) {
                    this.mRealDelegate.sendAccessibilityEvent(host, eventType);
                }
            }
        }
    }

    public static class PropertySetVisitor
    extends ViewVisitor {
        private final Caller mMutator;
        private final Caller mAccessor;

        public PropertySetVisitor(List<PathElement> path, Caller mutator, Caller accessor) {
            super(path);
            this.mMutator = mutator;
            this.mAccessor = accessor;
        }

        @Override
        public void accumulate(View found) {
            Object[] setArgs;
            if (null != this.mAccessor && 1 == (setArgs = this.mMutator.getArgs()).length) {
                Bitmap currentBitmap;
                Bitmap desiredBitmap;
                Object desiredValue = setArgs[0];
                Object currentValue = this.mAccessor.applyMethod(found);
                if (desiredValue == currentValue) {
                    return;
                }
                if (null != desiredValue && (desiredValue instanceof Bitmap && currentValue instanceof Bitmap ? (desiredBitmap = (Bitmap)desiredValue).sameAs(currentBitmap = (Bitmap)currentValue) : desiredValue.equals(currentValue))) {
                    return;
                }
            }
            this.mMutator.applyMethod(found);
        }
    }

    public static class PathElement {
        public final String viewClassName;
        public final int index;
        public final int viewId;
        public final String tag;

        public PathElement(String vClass, int ix, int vId, String vTag) {
            this.viewClassName = vClass;
            this.index = ix;
            this.viewId = vId;
            this.tag = vTag;
        }

        public String toString() {
            try {
                JSONObject ret = new JSONObject();
                ret.put("viewClassName", (Object)this.viewClassName);
                if (this.index > -1) {
                    ret.put("index", this.index);
                }
                if (this.viewId > -1) {
                    ret.put("viewId", this.viewId);
                }
                if (null != this.tag) {
                    ret.put("tag", (Object)this.tag);
                }
                return ret.toString();
            }
            catch (JSONException e) {
                throw new RuntimeException("Can't serialize PathElement to String", e);
            }
        }
    }

    public static interface OnVisitedListener {
        public void OnVisited(String var1);
    }
}

