/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.viewcrawler;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.hardware.Sensor;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.view.ViewTreeObserver;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.mpmetrics.MixpanelAPI;
import com.mixpanel.android.viewcrawler.EditProtocol;
import com.mixpanel.android.viewcrawler.EditorConnection;
import com.mixpanel.android.viewcrawler.FlipGesture;
import com.mixpanel.android.viewcrawler.Tweaks;
import com.mixpanel.android.viewcrawler.UpdatesFromMixpanel;
import com.mixpanel.android.viewcrawler.ViewSnapshot;
import com.mixpanel.android.viewcrawler.ViewVisitor;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.ref.WeakReference;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@TargetApi(value=14)
public class ViewCrawler
implements ViewVisitor.OnVisitedListener,
UpdatesFromMixpanel {
    private final Map<String, List<JSONObject>> mPersistentChanges;
    private final Map<String, List<JSONObject>> mEditorChanges;
    private final Map<String, List<JSONObject>> mPersistentEventBindings;
    private final Map<String, List<JSONObject>> mEditorEventBindings;
    private final Set<Activity> mLiveActivities = new HashSet<Activity>();
    private final SSLSocketFactory mSSLSocketFactory;
    private final EditProtocol mProtocol;
    private final Tweaks mTweaks = new Tweaks();
    private final Handler mUiThreadHandler;
    private final ViewCrawlerHandler mMessageThreadHandler;
    private final MixpanelAPI mMixpanel;
    private static final String SHARED_PREF_EDITS_FILE = "mixpanel.viewcrawler.changes";
    private static final String SHARED_PREF_CHANGES_KEY = "mixpanel.viewcrawler.changes";
    private static final String SHARED_PREF_BINDINGS_KEY = "mixpanel.viewcrawler.bindings";
    private static final int MESSAGE_INITIALIZE_CHANGES = 0;
    private static final int MESSAGE_CONNECT_TO_EDITOR = 1;
    private static final int MESSAGE_SEND_STATE_FOR_EDITING = 2;
    private static final int MESSAGE_HANDLE_EDITOR_CHANGES_RECEIVED = 3;
    private static final int MESSAGE_SEND_DEVICE_INFO = 4;
    private static final int MESSAGE_EVENT_BINDINGS_RECEIVED = 6;
    private static final int MESSAGE_DISCONNECT_FROM_EDITOR = 7;
    private static final int MESSAGE_HANDLE_EDITOR_BINDINGS_RECEIVED = 8;
    private static final String LOGTAG = "MixpanelAPI.ViewCrawler";

    public ViewCrawler(Context context, String token, MixpanelAPI mixpanel) {
        SSLSocketFactory foundSSLFactory;
        this.mPersistentChanges = new HashMap<String, List<JSONObject>>();
        this.mEditorChanges = new HashMap<String, List<JSONObject>>();
        this.mPersistentEventBindings = new HashMap<String, List<JSONObject>>();
        this.mEditorEventBindings = new HashMap<String, List<JSONObject>>();
        this.mProtocol = new EditProtocol(context);
        Application app = (Application)context.getApplicationContext();
        app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new LifecycleCallbacks());
        HandlerThread thread = new HandlerThread(ViewCrawler.class.getCanonicalName());
        thread.setPriority(10);
        thread.start();
        this.mMessageThreadHandler = new ViewCrawlerHandler(context, token, thread.getLooper());
        this.mMessageThreadHandler.sendMessage(this.mMessageThreadHandler.obtainMessage(0));
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, null, null);
            foundSSLFactory = sslContext.getSocketFactory();
        }
        catch (GeneralSecurityException e) {
            Log.d((String)LOGTAG, (String)"System has no SSL support. Built-in events editor will not be available", (Throwable)e);
            foundSSLFactory = null;
        }
        this.mSSLSocketFactory = foundSSLFactory;
        this.mUiThreadHandler = new Handler(Looper.getMainLooper());
        this.mMixpanel = mixpanel;
    }

    @Override
    public Tweaks getTweaks() {
        return this.mTweaks;
    }

    @Override
    public void setEventBindings(JSONArray bindings) {
        Message msg = this.mMessageThreadHandler.obtainMessage(6);
        msg.obj = bindings;
        this.mMessageThreadHandler.sendMessage(msg);
    }

    @Override
    public void OnVisited(String eventName) {
        this.mMixpanel.track(eventName, null);
    }

    private void applyAllChangesOnUiThread() {
        this.mUiThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                ViewCrawler.this.applyAllChanges();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyAllChanges() {
        Set<Activity> set = this.mLiveActivities;
        synchronized (set) {
            for (Activity activity : this.mLiveActivities) {
                List<JSONObject> wildcardEditorBindings;
                List<JSONObject> editorBindings;
                List<JSONObject> wildcardEventBindings;
                List<JSONObject> eventBindings;
                List<JSONObject> wildcardEditorChanges;
                List<JSONObject> editorChanges;
                List<JSONObject> wildcardPersistentChanges;
                List<JSONObject> persistentChanges;
                String activityName = activity.getClass().getCanonicalName();
                View rootView = activity.getWindow().getDecorView().getRootView();
                Map<String, List<JSONObject>> map = this.mPersistentChanges;
                synchronized (map) {
                    persistentChanges = this.mPersistentChanges.get(activityName);
                    wildcardPersistentChanges = this.mPersistentChanges.get(null);
                }
                this.applyChangesFromList(rootView, persistentChanges);
                this.applyChangesFromList(rootView, wildcardPersistentChanges);
                Map<String, List<JSONObject>> map2 = this.mEditorChanges;
                synchronized (map2) {
                    editorChanges = this.mEditorChanges.get(activityName);
                    wildcardEditorChanges = this.mEditorChanges.get(null);
                }
                this.applyChangesFromList(rootView, editorChanges);
                this.applyChangesFromList(rootView, wildcardEditorChanges);
                Map<String, List<JSONObject>> map3 = this.mPersistentEventBindings;
                synchronized (map3) {
                    eventBindings = this.mPersistentEventBindings.get(activityName);
                    wildcardEventBindings = this.mPersistentEventBindings.get(null);
                }
                this.applyBindingsFromList(rootView, eventBindings);
                this.applyBindingsFromList(rootView, wildcardEventBindings);
                Map<String, List<JSONObject>> map4 = this.mEditorEventBindings;
                synchronized (map4) {
                    editorBindings = this.mEditorEventBindings.get(activityName);
                    wildcardEditorBindings = this.mEditorEventBindings.get(null);
                }
                this.applyBindingsFromList(rootView, editorBindings);
                this.applyBindingsFromList(rootView, wildcardEditorBindings);
            }
        }
    }

    private void applyChangesFromList(View rootView, List<JSONObject> changes) {
        if (null != changes) {
            int size = changes.size();
            for (int i = 0; i < size; ++i) {
                JSONObject desc = changes.get(i);
                try {
                    ViewVisitor visitor = this.mProtocol.readEdit(desc);
                    EditBinding binding = new EditBinding(rootView, visitor);
                    binding.performEdit();
                    continue;
                }
                catch (EditProtocol.BadInstructionsException e) {
                    Log.e((String)LOGTAG, (String)"Bad change request cannot be applied", (Throwable)e);
                }
            }
        }
    }

    private void applyBindingsFromList(View rootView, List<JSONObject> eventBindings) {
        if (null != eventBindings) {
            int size = eventBindings.size();
            for (int i = 0; i < size; ++i) {
                JSONObject desc = eventBindings.get(i);
                try {
                    ViewVisitor visitor = this.mProtocol.readEventBinding(desc, this);
                    EditBinding binding = new EditBinding(rootView, visitor);
                    binding.performEdit();
                    continue;
                }
                catch (EditProtocol.BadInstructionsException e) {
                    Log.e((String)LOGTAG, (String)"Bad binding cannot be applied", (Throwable)e);
                }
            }
        }
    }

    private static class EditBinding
    implements ViewTreeObserver.OnGlobalLayoutListener {
        private final WeakReference<View> mViewRoot;
        private final ViewVisitor mEdit;

        public EditBinding(View viewRoot, ViewVisitor edit) {
            this.mEdit = edit;
            this.mViewRoot = new WeakReference<View>(viewRoot);
            ViewTreeObserver observer = viewRoot.getViewTreeObserver();
            this.performEdit();
            if (observer.isAlive()) {
                observer.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }

        public void onGlobalLayout() {
            this.performEdit();
        }

        public void performEdit() {
            View viewRoot = (View)this.mViewRoot.get();
            if (null == viewRoot) {
                return;
            }
            this.mEdit.visit(viewRoot);
        }
    }

    private class Editor
    implements EditorConnection.Editor {
        private Editor() {
        }

        @Override
        public void sendSnapshot(JSONObject message) {
            Message msg = ViewCrawler.this.mMessageThreadHandler.obtainMessage(2);
            msg.obj = message;
            ViewCrawler.this.mMessageThreadHandler.sendMessage(msg);
        }

        @Override
        public void performEdit(JSONObject message) {
            Message msg = ViewCrawler.this.mMessageThreadHandler.obtainMessage(3);
            msg.obj = message;
            ViewCrawler.this.mMessageThreadHandler.sendMessage(msg);
        }

        @Override
        public void bindEvents(JSONObject message) {
            Message msg = ViewCrawler.this.mMessageThreadHandler.obtainMessage(8);
            msg.obj = message;
            ViewCrawler.this.mMessageThreadHandler.sendMessage(msg);
        }

        @Override
        public void sendDeviceInfo() {
            Message msg = ViewCrawler.this.mMessageThreadHandler.obtainMessage(4);
            ViewCrawler.this.mMessageThreadHandler.sendMessage(msg);
        }
    }

    private class ViewCrawlerHandler
    extends Handler {
        private EditorConnection mEditorConnection;
        private ViewSnapshot mSnapshot;
        private final Context mContext;
        private final String mToken;

        public ViewCrawlerHandler(Context context, String token, Looper looper) {
            super(looper);
            this.mContext = context;
            this.mToken = token;
            this.mSnapshot = null;
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    this.initializeChanges();
                    break;
                }
                case 1: {
                    this.connectToEditor();
                    break;
                }
                case 7: {
                    this.disconnectFromEditor();
                    break;
                }
                case 4: {
                    this.sendDeviceInfo();
                    break;
                }
                case 2: {
                    this.sendStateForEditing((JSONObject)msg.obj);
                    break;
                }
                case 3: {
                    this.handleEditorChangeReceived((JSONObject)msg.obj);
                    break;
                }
                case 6: {
                    this.handleEventBindingsReceived((JSONArray)msg.obj);
                    break;
                }
                case 8: {
                    this.handleEditorBindingsReceived((JSONObject)msg.obj);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initializeChanges() {
            block11: {
                SharedPreferences preferences = this.getSharedPreferences();
                String storedChanges = preferences.getString("mixpanel.viewcrawler.changes", null);
                String storedBindings = preferences.getString(ViewCrawler.SHARED_PREF_BINDINGS_KEY, null);
                try {
                    int i;
                    Map map;
                    if (null != storedChanges) {
                        JSONArray changes = new JSONArray(storedChanges);
                        map = ViewCrawler.this.mPersistentChanges;
                        synchronized (map) {
                            ViewCrawler.this.mPersistentChanges.clear();
                            for (i = 0; i < changes.length(); ++i) {
                                JSONObject change = changes.getJSONObject(i);
                                this.loadChange(ViewCrawler.this.mPersistentChanges, change);
                            }
                        }
                    }
                    if (null == storedBindings) break block11;
                    JSONArray bindings = new JSONArray(storedBindings);
                    map = ViewCrawler.this.mPersistentEventBindings;
                    synchronized (map) {
                        ViewCrawler.this.mPersistentEventBindings.clear();
                        for (i = 0; i < bindings.length(); ++i) {
                            JSONObject event = bindings.getJSONObject(i);
                            this.loadEventBinding(event, ViewCrawler.this.mPersistentEventBindings);
                        }
                    }
                }
                catch (JSONException e) {
                    Log.i((String)ViewCrawler.LOGTAG, (String)"JSON error when initializing saved changes, clearing persistent memory", (Throwable)e);
                    SharedPreferences.Editor editor = preferences.edit();
                    editor.remove("mixpanel.viewcrawler.changes");
                    editor.remove(ViewCrawler.SHARED_PREF_BINDINGS_KEY);
                    editor.apply();
                }
            }
        }

        private void connectToEditor() {
            if (MPConfig.DEBUG) {
                Log.d((String)ViewCrawler.LOGTAG, (String)"connecting to editor");
            }
            if (this.mEditorConnection != null && this.mEditorConnection.isValid()) {
                if (MPConfig.DEBUG) {
                    Log.d((String)ViewCrawler.LOGTAG, (String)"There is already a valid connection to an events editor.");
                }
                return;
            }
            if (null == ViewCrawler.this.mSSLSocketFactory) {
                Log.d((String)ViewCrawler.LOGTAG, (String)"SSL is not available on this device, no connection will be attempted to the events editor.");
                return;
            }
            String url = MPConfig.getInstance(this.mContext).getEditorUrl() + this.mToken;
            try {
                Socket sslSocket = ViewCrawler.this.mSSLSocketFactory.createSocket();
                this.mEditorConnection = new EditorConnection(new URI(url), new Editor(), sslSocket);
            }
            catch (URISyntaxException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)("Error parsing URI " + url + " for editor websocket"), (Throwable)e);
            }
            catch (EditorConnection.EditorConnectionException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)("Error connecting to URI " + url), (Throwable)e);
            }
            catch (IOException e) {
                Log.i((String)ViewCrawler.LOGTAG, (String)"Can't create SSL Socket to connect to editor service", (Throwable)e);
            }
        }

        private void disconnectFromEditor() {
            if (MPConfig.DEBUG) {
                Log.d((String)ViewCrawler.LOGTAG, (String)"disconnecting from editor");
            }
            if ((this.mEditorConnection == null || !this.mEditorConnection.isValid()) && MPConfig.DEBUG) {
                Log.d((String)ViewCrawler.LOGTAG, (String)"Editor is already disconnected.");
            }
            this.mEditorConnection.disconnect();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendError(String errorMessage) {
            JSONObject errorObject = new JSONObject();
            try {
                errorObject.put("error_message", (Object)errorMessage);
            }
            catch (JSONException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Apparently impossible JSONException", (Throwable)e);
            }
            OutputStreamWriter writer = new OutputStreamWriter(this.mEditorConnection.getBufferedOutputStream());
            try {
                writer.write("{\"type\": \"error\", ");
                writer.write("\"payload\": ");
                writer.write(errorObject.toString());
                writer.write("}");
            }
            catch (IOException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Can't write error message to editor", (Throwable)e);
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    Log.e((String)ViewCrawler.LOGTAG, (String)"Could not close output writer to editor", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendDeviceInfo() {
            BufferedOutputStream out = this.mEditorConnection.getBufferedOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(out);
            try {
                writer.write("{\"type\": \"device_info_response\",");
                writer.write("\"payload\": {");
                writer.write("\"device_type\": \"Android\",");
                writer.write("\"device_name\": \"" + Build.BRAND + "/" + Build.MODEL + "\",");
                writer.write("\"tweaks\":");
                writer.write(new JSONObject(ViewCrawler.this.mTweaks.getAll()).toString());
                writer.write("}");
                writer.write("}");
            }
            catch (IOException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Can't write device_info to server", (Throwable)e);
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    Log.e((String)ViewCrawler.LOGTAG, (String)"Can't close websocket writer", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendStateForEditing(JSONObject message) {
            try {
                JSONObject payload = message.getJSONObject("payload");
                if (payload.has("config")) {
                    this.mSnapshot = ViewCrawler.this.mProtocol.readSnapshotConfig(payload);
                }
            }
            catch (JSONException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Payload with snapshot config required with snapshot request", (Throwable)e);
                this.sendError("Payload with snapshot config required with snapshot request");
                return;
            }
            catch (EditProtocol.BadInstructionsException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Editor sent malformed message with snapshot request", (Throwable)e);
                this.sendError(e.getMessage());
                return;
            }
            if (null == this.mSnapshot) {
                this.sendError("No snapshot configuration was sent.");
                Log.w((String)ViewCrawler.LOGTAG, (String)"Mixpanel editor is misconfigured, sent a snapshot request without configuration.");
            }
            BufferedOutputStream out = this.mEditorConnection.getBufferedOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(out);
            try {
                writer.write("{\"type\": \"snapshot_response\",");
                writer.write("\"payload\": {");
                writer.write("\"activities\": [");
                writer.flush();
                this.mSnapshot.snapshots(ViewCrawler.this.mLiveActivities, out);
                writer.write("]");
                writer.write("}");
                writer.write("}");
            }
            catch (IOException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Can't write snapshot request to server", (Throwable)e);
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    Log.e((String)ViewCrawler.LOGTAG, (String)"Can't close writer.", (Throwable)e);
                }
            }
        }

        private void handleEditorChangeReceived(JSONObject change) {
            try {
                this.loadChange(ViewCrawler.this.mEditorChanges, change);
                ViewCrawler.this.applyAllChangesOnUiThread();
            }
            catch (JSONException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Bad change request received", (Throwable)e);
            }
        }

        private void handleEventBindingsReceived(JSONArray eventBindings) {
            SharedPreferences preferences = this.getSharedPreferences();
            SharedPreferences.Editor editor = preferences.edit();
            editor.putString(ViewCrawler.SHARED_PREF_BINDINGS_KEY, eventBindings.toString());
            editor.apply();
            this.initializeChanges();
            ViewCrawler.this.applyAllChangesOnUiThread();
        }

        private void handleEditorBindingsReceived(JSONObject message) {
            JSONArray eventBindings;
            try {
                JSONObject payload = message.getJSONObject("payload");
                eventBindings = payload.getJSONArray("events");
            }
            catch (JSONException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Bad event bindings received", (Throwable)e);
                return;
            }
            int eventCount = eventBindings.length();
            for (int i = 0; i < eventCount; ++i) {
                try {
                    JSONObject event = eventBindings.getJSONObject(i);
                    this.loadEventBinding(event, ViewCrawler.this.mEditorEventBindings);
                    continue;
                }
                catch (JSONException e) {
                    Log.e((String)ViewCrawler.LOGTAG, (String)("Bad event binding received from editor in " + eventBindings.toString()), (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadChange(Map<String, List<JSONObject>> changes, JSONObject newChange) throws JSONException {
            String targetActivity = newChange.optString("target", null);
            JSONObject change = newChange.getJSONObject("change");
            Map<String, List<JSONObject>> map = changes;
            synchronized (map) {
                List<Object> changeList;
                if (changes.containsKey(targetActivity)) {
                    changeList = changes.get(targetActivity);
                } else {
                    changeList = new ArrayList();
                    changes.put(targetActivity, changeList);
                }
                changeList.add(change);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadEventBinding(JSONObject newBinding, Map<String, List<JSONObject>> bindings) throws JSONException {
            String targetActivity = newBinding.optString("target_activity", null);
            Map<String, List<JSONObject>> map = bindings;
            synchronized (map) {
                List<Object> bindingList;
                if (bindings.containsKey(targetActivity)) {
                    bindingList = bindings.get(targetActivity);
                } else {
                    bindingList = new ArrayList();
                    bindings.put(targetActivity, bindingList);
                }
                bindingList.add(newBinding);
            }
        }

        private SharedPreferences getSharedPreferences() {
            String sharedPrefsName = "mixpanel.viewcrawler.changes" + this.mToken;
            return this.mContext.getSharedPreferences(sharedPrefsName, 0);
        }
    }

    private class LifecycleCallbacks
    implements Application.ActivityLifecycleCallbacks,
    FlipGesture.OnFlipGestureListener {
        private final FlipGesture mFlipGesture = new FlipGesture(this);

        @Override
        public void onFlipGesture() {
            Message message = ViewCrawler.this.mMessageThreadHandler.obtainMessage(1);
            ViewCrawler.this.mMessageThreadHandler.sendMessage(message);
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onActivityStarted(Activity activity) {
            Set set = ViewCrawler.this.mLiveActivities;
            synchronized (set) {
                ViewCrawler.this.mLiveActivities.add(activity);
            }
            ViewCrawler.this.applyAllChanges();
        }

        public void onActivityResumed(Activity activity) {
            SensorManager sensorManager = (SensorManager)activity.getSystemService("sensor");
            Sensor accelerometer = sensorManager.getDefaultSensor(1);
            sensorManager.registerListener((SensorEventListener)this.mFlipGesture, accelerometer, 3);
        }

        public void onActivityPaused(Activity activity) {
            SensorManager sensorManager = (SensorManager)activity.getSystemService("sensor");
            sensorManager.unregisterListener((SensorEventListener)this.mFlipGesture);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onActivityStopped(Activity activity) {
            Set set = ViewCrawler.this.mLiveActivities;
            synchronized (set) {
                ViewCrawler.this.mLiveActivities.remove(activity);
            }
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public void onActivityDestroyed(Activity activity) {
        }
    }
}

