/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.viewcrawler;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.util.Log;
import com.mixpanel.android.mpmetrics.MPConfig;

class FlipGesture
implements SensorEventListener {
    private int mTriggerState = -1;
    private int mFlipState = 0;
    private long mLastFlipTime = -1L;
    private final float[] mSmoothed = new float[3];
    private final OnFlipGestureListener mListener;
    private static final float MINIMUM_Z_GRAVITY_FOR_FLIP = 9.0f;
    private static final float MAXIMUM_XY_GRAVITY_FOR_FLIP = 2.0f;
    private static final long MINIMUM_FLIP_DURATION_NANOS = 1000000000L;
    private static final int FLIP_STATE_UP = -1;
    private static final int FLIP_STATE_NONE = 0;
    private static final int FLIP_STATE_DOWN = 1;
    private static final int TRIGGER_STATE_NONE = 0;
    private static final int TRIGGER_STATE_BEGIN = 1;
    private static final float ACCELEROMETER_SMOOTHING = 0.5f;
    private static final String LOGTAG = "MixpanelAPI.FlipGesture";

    public FlipGesture(OnFlipGestureListener listener) {
        this.mListener = listener;
    }

    public void onSensorChanged(SensorEvent event) {
        long flipDurationNanos;
        float[] smoothed = this.smoothXYZ(event.values);
        int oldFlipState = this.mFlipState;
        this.mFlipState = smoothed[0] > 2.0f || smoothed[0] < -2.0f ? 0 : (smoothed[1] > 2.0f || smoothed[1] < -2.0f ? 0 : (smoothed[2] > 9.0f ? -1 : (smoothed[2] < -9.0f ? 1 : 0)));
        if (oldFlipState != this.mFlipState) {
            this.mLastFlipTime = event.timestamp;
        }
        if ((flipDurationNanos = event.timestamp - this.mLastFlipTime) > 1000000000L) {
            if (this.mFlipState == 0 && this.mTriggerState != 0) {
                if (MPConfig.DEBUG) {
                    Log.d((String)LOGTAG, (String)"Flip gesture abandoned");
                }
                this.mTriggerState = 0;
            } else if (this.mFlipState == 1 && this.mTriggerState == 0) {
                if (MPConfig.DEBUG) {
                    Log.d((String)LOGTAG, (String)"Flip gesture begun");
                }
                this.mTriggerState = 1;
            } else if (this.mFlipState == -1 && this.mTriggerState == 1) {
                if (MPConfig.DEBUG) {
                    Log.d((String)LOGTAG, (String)"Flip gesture completed");
                }
                this.mTriggerState = 0;
                this.mListener.onFlipGesture();
            }
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    private float[] smoothXYZ(float[] samples) {
        for (int i = 0; i < 3; ++i) {
            float oldVal = this.mSmoothed[i];
            this.mSmoothed[i] = oldVal + 0.5f * (samples[i] - oldVal);
        }
        return this.mSmoothed;
    }

    public static interface OnFlipGestureListener {
        public void onFlipGesture();
    }
}

