/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.util.Log;
import com.mixpanel.android.surveys.SurveyActivity;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class ConfigurationChecker {
    public static String LOGTAG = "MixpanelAPI.ConfigurationChecker";

    ConfigurationChecker() {
    }

    public static boolean checkPushConfiguration(Context context) {
        PackageInfo receiversInfo;
        if (Build.VERSION.SDK_INT < 8) {
            Log.i((String)LOGTAG, (String)("Mixpanel push notifications not supported in SDK " + Build.VERSION.SDK_INT));
            return false;
        }
        PackageManager packageManager = context.getPackageManager();
        String packageName = context.getPackageName();
        String permissionName = packageName + ".permission.C2D_MESSAGE";
        try {
            packageManager.getPermissionInfo(permissionName, 4096);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w((String)LOGTAG, (String)("Application does not define permission " + permissionName));
            Log.i((String)LOGTAG, (String)("You will need to add the following lines to your application manifest:\n<permission android:name=\"" + packageName + ".permission.C2D_MESSAGE\" android:protectionLevel=\"signature\" />\n" + "<uses-permission android:name=\"" + packageName + ".permission.C2D_MESSAGE\" />"));
            return false;
        }
        if (0 != packageManager.checkPermission("com.google.android.c2dm.permission.RECEIVE", packageName)) {
            Log.w((String)LOGTAG, (String)"Package does not have permission com.google.android.c2dm.permission.RECEIVE");
            Log.i((String)LOGTAG, (String)"You can fix this by adding the following to your AndroidManifest.xml file:\n<uses-permission android:name=\"com.google.android.c2dm.permission.RECEIVE\" />");
            return false;
        }
        if (0 != packageManager.checkPermission("android.permission.INTERNET", packageName)) {
            Log.w((String)LOGTAG, (String)"Package does not have permission android.permission.INTERNET");
            Log.i((String)LOGTAG, (String)"You can fix this by adding the following to your AndroidManifest.xml file:\n<uses-permission android:name=\"android.permission.INTERNET\" />");
            return false;
        }
        if (0 != packageManager.checkPermission("android.permission.GET_ACCOUNTS", packageName)) {
            Log.w((String)LOGTAG, (String)"Package does not have permission android.permission.GET_ACCOUNTS");
            Log.i((String)LOGTAG, (String)"You can fix this by adding the following to your AndroidManifest.xml file:\n<uses-permission android:name=\"android.permission.GET_ACCOUNTS\" />");
            return false;
        }
        if (0 != packageManager.checkPermission("android.permission.WAKE_LOCK", packageName)) {
            Log.w((String)LOGTAG, (String)"Package does not have permission android.permission.WAKE_LOCK");
            Log.i((String)LOGTAG, (String)"You can fix this by adding the following to your AndroidManifest.xml file:\n<uses-permission android:name=\"android.permission.WAKE_LOCK\" />");
            return false;
        }
        try {
            receiversInfo = packageManager.getPackageInfo(packageName, 2);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w((String)LOGTAG, (String)("Could not get receivers for package " + packageName));
            return false;
        }
        ActivityInfo[] receivers = receiversInfo.receivers;
        if (receivers == null || receivers.length == 0) {
            Log.w((String)LOGTAG, (String)("No receiver for package " + packageName));
            Log.i((String)LOGTAG, (String)("You can fix this with the following into your <application> tag:\n" + ConfigurationChecker.samplePushConfigurationMessage(packageName)));
            return false;
        }
        HashSet<String> allowedReceivers = new HashSet<String>();
        for (ActivityInfo receiver : receivers) {
            if (!"com.google.android.c2dm.permission.SEND".equals(receiver.permission)) continue;
            allowedReceivers.add(receiver.name);
        }
        if (allowedReceivers.isEmpty()) {
            Log.w((String)LOGTAG, (String)"No receiver allowed to receive com.google.android.c2dm.permission.SEND");
            Log.i((String)LOGTAG, (String)("You can fix by pasting the following into the <application> tag in your AndroidManifest.xml:\n" + ConfigurationChecker.samplePushConfigurationMessage(packageName)));
            return false;
        }
        return ConfigurationChecker.checkReceiver(context, allowedReceivers, "com.google.android.c2dm.intent.REGISTRATION") && ConfigurationChecker.checkReceiver(context, allowedReceivers, "com.google.android.c2dm.intent.RECEIVE");
    }

    public static boolean checkSurveyActivityAvailable(Context context) {
        if (Build.VERSION.SDK_INT < 14) {
            return false;
        }
        Intent surveyIntent = new Intent(context, SurveyActivity.class);
        surveyIntent.addFlags(0x10000000);
        surveyIntent.addFlags(131072);
        PackageManager packageManager = context.getPackageManager();
        List intentActivities = packageManager.queryIntentActivities(surveyIntent, 0);
        if (intentActivities.size() == 0) {
            Log.w((String)LOGTAG, (String)(SurveyActivity.class.getName() + " is not registered as an activity in your application, so surveys can't be shown."));
            Log.i((String)LOGTAG, (String)"Please add the child tag <activity android:name=\"com.mixpanel.android.surveys.SurveyActivity\" /> to your <application> tag.");
            return false;
        }
        return true;
    }

    private static String samplePushConfigurationMessage(String packageName) {
        return "<receiver android:name=\"com.mixpanel.android.mpmetrics.GCMReceiver\"\n          android:permission=\"com.google.android.c2dm.permission.SEND\" >\n    <intent-filter>\n       <action android:name=\"com.google.android.c2dm.intent.RECEIVE\" />\n       <action android:name=\"com.google.android.c2dm.intent.REGISTRATION\" />\n       <category android:name=\"" + packageName + "\" />\n" + "    </intent-filter>\n" + "</receiver>";
    }

    private static boolean checkReceiver(Context context, Set<String> allowedReceivers, String action) {
        PackageManager pm = context.getPackageManager();
        String packageName = context.getPackageName();
        Intent intent = new Intent(action);
        intent.setPackage(packageName);
        List receivers = pm.queryBroadcastReceivers(intent, 32);
        if (receivers.isEmpty()) {
            Log.w((String)LOGTAG, (String)("No receivers for action " + action));
            Log.i((String)LOGTAG, (String)("You can fix by pasting the following into the <application> tag in your AndroidManifest.xml:\n" + ConfigurationChecker.samplePushConfigurationMessage(packageName)));
            return false;
        }
        for (ResolveInfo receiver : receivers) {
            String name = receiver.activityInfo.name;
            if (allowedReceivers.contains(name)) continue;
            Log.w((String)LOGTAG, (String)("Receiver " + name + " is not set with permission com.google.android.c2dm.permission.SEND"));
            Log.i((String)LOGTAG, (String)"Please add the attribute 'android:permission=\"com.google.android.c2dm.permission.SEND\"' to your <receiver> tag");
            return false;
        }
        return true;
    }
}

