/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import com.mixpanel.android.mpmetrics.BadDecideObjectException;
import com.mixpanel.android.mpmetrics.DecideUpdates;
import com.mixpanel.android.mpmetrics.InAppNotification;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.mpmetrics.ServerMessage;
import com.mixpanel.android.mpmetrics.Survey;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class DecideChecker {
    private final MPConfig mConfig;
    private final Context mContext;
    private final List<DecideUpdates> mChecks;
    private static final String LOGTAG = "MixpanelAPI DecideChecker";

    public DecideChecker(Context context, MPConfig config) {
        this.mContext = context;
        this.mConfig = config;
        this.mChecks = new LinkedList<DecideUpdates>();
    }

    public void addDecideCheck(DecideUpdates check) {
        this.mChecks.add(check);
    }

    public void runDecideChecks(ServerMessage poster) {
        Iterator<DecideUpdates> itr = this.mChecks.iterator();
        while (itr.hasNext()) {
            DecideUpdates updates = itr.next();
            if (updates.isDestroyed()) {
                itr.remove();
                continue;
            }
            Result result = this.runDecideCheck(updates.getToken(), updates.getDistinctId(), poster);
            updates.reportResults(result.surveys, result.notifications);
        }
    }

    private Result runDecideCheck(String token, String distinctId, ServerMessage poster) {
        String responseString = this.getDecideResponseFromServer(token, distinctId, poster);
        Log.d((String)LOGTAG, (String)("Mixpanel decide server response was\n" + responseString));
        Result parsed = new Result();
        if (null != responseString) {
            parsed = DecideChecker.parseDecideResponse(responseString);
        }
        Iterator<InAppNotification> notificationIterator = parsed.notifications.iterator();
        while (notificationIterator.hasNext()) {
            InAppNotification notification = notificationIterator.next();
            Bitmap image = DecideChecker.getNotificationImage(notification, this.mContext, poster);
            if (null == image) {
                Log.i((String)LOGTAG, (String)"Could not retrieve image for notification, will not show the notification.");
                notificationIterator.remove();
                continue;
            }
            notification.setImage(image);
        }
        return parsed;
    }

    static Result parseDecideResponse(String responseString) {
        JSONObject response;
        Result ret = new Result();
        try {
            response = new JSONObject(responseString);
        }
        catch (JSONException e) {
            Log.e((String)LOGTAG, (String)("Mixpanel endpoint returned unparsable result:\n" + responseString), (Throwable)e);
            return ret;
        }
        JSONArray surveys = null;
        if (response.has("surveys")) {
            try {
                surveys = response.getJSONArray("surveys");
            }
            catch (JSONException e) {
                Log.e((String)LOGTAG, (String)("Mixpanel endpoint returned non-array JSON for surveys: " + response));
            }
        }
        if (null != surveys) {
            int surveysToRead = Math.min(surveys.length(), 4);
            for (int i = 0; i < surveysToRead; ++i) {
                try {
                    JSONObject surveyJson = surveys.getJSONObject(i);
                    Survey survey = new Survey(surveyJson);
                    ret.surveys.add(survey);
                    continue;
                }
                catch (JSONException e) {
                    Log.e((String)LOGTAG, (String)("Received a strange response from surveys service: " + surveys.toString()));
                    continue;
                }
                catch (BadDecideObjectException e) {
                    Log.e((String)LOGTAG, (String)("Received a strange response from surveys service: " + surveys.toString()));
                }
            }
        }
        JSONArray notifications = null;
        if (response.has("notifications")) {
            try {
                notifications = response.getJSONArray("notifications");
            }
            catch (JSONException e) {
                Log.e((String)LOGTAG, (String)("Mixpanel endpoint returned non-array JSON for notifications: " + response));
            }
        }
        if (null != notifications) {
            int notificationsToRead = Math.min(notifications.length(), 4);
            for (int i = 0; null != notifications && i < notificationsToRead; ++i) {
                try {
                    JSONObject notificationJson = notifications.getJSONObject(i);
                    InAppNotification notification = new InAppNotification(notificationJson);
                    ret.notifications.add(notification);
                    continue;
                }
                catch (JSONException e) {
                    Log.e((String)LOGTAG, (String)("Received a strange response from notifications service: " + notifications.toString()), (Throwable)e);
                    continue;
                }
                catch (BadDecideObjectException e) {
                    Log.e((String)LOGTAG, (String)("Received a strange response from notifications service: " + notifications.toString()), (Throwable)e);
                }
            }
        }
        return ret;
    }

    private String getDecideResponseFromServer(String unescapedToken, String unescapedDistinctId, ServerMessage poster) {
        String escapedId;
        String escapedToken;
        try {
            escapedToken = URLEncoder.encode(unescapedToken, "utf-8");
            escapedId = URLEncoder.encode(unescapedDistinctId, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Mixpanel library requires utf-8 string encoding to be available", e);
        }
        String checkQuery = "?version=1&lib=android&token=" + escapedToken + "&distinct_id=" + escapedId;
        String endpointUrl = this.mConfig.getDecideEndpoint() + checkQuery;
        String fallbackUrl = this.mConfig.getDecideFallbackEndpoint() + checkQuery;
        Log.d((String)LOGTAG, (String)("Querying decide server at " + endpointUrl));
        Log.d((String)LOGTAG, (String)("    (with fallback " + fallbackUrl + ")"));
        ServerMessage.Result result = poster.get(this.mContext, endpointUrl, fallbackUrl);
        if (result.getStatus() != ServerMessage.Status.SUCCEEDED) {
            Log.d((String)LOGTAG, (String)"Couldn't reach Mixpanel to check for Surveys. (Or user doesn't exist yet)");
            return null;
        }
        return result.getResponse();
    }

    private static Bitmap getNotificationImage(InAppNotification notification, Context context, ServerMessage poster) {
        Bitmap ret = null;
        String imageUrl = notification.getType() == InAppNotification.Type.MINI ? notification.getImageUrl() : notification.getImage2xUrl();
        Log.d((String)LOGTAG, (String)("Downloading image from URL " + imageUrl));
        ServerMessage.Result result = poster.get(context, imageUrl, null);
        if (result.getStatus() != ServerMessage.Status.SUCCEEDED) {
            Log.i((String)LOGTAG, (String)("Could not access image at " + imageUrl + ", notification will not be shown"));
        } else {
            byte[] imageBytes = result.getResponseBytes();
            ret = BitmapFactory.decodeByteArray((byte[])imageBytes, (int)0, (int)imageBytes.length);
        }
        return ret;
    }

    static class Result {
        public final List<Survey> surveys = new ArrayList<Survey>();
        public final List<InAppNotification> notifications = new ArrayList<InAppNotification>();
    }
}

