/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class WaitingPeopleRecord {
    private static final String LOGTAG = "MixpanelAPI";
    private JSONObject mSets;
    private Map<String, Double> mAdds = new HashMap<String, Double>();
    private List<JSONObject> mAppends = new ArrayList<JSONObject>();

    public WaitingPeopleRecord() {
        this.mSets = new JSONObject();
    }

    public void setOnWaitingPeopleRecord(JSONObject sets) throws JSONException {
        Iterator iter = sets.keys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Object val = sets.get(key);
            this.mAdds.remove(key);
            ArrayList<JSONObject> remainingAppends = new ArrayList<JSONObject>();
            for (JSONObject nextAppend : remainingAppends) {
                nextAppend.remove(key);
                if (nextAppend.length() <= 0) continue;
                remainingAppends.add(nextAppend);
            }
            this.mAppends = remainingAppends;
            this.mSets.put(key, val);
        }
    }

    public void incrementToWaitingPeopleRecord(Map<String, ? extends Number> adds) {
        for (String key : adds.keySet()) {
            Number oldIncrement = this.mAdds.get(key);
            Number changeIncrement = adds.get(key);
            if (oldIncrement == null && changeIncrement != null) {
                this.mAdds.put(key, changeIncrement.doubleValue());
                continue;
            }
            if (oldIncrement == null || changeIncrement == null) continue;
            this.mAdds.put(key, oldIncrement.doubleValue() + changeIncrement.doubleValue());
        }
    }

    public void appendToWaitingPeopleRecord(JSONObject properties) {
        this.mAppends.add(properties);
    }

    public void readFromJSONString(String jsonString) throws JSONException {
        JSONObject stored = new JSONObject(jsonString);
        JSONObject newSets = new JSONObject();
        if (stored.has("$set")) {
            newSets = stored.getJSONObject("$set");
        }
        HashMap<String, Double> newAdds = new HashMap<String, Double>();
        if (stored.has("$add")) {
            JSONObject addsJSON = stored.getJSONObject("$add");
            Iterator iter = addsJSON.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Double amount = addsJSON.getDouble(key);
                newAdds.put(key, amount);
            }
        }
        ArrayList<JSONObject> newAppends = new ArrayList<JSONObject>();
        if (stored.has("$append")) {
            JSONArray appendsJSON = stored.getJSONArray("$append");
            for (int i = 0; i < appendsJSON.length(); ++i) {
                JSONObject nextAppend = appendsJSON.getJSONObject(i);
                newAppends.add(nextAppend);
            }
        }
        this.mSets = newSets;
        this.mAdds = newAdds;
        this.mAppends = newAppends;
    }

    public String toJSONString() {
        String ret = null;
        try {
            JSONObject addObject = new JSONObject();
            for (String addKey : this.mAdds.keySet()) {
                Double value = this.mAdds.get(addKey);
                addObject.put(addKey, (Object)value);
            }
            JSONArray appendArray = new JSONArray();
            for (JSONObject append : this.mAppends) {
                appendArray.put((Object)append);
            }
            JSONObject retObject = new JSONObject();
            retObject.put("$set", (Object)this.mSets);
            retObject.put("$add", (Object)addObject);
            retObject.put("$append", (Object)appendArray);
            ret = retObject.toString();
        }
        catch (JSONException e) {
            Log.e((String)LOGTAG, (String)"Could not write Waiting User Properties to JSON", (Throwable)e);
        }
        return ret;
    }

    public JSONObject setMessage() {
        return this.mSets;
    }

    public Map<String, Double> incrementMessage() {
        return this.mAdds;
    }

    public List<JSONObject> appendMessages() {
        return this.mAppends;
    }
}

