/*
 * Decompiled with CFR 0.152.
 */
package com.mikhaellopez.circularimageview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewOutlineProvider;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatImageView;
import com.mikhaellopez.circularimageview.R;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0007\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u0081\u00012\u00020\u0001:\u0006\u0081\u0001\u0082\u0001\u0083\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u0002082\u0006\u0010T\u001a\u00020\u0007H\u0002J\u0018\u0010U\u001a\u00020R2\u0006\u0010S\u001a\u0002082\u0006\u0010T\u001a\u00020\u0007H\u0002J \u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020\u00072\u0006\u0010Y\u001a\u00020\u00072\u0006\u0010Z\u001a\u00020\u000fH\u0002J\b\u0010[\u001a\u00020\\H\u0002J\u0014\u0010]\u001a\u0004\u0018\u0001082\b\u0010^\u001a\u0004\u0018\u000106H\u0002J\u0018\u0010_\u001a\u00020R2\u0006\u0010S\u001a\u0002082\u0006\u0010T\u001a\u00020\u0007H\u0002J\b\u0010`\u001a\u00020aH\u0016J\"\u0010b\u001a\u00020\\2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010c\u001a\u00020\\H\u0002J\b\u0010d\u001a\u00020\\H\u0002J\b\u0010e\u001a\u00020\\H\u0002J\b\u0010f\u001a\u00020\\H\u0002J\u0010\u0010g\u001a\u00020\u00072\u0006\u0010h\u001a\u00020\u0007H\u0002J\u0010\u0010i\u001a\u00020\\2\u0006\u0010j\u001a\u00020kH\u0014J\u0018\u0010l\u001a\u00020\\2\u0006\u0010m\u001a\u00020\u00072\u0006\u0010n\u001a\u00020\u0007H\u0014J(\u0010o\u001a\u00020\\2\u0006\u0010p\u001a\u00020\u00072\u0006\u0010q\u001a\u00020\u00072\u0006\u0010r\u001a\u00020\u00072\u0006\u0010s\u001a\u00020\u0007H\u0014J\u0012\u0010t\u001a\u00020\\2\b\u0010u\u001a\u0004\u0018\u000101H\u0016J\u0010\u0010v\u001a\u00020\\2\u0006\u0010w\u001a\u00020aH\u0016J\b\u0010x\u001a\u00020\\H\u0002J\b\u0010y\u001a\u00020\\H\u0002J\f\u0010z\u001a\u000208*\u00020{H\u0002J\u000e\u0010|\u001a\u0004\u0018\u000108*\u000206H\u0002J\f\u0010}\u001a\u00020\u000f*\u00020\u0007H\u0002J\f\u0010~\u001a\u00020H*\u00020\u0007H\u0002J\r\u0010\u007f\u001a\u000208*\u00030\u0080\u0001H\u0002R$\u0010\n\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u000f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R*\u0010\u0015\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u0007@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001a\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R*\u0010\u001b\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u0007@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001a\u001a\u0004\b\u001c\u0010\u0017\"\u0004\b\u001d\u0010\u0019R$\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\u001e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010%\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\f\"\u0004\b'\u0010\u000eR$\u0010(\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u000f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0012\"\u0004\b*\u0010\u0014R*\u0010+\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u0007@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001a\u001a\u0004\b,\u0010\u0017\"\u0004\b-\u0010\u0019R*\u0010.\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u0007@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001a\u001a\u0004\b/\u0010\u0017\"\u0004\b0\u0010\u0019R\"\u00102\u001a\u0004\u0018\u0001012\b\u0010\t\u001a\u0004\u0018\u000101@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b3\u00104R\u0010\u00105\u001a\u0004\u0018\u000106X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00107\u001a\u0004\u0018\u000108X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020;X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020;X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020;X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020;X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010?\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010\f\"\u0004\bA\u0010\u000eR$\u0010C\u001a\u00020B2\u0006\u0010\t\u001a\u00020B@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR$\u0010I\u001a\u00020H2\u0006\u0010\t\u001a\u00020H@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR$\u0010N\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\u001e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010!\"\u0004\bP\u0010#\u00a8\u0006\u0084\u0001"}, d2={"Lcom/mikhaellopez/circularimageview/CircularImageView;", "Landroidx/appcompat/widget/AppCompatImageView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "value", "borderColor", "getBorderColor", "()I", "setBorderColor", "(I)V", "Lcom/mikhaellopez/circularimageview/CircularImageView$GradientDirection;", "borderColorDirection", "getBorderColorDirection", "()Lcom/mikhaellopez/circularimageview/CircularImageView$GradientDirection;", "setBorderColorDirection", "(Lcom/mikhaellopez/circularimageview/CircularImageView$GradientDirection;)V", "borderColorEnd", "getBorderColorEnd", "()Ljava/lang/Integer;", "setBorderColorEnd", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "borderColorStart", "getBorderColorStart", "setBorderColorStart", "", "borderWidth", "getBorderWidth", "()F", "setBorderWidth", "(F)V", "circleCenter", "circleColor", "getCircleColor", "setCircleColor", "circleColorDirection", "getCircleColorDirection", "setCircleColorDirection", "circleColorEnd", "getCircleColorEnd", "setCircleColorEnd", "circleColorStart", "getCircleColorStart", "setCircleColorStart", "Landroid/graphics/ColorFilter;", "civColorFilter", "setCivColorFilter", "(Landroid/graphics/ColorFilter;)V", "civDrawable", "Landroid/graphics/drawable/Drawable;", "civImage", "Landroid/graphics/Bitmap;", "heightCircle", "paint", "Landroid/graphics/Paint;", "paintBackground", "paintBorder", "paintShadow", "shadowColor", "getShadowColor", "setShadowColor", "", "shadowEnable", "getShadowEnable", "()Z", "setShadowEnable", "(Z)V", "Lcom/mikhaellopez/circularimageview/CircularImageView$ShadowGravity;", "shadowGravity", "getShadowGravity", "()Lcom/mikhaellopez/circularimageview/CircularImageView$ShadowGravity;", "setShadowGravity", "(Lcom/mikhaellopez/circularimageview/CircularImageView$ShadowGravity;)V", "shadowRadius", "getShadowRadius", "setShadowRadius", "centerCrop", "Landroid/graphics/Matrix;", "bitmap", "viewSize", "centerInside", "createLinearGradient", "Landroid/graphics/LinearGradient;", "startColor", "endColor", "gradientDirection", "drawShadow", "", "drawableToBitmap", "drawable", "fitCenter", "getScaleType", "Landroid/widget/ImageView$ScaleType;", "init", "loadBitmap", "manageBorderColor", "manageCircleColor", "manageElevation", "measure", "measureSpec", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onSizeChanged", "w", "h", "oldw", "oldh", "setColorFilter", "colorFilter", "setScaleType", "scaleType", "update", "updateShader", "bitmapDrawableToBitmap", "Landroid/graphics/drawable/BitmapDrawable;", "toBitmap", "toGradientDirection", "toShadowGravity", "vectorDrawableToBitmap", "Landroid/graphics/drawable/VectorDrawable;", "Companion", "GradientDirection", "ShadowGravity", "circularimageview_release"})
public final class CircularImageView
extends AppCompatImageView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Paint paint;
    @NotNull
    private final Paint paintBorder;
    @NotNull
    private final Paint paintShadow;
    @NotNull
    private final Paint paintBackground;
    private int circleCenter;
    private int heightCircle;
    private int circleColor;
    @Nullable
    private Integer circleColorStart;
    @Nullable
    private Integer circleColorEnd;
    @NotNull
    private GradientDirection circleColorDirection;
    private float borderWidth;
    private int borderColor;
    @Nullable
    private Integer borderColorStart;
    @Nullable
    private Integer borderColorEnd;
    @NotNull
    private GradientDirection borderColorDirection;
    private float shadowRadius;
    private int shadowColor;
    @NotNull
    private ShadowGravity shadowGravity;
    private boolean shadowEnable;
    @Nullable
    private ColorFilter civColorFilter;
    @Nullable
    private Bitmap civImage;
    @Nullable
    private Drawable civDrawable;
    private static final float DEFAULT_BORDER_WIDTH = 4.0f;
    private static final float DEFAULT_SHADOW_RADIUS = 8.0f;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public CircularImageView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        void $this$paintBackground_u24lambda_u2d3;
        Paint $this$paintShadow_u24lambda_u2d2;
        Paint $this$paintBorder_u24lambda_u2d1;
        Paint $this$paint_u24lambda_u2d0;
        Paint paint;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        Paint paint2 = paint = new Paint();
        CircularImageView circularImageView = this;
        boolean bl = false;
        $this$paint_u24lambda_u2d0.setAntiAlias(true);
        circularImageView.paint = paint;
        $this$paint_u24lambda_u2d0 = paint = new Paint();
        circularImageView = this;
        boolean bl2 = false;
        $this$paintBorder_u24lambda_u2d1.setAntiAlias(true);
        circularImageView.paintBorder = paint;
        $this$paintBorder_u24lambda_u2d1 = paint = new Paint();
        circularImageView = this;
        boolean bl3 = false;
        $this$paintShadow_u24lambda_u2d2.setAntiAlias(true);
        circularImageView.paintShadow = paint;
        $this$paintShadow_u24lambda_u2d2 = paint = new Paint();
        circularImageView = this;
        boolean bl4 = false;
        $this$paintBackground_u24lambda_u2d3.setAntiAlias(true);
        circularImageView.paintBackground = paint;
        this.circleColor = -1;
        this.circleColorDirection = GradientDirection.LEFT_TO_RIGHT;
        this.borderColor = -16777216;
        this.borderColorDirection = GradientDirection.LEFT_TO_RIGHT;
        this.shadowColor = -16777216;
        this.shadowGravity = ShadowGravity.BOTTOM;
        this.init(context, attrs, defStyleAttr);
    }

    public /* synthetic */ CircularImageView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final int getCircleColor() {
        return this.circleColor;
    }

    public final void setCircleColor(int value) {
        this.circleColor = value;
        this.manageCircleColor();
        this.invalidate();
    }

    @Nullable
    public final Integer getCircleColorStart() {
        return this.circleColorStart;
    }

    public final void setCircleColorStart(@Nullable Integer value) {
        this.circleColorStart = value;
        this.manageCircleColor();
        this.invalidate();
    }

    @Nullable
    public final Integer getCircleColorEnd() {
        return this.circleColorEnd;
    }

    public final void setCircleColorEnd(@Nullable Integer value) {
        this.circleColorEnd = value;
        this.manageCircleColor();
        this.invalidate();
    }

    @NotNull
    public final GradientDirection getCircleColorDirection() {
        return this.circleColorDirection;
    }

    public final void setCircleColorDirection(@NotNull GradientDirection value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.circleColorDirection = value;
        this.manageCircleColor();
        this.invalidate();
    }

    public final float getBorderWidth() {
        return this.borderWidth;
    }

    public final void setBorderWidth(float value) {
        this.borderWidth = value;
        this.update();
    }

    public final int getBorderColor() {
        return this.borderColor;
    }

    public final void setBorderColor(int value) {
        this.borderColor = value;
        this.manageBorderColor();
        this.invalidate();
    }

    @Nullable
    public final Integer getBorderColorStart() {
        return this.borderColorStart;
    }

    public final void setBorderColorStart(@Nullable Integer value) {
        this.borderColorStart = value;
        this.manageBorderColor();
        this.invalidate();
    }

    @Nullable
    public final Integer getBorderColorEnd() {
        return this.borderColorEnd;
    }

    public final void setBorderColorEnd(@Nullable Integer value) {
        this.borderColorEnd = value;
        this.manageBorderColor();
        this.invalidate();
    }

    @NotNull
    public final GradientDirection getBorderColorDirection() {
        return this.borderColorDirection;
    }

    public final void setBorderColorDirection(@NotNull GradientDirection value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.borderColorDirection = value;
        this.manageBorderColor();
        this.invalidate();
    }

    public final float getShadowRadius() {
        return this.shadowRadius;
    }

    public final void setShadowRadius(float value) {
        this.shadowRadius = value;
        this.setShadowEnable(this.shadowRadius > 0.0f);
    }

    public final int getShadowColor() {
        return this.shadowColor;
    }

    public final void setShadowColor(int value) {
        this.shadowColor = value;
        this.paintShadow.setColor(this.shadowColor);
        this.invalidate();
    }

    @NotNull
    public final ShadowGravity getShadowGravity() {
        return this.shadowGravity;
    }

    public final void setShadowGravity(@NotNull ShadowGravity value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.shadowGravity = value;
        this.invalidate();
    }

    public final boolean getShadowEnable() {
        return this.shadowEnable;
    }

    public final void setShadowEnable(boolean value) {
        this.shadowEnable = value;
        if (this.shadowEnable && this.shadowRadius == 0.0f) {
            this.setShadowRadius(8.0f * this.getResources().getDisplayMetrics().density);
        }
        this.update();
    }

    private final void setCivColorFilter(ColorFilter value) {
        if (!Intrinsics.areEqual((Object)this.civColorFilter, (Object)value)) {
            this.civColorFilter = value;
            if (this.civColorFilter != null) {
                this.civDrawable = null;
                this.invalidate();
            }
        }
    }

    private final void init(Context context, AttributeSet attrs, int defStyleAttr) {
        int n;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.CircularImageView, defStyleAttr, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026ageView, defStyleAttr, 0)");
        TypedArray attributes = typedArray;
        this.setCircleColor(attributes.getColor(R.styleable.CircularImageView_civ_circle_color, -1));
        int it = n = attributes.getColor(R.styleable.CircularImageView_civ_circle_color_start, 0);
        boolean bl = false;
        if (it != 0) {
            this.setCircleColorStart(it);
        }
        it = n = attributes.getColor(R.styleable.CircularImageView_civ_circle_color_end, 0);
        boolean bl2 = false;
        if (it != 0) {
            this.setCircleColorEnd(it);
        }
        this.setCircleColorDirection(this.toGradientDirection(attributes.getInteger(R.styleable.CircularImageView_civ_circle_color_direction, this.circleColorDirection.getValue())));
        if (attributes.getBoolean(R.styleable.CircularImageView_civ_border, true)) {
            int n2;
            float defaultBorderWidth = 4.0f * this.getResources().getDisplayMetrics().density;
            this.setBorderWidth(attributes.getDimension(R.styleable.CircularImageView_civ_border_width, defaultBorderWidth));
            this.setBorderColor(attributes.getColor(R.styleable.CircularImageView_civ_border_color, -1));
            int it2 = n2 = attributes.getColor(R.styleable.CircularImageView_civ_border_color_start, 0);
            boolean bl3 = false;
            if (it2 != 0) {
                this.setBorderColorStart(it2);
            }
            it2 = n2 = attributes.getColor(R.styleable.CircularImageView_civ_border_color_end, 0);
            boolean bl4 = false;
            if (it2 != 0) {
                this.setBorderColorEnd(it2);
            }
            this.setBorderColorDirection(this.toGradientDirection(attributes.getInteger(R.styleable.CircularImageView_civ_border_color_direction, this.borderColorDirection.getValue())));
        }
        this.setShadowEnable(attributes.getBoolean(R.styleable.CircularImageView_civ_shadow, this.shadowEnable));
        if (this.shadowEnable) {
            this.setShadowGravity(this.toShadowGravity(attributes.getInteger(R.styleable.CircularImageView_civ_shadow_gravity, this.shadowGravity.getValue())));
            float defaultShadowRadius = 8.0f * this.getResources().getDisplayMetrics().density;
            this.setShadowRadius(attributes.getDimension(R.styleable.CircularImageView_civ_shadow_radius, defaultShadowRadius));
            this.setShadowColor(attributes.getColor(R.styleable.CircularImageView_civ_shadow_color, this.shadowColor));
        }
        attributes.recycle();
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.setCivColorFilter(colorFilter);
    }

    @NotNull
    public ImageView.ScaleType getScaleType() {
        ImageView.ScaleType scaleType = super.getScaleType();
        if (scaleType == null) {
            scaleType = ImageView.ScaleType.CENTER_CROP;
        }
        return scaleType;
    }

    public void setScaleType(@NotNull ImageView.ScaleType scaleType) {
        Intrinsics.checkNotNullParameter((Object)scaleType, (String)"scaleType");
        Object[] objectArray = new ImageView.ScaleType[]{ImageView.ScaleType.CENTER_CROP, ImageView.ScaleType.CENTER_INSIDE, ImageView.ScaleType.FIT_CENTER};
        if (!CollectionsKt.listOf((Object[])objectArray).contains(scaleType)) {
            boolean bl = false;
            String string = "ScaleType " + scaleType + " not supported. Just ScaleType.CENTER_CROP, ScaleType.CENTER_INSIDE & ScaleType.FIT_CENTER are available for this library.";
            throw new IllegalArgumentException(string.toString());
        }
        super.setScaleType(scaleType);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        float margeWithShadowRadius;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this.loadBitmap();
        if (this.civImage == null) {
            return;
        }
        float circleCenterWithBorder = (float)this.circleCenter + this.borderWidth;
        float f = margeWithShadowRadius = this.shadowEnable ? this.shadowRadius * (float)2 : 0.0f;
        if (this.shadowEnable) {
            this.drawShadow();
            canvas.drawCircle(circleCenterWithBorder, circleCenterWithBorder, circleCenterWithBorder - margeWithShadowRadius, this.paintShadow);
        }
        canvas.drawCircle(circleCenterWithBorder, circleCenterWithBorder, circleCenterWithBorder - margeWithShadowRadius, this.paintBorder);
        canvas.drawCircle(circleCenterWithBorder, circleCenterWithBorder, (float)this.circleCenter - margeWithShadowRadius, this.paintBackground);
        canvas.drawCircle(circleCenterWithBorder, circleCenterWithBorder, (float)this.circleCenter - margeWithShadowRadius, this.paint);
    }

    private final void update() {
        if (this.civImage != null) {
            this.updateShader();
        }
        int usableWidth = this.getWidth() - (this.getPaddingLeft() + this.getPaddingRight());
        int usableHeight = this.getHeight() - (this.getPaddingTop() + this.getPaddingBottom());
        this.heightCircle = Math.min(usableWidth, usableHeight);
        this.circleCenter = (int)((float)this.heightCircle - this.borderWidth * (float)2) / 2;
        this.manageCircleColor();
        this.manageBorderColor();
        this.manageElevation();
        this.invalidate();
    }

    private final void manageCircleColor() {
        Integer n = this.circleColorStart;
        Integer n2 = this.circleColorEnd;
        this.paintBackground.setShader((Shader)this.createLinearGradient(n != null ? n : this.circleColor, n2 != null ? n2 : this.circleColor, this.circleColorDirection));
    }

    private final void manageBorderColor() {
        int borderColor = this.borderWidth == 0.0f ? this.circleColor : this.borderColor;
        Integer n = this.borderColorStart;
        Integer n2 = this.borderColorEnd;
        this.paintBorder.setShader((Shader)this.createLinearGradient(n != null ? n : borderColor, n2 != null ? n2 : borderColor, this.borderColorDirection));
    }

    private final LinearGradient createLinearGradient(int startColor, int endColor, GradientDirection gradientDirection) {
        float x0 = 0.0f;
        float y0 = 0.0f;
        float x1 = 0.0f;
        float y1 = 0.0f;
        switch (WhenMappings.$EnumSwitchMapping$0[gradientDirection.ordinal()]) {
            case 1: {
                x1 = this.getWidth();
                break;
            }
            case 2: {
                x0 = this.getWidth();
                break;
            }
            case 3: {
                y1 = this.getHeight();
                break;
            }
            case 4: {
                y0 = this.getHeight();
            }
        }
        return new LinearGradient(x0, y0, x1, y1, startColor, endColor, Shader.TileMode.CLAMP);
    }

    private final void manageElevation() {
        if (Build.VERSION.SDK_INT >= 21) {
            this.setOutlineProvider(!this.shadowEnable ? (ViewOutlineProvider)new ViewOutlineProvider(this){
                final /* synthetic */ CircularImageView this$0;
                {
                    this.this$0 = $receiver;
                }

                public void getOutline(@Nullable View view, @Nullable Outline outline) {
                    block0: {
                        Outline outline2 = outline;
                        if (outline2 == null) break block0;
                        outline2.setOval(0, 0, CircularImageView.access$getHeightCircle$p(this.this$0), CircularImageView.access$getHeightCircle$p(this.this$0));
                    }
                }
            } : (ViewOutlineProvider)null);
        }
    }

    private final void loadBitmap() {
        if (Intrinsics.areEqual((Object)this.civDrawable, (Object)this.getDrawable())) {
            return;
        }
        this.civDrawable = this.getDrawable();
        this.civImage = this.drawableToBitmap(this.civDrawable);
        this.updateShader();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.update();
    }

    private final void drawShadow() {
        if (Build.VERSION.SDK_INT < 28) {
            this.setLayerType(1, this.paintShadow);
        }
        float dx = 0.0f;
        float dy = 0.0f;
        switch (WhenMappings.$EnumSwitchMapping$1[this.shadowGravity.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                dy = -this.shadowRadius / (float)2;
                break;
            }
            case 3: {
                dy = this.shadowRadius / (float)2;
                break;
            }
            case 4: {
                dx = -this.shadowRadius / (float)2;
                break;
            }
            case 5: {
                dx = this.shadowRadius / (float)2;
            }
        }
        this.paintShadow.setShadowLayer(this.shadowRadius, dx, dy, this.shadowColor);
    }

    private final void updateShader() {
        block5: {
            Matrix matrix;
            Bitmap bitmap;
            Bitmap bitmap2 = this.civImage;
            if (bitmap2 == null) break block5;
            Bitmap it = bitmap = bitmap2;
            boolean bl = false;
            BitmapShader shader = new BitmapShader(it, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            switch (WhenMappings.$EnumSwitchMapping$2[this.getScaleType().ordinal()]) {
                case 1: {
                    matrix = this.centerCrop(it, this.heightCircle);
                    break;
                }
                case 2: {
                    matrix = this.centerInside(it, this.heightCircle);
                    break;
                }
                case 3: {
                    matrix = this.fitCenter(it, this.heightCircle);
                    break;
                }
                default: {
                    matrix = new Matrix();
                }
            }
            shader.setLocalMatrix(matrix);
            this.paint.setShader((Shader)shader);
            this.paint.setColorFilter(this.civColorFilter);
        }
    }

    private final Matrix centerCrop(Bitmap bitmap, int viewSize) {
        Matrix matrix;
        Matrix $this$centerCrop_u24lambda_u2d10 = matrix = new Matrix();
        boolean bl = false;
        float scale = 0.0f;
        float dx = 0.0f;
        float dy = 0.0f;
        if (bitmap.getWidth() * viewSize > bitmap.getHeight() * viewSize) {
            scale = (float)viewSize / (float)bitmap.getHeight();
            dx = ((float)viewSize - (float)bitmap.getWidth() * scale) * 0.5f;
            dy = 0.0f;
        } else {
            scale = (float)viewSize / (float)bitmap.getWidth();
            dx = 0.0f;
            dy = ((float)viewSize - (float)bitmap.getHeight() * scale) * 0.5f;
        }
        $this$centerCrop_u24lambda_u2d10.setScale(scale, scale);
        $this$centerCrop_u24lambda_u2d10.postTranslate(dx, dy);
        return matrix;
    }

    private final Matrix centerInside(Bitmap bitmap, int viewSize) {
        Matrix matrix;
        Matrix $this$centerInside_u24lambda_u2d11 = matrix = new Matrix();
        boolean bl = false;
        float scale = bitmap.getWidth() <= viewSize && bitmap.getHeight() <= viewSize ? 1.0f : RangesKt.coerceAtMost((float)((float)viewSize / (float)bitmap.getWidth()), (float)((float)viewSize / (float)bitmap.getHeight()));
        float dx = MathKt.roundToInt((float)(((float)viewSize - (float)bitmap.getWidth() * scale) * 0.5f));
        float dy = MathKt.roundToInt((float)(((float)viewSize - (float)bitmap.getHeight() * scale) * 0.5f));
        $this$centerInside_u24lambda_u2d11.setScale(scale, scale);
        $this$centerInside_u24lambda_u2d11.postTranslate(dx, dy);
        return matrix;
    }

    /*
     * WARNING - void declaration
     */
    private final Matrix fitCenter(Bitmap bitmap, int viewSize) {
        void $this$fitCenter_u24lambda_u2d14_u24lambda_u2d13;
        RectF $this$fitCenter_u24lambda_u2d14_u24lambda_u2d12;
        RectF rectF;
        Matrix matrix;
        Matrix $this$fitCenter_u24lambda_u2d14 = matrix = new Matrix();
        boolean bl = false;
        RectF rectF2 = rectF = new RectF();
        Matrix matrix2 = $this$fitCenter_u24lambda_u2d14;
        boolean bl2 = false;
        $this$fitCenter_u24lambda_u2d14_u24lambda_u2d12.set(0.0f, 0.0f, (float)bitmap.getWidth(), (float)bitmap.getHeight());
        RectF rectF3 = rectF;
        $this$fitCenter_u24lambda_u2d14_u24lambda_u2d12 = rectF = new RectF();
        RectF rectF4 = rectF3;
        boolean bl3 = false;
        $this$fitCenter_u24lambda_u2d14_u24lambda_u2d13.set(0.0f, 0.0f, (float)viewSize, (float)viewSize);
        Unit unit = Unit.INSTANCE;
        matrix2.setRectToRect(rectF4, rectF, Matrix.ScaleToFit.CENTER);
        return matrix;
    }

    private final Bitmap drawableToBitmap(Drawable drawable) {
        Bitmap bitmap;
        Drawable drawable2 = drawable;
        if (drawable2 != null) {
            Drawable it = drawable2;
            boolean bl = false;
            bitmap = Build.VERSION.SDK_INT >= 21 && drawable instanceof VectorDrawable ? this.vectorDrawableToBitmap((VectorDrawable)drawable) : (drawable instanceof BitmapDrawable ? this.bitmapDrawableToBitmap((BitmapDrawable)drawable) : this.toBitmap(drawable));
        } else {
            bitmap = null;
        }
        return bitmap;
    }

    private final Bitmap vectorDrawableToBitmap(VectorDrawable $this$vectorDrawableToBitmap) {
        Bitmap bitmap = Bitmap.createBitmap((int)(this.getScaleType() == ImageView.ScaleType.CENTER_INSIDE ? $this$vectorDrawableToBitmap.getIntrinsicWidth() : this.getWidth()), (int)(this.getScaleType() == ImageView.ScaleType.CENTER_INSIDE ? $this$vectorDrawableToBitmap.getIntrinsicHeight() : this.getHeight()), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        $this$vectorDrawableToBitmap.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        $this$vectorDrawableToBitmap.draw(canvas);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bitmap");
        return bitmap;
    }

    private final Bitmap bitmapDrawableToBitmap(BitmapDrawable $this$bitmapDrawableToBitmap) {
        Bitmap it = $this$bitmapDrawableToBitmap.getBitmap();
        boolean bl = false;
        Bitmap bitmap = Bitmap.createScaledBitmap((Bitmap)it, (int)$this$bitmapDrawableToBitmap.getIntrinsicWidth(), (int)$this$bitmapDrawableToBitmap.getIntrinsicHeight(), (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bitmap.let {\n           \u2026e\n            )\n        }");
        return bitmap;
    }

    private final Bitmap toBitmap(Drawable $this$toBitmap) {
        Bitmap bitmap;
        try {
            Bitmap bitmap2 = Bitmap.createBitmap((int)$this$toBitmap.getIntrinsicWidth(), (int)$this$toBitmap.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap2);
            $this$toBitmap.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            $this$toBitmap.draw(canvas);
        }
        catch (Exception e) {
            e.printStackTrace();
            bitmap = null;
        }
        return bitmap;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int usableWidth = this.measure(widthMeasureSpec) - (this.getPaddingLeft() + this.getPaddingRight());
        int usableHeight = this.measure(heightMeasureSpec) - (this.getPaddingTop() + this.getPaddingBottom());
        this.heightCircle = Math.min(usableWidth, usableHeight);
        this.setMeasuredDimension(this.heightCircle, this.heightCircle);
    }

    private final int measure(int measureSpec) {
        int n;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        switch (specMode) {
            case 0x40000000: {
                n = specSize;
                break;
            }
            case -2147483648: {
                n = specSize;
                break;
            }
            default: {
                n = this.heightCircle;
            }
        }
        return n;
    }

    private final ShadowGravity toShadowGravity(int $this$toShadowGravity) {
        ShadowGravity shadowGravity;
        switch ($this$toShadowGravity) {
            case 1: {
                shadowGravity = ShadowGravity.CENTER;
                break;
            }
            case 2: {
                shadowGravity = ShadowGravity.TOP;
                break;
            }
            case 3: {
                shadowGravity = ShadowGravity.BOTTOM;
                break;
            }
            case 4: {
                shadowGravity = ShadowGravity.START;
                break;
            }
            case 5: {
                shadowGravity = ShadowGravity.END;
                break;
            }
            default: {
                throw new IllegalArgumentException("This value is not supported for ShadowGravity: " + $this$toShadowGravity);
            }
        }
        return shadowGravity;
    }

    private final GradientDirection toGradientDirection(int $this$toGradientDirection) {
        GradientDirection gradientDirection;
        switch ($this$toGradientDirection) {
            case 1: {
                gradientDirection = GradientDirection.LEFT_TO_RIGHT;
                break;
            }
            case 2: {
                gradientDirection = GradientDirection.RIGHT_TO_LEFT;
                break;
            }
            case 3: {
                gradientDirection = GradientDirection.TOP_TO_BOTTOM;
                break;
            }
            case 4: {
                gradientDirection = GradientDirection.BOTTOM_TO_TOP;
                break;
            }
            default: {
                throw new IllegalArgumentException("This value is not supported for GradientDirection: " + $this$toGradientDirection);
            }
        }
        return gradientDirection;
    }

    @JvmOverloads
    public CircularImageView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public CircularImageView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ int access$getHeightCircle$p(CircularImageView $this) {
        return $this.heightCircle;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/mikhaellopez/circularimageview/CircularImageView$Companion;", "", "()V", "DEFAULT_BORDER_WIDTH", "", "DEFAULT_SHADOW_RADIUS", "circularimageview_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/mikhaellopez/circularimageview/CircularImageView$ShadowGravity;", "", "value", "", "(Ljava/lang/String;II)V", "getValue", "()I", "CENTER", "TOP", "BOTTOM", "START", "END", "circularimageview_release"})
    public static final class ShadowGravity
    extends Enum<ShadowGravity> {
        private final int value;
        public static final /* enum */ ShadowGravity CENTER = new ShadowGravity(1);
        public static final /* enum */ ShadowGravity TOP = new ShadowGravity(2);
        public static final /* enum */ ShadowGravity BOTTOM = new ShadowGravity(3);
        public static final /* enum */ ShadowGravity START = new ShadowGravity(4);
        public static final /* enum */ ShadowGravity END = new ShadowGravity(5);
        private static final /* synthetic */ ShadowGravity[] $VALUES;

        private ShadowGravity(int value) {
            this.value = value;
        }

        public final int getValue() {
            return this.value;
        }

        public static ShadowGravity[] values() {
            return (ShadowGravity[])$VALUES.clone();
        }

        public static ShadowGravity valueOf(String value) {
            return Enum.valueOf(ShadowGravity.class, value);
        }

        static {
            $VALUES = shadowGravityArray = new ShadowGravity[]{ShadowGravity.CENTER, ShadowGravity.TOP, ShadowGravity.BOTTOM, ShadowGravity.START, ShadowGravity.END};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/mikhaellopez/circularimageview/CircularImageView$GradientDirection;", "", "value", "", "(Ljava/lang/String;II)V", "getValue", "()I", "LEFT_TO_RIGHT", "RIGHT_TO_LEFT", "TOP_TO_BOTTOM", "BOTTOM_TO_TOP", "circularimageview_release"})
    public static final class GradientDirection
    extends Enum<GradientDirection> {
        private final int value;
        public static final /* enum */ GradientDirection LEFT_TO_RIGHT = new GradientDirection(1);
        public static final /* enum */ GradientDirection RIGHT_TO_LEFT = new GradientDirection(2);
        public static final /* enum */ GradientDirection TOP_TO_BOTTOM = new GradientDirection(3);
        public static final /* enum */ GradientDirection BOTTOM_TO_TOP = new GradientDirection(4);
        private static final /* synthetic */ GradientDirection[] $VALUES;

        private GradientDirection(int value) {
            this.value = value;
        }

        public final int getValue() {
            return this.value;
        }

        public static GradientDirection[] values() {
            return (GradientDirection[])$VALUES.clone();
        }

        public static GradientDirection valueOf(String value) {
            return Enum.valueOf(GradientDirection.class, value);
        }

        static {
            $VALUES = gradientDirectionArray = new GradientDirection[]{GradientDirection.LEFT_TO_RIGHT, GradientDirection.RIGHT_TO_LEFT, GradientDirection.TOP_TO_BOTTOM, GradientDirection.BOTTOM_TO_TOP};
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[GradientDirection.values().length];
            nArray[GradientDirection.LEFT_TO_RIGHT.ordinal()] = 1;
            nArray[GradientDirection.RIGHT_TO_LEFT.ordinal()] = 2;
            nArray[GradientDirection.TOP_TO_BOTTOM.ordinal()] = 3;
            nArray[GradientDirection.BOTTOM_TO_TOP.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ShadowGravity.values().length];
            nArray[ShadowGravity.CENTER.ordinal()] = 1;
            nArray[ShadowGravity.TOP.ordinal()] = 2;
            nArray[ShadowGravity.BOTTOM.ordinal()] = 3;
            nArray[ShadowGravity.START.ordinal()] = 4;
            nArray[ShadowGravity.END.ordinal()] = 5;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[ImageView.ScaleType.values().length];
            nArray[ImageView.ScaleType.CENTER_CROP.ordinal()] = 1;
            nArray[ImageView.ScaleType.CENTER_INSIDE.ordinal()] = 2;
            nArray[ImageView.ScaleType.FIT_CENTER.ordinal()] = 3;
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

