/*
 * Decompiled with CFR 0.152.
 */
package com.mikhaellopez.circularimageview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import com.mikhaellopez.circularimageview.R;

public class CircularImageView
extends ImageView {
    private static final ImageView.ScaleType SCALE_TYPE = ImageView.ScaleType.CENTER_CROP;
    private static final float DEFAULT_BORDER_WIDTH = 4.0f;
    private static final float DEFAULT_SHADOW_RADIUS = 8.0f;
    private float borderWidth;
    private int canvasSize;
    private float shadowRadius;
    private int shadowColor = -16777216;
    private Bitmap image;
    private Drawable drawable;
    private Paint paint;
    private Paint paintBorder;

    public CircularImageView(Context context) {
        this(context, null);
    }

    public CircularImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircularImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.paintBorder = new Paint();
        this.paintBorder.setAntiAlias(true);
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.CircularImageView, defStyleAttr, 0);
        if (attributes.getBoolean(R.styleable.CircularImageView_civ_border, true)) {
            float defaultBorderSize = 4.0f * this.getContext().getResources().getDisplayMetrics().density;
            this.setBorderWidth(attributes.getDimension(R.styleable.CircularImageView_civ_border_width, defaultBorderSize));
            this.setBorderColor(attributes.getColor(R.styleable.CircularImageView_civ_border_color, -1));
        }
        if (attributes.getBoolean(R.styleable.CircularImageView_civ_shadow, false)) {
            this.shadowRadius = 8.0f;
            this.drawShadow(attributes.getFloat(R.styleable.CircularImageView_civ_shadow_radius, this.shadowRadius), attributes.getColor(R.styleable.CircularImageView_civ_shadow_color, this.shadowColor));
        }
    }

    public void setBorderWidth(float borderWidth) {
        this.borderWidth = borderWidth;
        this.requestLayout();
        this.invalidate();
    }

    public void setBorderColor(int borderColor) {
        if (this.paintBorder != null) {
            this.paintBorder.setColor(borderColor);
        }
        this.invalidate();
    }

    public void addShadow() {
        if (this.shadowRadius == 0.0f) {
            this.shadowRadius = 8.0f;
        }
        this.drawShadow(this.shadowRadius, this.shadowColor);
        this.invalidate();
    }

    public void setShadowRadius(float shadowRadius) {
        this.drawShadow(shadowRadius, this.shadowColor);
        this.invalidate();
    }

    public void setShadowColor(int shadowColor) {
        this.drawShadow(this.shadowRadius, shadowColor);
        this.invalidate();
    }

    public ImageView.ScaleType getScaleType() {
        return SCALE_TYPE;
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        if (scaleType != SCALE_TYPE) {
            throw new IllegalArgumentException(String.format("ScaleType %s not supported. ScaleType.CENTER_CROP is used by default. So you don't need to use ScaleType.", scaleType));
        }
    }

    public void onDraw(Canvas canvas) {
        this.loadBitmap();
        if (this.image == null) {
            return;
        }
        if (!this.isInEditMode()) {
            this.canvasSize = canvas.getWidth();
            if (canvas.getHeight() < this.canvasSize) {
                this.canvasSize = canvas.getHeight();
            }
        }
        int circleCenter = (int)((float)this.canvasSize - this.borderWidth * 2.0f) / 2;
        canvas.drawCircle((float)circleCenter + this.borderWidth, (float)circleCenter + this.borderWidth, (float)circleCenter + this.borderWidth - (this.shadowRadius + this.shadowRadius / 2.0f), this.paintBorder);
        canvas.drawCircle((float)circleCenter + this.borderWidth, (float)circleCenter + this.borderWidth, (float)circleCenter - (this.shadowRadius + this.shadowRadius / 2.0f), this.paint);
    }

    private void loadBitmap() {
        if (this.drawable == this.getDrawable()) {
            return;
        }
        this.drawable = this.getDrawable();
        this.image = this.drawableToBitmap(this.drawable);
        this.updateShader();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.canvasSize = w;
        if (h < this.canvasSize) {
            this.canvasSize = h;
        }
        if (this.image != null) {
            this.updateShader();
        }
    }

    private void drawShadow(float shadowRadius, int shadowColor) {
        this.shadowRadius = shadowRadius;
        this.shadowColor = shadowColor;
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, this.paintBorder);
        }
        this.paintBorder.setShadowLayer(shadowRadius, 0.0f, shadowRadius / 2.0f, shadowColor);
    }

    private void updateShader() {
        if (this.image == null) {
            return;
        }
        this.image = this.cropBitmap(this.image);
        BitmapShader shader = new BitmapShader(this.image, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        Matrix matrix = new Matrix();
        matrix.setScale((float)this.canvasSize / (float)this.image.getWidth(), (float)this.canvasSize / (float)this.image.getHeight());
        shader.setLocalMatrix(matrix);
        this.paint.setShader((Shader)shader);
    }

    private Bitmap cropBitmap(Bitmap bitmap) {
        Bitmap bmp = bitmap.getWidth() >= bitmap.getHeight() ? Bitmap.createBitmap((Bitmap)bitmap, (int)(bitmap.getWidth() / 2 - bitmap.getHeight() / 2), (int)0, (int)bitmap.getHeight(), (int)bitmap.getHeight()) : Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)(bitmap.getHeight() / 2 - bitmap.getWidth() / 2), (int)bitmap.getWidth(), (int)bitmap.getWidth());
        return bmp;
    }

    private Bitmap drawableToBitmap(Drawable drawable) {
        if (drawable == null) {
            return null;
        }
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        int intrinsicWidth = drawable.getIntrinsicWidth();
        int intrinsicHeight = drawable.getIntrinsicHeight();
        if (intrinsicWidth <= 0 || intrinsicHeight <= 0) {
            return null;
        }
        try {
            Bitmap bitmap = Bitmap.createBitmap((int)intrinsicWidth, (int)intrinsicHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable.draw(canvas);
            return bitmap;
        }
        catch (OutOfMemoryError e) {
            Log.e((String)((Object)((Object)this)).getClass().toString(), (String)"Encountered OutOfMemoryError while generating bitmap!");
            return null;
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = this.measureWidth(widthMeasureSpec);
        int height = this.measureHeight(heightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    private int measureWidth(int measureSpec) {
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        int result = specMode == 0x40000000 ? specSize : (specMode == Integer.MIN_VALUE ? specSize : this.canvasSize);
        return result;
    }

    private int measureHeight(int measureSpecHeight) {
        int specMode = View.MeasureSpec.getMode((int)measureSpecHeight);
        int specSize = View.MeasureSpec.getSize((int)measureSpecHeight);
        int result = specMode == 0x40000000 ? specSize : (specMode == Integer.MIN_VALUE ? specSize : this.canvasSize);
        return result + 2;
    }
}

