/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.utils;

import android.support.annotation.Nullable;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.utils.DefaultItemListImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ComparableItemListImpl<Item extends IItem>
extends DefaultItemListImpl<Item> {
    private Comparator<Item> mComparator;

    public ComparableItemListImpl(@Nullable Comparator<Item> comparator) {
        this.mItems = new ArrayList();
        this.mComparator = comparator;
    }

    public ComparableItemListImpl(@Nullable Comparator<Item> comparator, List<Item> items) {
        this.mItems = items;
        this.mComparator = comparator;
    }

    public Comparator<Item> getComparator() {
        return this.mComparator;
    }

    public ComparableItemListImpl<Item> withComparator(@Nullable Comparator<Item> comparator) {
        return this.withComparator(comparator, true);
    }

    public ComparableItemListImpl<Item> withComparator(@Nullable Comparator<Item> comparator, boolean sortNow) {
        this.mComparator = comparator;
        if (this.mItems != null && this.mComparator != null && sortNow) {
            Collections.sort(this.mItems, this.mComparator);
            this.getFastAdapter().notifyAdapterDataSetChanged();
        }
        return this;
    }

    @Override
    public void move(int fromPosition, int toPosition, int preItemCount) {
        IItem item = (IItem)this.mItems.get(fromPosition - preItemCount);
        this.mItems.remove(fromPosition - preItemCount);
        this.mItems.add(toPosition - preItemCount, item);
        if (this.mComparator != null) {
            Collections.sort(this.mItems, this.mComparator);
        }
        this.getFastAdapter().notifyAdapterDataSetChanged();
    }

    @Override
    public void addAll(List<Item> items, int preItemCount) {
        this.mItems.addAll(items);
        if (this.mComparator != null) {
            Collections.sort(this.mItems, this.mComparator);
        }
        this.getFastAdapter().notifyAdapterDataSetChanged();
    }

    @Override
    public void addAll(int position, List<Item> items, int preItemCount) {
        this.mItems.addAll(position - preItemCount, items);
        if (this.mComparator != null) {
            Collections.sort(this.mItems, this.mComparator);
        }
        this.getFastAdapter().notifyAdapterDataSetChanged();
    }

    @Override
    public void setNewList(List<Item> items, boolean notify) {
        this.mItems = new ArrayList<Item>(items);
        if (this.mComparator != null) {
            Collections.sort(this.mItems, this.mComparator);
        }
        if (notify) {
            this.getFastAdapter().notifyAdapterDataSetChanged();
        }
    }
}

