/*
 * Decompiled with CFR 0.152.
 */
package com.midtrans.sdk.corekit.utilities;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.support.annotation.NonNull;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import com.midtrans.sdk.corekit.core.Logger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class Utils {
    public static final String CARD_TYPE_VISA = "VISA";
    public static final String CARD_TYPE_MASTERCARD = "MASTERCARD";
    public static final String CARD_TYPE_AMEX = "AMEX";
    public static final String CARD_TYPE_JCB = "JCB";
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;

    public static boolean isNetworkAvailable(Context context) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivityManager.getActiveNetworkInfo() != null && connectivityManager.getActiveNetworkInfo().isAvailable() && connectivityManager.getActiveNetworkInfo().isConnected()) {
                return true;
            }
        }
        catch (Exception exception) {
            Logger.e(exception.getMessage());
            return false;
        }
        return false;
    }

    public static void hideKeyboard(Context context, View view) {
        try {
            InputMethodManager inputMethodManager = (InputMethodManager)context.getSystemService("input_method");
            if (view != null) {
                inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
                view.clearFocus();
            }
        }
        catch (Exception exception) {
            Logger.e(exception.getMessage());
        }
    }

    public static String getFormattedAmount(double d2) {
        try {
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.US);
            decimalFormatSymbols.setDecimalSeparator('.');
            decimalFormatSymbols.setGroupingSeparator(',');
            String string2 = new DecimalFormat("#,###", decimalFormatSymbols).format(d2);
            return string2;
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            return "" + d2;
        }
    }

    public static String getValidityTime(String string2) {
        String[] stringArray;
        if (string2 != null && (stringArray = string2.split(" ")).length > 1) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(simpleDateFormat.parse(stringArray[0]));
                calendar.add(5, 1);
                String string3 = simpleDateFormat.format(calendar.getTime());
                String[] stringArray2 = string3.split("-");
                String string4 = Utils.getMonth(Integer.parseInt(stringArray2[1]));
                String string5 = "" + stringArray2[2] + " " + string4 + " " + stringArray2[0] + ", " + stringArray[1];
                Logger.i("after parsing validity date becomes : " + string3);
                Logger.i("month is : " + string4);
                Logger.i("validity time is : " + string5);
                return string5;
            }
            catch (ParseException parseException) {
                Logger.e("Error while parsing date : " + parseException.getMessage());
            }
        }
        return string2;
    }

    public static String getMonth(int n) {
        switch (n) {
            case 1: {
                return "January";
            }
            case 2: {
                return "February";
            }
            case 3: {
                return "March";
            }
            case 4: {
                return "April";
            }
            case 5: {
                return "May";
            }
            case 6: {
                return "June";
            }
            case 7: {
                return "July";
            }
            case 8: {
                return "August";
            }
            case 9: {
                return "September";
            }
            case 10: {
                return "October";
            }
            case 11: {
                return "November";
            }
            case 12: {
                return "December";
            }
        }
        return "Invalid Month";
    }

    public static int dpToPx(int n) {
        return (int)((float)n * Resources.getSystem().getDisplayMetrics().density);
    }

    public static String getFormattedCreditCardNumber(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string2.length() == 16) {
            for (int i = 0; i < 16; i += 4) {
                stringBuilder.append(string2.substring(i, i + 4));
                stringBuilder.append(" ");
            }
        }
        return stringBuilder.toString();
    }

    public static String getCardType(@NonNull String string2) {
        try {
            if (string2.isEmpty()) {
                return "";
            }
            if (string2.charAt(0) == '4') {
                return CARD_TYPE_VISA;
            }
            if (string2.charAt(0) == '5' && (string2.charAt(1) == '1' || string2.charAt(1) == '2' || string2.charAt(1) == '3' || string2.charAt(1) == '4' || string2.charAt(1) == '5')) {
                return CARD_TYPE_MASTERCARD;
            }
            if (string2.charAt(0) == '3' && (string2.charAt(1) == '4' || string2.charAt(1) == '7')) {
                return CARD_TYPE_AMEX;
            }
            if (string2.startsWith("35") || string2.startsWith("2131") || string2.startsWith("1800")) {
                return CARD_TYPE_JCB;
            }
            return "";
        }
        catch (RuntimeException runtimeException) {
            return "";
        }
    }

    public static String getFormattedTime(long l) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("Asia/Jakarta"));
        String string2 = simpleDateFormat.format(new Date(l));
        return string2;
    }

    public static String formatDouble(double d2) {
        String string2 = "0";
        try {
            string2 = d2 == (double)((long)d2) ? String.format("%d", (long)d2) : String.format("%s", d2);
        }
        catch (RuntimeException runtimeException) {
            Logger.e("formatDouble():" + runtimeException.getMessage());
        }
        return string2;
    }

    public static String getDeviceType(Activity activity) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        float f2 = (float)displayMetrics.heightPixels / displayMetrics.ydpi;
        float f3 = (float)displayMetrics.widthPixels / displayMetrics.xdpi;
        double d2 = Math.sqrt(f3 * f3 + f2 * f2);
        String string2 = d2 >= 6.5 ? "TABLET" : "PHONE";
        return string2;
    }
}

