/*
 * Decompiled with CFR 0.152.
 */
package com.midtrans.sdk.corekit.core;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.midtrans.sdk.corekit.core.Logger;
import com.midtrans.sdk.corekit.models.BcaBankTransferRequestModel;
import com.midtrans.sdk.corekit.models.BillInfoModel;
import com.midtrans.sdk.corekit.models.BillingAddress;
import com.midtrans.sdk.corekit.models.CustomerDetails;
import com.midtrans.sdk.corekit.models.ExpiryModel;
import com.midtrans.sdk.corekit.models.ItemDetails;
import com.midtrans.sdk.corekit.models.ShippingAddress;
import com.midtrans.sdk.corekit.models.snap.BankTransferRequestModel;
import com.midtrans.sdk.corekit.models.snap.CreditCard;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TransactionRequest {
    protected int paymentMethod = -1;
    private String orderId = null;
    private long amount = 0L;
    private boolean isSecureCard = true;
    private String cardClickType;
    private boolean promoEnabled;
    private List<String> promoCodes;
    private BillInfoModel billInfoModel = null;
    private ArrayList<ItemDetails> itemDetails = new ArrayList();
    private ArrayList<BillingAddress> mBillingAddressArrayList = new ArrayList();
    private ArrayList<ShippingAddress> mShippingAddressArrayList = new ArrayList();
    private CustomerDetails mCustomerDetails = null;
    private boolean useUi = true;
    private CreditCard creditCard;
    private Map<String, String> customObject;
    private ExpiryModel expiry;
    private String customField1;
    private String customField2;
    private String customField3;
    private BankTransferRequestModel permataVa;
    private BcaBankTransferRequestModel bcaVa;
    private BankTransferRequestModel bniVa;
    private List<String> enabledPayments;

    public TransactionRequest(String string2, long l, int n) {
        if (!TextUtils.isEmpty((CharSequence)string2) && l > 0L) {
            this.orderId = string2;
            this.amount = l;
            this.paymentMethod = n;
        } else {
            Logger.e("Invalid transaction data.");
        }
    }

    public TransactionRequest(String string2, long l) {
        if (!TextUtils.isEmpty((CharSequence)string2) && l > 0L) {
            this.orderId = string2;
            this.amount = l;
            this.paymentMethod = -1;
        } else {
            Logger.e("Invalid transaction data.");
        }
    }

    public CustomerDetails getCustomerDetails() {
        return this.mCustomerDetails;
    }

    public void setCustomerDetails(@NonNull CustomerDetails customerDetails) {
        this.mCustomerDetails = this.sanitizeCustomerDetails(customerDetails);
    }

    private CustomerDetails sanitizeCustomerDetails(CustomerDetails customerDetails) {
        if (customerDetails != null) {
            if (TextUtils.isEmpty((CharSequence)customerDetails.getFirstName())) {
                customerDetails.setFirstName(null);
            }
            if (TextUtils.isEmpty((CharSequence)customerDetails.getLastName())) {
                customerDetails.setLastName(null);
            }
            if (TextUtils.isEmpty((CharSequence)customerDetails.getEmail())) {
                customerDetails.setEmail(null);
            }
            if (TextUtils.isEmpty((CharSequence)customerDetails.getPhone())) {
                customerDetails.setPhone(null);
            }
            this.sanitizeBillingAddress(customerDetails.getBillingAddress());
            this.sanitizeShippingAddress(customerDetails.getShippingAddress());
        }
        return customerDetails;
    }

    private void sanitizeBillingAddress(BillingAddress billingAddress) {
        if (billingAddress != null) {
            if (TextUtils.isEmpty((CharSequence)billingAddress.getAddress())) {
                billingAddress.setAddress(null);
            }
            if (TextUtils.isEmpty((CharSequence)billingAddress.getFirstName())) {
                billingAddress.setFirstName(null);
            }
            if (TextUtils.isEmpty((CharSequence)billingAddress.getLastName())) {
                billingAddress.setLastName(null);
            }
            if (TextUtils.isEmpty((CharSequence)billingAddress.getCity())) {
                billingAddress.setCity(null);
            }
            if (TextUtils.isEmpty((CharSequence)billingAddress.getPostalCode())) {
                billingAddress.setPostalCode(null);
            }
            if (TextUtils.isEmpty((CharSequence)billingAddress.getPhone())) {
                billingAddress.setPhone(null);
            }
            if (TextUtils.isEmpty((CharSequence)billingAddress.getCountryCode())) {
                billingAddress.setCountryCode(null);
            }
        }
    }

    private void sanitizeShippingAddress(ShippingAddress shippingAddress) {
        if (shippingAddress != null) {
            if (TextUtils.isEmpty((CharSequence)shippingAddress.getAddress())) {
                shippingAddress.setAddress(null);
            }
            if (TextUtils.isEmpty((CharSequence)shippingAddress.getFirstName())) {
                shippingAddress.setFirstName(null);
            }
            if (TextUtils.isEmpty((CharSequence)shippingAddress.getLastName())) {
                shippingAddress.setLastName(null);
            }
            if (TextUtils.isEmpty((CharSequence)shippingAddress.getCity())) {
                shippingAddress.setCity(null);
            }
            if (TextUtils.isEmpty((CharSequence)shippingAddress.getPostalCode())) {
                shippingAddress.setPostalCode(null);
            }
            if (TextUtils.isEmpty((CharSequence)shippingAddress.getPhone())) {
                shippingAddress.setPhone(null);
            }
            if (TextUtils.isEmpty((CharSequence)shippingAddress.getCountryCode())) {
                shippingAddress.setCountryCode(null);
            }
        }
    }

    public ArrayList<BillingAddress> getBillingAddressArrayList() {
        return this.mBillingAddressArrayList;
    }

    public void setBillingAddressArrayList(@NonNull ArrayList<BillingAddress> arrayList) {
        this.mBillingAddressArrayList = arrayList;
    }

    public ArrayList<ShippingAddress> getShippingAddressArrayList() {
        return this.mShippingAddressArrayList;
    }

    public void setShippingAddressArrayList(@NonNull ArrayList<ShippingAddress> arrayList) {
        this.mShippingAddressArrayList = arrayList;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public long getAmount() {
        return this.amount;
    }

    public int getPaymentMethod() {
        return this.paymentMethod;
    }

    public boolean isSecureCard() {
        return this.isSecureCard;
    }

    public String getCardClickType() {
        return this.cardClickType;
    }

    public BillInfoModel getBillInfoModel() {
        return this.billInfoModel;
    }

    public void setBillInfoModel(BillInfoModel billInfoModel) {
        this.billInfoModel = billInfoModel;
    }

    public ArrayList<ItemDetails> getItemDetails() {
        return this.itemDetails;
    }

    public void setItemDetails(ArrayList<ItemDetails> arrayList) {
        this.itemDetails = arrayList;
    }

    protected void enableUi(boolean bl) {
        this.useUi = bl;
    }

    protected boolean isUiEnabled() {
        return this.useUi;
    }

    @Deprecated
    public void setCardPaymentInfo(String string2, boolean bl) {
        Logger.i("clicktype:" + string2 + ",isSecured:" + bl);
        this.cardClickType = string2;
        this.isSecureCard = bl;
    }

    public CreditCard getCreditCard() {
        return this.creditCard;
    }

    public void setCreditCard(CreditCard creditCard) {
        this.creditCard = creditCard;
    }

    public ExpiryModel getExpiry() {
        return this.expiry;
    }

    public void setExpiry(ExpiryModel expiryModel) {
        this.expiry = expiryModel;
    }

    public List<String> getPromoCodes() {
        return this.promoCodes;
    }

    public void setPromoCodes(List<String> list) {
        this.promoCodes = list;
    }

    public boolean isPromoEnabled() {
        return this.promoEnabled;
    }

    public void setPromoEnabled(boolean bl) {
        this.promoEnabled = bl;
    }

    public String getCustomField1() {
        return this.customField1;
    }

    public void setCustomField1(String string2) {
        this.customField1 = string2;
    }

    public String getCustomField2() {
        return this.customField2;
    }

    public void setCustomField2(String string2) {
        this.customField2 = string2;
    }

    public String getCustomField3() {
        return this.customField3;
    }

    public void setCustomField3(String string2) {
        this.customField3 = string2;
    }

    public BankTransferRequestModel getPermataVa() {
        return this.permataVa;
    }

    public void setPermataVa(BankTransferRequestModel bankTransferRequestModel) {
        this.permataVa = bankTransferRequestModel;
    }

    public BcaBankTransferRequestModel getBcaVa() {
        return this.bcaVa;
    }

    public void setBcaVa(BcaBankTransferRequestModel bcaBankTransferRequestModel) {
        this.bcaVa = bcaBankTransferRequestModel;
    }

    public BankTransferRequestModel getBniVa() {
        return this.bniVa;
    }

    public void setBniVa(BankTransferRequestModel bankTransferRequestModel) {
        this.bniVa = bankTransferRequestModel;
    }

    public List<String> getEnabledPayments() {
        return this.enabledPayments;
    }

    public void setEnabledPayments(List<String> list) {
        this.enabledPayments = list;
    }
}

