/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.table.implementation;

import com.microsoft.windowsazure.services.table.implementation.InputStreamDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.inject.Inject;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.MultipartDataSource;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;

public class MimeReaderWriter {
    @Inject
    public MimeReaderWriter() {
    }

    public MimeMultipart getMimeMultipart(List<DataSource> bodyPartContents) {
        try {
            return this.getMimeMultipartCore(bodyPartContents);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private MimeMultipart getMimeMultipartCore(List<DataSource> bodyPartContents) throws MessagingException, IOException {
        String batchId = String.format("batch_%s", UUID.randomUUID().toString());
        String changeSet = String.format("changeset_%s", UUID.randomUUID().toString());
        MimeMultipart changeSets = new MimeMultipart((DataSource)new SetBoundaryMultipartDataSource(changeSet));
        for (DataSource bodyPart : bodyPartContents) {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setDataHandler(new DataHandler(bodyPart));
            mimeBodyPart.setHeader("Content-Type", bodyPart.getContentType());
            mimeBodyPart.setHeader("Content-Transfer-Encoding", "binary");
            changeSets.addBodyPart((BodyPart)mimeBodyPart);
        }
        MimeBodyPart batchbody = new MimeBodyPart();
        batchbody.setContent((Multipart)changeSets);
        batchbody.setHeader("Content-Type", changeSets.getContentType());
        MimeMultipart batch = new MimeMultipart((DataSource)new SetBoundaryMultipartDataSource(batchId));
        batch.addBodyPart((BodyPart)batchbody);
        return batch;
    }

    public List<DataSource> parseParts(InputStream entityInputStream, String contentType) {
        try {
            return this.parsePartsCore(entityInputStream, contentType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    private List<DataSource> parsePartsCore(InputStream entityInputStream, String contentType) throws MessagingException, IOException {
        InputStreamDataSource ds = new InputStreamDataSource(entityInputStream, contentType);
        MimeMultipart batch = new MimeMultipart((DataSource)ds);
        MimeBodyPart batchBody = (MimeBodyPart)batch.getBodyPart(0);
        MimeMultipart changeSets = new MimeMultipart((DataSource)new MimePartDataSource((MimePart)batchBody));
        ArrayList<DataSource> result = new ArrayList<DataSource>();
        for (int i = 0; i < changeSets.getCount(); ++i) {
            BodyPart part = changeSets.getBodyPart(i);
            result.add(new InputStreamDataSource(part.getInputStream(), part.getContentType()));
        }
        return result;
    }

    private class SetBoundaryMultipartDataSource
    implements MultipartDataSource {
        private final String boundary;

        public SetBoundaryMultipartDataSource(String boundary) {
            this.boundary = boundary;
        }

        public String getContentType() {
            return "multipart/mixed; boundary=" + this.boundary;
        }

        public InputStream getInputStream() throws IOException {
            return null;
        }

        public String getName() {
            return null;
        }

        public OutputStream getOutputStream() throws IOException {
            return null;
        }

        public int getCount() {
            return 0;
        }

        public BodyPart getBodyPart(int index) throws MessagingException {
            return null;
        }
    }
}

