/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.table.implementation;

import com.microsoft.windowsazure.services.blob.implementation.ISO8601DateConverter;
import com.microsoft.windowsazure.services.table.EdmValueConverter;
import com.sun.jersey.core.util.Base64;
import java.text.ParseException;
import java.util.Date;
import java.util.UUID;
import javax.inject.Inject;

public class DefaultEdmValueConterter
implements EdmValueConverter {
    private final ISO8601DateConverter iso8601DateConverter;

    @Inject
    public DefaultEdmValueConterter(ISO8601DateConverter iso8601DateConverter) {
        this.iso8601DateConverter = iso8601DateConverter;
    }

    @Override
    public String serialize(String edmType, Object value) {
        if (value == null) {
            return null;
        }
        String serializedValue = value instanceof Date ? this.iso8601DateConverter.format((Date)value) : (value instanceof byte[] ? new String(Base64.encode((byte[])((byte[])value))) : value.toString());
        return serializedValue;
    }

    @Override
    public Object deserialize(String edmType, String value) {
        if (edmType == null) {
            return value;
        }
        if ("Edm.DateTime".equals(edmType)) {
            try {
                return this.iso8601DateConverter.parse(value);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        if ("Edm.Boolean".equals(edmType)) {
            return Boolean.parseBoolean(value);
        }
        if ("Edm.Double".equals(edmType)) {
            return Double.parseDouble(value);
        }
        if ("Edm.Int32".equals(edmType)) {
            return Integer.parseInt(value);
        }
        if ("Edm.Int64".equals(edmType)) {
            return Long.parseLong(value);
        }
        if ("Edm.Binary".equals(edmType)) {
            return Base64.decode((String)value);
        }
        if ("Edm.Guid".equals(edmType)) {
            return UUID.fromString(value);
        }
        return value;
    }
}

