/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.table.client;

import com.microsoft.windowsazure.services.core.storage.RequestResult;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.StorageExtendedErrorInformation;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.StorageErrorResponse;
import com.microsoft.windowsazure.services.table.client.TableOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.xml.stream.XMLStreamException;

public class TableServiceException
extends StorageException {
    private static final long serialVersionUID = 6037366449663934891L;
    private TableOperation operation;
    protected boolean retryable = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static TableServiceException generateTableServiceException(boolean retryable, RequestResult res, TableOperation op, InputStream inStream) throws IOException {
        try {
            TableServiceException retryableException = new TableServiceException(res.getStatusCode(), res.getStatusMessage(), op, new InputStreamReader(inStream));
            retryableException.retryable = retryable;
            TableServiceException tableServiceException = retryableException;
            return tableServiceException;
        }
        finally {
            inStream.close();
        }
    }

    public TableServiceException(String errorCode, String message, int statusCode, StorageExtendedErrorInformation extendedErrorInfo, Exception innerException) {
        super(errorCode, message, statusCode, extendedErrorInfo, innerException);
    }

    protected TableServiceException(int httpStatusCode, String message, TableOperation operation, Reader reader) {
        super(null, message, httpStatusCode, null, null);
        this.operation = operation;
        if (reader != null) {
            try {
                StorageErrorResponse error = new StorageErrorResponse(reader);
                this.extendedErrorInformation = error.getExtendedErrorInformation();
                this.errorCode = this.extendedErrorInformation.getErrorCode();
            }
            catch (XMLStreamException e) {
                // empty catch block
            }
        }
    }

    public TableOperation getOperation() {
        return this.operation;
    }

    public boolean isRetryable() {
        return this.retryable;
    }

    protected void setOperation(TableOperation operation) {
        this.operation = operation;
    }

    protected void setRetryable(boolean retryable) {
        this.retryable = retryable;
    }
}

