/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.table.client;

import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.RequestOptions;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.ExecutionEngine;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.StorageOperation;
import com.microsoft.windowsazure.services.table.client.AtomPubParser;
import com.microsoft.windowsazure.services.table.client.CloudTableClient;
import com.microsoft.windowsazure.services.table.client.EntityResolver;
import com.microsoft.windowsazure.services.table.client.QueryTableOperation;
import com.microsoft.windowsazure.services.table.client.TableEntity;
import com.microsoft.windowsazure.services.table.client.TableOperationType;
import com.microsoft.windowsazure.services.table.client.TableRequest;
import com.microsoft.windowsazure.services.table.client.TableRequestOptions;
import com.microsoft.windowsazure.services.table.client.TableResult;
import com.microsoft.windowsazure.services.table.client.TableServiceException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.text.ParseException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class TableOperation {
    TableEntity entity;
    TableOperationType opType = null;

    public static TableOperation delete(TableEntity entity) {
        Utility.assertNotNull("Entity", entity);
        Utility.assertNotNullOrEmpty("Entity Etag", entity.getEtag());
        return new TableOperation(entity, TableOperationType.DELETE);
    }

    public static TableOperation insert(TableEntity entity) {
        Utility.assertNotNull("Entity", entity);
        return new TableOperation(entity, TableOperationType.INSERT);
    }

    public static TableOperation insertOrMerge(TableEntity entity) {
        Utility.assertNotNull("Entity", entity);
        return new TableOperation(entity, TableOperationType.INSERT_OR_MERGE);
    }

    public static TableOperation insertOrReplace(TableEntity entity) {
        Utility.assertNotNull("Entity", entity);
        return new TableOperation(entity, TableOperationType.INSERT_OR_REPLACE);
    }

    public static TableOperation merge(TableEntity entity) {
        Utility.assertNotNull("Entity", entity);
        Utility.assertNotNullOrEmpty("Entity Etag", entity.getEtag());
        return new TableOperation(entity, TableOperationType.MERGE);
    }

    public static TableOperation retrieve(String partitionKey, String rowKey, Class<? extends TableEntity> clazzType) {
        QueryTableOperation retOp = new QueryTableOperation(partitionKey, rowKey);
        retOp.setClazzType(clazzType);
        return retOp;
    }

    public static TableOperation retrieve(String partitionKey, String rowKey, EntityResolver<?> resolver) {
        QueryTableOperation retOp = new QueryTableOperation(partitionKey, rowKey);
        retOp.setResolver(resolver);
        return retOp;
    }

    public static TableOperation replace(TableEntity entity) {
        Utility.assertNotNullOrEmpty("Entity Etag", entity.getEtag());
        return new TableOperation(entity, TableOperationType.REPLACE);
    }

    protected TableOperation() {
    }

    protected TableOperation(TableEntity entity, TableOperationType opType) {
        this.entity = entity;
        this.opType = opType;
    }

    private TableResult performDelete(CloudTableClient client, final String tableName, final TableRequestOptions options, OperationContext opContext) throws StorageException {
        String tableIdentity;
        final boolean isTableEntry = "Tables".equals(tableName);
        String string = tableIdentity = isTableEntry ? this.getEntity().writeEntity(opContext).get("TableName").getValueAsString() : null;
        if (!isTableEntry) {
            Utility.assertNotNullOrEmpty("Delete requires a valid ETag", this.getEntity().getEtag());
            Utility.assertNotNullOrEmpty("Delete requires a valid PartitionKey", this.getEntity().getPartitionKey());
            Utility.assertNotNullOrEmpty("Delete requires a valid RowKey", this.getEntity().getRowKey());
        }
        StorageOperation<CloudTableClient, TableOperation, TableResult> impl = new StorageOperation<CloudTableClient, TableOperation, TableResult>((RequestOptions)options){

            @Override
            public TableResult execute(CloudTableClient client, TableOperation operation, OperationContext opContext) throws Exception {
                HttpURLConnection request = TableRequest.delete(client.getTransformedEndPoint(opContext), tableName, TableOperation.this.generateRequestIdentity(isTableEntry, tableIdentity, false), operation.getEntity().getEtag(), options.getTimeoutIntervalInMs(), null, options, opContext);
                this.setConnection(request);
                this.signTableRequest(client, request, -1L, opContext);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() == 404 || this.getResult().getStatusCode() == 409) {
                    throw TableServiceException.generateTableServiceException(false, this.getResult(), operation, request.getErrorStream());
                }
                if (this.getResult().getStatusCode() != 204) {
                    throw TableServiceException.generateTableServiceException(true, this.getResult(), operation, request.getErrorStream());
                }
                return operation.parseResponse(null, this.getResult().getStatusCode(), null, opContext);
            }
        };
        return ExecutionEngine.executeWithRetry(client, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    private TableResult performInsert(CloudTableClient client, final String tableName, final TableRequestOptions options, OperationContext opContext) throws StorageException {
        String tableIdentity;
        final boolean isTableEntry = "Tables".equals(tableName);
        String string = tableIdentity = isTableEntry ? this.getEntity().writeEntity(opContext).get("TableName").getValueAsString() : null;
        if (!isTableEntry && this.opType != TableOperationType.INSERT) {
            Utility.assertNotNullOrEmpty("Upserts require a valid PartitionKey", this.getEntity().getPartitionKey());
            Utility.assertNotNullOrEmpty("Upserts require a valid RowKey", this.getEntity().getRowKey());
        }
        StorageOperation<CloudTableClient, TableOperation, TableResult> impl = new StorageOperation<CloudTableClient, TableOperation, TableResult>((RequestOptions)options){

            @Override
            public TableResult execute(CloudTableClient client, TableOperation operation, OperationContext opContext) throws Exception {
                HttpURLConnection request = TableRequest.insert(client.getTransformedEndPoint(opContext), tableName, TableOperation.this.generateRequestIdentity(isTableEntry, tableIdentity, false), operation.opType != TableOperationType.INSERT ? operation.getEntity().getEtag() : null, operation.opType.getUpdateType(), options.getTimeoutIntervalInMs(), null, options, opContext);
                this.setConnection(request);
                this.signTableRequest(client, request, -1L, opContext);
                AtomPubParser.writeSingleEntityToStream(operation.getEntity(), isTableEntry, request.getOutputStream(), opContext);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (operation.opType == TableOperationType.INSERT) {
                    if (this.getResult().getStatusCode() == 409) {
                        throw TableServiceException.generateTableServiceException(false, this.getResult(), operation, request.getErrorStream());
                    }
                    if (this.getResult().getStatusCode() != 201) {
                        throw TableServiceException.generateTableServiceException(true, this.getResult(), operation, request.getErrorStream());
                    }
                    InputStream inStream = request.getInputStream();
                    TableResult res = null;
                    XMLStreamReader xmlr = Utility.createXMLStreamReaderFromStream(inStream);
                    res = operation.parseResponse(xmlr, this.getResult().getStatusCode(), null, opContext);
                    return res;
                }
                if (this.getResult().getStatusCode() == 204) {
                    return operation.parseResponse(null, this.getResult().getStatusCode(), request.getHeaderField("ETag"), opContext);
                }
                throw TableServiceException.generateTableServiceException(true, this.getResult(), operation, request.getErrorStream());
            }
        };
        return ExecutionEngine.executeWithRetry(client, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    private TableResult performMerge(CloudTableClient client, final String tableName, final TableRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNullOrEmpty("Merge requires a valid ETag", this.getEntity().getEtag());
        Utility.assertNotNullOrEmpty("Merge requires a valid PartitionKey", this.getEntity().getPartitionKey());
        Utility.assertNotNullOrEmpty("Merge requires a valid RowKey", this.getEntity().getRowKey());
        StorageOperation<CloudTableClient, TableOperation, TableResult> impl = new StorageOperation<CloudTableClient, TableOperation, TableResult>((RequestOptions)options){

            @Override
            public TableResult execute(CloudTableClient client, TableOperation operation, OperationContext opContext) throws Exception {
                HttpURLConnection request = TableRequest.merge(client.getTransformedEndPoint(opContext), tableName, TableOperation.this.generateRequestIdentity(false, null, false), operation.getEntity().getEtag(), options.getTimeoutIntervalInMs(), null, options, opContext);
                this.setConnection(request);
                this.signTableRequest(client, request, -1L, opContext);
                AtomPubParser.writeSingleEntityToStream(operation.getEntity(), false, request.getOutputStream(), opContext);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() == 404 || this.getResult().getStatusCode() == 409) {
                    throw TableServiceException.generateTableServiceException(false, this.getResult(), operation, request.getErrorStream());
                }
                if (this.getResult().getStatusCode() == 204) {
                    return operation.parseResponse(null, this.getResult().getStatusCode(), request.getHeaderField("ETag"), opContext);
                }
                throw TableServiceException.generateTableServiceException(true, this.getResult(), operation, request.getErrorStream());
            }
        };
        return ExecutionEngine.executeWithRetry(client, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    private TableResult performUpdate(CloudTableClient client, final String tableName, final TableRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNullOrEmpty("Update requires a valid ETag", this.getEntity().getEtag());
        Utility.assertNotNullOrEmpty("Update requires a valid PartitionKey", this.getEntity().getPartitionKey());
        Utility.assertNotNullOrEmpty("Update requires a valid RowKey", this.getEntity().getRowKey());
        StorageOperation<CloudTableClient, TableOperation, TableResult> impl = new StorageOperation<CloudTableClient, TableOperation, TableResult>((RequestOptions)options){

            @Override
            public TableResult execute(CloudTableClient client, TableOperation operation, OperationContext opContext) throws Exception {
                HttpURLConnection request = TableRequest.update(client.getTransformedEndPoint(opContext), tableName, TableOperation.this.generateRequestIdentity(false, null, false), operation.getEntity().getEtag(), options.getTimeoutIntervalInMs(), null, options, opContext);
                this.setConnection(request);
                this.signTableRequest(client, request, -1L, opContext);
                AtomPubParser.writeSingleEntityToStream(operation.getEntity(), false, request.getOutputStream(), opContext);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() == 404 || this.getResult().getStatusCode() == 409) {
                    throw TableServiceException.generateTableServiceException(false, this.getResult(), operation, request.getErrorStream());
                }
                if (this.getResult().getStatusCode() == 204) {
                    return operation.parseResponse(null, this.getResult().getStatusCode(), request.getHeaderField("ETag"), opContext);
                }
                throw TableServiceException.generateTableServiceException(true, this.getResult(), operation, request.getErrorStream());
            }
        };
        return ExecutionEngine.executeWithRetry(client, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    protected TableResult execute(CloudTableClient client, String tableName, TableRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new TableRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(client);
        Utility.assertNotNullOrEmpty("TableName", tableName);
        if (this.getOperationType() == TableOperationType.INSERT || this.getOperationType() == TableOperationType.INSERT_OR_MERGE || this.getOperationType() == TableOperationType.INSERT_OR_REPLACE) {
            return this.performInsert(client, tableName, options, opContext);
        }
        if (this.getOperationType() == TableOperationType.DELETE) {
            return this.performDelete(client, tableName, options, opContext);
        }
        if (this.getOperationType() == TableOperationType.MERGE) {
            return this.performMerge(client, tableName, options, opContext);
        }
        if (this.getOperationType() == TableOperationType.REPLACE) {
            return this.performUpdate(client, tableName, options, opContext);
        }
        if (this.getOperationType() == TableOperationType.RETRIEVE) {
            return ((QueryTableOperation)this).performRetrieve(client, tableName, options, opContext);
        }
        throw new IllegalArgumentException("Unknown table operation");
    }

    protected String generateRequestIdentity(boolean isSingleIndexEntry, String entryName, boolean encodeKeys) throws StorageException {
        if (isSingleIndexEntry) {
            return String.format("'%s'", entryName);
        }
        if (this.opType == TableOperationType.INSERT) {
            return "";
        }
        String pk = null;
        String rk = null;
        if (this.opType == TableOperationType.RETRIEVE) {
            QueryTableOperation qOp = (QueryTableOperation)this;
            pk = qOp.getPartitionKey();
            rk = qOp.getRowKey();
        } else {
            pk = this.getEntity().getPartitionKey();
            rk = this.getEntity().getRowKey();
        }
        return String.format("%s='%s',%s='%s'", "PartitionKey", encodeKeys ? Utility.safeEncode(pk) : pk, "RowKey", encodeKeys ? Utility.safeEncode(rk) : rk);
    }

    protected String generateRequestIdentityWithTable(String tableName) throws StorageException {
        return String.format("/%s(%s)", tableName, this.generateRequestIdentity(false, null, true));
    }

    protected final synchronized TableEntity getEntity() {
        return this.entity;
    }

    protected final synchronized TableOperationType getOperationType() {
        return this.opType;
    }

    protected TableResult parseResponse(XMLStreamReader xmlr, int httpStatusCode, String etagFromHeader, OperationContext opContext) throws XMLStreamException, ParseException, InstantiationException, IllegalAccessException, StorageException {
        TableResult resObj = null;
        if (this.opType == TableOperationType.INSERT) {
            resObj = AtomPubParser.parseSingleOpResponse(xmlr, httpStatusCode, null, null, opContext);
            resObj.updateResultObject(this.getEntity());
        } else {
            resObj = new TableResult(httpStatusCode);
            resObj.setResult(this.getEntity());
            if (this.opType != TableOperationType.DELETE && etagFromHeader != null) {
                resObj.setEtag(etagFromHeader);
                this.getEntity().setEtag(etagFromHeader);
            }
        }
        return resObj;
    }

    protected final synchronized void setEntity(TableEntity entity) {
        this.entity = entity;
    }
}

