/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.table.client;

import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import com.microsoft.windowsazure.services.table.client.EdmType;
import com.microsoft.windowsazure.services.table.client.EntityProperty;
import com.microsoft.windowsazure.services.table.client.Ignore;
import com.microsoft.windowsazure.services.table.client.StoreAs;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

class PropertyPair {
    private Method getter = null;
    private Method setter = null;
    private String name = null;
    String effectiveName = null;

    PropertyPair() {
    }

    protected static HashMap<String, PropertyPair> generatePropertyPairs(Class<?> clazzType) {
        Method[] methods = clazzType.getMethods();
        HashMap<String, PropertyPair> propMap = new HashMap<String, PropertyPair>();
        String propName = null;
        PropertyPair currProperty = null;
        for (Method m : methods) {
            if (m.getName().length() < 4 || !m.getName().startsWith("get") && !m.getName().startsWith("set") || (propName = m.getName().substring(3)).equals("PartitionKey") || propName.equals("RowKey") || propName.equals("Timestamp") || propName.equals("Etag") || propName.equals("LastModified")) continue;
            if (propMap.containsKey(propName)) {
                currProperty = propMap.get(propName);
            } else {
                currProperty = new PropertyPair();
                currProperty.name = propName;
                propMap.put(propName, currProperty);
            }
            if (m.getName().startsWith("get") && m.getParameterTypes().length == 0) {
                currProperty.getter = m;
            } else if (m.getName().startsWith("set") && m.getParameterTypes().length == 1 && Void.TYPE.equals(m.getReturnType())) {
                currProperty.setter = m;
            }
            StoreAs storeAsInstance = m.getAnnotation(StoreAs.class);
            if (storeAsInstance == null) continue;
            if (Utility.isNullOrEmpty(storeAsInstance.name())) {
                throw new IllegalArgumentException(String.format("StoreAs Annotation found for property %s with empty value", currProperty.name));
            }
            if (currProperty.effectiveName != null && !currProperty.effectiveName.equals(currProperty.name) && !currProperty.effectiveName.equals(storeAsInstance.name())) {
                throw new IllegalArgumentException(String.format("StoreAs Annotation found for both getter and setter for property %s with non equal values", currProperty.name));
            }
            if (currProperty.name.equals(storeAsInstance.name())) continue;
            currProperty.effectiveName = storeAsInstance.name();
        }
        ArrayList keysToRemove = new ArrayList();
        ArrayList keysToAlter = new ArrayList();
        for (Map.Entry e : propMap.entrySet()) {
            if (!((PropertyPair)e.getValue()).shouldProcess()) {
                keysToRemove.add(e.getKey());
                continue;
            }
            if (!Utility.isNullOrEmpty(((PropertyPair)e.getValue()).effectiveName)) {
                keysToAlter.add(e.getKey());
                continue;
            }
            ((PropertyPair)e.getValue()).effectiveName = ((PropertyPair)e.getValue()).name;
        }
        for (String key : keysToRemove) {
            propMap.remove(key);
        }
        for (String key : keysToAlter) {
            PropertyPair p = propMap.get(key);
            propMap.remove(key);
            propMap.put(p.effectiveName, p);
        }
        return propMap;
    }

    protected void consumeTableProperty(EntityProperty prop, Object instance) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (prop.getEdmType() == EdmType.STRING) {
            this.setter.invoke(instance, prop.getValueAsString());
        } else if (prop.getEdmType() == EdmType.BINARY) {
            if (this.setter.getParameterTypes()[0].equals(Byte[].class)) {
                this.setter.invoke(instance, new Object[]{prop.getValueAsByteObjectArray()});
            } else {
                this.setter.invoke(instance, new Object[]{prop.getValueAsByteArray()});
            }
        } else if (prop.getEdmType() == EdmType.BOOLEAN) {
            this.setter.invoke(instance, prop.getValueAsBoolean());
        } else if (prop.getEdmType() == EdmType.DOUBLE) {
            this.setter.invoke(instance, prop.getValueAsDouble());
        } else if (prop.getEdmType() == EdmType.GUID) {
            this.setter.invoke(instance, prop.getValueAsUUID());
        } else if (prop.getEdmType() == EdmType.INT32) {
            this.setter.invoke(instance, prop.getValueAsInteger());
        } else if (prop.getEdmType() == EdmType.INT64) {
            this.setter.invoke(instance, prop.getValueAsLong());
        } else if (prop.getEdmType() == EdmType.DATE_TIME) {
            this.setter.invoke(instance, prop.getValueAsDate());
        } else {
            throw new IllegalArgumentException(String.format("Property %s with Edm Type %s cannot be de-serialized.", this.name, prop.getEdmType().toString()));
        }
    }

    protected EntityProperty generateTableProperty(Object instance) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> getType = this.getter.getReturnType();
        Object val = this.getter.invoke(instance, (Object[])null);
        if (getType.equals(byte[].class)) {
            return val != null ? new EntityProperty((byte[])val) : new EntityProperty(EdmType.BINARY);
        }
        if (getType.equals(Byte[].class)) {
            return val != null ? new EntityProperty((Byte[])val) : new EntityProperty(EdmType.BINARY);
        }
        if (getType.equals(String.class)) {
            return val != null ? new EntityProperty((String)val) : new EntityProperty(EdmType.STRING);
        }
        if (getType.equals(Boolean.TYPE) || getType.equals(Boolean.class)) {
            return val != null ? new EntityProperty((Boolean)val) : new EntityProperty(EdmType.BOOLEAN);
        }
        if (getType.equals(Double.TYPE) || getType.equals(Double.class)) {
            return val != null ? new EntityProperty((Double)val) : new EntityProperty(EdmType.DOUBLE);
        }
        if (getType.equals(UUID.class)) {
            return val != null ? new EntityProperty((UUID)val) : new EntityProperty(EdmType.GUID);
        }
        if (getType.equals(Integer.TYPE) || getType.equals(Integer.class)) {
            return val != null ? new EntityProperty((Integer)val) : new EntityProperty(EdmType.INT32);
        }
        if (getType.equals(Long.TYPE) || getType.equals(Long.class)) {
            return val != null ? new EntityProperty((Long)val) : new EntityProperty(EdmType.INT64);
        }
        if (getType.equals(Date.class)) {
            return val != null ? new EntityProperty((Date)val) : new EntityProperty(EdmType.DATE_TIME);
        }
        throw new IllegalArgumentException(String.format("Property %s with return type %s cannot be serialized.", this.getter.getName(), this.getter.getReturnType()));
    }

    protected boolean shouldProcess() {
        return !Utility.isNullOrEmpty(this.name) && this.getter != null && !this.getter.isAnnotationPresent(Ignore.class) && this.setter != null && !this.setter.isAnnotationPresent(Ignore.class) && this.getter.getReturnType().equals(this.setter.getParameterTypes()[0]);
    }
}

