/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.table.client;

import com.microsoft.windowsazure.services.core.storage.DoesServiceRequest;
import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.ResultContinuation;
import com.microsoft.windowsazure.services.core.storage.ResultContinuationType;
import com.microsoft.windowsazure.services.core.storage.ResultSegment;
import com.microsoft.windowsazure.services.core.storage.ServiceClient;
import com.microsoft.windowsazure.services.core.storage.StorageCredentials;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.ExecutionEngine;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.LazySegmentedIterable;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.SegmentedStorageOperation;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.StorageOperation;
import com.microsoft.windowsazure.services.table.client.AtomPubParser;
import com.microsoft.windowsazure.services.table.client.CloudTable;
import com.microsoft.windowsazure.services.table.client.EntityProperty;
import com.microsoft.windowsazure.services.table.client.EntityResolver;
import com.microsoft.windowsazure.services.table.client.ODataPayload;
import com.microsoft.windowsazure.services.table.client.TableBatchOperation;
import com.microsoft.windowsazure.services.table.client.TableEntity;
import com.microsoft.windowsazure.services.table.client.TableOperation;
import com.microsoft.windowsazure.services.table.client.TableQuery;
import com.microsoft.windowsazure.services.table.client.TableRequest;
import com.microsoft.windowsazure.services.table.client.TableRequestOptions;
import com.microsoft.windowsazure.services.table.client.TableResponse;
import com.microsoft.windowsazure.services.table.client.TableResult;
import com.microsoft.windowsazure.services.table.client.TableServiceEntity;
import com.microsoft.windowsazure.services.table.client.TableServiceException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;

public final class CloudTableClient
extends ServiceClient {
    private final EntityResolver<String> tableNameResolver = new EntityResolver<String>(){

        @Override
        public String resolve(String partitionKey, String rowKey, Date timeStamp, HashMap<String, EntityProperty> properties, String etag) {
            return properties.get("TableName").getValueAsString();
        }
    };

    public CloudTableClient(URI baseUri) {
        this(baseUri, null);
        this.setTimeoutInMs(60000);
    }

    public CloudTableClient(URI baseUri, StorageCredentials credentials) {
        super(baseUri, credentials);
        this.setTimeoutInMs(60000);
    }

    public CloudTable getTableReference(String tableAddress) throws URISyntaxException, StorageException {
        Utility.assertNotNullOrEmpty("tableAddress", tableAddress);
        return new CloudTable(tableAddress, this);
    }

    @DoesServiceRequest
    public ArrayList<TableResult> execute(String tableName, TableBatchOperation batch) throws StorageException {
        return this.execute(tableName, batch, null, null);
    }

    @DoesServiceRequest
    public ArrayList<TableResult> execute(String tableName, TableBatchOperation batch, TableRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("batch", batch);
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new TableRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this);
        return batch.execute(this, tableName, options, opContext);
    }

    @DoesServiceRequest
    public TableResult execute(String tableName, TableOperation operation) throws StorageException {
        return this.execute(tableName, operation, null, null);
    }

    @DoesServiceRequest
    public TableResult execute(String tableName, TableOperation operation, TableRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("operation", operation);
        return operation.execute(this, tableName, options, opContext);
    }

    @DoesServiceRequest
    public <R> Iterable<R> execute(TableQuery<?> query, EntityResolver<R> resolver) {
        return this.execute(query, resolver, null, null);
    }

    @DoesServiceRequest
    public <R> Iterable<R> execute(TableQuery<?> query, EntityResolver<R> resolver, TableRequestOptions options, OperationContext opContext) {
        Utility.assertNotNull("query", query);
        Utility.assertNotNull("Query requires a valid class type or resolver.", resolver);
        return this.generateIteratorForQuery(query, resolver, options, opContext);
    }

    @DoesServiceRequest
    public <T extends TableEntity> Iterable<T> execute(TableQuery<T> query) {
        return this.execute(query, null, null);
    }

    @DoesServiceRequest
    public <T extends TableEntity> Iterable<T> execute(TableQuery<T> query, TableRequestOptions options, OperationContext opContext) {
        Utility.assertNotNull("query", query);
        return this.generateIteratorForQuery(query, null, options, opContext);
    }

    @DoesServiceRequest
    public <R> ResultSegment<R> executeSegmented(TableQuery<?> query, EntityResolver<R> resolver, ResultContinuation continuationToken) throws IOException, URISyntaxException, StorageException {
        return this.executeSegmented(query, resolver, continuationToken, null, null);
    }

    @DoesServiceRequest
    public <R> ResultSegment<R> executeSegmented(TableQuery<?> query, EntityResolver<R> resolver, ResultContinuation continuationToken, TableRequestOptions options, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        Utility.assertNotNull("Query requires a valid class type or resolver.", resolver);
        return this.executeQuerySegmentedImpl(query, resolver, continuationToken, options, opContext);
    }

    @DoesServiceRequest
    public <T extends TableEntity> ResultSegment<T> executeSegmented(TableQuery<T> query, ResultContinuation continuationToken) throws IOException, URISyntaxException, StorageException {
        return this.executeSegmented(query, continuationToken, null, null);
    }

    @DoesServiceRequest
    public <T extends TableEntity> ResultSegment<T> executeSegmented(TableQuery<T> query, ResultContinuation continuationToken, TableRequestOptions options, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        Utility.assertNotNull("query", query);
        return this.executeQuerySegmentedImpl(query, null, continuationToken, options, opContext);
    }

    @DoesServiceRequest
    public Iterable<String> listTables() {
        return this.listTables(null);
    }

    @DoesServiceRequest
    public Iterable<String> listTables(String prefix) {
        return this.listTables(prefix, null, null);
    }

    @DoesServiceRequest
    public Iterable<String> listTables(String prefix, TableRequestOptions options, OperationContext opContext) {
        return this.execute(this.generateListTablesQuery(prefix), this.tableNameResolver, options, opContext);
    }

    @DoesServiceRequest
    public ResultSegment<String> listTablesSegmented() throws IOException, URISyntaxException, StorageException {
        return this.listTablesSegmented(null);
    }

    @DoesServiceRequest
    public ResultSegment<String> listTablesSegmented(String prefix) throws IOException, URISyntaxException, StorageException {
        return this.listTablesSegmented(prefix, null, null, null, null);
    }

    @DoesServiceRequest
    public ResultSegment<String> listTablesSegmented(String prefix, Integer maxResults, ResultContinuation continuationToken, TableRequestOptions options, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        return this.executeSegmented(this.generateListTablesQuery(prefix).take(maxResults), this.tableNameResolver, continuationToken, options, opContext);
    }

    private TableQuery<TableServiceEntity> generateListTablesQuery(String prefix) {
        TableQuery<TableServiceEntity> listQuery = TableQuery.from("Tables", TableServiceEntity.class);
        if (!Utility.isNullOrEmpty(prefix)) {
            String prefixFilter = String.format("(%s ge '%s') and (%s lt '%s{')", "TableName", prefix, "TableName", prefix);
            listQuery = listQuery.where(prefixFilter);
        }
        return listQuery;
    }

    protected <T extends TableEntity, R> ResultSegment<?> executeQuerySegmentedCore(TableQuery<T> queryToExecute, EntityResolver<R> resolver, ResultContinuation continuationToken, StorageOperation<?, ?, ?> taskReference, TableRequestOptions options, OperationContext opContext) throws StorageException, IOException, URISyntaxException, XMLStreamException, ParseException, InstantiationException, IllegalAccessException, InvalidKeyException {
        if (resolver == null) {
            Utility.assertNotNull("Query requires a valid class type or resolver.", queryToExecute.getClazzType());
        }
        HttpURLConnection queryRequest = TableRequest.query(this.getTransformedEndPoint(opContext), queryToExecute.getSourceTableName(), null, options.getTimeoutIntervalInMs(), queryToExecute.generateQueryBuilder(), continuationToken, options, opContext);
        taskReference.setConnection(queryRequest);
        taskReference.signTableRequest(this, queryRequest, -1L, opContext);
        ExecutionEngine.processRequest(queryRequest, opContext, taskReference.getResult());
        if (taskReference.getResult().getStatusCode() != 200) {
            throw TableServiceException.generateTableServiceException(true, taskReference.getResult(), null, queryRequest.getErrorStream());
        }
        ODataPayload<?> clazzResponse = null;
        ODataPayload<?> resolvedResponse = null;
        InputStream inStream = queryRequest.getInputStream();
        if (resolver == null) {
            clazzResponse = AtomPubParser.parseResponse(inStream, queryToExecute.getClazzType(), null, opContext);
        } else {
            resolvedResponse = AtomPubParser.parseResponse(inStream, queryToExecute.getClazzType(), resolver, opContext);
        }
        ResultContinuation nextToken = TableResponse.getTableContinuationFromResponse(queryRequest);
        if (resolver == null) {
            return new ResultSegment(clazzResponse.results, queryToExecute.getTakeCount() == null ? clazzResponse.results.size() : queryToExecute.getTakeCount().intValue(), nextToken);
        }
        return new ResultSegment(resolvedResponse.results, queryToExecute.getTakeCount() == null ? resolvedResponse.results.size() : queryToExecute.getTakeCount().intValue(), nextToken);
    }

    protected <T extends TableEntity, R> ResultSegment<?> executeQuerySegmentedImpl(TableQuery<T> queryToExecute, final EntityResolver<R> resolver, final ResultContinuation continuationToken, TableRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new TableRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this);
        Utility.assertContinuationType(continuationToken, ResultContinuationType.TABLE);
        StorageOperation impl = new StorageOperation<CloudTableClient, TableQuery<T>, ResultSegment<?>>(options){

            @Override
            public ResultSegment<?> execute(CloudTableClient client, TableQuery<T> queryRef, OperationContext opContext) throws Exception {
                return CloudTableClient.this.executeQuerySegmentedCore(queryRef, resolver, continuationToken, this, (TableRequestOptions)this.getRequestOptions(), opContext);
            }
        };
        return (ResultSegment)ExecutionEngine.executeWithRetry(this, queryToExecute, impl, options.getRetryPolicyFactory(), opContext);
    }

    protected final URI getTransformedEndPoint(OperationContext opContext) throws URISyntaxException, StorageException {
        if (this.getCredentials().doCredentialsNeedTransformUri()) {
            if (this.getEndpoint().isAbsolute()) {
                return this.getCredentials().transformUri(this.getEndpoint(), opContext);
            }
            StorageException ex = Utility.generateNewUnexpectedStorageException(null);
            ex.getExtendedErrorInformation().setErrorMessage("Table Object relative URIs not supported.");
            throw ex;
        }
        return this.getEndpoint();
    }

    protected <T extends TableEntity, R> Iterable<?> generateIteratorForQuery(TableQuery<T> queryRef, final EntityResolver<R> resolver, TableRequestOptions options, OperationContext opContext) {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new TableRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this);
        if (resolver == null) {
            SegmentedStorageOperation impl = new SegmentedStorageOperation<CloudTableClient, TableQuery<T>, ResultSegment<T>>(options, null){

                @Override
                public ResultSegment<T> execute(CloudTableClient client, TableQuery<T> queryToExecute, OperationContext opContext) throws Exception {
                    ResultSegment<?> result = CloudTableClient.this.executeQuerySegmentedCore(queryToExecute, null, this.getToken(), this, (TableRequestOptions)this.getRequestOptions(), opContext);
                    if (result != null) {
                        this.setToken(result.getContinuationToken());
                    }
                    return result;
                }
            };
            return new LazySegmentedIterable(impl, this, queryRef, options.getRetryPolicyFactory(), opContext);
        }
        SegmentedStorageOperation impl = new SegmentedStorageOperation<CloudTableClient, TableQuery<T>, ResultSegment<R>>(options, null){

            @Override
            public ResultSegment<R> execute(CloudTableClient client, TableQuery<T> queryToExecute, OperationContext opContext) throws Exception {
                ResultSegment<?> result = CloudTableClient.this.executeQuerySegmentedCore(queryToExecute, resolver, this.getToken(), this, (TableRequestOptions)this.getRequestOptions(), opContext);
                if (result != null) {
                    this.setToken(result.getContinuationToken());
                }
                return result;
            }
        };
        return new LazySegmentedIterable(impl, this, queryRef, options.getRetryPolicyFactory(), opContext);
    }
}

