/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.table.client;

import com.microsoft.windowsazure.services.blob.core.storage.SharedAccessSignatureHelper;
import com.microsoft.windowsazure.services.core.storage.DoesServiceRequest;
import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.RequestOptions;
import com.microsoft.windowsazure.services.core.storage.StorageCredentials;
import com.microsoft.windowsazure.services.core.storage.StorageCredentialsAccountAndKey;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.PathUtility;
import com.microsoft.windowsazure.services.core.storage.utils.UriQueryBuilder;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.ExecutionEngine;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.StorageOperation;
import com.microsoft.windowsazure.services.table.client.CloudTableClient;
import com.microsoft.windowsazure.services.table.client.DynamicTableEntity;
import com.microsoft.windowsazure.services.table.client.EntityProperty;
import com.microsoft.windowsazure.services.table.client.SharedAccessTablePolicy;
import com.microsoft.windowsazure.services.table.client.TableAccessPolicyResponse;
import com.microsoft.windowsazure.services.table.client.TableOperation;
import com.microsoft.windowsazure.services.table.client.TableOperationType;
import com.microsoft.windowsazure.services.table.client.TablePermissions;
import com.microsoft.windowsazure.services.table.client.TableRequest;
import com.microsoft.windowsazure.services.table.client.TableRequestOptions;
import com.microsoft.windowsazure.services.table.client.TableResult;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;

public final class CloudTable {
    String name;
    URI uri;
    private final CloudTableClient tableServiceClient;

    public String getName() {
        return this.name;
    }

    public CloudTableClient getServiceClient() {
        return this.tableServiceClient;
    }

    public URI getUri() {
        return this.uri;
    }

    public CloudTable(String tableName, CloudTableClient client) throws URISyntaxException {
        this(PathUtility.appendPathToUri(client.getEndpoint(), tableName), client);
    }

    public CloudTable(URI uri, CloudTableClient client) {
        this.uri = uri;
        this.name = PathUtility.getTableNameFromUri(uri, client.isUsePathStyleUris());
        this.tableServiceClient = client;
    }

    @DoesServiceRequest
    public void create() throws StorageException {
        this.create(null, null);
    }

    @DoesServiceRequest
    public void create(TableRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new TableRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.tableServiceClient);
        Utility.assertNotNullOrEmpty("tableName", this.name);
        DynamicTableEntity tableEntry = new DynamicTableEntity();
        tableEntry.getProperties().put("TableName", new EntityProperty(this.name));
        this.tableServiceClient.execute("Tables", TableOperation.insert(tableEntry), options, opContext);
    }

    @DoesServiceRequest
    public boolean createIfNotExist() throws StorageException {
        return this.createIfNotExist(null, null);
    }

    @DoesServiceRequest
    public boolean createIfNotExist(TableRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new TableRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.tableServiceClient);
        Utility.assertNotNullOrEmpty("tableName", this.name);
        if (this.exists(options, opContext)) {
            return false;
        }
        try {
            this.create(options, opContext);
        }
        catch (StorageException ex) {
            if (ex.getHttpStatusCode() == 409 && "TableAlreadyExists".equals(ex.getErrorCode())) {
                return false;
            }
            throw ex;
        }
        return true;
    }

    @DoesServiceRequest
    public void delete() throws StorageException {
        this.delete(null, null);
    }

    @DoesServiceRequest
    public void delete(TableRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new TableRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.tableServiceClient);
        Utility.assertNotNullOrEmpty("tableName", this.name);
        DynamicTableEntity tableEntry = new DynamicTableEntity();
        tableEntry.getProperties().put("TableName", new EntityProperty(this.name));
        TableOperation delOp = new TableOperation(tableEntry, TableOperationType.DELETE);
        TableResult result = this.tableServiceClient.execute("Tables", delOp, options, opContext);
        if (result.getHttpStatusCode() == 204) {
            return;
        }
        throw new StorageException("OutOfRangeInput", "Unexpected http status code received.", result.getHttpStatusCode(), null, null);
    }

    @DoesServiceRequest
    public boolean deleteIfExists() throws StorageException {
        return this.deleteIfExists(null, null);
    }

    @DoesServiceRequest
    public boolean deleteIfExists(TableRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new TableRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.tableServiceClient);
        Utility.assertNotNullOrEmpty("tableName", this.name);
        if (this.exists(options, opContext)) {
            try {
                this.delete(options, opContext);
            }
            catch (StorageException ex) {
                if (ex.getHttpStatusCode() == 404 && "ResourceNotFound".equals(ex.getErrorCode())) {
                    return false;
                }
                throw ex;
            }
            return true;
        }
        return false;
    }

    @DoesServiceRequest
    public boolean exists() throws StorageException {
        return this.exists(null, null);
    }

    @DoesServiceRequest
    public boolean exists(TableRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new TableRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.tableServiceClient);
        Utility.assertNotNullOrEmpty("tableName", this.name);
        TableResult result = this.tableServiceClient.execute("Tables", TableOperation.retrieve(this.name, null, DynamicTableEntity.class), options, opContext);
        if (result.getHttpStatusCode() == 200) {
            return true;
        }
        if (result.getHttpStatusCode() == 404) {
            return false;
        }
        throw new StorageException("OutOfRangeInput", "Unexpected http status code received.", result.getHttpStatusCode(), null, null);
    }

    @DoesServiceRequest
    public void uploadPermissions(TablePermissions permissions) throws StorageException {
        this.uploadPermissions(permissions, null, null);
    }

    @DoesServiceRequest
    public void uploadPermissions(final TablePermissions permissions, TableRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new TableRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.tableServiceClient);
        StorageOperation<CloudTableClient, CloudTable, Void> impl = new StorageOperation<CloudTableClient, CloudTable, Void>((RequestOptions)options){

            @Override
            public Void execute(CloudTableClient client, CloudTable table, OperationContext opContext) throws Exception {
                HttpURLConnection request = TableRequest.setAcl(table.uri, this.getRequestOptions().getTimeoutIntervalInMs(), opContext);
                this.setConnection(request);
                StringWriter outBuffer = new StringWriter();
                TableRequest.writeSharedAccessIdentifiersToStream(permissions.getSharedAccessPolicies(), outBuffer);
                byte[] aclBytes = outBuffer.toString().getBytes("UTF8");
                this.signTableRequest(client, request, aclBytes.length, opContext);
                OutputStream outStreamRef = request.getOutputStream();
                outStreamRef.write(aclBytes);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 204) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }
        };
        ExecutionEngine.executeWithRetry(this.tableServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public TablePermissions downloadPermissions() throws StorageException {
        return this.downloadPermissions(null, null);
    }

    @DoesServiceRequest
    public TablePermissions downloadPermissions(TableRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new TableRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.tableServiceClient);
        final String tableName = this.name;
        StorageOperation<CloudTableClient, CloudTable, TablePermissions> impl = new StorageOperation<CloudTableClient, CloudTable, TablePermissions>((RequestOptions)options){

            @Override
            public TablePermissions execute(CloudTableClient client, CloudTable table, OperationContext opContext) throws Exception {
                HttpURLConnection request = TableRequest.getAcl(table.uri, tableName, this.getRequestOptions().getTimeoutIntervalInMs(), opContext);
                this.setConnection(request);
                this.signTableRequest(client, request, -1L, opContext);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                TablePermissions permissions = new TablePermissions();
                TableAccessPolicyResponse response = new TableAccessPolicyResponse(request.getInputStream());
                for (String key : response.getAccessIdentifiers().keySet()) {
                    permissions.getSharedAccessPolicies().put(key, (SharedAccessTablePolicy)response.getAccessIdentifiers().get(key));
                }
                return permissions;
            }
        };
        return ExecutionEngine.executeWithRetry(this.tableServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    public String generateSharedAccessSignature(SharedAccessTablePolicy policy, String accessPolicyIdentifier, String startPartitionKey, String startRowKey, String endPartitionKey, String endRowKey) throws InvalidKeyException, StorageException {
        if (!this.tableServiceClient.getCredentials().canCredentialsSignRequest()) {
            String errorMessage = "Cannot create Shared Access Signature unless the Account Key credentials are used by the BlobServiceClient.";
            throw new IllegalArgumentException("Cannot create Shared Access Signature unless the Account Key credentials are used by the BlobServiceClient.");
        }
        String resourceName = this.getSharedAccessCanonicalName();
        String signature = SharedAccessSignatureHelper.generateSharedAccessSignatureHash(policy, accessPolicyIdentifier, resourceName, startPartitionKey, startRowKey, endPartitionKey, endRowKey, this.tableServiceClient, null);
        String accountKeyName = null;
        StorageCredentials credentials = this.tableServiceClient.getCredentials();
        if (credentials instanceof StorageCredentialsAccountAndKey) {
            accountKeyName = ((StorageCredentialsAccountAndKey)credentials).getAccountKeyName();
        }
        UriQueryBuilder builder = SharedAccessSignatureHelper.generateSharedAccessSignature(policy, startPartitionKey, startRowKey, endPartitionKey, endRowKey, accessPolicyIdentifier, this.name, signature, accountKeyName);
        return builder.toString();
    }

    private String getSharedAccessCanonicalName() {
        if (this.tableServiceClient.isUsePathStyleUris()) {
            return this.getUri().getPath();
        }
        return PathUtility.getCanonicalPathFromCredentials(this.tableServiceClient.getCredentials(), this.getUri().getPath());
    }
}

