/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.table.client;

import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import com.microsoft.windowsazure.services.table.client.EdmType;
import com.microsoft.windowsazure.services.table.client.EntityProperty;
import com.microsoft.windowsazure.services.table.client.EntityResolver;
import com.microsoft.windowsazure.services.table.client.ODataPayload;
import com.microsoft.windowsazure.services.table.client.TableEntity;
import com.microsoft.windowsazure.services.table.client.TableResult;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringEscapeUtils;

class AtomPubParser {
    AtomPubParser() {
    }

    protected static XMLStreamWriter generateTableWriter(OutputStream outStream) throws XMLStreamException {
        XMLOutputFactory xmlOutFactoryInst = XMLOutputFactory.newInstance();
        return xmlOutFactoryInst.createXMLStreamWriter(outStream, "UTF-8");
    }

    protected static <T extends TableEntity, R> TableResult parseEntity(XMLStreamReader xmlr, Class<T> clazzType, EntityResolver<R> resolver, OperationContext opContext) throws XMLStreamException, ParseException, InstantiationException, IllegalAccessException, StorageException {
        int eventType = xmlr.getEventType();
        TableResult res = new TableResult();
        xmlr.require(1, null, "entry");
        res.setEtag(StringEscapeUtils.unescapeHtml4((String)xmlr.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "etag")));
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType == 4) {
                xmlr.getText();
                continue;
            }
            String name = xmlr.getName().toString();
            if (eventType != 1) continue;
            if (name.equals("{http://www.w3.org/2005/Atom}id")) {
                res.setId(Utility.readElementFromXMLReader(xmlr, "id"));
                continue;
            }
            if (!name.equals("{http://schemas.microsoft.com/ado/2007/08/dataservices/metadata}properties")) continue;
            if (resolver == null && clazzType == null) {
                return res;
            }
            res.setProperties(AtomPubParser.readProperties(xmlr, opContext));
            break;
        }
        if ((eventType = xmlr.next()) == 4) {
            eventType = xmlr.next();
        }
        xmlr.require(2, null, "content");
        eventType = xmlr.next();
        if (eventType == 4) {
            eventType = xmlr.next();
        }
        xmlr.require(2, null, "entry");
        String rowKey = null;
        String partitionKey = null;
        Date timestamp = null;
        EntityProperty tempProp = res.getProperties().get("PartitionKey");
        if (tempProp != null) {
            res.getProperties().remove("PartitionKey");
            partitionKey = tempProp.getValueAsString();
        }
        if ((tempProp = res.getProperties().get("RowKey")) != null) {
            res.getProperties().remove("RowKey");
            rowKey = tempProp.getValueAsString();
        }
        if ((tempProp = res.getProperties().get("Timestamp")) != null) {
            res.getProperties().remove("Timestamp");
            timestamp = tempProp.getValueAsDate();
        }
        if (resolver != null) {
            res.setResult(resolver.resolve(partitionKey, rowKey, timestamp, res.getProperties(), res.getEtag()));
        } else if (clazzType != null) {
            TableEntity entity = (TableEntity)clazzType.newInstance();
            entity.setEtag(res.getEtag());
            entity.setPartitionKey(partitionKey);
            entity.setRowKey(rowKey);
            entity.setTimestamp(timestamp);
            entity.readEntity(res.getProperties(), opContext);
            res.setResult(entity);
        }
        return res;
    }

    protected static <T extends TableEntity, R> ODataPayload<?> parseResponse(InputStream inStream, Class<T> clazzType, EntityResolver<R> resolver, OperationContext opContext) throws XMLStreamException, ParseException, InstantiationException, IllegalAccessException, StorageException {
        ODataPayload corePayload = null;
        ODataPayload resolvedPayload = null;
        ODataPayload commonPayload = null;
        if (resolver != null) {
            commonPayload = resolvedPayload = new ODataPayload();
        } else {
            corePayload = new ODataPayload();
            commonPayload = corePayload;
        }
        XMLStreamReader xmlr = Utility.createXMLStreamReaderFromStream(inStream);
        int eventType = xmlr.getEventType();
        xmlr.require(7, null, null);
        eventType = xmlr.next();
        xmlr.require(1, null, "feed");
        eventType = xmlr.next();
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType == 4) {
                xmlr.getText();
                continue;
            }
            String name = xmlr.getName().toString();
            if (eventType == 1) {
                if (!name.equals("{http://www.w3.org/2005/Atom}entry")) continue;
                TableResult res = AtomPubParser.parseEntity(xmlr, clazzType, resolver, opContext);
                if (corePayload != null) {
                    corePayload.tableResults.add(res);
                }
                if (resolver != null) {
                    resolvedPayload.results.add(res.getResult());
                    continue;
                }
                corePayload.results.add((TableEntity)res.getResult());
                continue;
            }
            if (eventType != 2 || !name.equals("{http://www.w3.org/2005/Atom}feed")) continue;
            break;
        }
        xmlr.require(2, null, "feed");
        return commonPayload;
    }

    protected static <T extends TableEntity, R> TableResult parseSingleOpResponse(XMLStreamReader xmlr, int httpStatusCode, Class<T> clazzType, EntityResolver<R> resolver, OperationContext opContext) throws XMLStreamException, ParseException, InstantiationException, IllegalAccessException, StorageException {
        xmlr.require(7, null, null);
        xmlr.next();
        TableResult res = AtomPubParser.parseEntity(xmlr, clazzType, resolver, opContext);
        res.setHttpStatusCode(httpStatusCode);
        return res;
    }

    protected static HashMap<String, EntityProperty> readProperties(XMLStreamReader xmlr, OperationContext opContext) throws XMLStreamException, ParseException {
        int eventType = xmlr.getEventType();
        xmlr.require(1, null, "properties");
        HashMap<String, EntityProperty> properties = new HashMap<String, EntityProperty>();
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType == 4) {
                xmlr.getText();
                continue;
            }
            if (eventType == 1 && xmlr.getNamespaceURI().equals("http://schemas.microsoft.com/ado/2007/08/dataservices")) {
                String key = xmlr.getLocalName();
                String val = "";
                String edmType = null;
                if (xmlr.getAttributeCount() > 0) {
                    edmType = xmlr.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "type");
                }
                if ((eventType = xmlr.next()) == 4) {
                    val = xmlr.getText();
                    eventType = xmlr.next();
                }
                xmlr.require(2, null, key);
                EntityProperty newProp = new EntityProperty(val, EdmType.parse(edmType));
                properties.put(key, newProp);
                continue;
            }
            if (eventType != 2 || !xmlr.getName().toString().equals("{http://schemas.microsoft.com/ado/2007/08/dataservices/metadata}properties")) continue;
        }
        xmlr.require(2, null, "properties");
        return properties;
    }

    protected static void writeEntityToStream(TableEntity entity, boolean isTableEntry, XMLStreamWriter xmlw, OperationContext opContext) throws XMLStreamException, StorageException {
        HashMap<String, EntityProperty> properties = entity.writeEntity(opContext);
        if (properties == null) {
            throw new IllegalArgumentException("Entity did not produce properties to serialize");
        }
        if (!isTableEntry) {
            Utility.assertNotNull("PartitionKey", entity.getPartitionKey());
            Utility.assertNotNull("RowKey", entity.getRowKey());
            Utility.assertNotNull("Timestamp", entity.getTimestamp());
        }
        xmlw.writeStartElement("entry");
        xmlw.writeNamespace("d", "http://schemas.microsoft.com/ado/2007/08/dataservices");
        xmlw.writeNamespace("m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata");
        xmlw.writeNamespace(null, "http://www.w3.org/2005/Atom");
        xmlw.writeStartElement("content");
        xmlw.writeAttribute("type", "application/xml");
        xmlw.writeStartElement("m", "properties", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata");
        if (!isTableEntry) {
            xmlw.writeStartElement("d", "PartitionKey", "http://schemas.microsoft.com/ado/2007/08/dataservices");
            xmlw.writeAttribute("xml", "xml", "space", "preserve");
            xmlw.writeCharacters(entity.getPartitionKey());
            xmlw.writeEndElement();
            xmlw.writeStartElement("d", "RowKey", "http://schemas.microsoft.com/ado/2007/08/dataservices");
            xmlw.writeAttribute("xml", "xml", "space", "preserve");
            xmlw.writeCharacters(entity.getRowKey());
            xmlw.writeEndElement();
            if (entity.getTimestamp() == null) {
                entity.setTimestamp(new Date());
            }
            xmlw.writeStartElement("d", "Timestamp", "http://schemas.microsoft.com/ado/2007/08/dataservices");
            xmlw.writeAttribute("m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "type", EdmType.DATE_TIME.toString());
            xmlw.writeCharacters(Utility.getTimeByZoneAndFormat(entity.getTimestamp(), Utility.UTC_ZONE, "yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'"));
            xmlw.writeEndElement();
        }
        for (Map.Entry<String, EntityProperty> ent : properties.entrySet()) {
            String edmTypeString;
            if (ent.getKey().equals("PartitionKey") || ent.getKey().equals("RowKey") || ent.getKey().equals("Timestamp") || ent.getKey().equals("Etag")) continue;
            EntityProperty currProp = ent.getValue();
            xmlw.writeStartElement("d", ent.getKey(), "http://schemas.microsoft.com/ado/2007/08/dataservices");
            if (currProp.getEdmType() == EdmType.STRING) {
                xmlw.writeAttribute("xml", "xml", "space", "preserve");
            } else if (currProp.getEdmType().toString().length() != 0 && (edmTypeString = currProp.getEdmType().toString()).length() != 0) {
                xmlw.writeAttribute("m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "type", edmTypeString);
            }
            if (currProp.getIsNull()) {
                xmlw.writeAttribute("m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "null", "true");
            }
            xmlw.writeCharacters(currProp.getValueAsString());
            xmlw.writeEndElement();
        }
        xmlw.writeEndElement();
        xmlw.writeEndElement();
        xmlw.writeEndElement();
    }

    protected static void writeSingleEntityToStream(TableEntity entity, boolean isTableEntry, OutputStream outStream, OperationContext opContext) throws XMLStreamException, StorageException {
        XMLStreamWriter xmlw = AtomPubParser.generateTableWriter(outStream);
        AtomPubParser.writeSingleEntityToStream(entity, isTableEntry, xmlw, opContext);
    }

    protected static void writeSingleEntityToStream(TableEntity entity, boolean isTableEntry, XMLStreamWriter xmlw, OperationContext opContext) throws XMLStreamException, StorageException {
        xmlw.writeStartDocument("UTF-8", "1.0");
        AtomPubParser.writeEntityToStream(entity, isTableEntry, xmlw, opContext);
        xmlw.writeEndDocument();
        xmlw.flush();
    }
}

