/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.queue.implementation;

import com.microsoft.windowsazure.services.core.ServiceException;
import com.microsoft.windowsazure.services.core.ServiceFilter;
import com.microsoft.windowsazure.services.core.utils.ServiceExceptionFactory;
import com.microsoft.windowsazure.services.queue.QueueContract;
import com.microsoft.windowsazure.services.queue.implementation.QueueRestProxy;
import com.microsoft.windowsazure.services.queue.models.CreateMessageOptions;
import com.microsoft.windowsazure.services.queue.models.CreateQueueOptions;
import com.microsoft.windowsazure.services.queue.models.GetQueueMetadataResult;
import com.microsoft.windowsazure.services.queue.models.GetServicePropertiesResult;
import com.microsoft.windowsazure.services.queue.models.ListMessagesOptions;
import com.microsoft.windowsazure.services.queue.models.ListMessagesResult;
import com.microsoft.windowsazure.services.queue.models.ListQueuesOptions;
import com.microsoft.windowsazure.services.queue.models.ListQueuesResult;
import com.microsoft.windowsazure.services.queue.models.PeekMessagesOptions;
import com.microsoft.windowsazure.services.queue.models.PeekMessagesResult;
import com.microsoft.windowsazure.services.queue.models.QueueServiceOptions;
import com.microsoft.windowsazure.services.queue.models.ServiceProperties;
import com.microsoft.windowsazure.services.queue.models.UpdateMessageResult;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.util.HashMap;
import javax.inject.Inject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueueExceptionProcessor
implements QueueContract {
    private static Log log = LogFactory.getLog(QueueExceptionProcessor.class);
    private final QueueContract service;

    @Inject
    public QueueExceptionProcessor(QueueRestProxy service) {
        this.service = service;
    }

    public QueueExceptionProcessor(QueueContract service) {
        this.service = service;
    }

    @Override
    public QueueContract withFilter(ServiceFilter filter) {
        return new QueueExceptionProcessor((QueueContract)this.service.withFilter(filter));
    }

    private ServiceException processCatch(ServiceException e) {
        log.warn((Object)e.getMessage(), e.getCause());
        return ServiceExceptionFactory.process("queue", e);
    }

    @Override
    public GetServicePropertiesResult getServiceProperties() throws ServiceException {
        try {
            return this.service.getServiceProperties();
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException(e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException(e));
        }
    }

    @Override
    public GetServicePropertiesResult getServiceProperties(QueueServiceOptions options) throws ServiceException {
        try {
            return this.service.getServiceProperties(options);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException(e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException(e));
        }
    }

    @Override
    public void setServiceProperties(ServiceProperties serviceProperties) throws ServiceException {
        try {
            this.service.setServiceProperties(serviceProperties);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException(e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException(e));
        }
    }

    @Override
    public void setServiceProperties(ServiceProperties serviceProperties, QueueServiceOptions options) throws ServiceException {
        try {
            this.service.setServiceProperties(serviceProperties, options);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException(e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException(e));
        }
    }

    @Override
    public void createQueue(String queue) throws ServiceException {
        try {
            this.service.createQueue(queue);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException(e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException(e));
        }
    }

    @Override
    public void createQueue(String queue, CreateQueueOptions options) throws ServiceException {
        try {
            this.service.createQueue(queue, options);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException(e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException(e));
        }
    }

    @Override
    public void deleteQueue(String queue) throws ServiceException {
        try {
            this.service.deleteQueue(queue);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException(e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException(e));
        }
    }

    @Override
    public void deleteQueue(String queue, QueueServiceOptions options) throws ServiceException {
        try {
            this.service.deleteQueue(queue, options);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException(e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException(e));
        }
    }

    @Override
    public ListQueuesResult listQueues() throws ServiceException {
        try {
            return this.service.listQueues();
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException(e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException(e));
        }
    }

    @Override
    public ListQueuesResult listQueues(ListQueuesOptions options) throws ServiceException {
        try {
            return this.service.listQueues(options);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException(e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException(e));
        }
    }

    @Override
    public GetQueueMetadataResult getQueueMetadata(String queue) throws ServiceException {
        try {
            return this.service.getQueueMetadata(queue);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException(e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException(e));
        }
    }

    @Override
    public GetQueueMetadataResult getQueueMetadata(String queue, QueueServiceOptions options) throws ServiceException {
        try {
            return this.service.getQueueMetadata(queue, options);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException(e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException(e));
        }
    }

    @Override
    public void setQueueMetadata(String queue, HashMap<String, String> metadata) throws ServiceException {
        try {
            this.service.setQueueMetadata(queue, metadata);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException(e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException(e));
        }
    }

    @Override
    public void setQueueMetadata(String queue, HashMap<String, String> metadata, QueueServiceOptions options) throws ServiceException {
        try {
            this.service.setQueueMetadata(queue, metadata, options);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException(e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException(e));
        }
    }

    @Override
    public void createMessage(String queue, String messageText) throws ServiceException {
        try {
            this.service.createMessage(queue, messageText);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException(e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException(e));
        }
    }

    @Override
    public void createMessage(String queue, String messageText, CreateMessageOptions options) throws ServiceException {
        try {
            this.service.createMessage(queue, messageText, options);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException(e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException(e));
        }
    }

    @Override
    public UpdateMessageResult updateMessage(String queue, String messageId, String popReceipt, String messageText, int visibilityTimeoutInSeconds) throws ServiceException {
        try {
            return this.service.updateMessage(queue, messageId, popReceipt, messageText, visibilityTimeoutInSeconds);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException(e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException(e));
        }
    }

    @Override
    public UpdateMessageResult updateMessage(String queue, String messageId, String popReceipt, String messageText, int visibilityTimeoutInSeconds, QueueServiceOptions options) throws ServiceException {
        try {
            return this.service.updateMessage(queue, messageId, popReceipt, messageText, visibilityTimeoutInSeconds, options);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException(e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException(e));
        }
    }

    @Override
    public ListMessagesResult listMessages(String queue) throws ServiceException {
        try {
            return this.service.listMessages(queue);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException(e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException(e));
        }
    }

    @Override
    public ListMessagesResult listMessages(String queue, ListMessagesOptions options) throws ServiceException {
        try {
            return this.service.listMessages(queue, options);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException(e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException(e));
        }
    }

    @Override
    public PeekMessagesResult peekMessages(String queue) throws ServiceException {
        try {
            return this.service.peekMessages(queue);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException(e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException(e));
        }
    }

    @Override
    public PeekMessagesResult peekMessages(String queue, PeekMessagesOptions options) throws ServiceException {
        try {
            return this.service.peekMessages(queue, options);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException(e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException(e));
        }
    }

    @Override
    public void deleteMessage(String queue, String messageId, String popReceipt) throws ServiceException {
        try {
            this.service.deleteMessage(queue, messageId, popReceipt);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException(e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException(e));
        }
    }

    @Override
    public void deleteMessage(String queue, String messageId, String popReceipt, QueueServiceOptions options) throws ServiceException {
        try {
            this.service.deleteMessage(queue, messageId, popReceipt, options);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException(e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException(e));
        }
    }

    @Override
    public void clearMessages(String queue) throws ServiceException {
        try {
            this.service.clearMessages(queue);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException(e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException(e));
        }
    }

    @Override
    public void clearMessages(String queue, QueueServiceOptions options) throws ServiceException {
        try {
            this.service.clearMessages(queue, options);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException(e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException(e));
        }
    }
}

