/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.queue.client;

import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.UriQueryBuilder;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.BaseRequest;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.ListingContext;
import com.microsoft.windowsazure.services.queue.client.QueueListingDetails;
import com.microsoft.windowsazure.services.queue.client.SharedAccessQueuePolicy;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

final class QueueRequest {
    public static void addMetadata(HttpURLConnection request, HashMap<String, String> metadata, OperationContext opContext) {
        BaseRequest.addMetadata(request, metadata, opContext);
    }

    public static HttpURLConnection clearMessages(URI uri, int timeout, OperationContext opContext) throws URISyntaxException, IOException, StorageException {
        HttpURLConnection request = BaseRequest.createURLConnection(uri, timeout, null, opContext);
        request.setRequestMethod("DELETE");
        return request;
    }

    public static HttpURLConnection create(URI uri, int timeout, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        return BaseRequest.create(uri, timeout, null, opContext);
    }

    public static HttpURLConnection delete(URI uri, int timeout, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        return BaseRequest.delete(uri, timeout, null, opContext);
    }

    public static HttpURLConnection deleteMessage(URI uri, int timeout, String popReceipt, OperationContext opContext) throws URISyntaxException, IOException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("popreceipt", popReceipt);
        HttpURLConnection request = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        request.setRequestMethod("DELETE");
        return request;
    }

    public static HttpURLConnection downloadAttributes(URI uri, int timeout, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        return BaseRequest.getMetadata(uri, timeout, null, opContext);
    }

    public static byte[] generateMessageRequestBody(String message) throws XMLStreamException, StorageException {
        StringWriter outWriter = new StringWriter();
        XMLOutputFactory xmlOutFactoryInst = XMLOutputFactory.newInstance();
        XMLStreamWriter xmlw = xmlOutFactoryInst.createXMLStreamWriter(outWriter);
        xmlw.writeStartDocument();
        xmlw.writeStartElement("QueueMessage");
        xmlw.writeStartElement("MessageText");
        xmlw.writeCharacters(message);
        xmlw.writeEndElement();
        xmlw.writeEndElement();
        xmlw.writeEndDocument();
        try {
            return outWriter.toString().getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw Utility.generateNewUnexpectedStorageException(e);
        }
    }

    public static HttpURLConnection list(URI uri, int timeout, ListingContext listingContext, QueueListingDetails detailsIncluded, OperationContext opContext) throws URISyntaxException, IOException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", "list");
        if (listingContext != null) {
            if (!Utility.isNullOrEmpty(listingContext.getPrefix())) {
                builder.add("prefix", listingContext.getPrefix());
            }
            if (!Utility.isNullOrEmpty(listingContext.getMarker())) {
                builder.add("marker", listingContext.getMarker());
            }
            if (listingContext.getMaxResults() != null && listingContext.getMaxResults() > 0) {
                builder.add("maxresults", listingContext.getMaxResults().toString());
            }
        }
        if (detailsIncluded == QueueListingDetails.ALL || detailsIncluded == QueueListingDetails.METADATA) {
            builder.add("include", "metadata");
        }
        HttpURLConnection request = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        request.setRequestMethod("GET");
        return request;
    }

    public static HttpURLConnection peekMessages(URI uri, int timeout, int numberOfMessages, OperationContext opContext) throws URISyntaxException, IOException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("peekonly", "true");
        if (numberOfMessages != 0) {
            builder.add("numofmessages", Integer.toString(numberOfMessages));
        }
        HttpURLConnection request = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        request.setRequestMethod("GET");
        return request;
    }

    public static HttpURLConnection putMessage(URI uri, int timeout, int visibilityTimeoutInSeconds, int timeToLiveInSeconds, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        if (visibilityTimeoutInSeconds != 0) {
            builder.add("visibilitytimeout", Integer.toString(visibilityTimeoutInSeconds));
        }
        if (timeToLiveInSeconds != 0) {
            builder.add("messagettl", Integer.toString(timeToLiveInSeconds));
        }
        HttpURLConnection request = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        request.setDoOutput(true);
        request.setRequestMethod("POST");
        return request;
    }

    public static HttpURLConnection retrieveMessages(URI uri, int timeout, int numberOfMessages, int visibilityTimeoutInSeconds, OperationContext opContext) throws URISyntaxException, IOException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        if (numberOfMessages != 0) {
            builder.add("numofmessages", Integer.toString(numberOfMessages));
        }
        builder.add("visibilitytimeout", Integer.toString(visibilityTimeoutInSeconds));
        HttpURLConnection request = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        request.setRequestMethod("GET");
        return request;
    }

    public static HttpURLConnection setMetadata(URI uri, int timeout, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        return BaseRequest.setMetadata(uri, timeout, null, opContext);
    }

    public static HttpURLConnection updateMessage(URI uri, int timeout, String popReceipt, int visibilityTimeoutInSeconds, OperationContext opContext) throws URISyntaxException, IOException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("popreceipt", popReceipt);
        builder.add("visibilitytimeout", Integer.toString(visibilityTimeoutInSeconds));
        HttpURLConnection request = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        request.setRequestProperty("x-ms-version", "2011-08-18");
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        return request;
    }

    public static HttpURLConnection setAcl(URI uri, int timeout, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", "acl");
        HttpURLConnection request = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        return request;
    }

    public static void writeSharedAccessIdentifiersToStream(HashMap<String, SharedAccessQueuePolicy> sharedAccessPolicies, StringWriter outWriter) throws XMLStreamException {
        Utility.assertNotNull("sharedAccessPolicies", sharedAccessPolicies);
        Utility.assertNotNull("outWriter", outWriter);
        XMLOutputFactory xmlOutFactoryInst = XMLOutputFactory.newInstance();
        XMLStreamWriter xmlw = xmlOutFactoryInst.createXMLStreamWriter(outWriter);
        if (sharedAccessPolicies.keySet().size() > 5) {
            String errorMessage = String.format("Too many %d shared access policy identifiers provided. Server does not support setting more than %d on a single queue.", sharedAccessPolicies.keySet().size(), 5);
            throw new IllegalArgumentException(errorMessage);
        }
        xmlw.writeStartDocument();
        xmlw.writeStartElement("SignedIdentifiers");
        for (Map.Entry<String, SharedAccessQueuePolicy> entry : sharedAccessPolicies.entrySet()) {
            SharedAccessQueuePolicy policy = entry.getValue();
            xmlw.writeStartElement("SignedIdentifier");
            xmlw.writeStartElement("Id");
            xmlw.writeCharacters(entry.getKey());
            xmlw.writeEndElement();
            xmlw.writeStartElement("AccessPolicy");
            xmlw.writeStartElement("Start");
            xmlw.writeCharacters(Utility.getUTCTimeOrEmpty(policy.getSharedAccessStartTime()));
            xmlw.writeEndElement();
            xmlw.writeStartElement("Expiry");
            xmlw.writeCharacters(Utility.getUTCTimeOrEmpty(policy.getSharedAccessExpiryTime()));
            xmlw.writeEndElement();
            xmlw.writeStartElement("Permission");
            xmlw.writeCharacters(SharedAccessQueuePolicy.permissionsToString(policy.getPermissions()));
            xmlw.writeEndElement();
            xmlw.writeEndElement();
            xmlw.writeEndElement();
        }
        xmlw.writeEndElement();
        xmlw.writeEndDocument();
    }

    public static HttpURLConnection getAcl(URI uri, int timeout, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", "acl");
        HttpURLConnection request = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        request.setRequestMethod("GET");
        return request;
    }

    private QueueRequest() {
    }
}

