/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.queue.client;

import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.DeserializationHelper;
import com.microsoft.windowsazure.services.queue.client.CloudQueue;
import com.microsoft.windowsazure.services.queue.client.CloudQueueClient;
import com.microsoft.windowsazure.services.queue.client.CloudQueueMessage;
import com.microsoft.windowsazure.services.queue.client.QueueMessageType;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

final class QueueDeserializationHelper {
    protected static CloudQueueMessage readMessage(XMLStreamReader xmlr, boolean shouldEncodeMessage) throws XMLStreamException, ParseException, URISyntaxException, StorageException {
        xmlr.require(1, null, "QueueMessage");
        CloudQueueMessage message = new CloudQueueMessage();
        message.messageType = shouldEncodeMessage ? QueueMessageType.BASE_64_ENCODED : QueueMessageType.RAW_STRING;
        int eventType = xmlr.getEventType();
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            String name = xmlr.getName().toString();
            if (eventType == 1) {
                if (name.equals("MessageId")) {
                    message.id = Utility.readElementFromXMLReader(xmlr, "MessageId");
                    continue;
                }
                if (name.equals("InsertionTime")) {
                    message.insertionTime = Utility.parseRFC1123DateFromStringInGMT(Utility.readElementFromXMLReader(xmlr, "InsertionTime"));
                    continue;
                }
                if (name.equals("ExpirationTime")) {
                    message.expirationTime = Utility.parseRFC1123DateFromStringInGMT(Utility.readElementFromXMLReader(xmlr, "ExpirationTime"));
                    continue;
                }
                if (name.equals("PopReceipt")) {
                    message.popReceipt = Utility.readElementFromXMLReader(xmlr, "PopReceipt");
                    continue;
                }
                if (name.equals("TimeNextVisible")) {
                    message.nextVisibleTime = Utility.parseRFC1123DateFromStringInGMT(Utility.readElementFromXMLReader(xmlr, "TimeNextVisible"));
                    continue;
                }
                if (name.equals("DequeueCount")) {
                    message.dequeueCount = Integer.parseInt(Utility.readElementFromXMLReader(xmlr, "DequeueCount"));
                    continue;
                }
                if (!name.equals("MessageText")) continue;
                message.messageContent = Utility.readElementFromXMLReader(xmlr, "MessageText");
                continue;
            }
            if (eventType != 2 || !name.equals("QueueMessage")) continue;
            break;
        }
        xmlr.require(2, null, "QueueMessage");
        return message;
    }

    public static ArrayList<CloudQueueMessage> readMessages(InputStream stream, boolean shouldEncodeMessage) throws XMLStreamException, ParseException, URISyntaxException, StorageException {
        XMLStreamReader xmlr = Utility.createXMLStreamReaderFromStream(stream);
        int eventType = xmlr.getEventType();
        xmlr.require(7, null, null);
        eventType = xmlr.next();
        xmlr.require(1, null, "QueueMessagesList");
        ArrayList<CloudQueueMessage> messages = new ArrayList<CloudQueueMessage>();
        eventType = xmlr.next();
        while (eventType == 1 && xmlr.hasName() && "QueueMessage".equals(xmlr.getName().toString())) {
            messages.add(QueueDeserializationHelper.readMessage(xmlr, shouldEncodeMessage));
            eventType = xmlr.next();
        }
        xmlr.require(2, null, "QueueMessagesList");
        return messages;
    }

    protected static CloudQueue readQueue(XMLStreamReader xmlr, CloudQueueClient serviceClient) throws XMLStreamException, ParseException, URISyntaxException, StorageException {
        xmlr.require(1, null, "Queue");
        String queueName = null;
        URI queueUri = null;
        HashMap<String, String> queueMetadata = null;
        int eventType = xmlr.getEventType();
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            String name = xmlr.getName().toString();
            if (eventType == 1) {
                if (name.equals("Url")) {
                    queueUri = new URI(Utility.readElementFromXMLReader(xmlr, "Url"));
                    continue;
                }
                if (name.equals("Name")) {
                    queueName = Utility.readElementFromXMLReader(xmlr, "Name");
                    continue;
                }
                if (!name.equals("Metadata")) continue;
                queueMetadata = DeserializationHelper.parseMetadateFromXML(xmlr);
                xmlr.require(2, null, "Metadata");
                continue;
            }
            if (eventType != 2 || !name.equals("Queue")) continue;
            break;
        }
        CloudQueue queue = new CloudQueue(queueUri, serviceClient);
        queue.setMetadata(queueMetadata);
        queue.setName(queueName);
        xmlr.require(2, null, "Queue");
        return queue;
    }

    public static ArrayList<CloudQueue> readQueues(XMLStreamReader xmlr, CloudQueueClient serviceClient) throws XMLStreamException, ParseException, URISyntaxException, StorageException {
        int eventType = xmlr.getEventType();
        xmlr.require(1, null, "Queues");
        ArrayList<CloudQueue> queues = new ArrayList<CloudQueue>();
        eventType = xmlr.next();
        while (eventType == 1 && xmlr.hasName() && "Queue".equals(xmlr.getName().toString())) {
            queues.add(QueueDeserializationHelper.readQueue(xmlr, serviceClient));
            eventType = xmlr.next();
        }
        xmlr.require(2, null, "Queues");
        return queues;
    }

    private QueueDeserializationHelper() {
    }
}

