/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.queue.client;

import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import com.microsoft.windowsazure.services.queue.client.CloudQueue;
import com.microsoft.windowsazure.services.queue.client.CloudQueueClient;
import com.microsoft.windowsazure.services.queue.client.QueueDeserializationHelper;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

final class ListQueuesResponse {
    private ArrayList<CloudQueue> queues = new ArrayList();
    private boolean isParsed;
    private String marker;
    private int maxResults;
    private String nextMarker;
    private String prefix;
    private final InputStream streamRef;

    public ListQueuesResponse(InputStream stream) {
        this.streamRef = stream;
    }

    public String getMarker() {
        return this.marker;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ArrayList<CloudQueue> getQueues(CloudQueueClient serviceClient) throws XMLStreamException, StorageException {
        if (!this.isParsed) {
            this.parseResponse(serviceClient);
        }
        return this.queues;
    }

    public void parseResponse(CloudQueueClient serviceClient) throws XMLStreamException, StorageException {
        XMLStreamReader xmlr = Utility.createXMLStreamReaderFromStream(this.streamRef);
        String tempParseString = null;
        int eventType = xmlr.getEventType();
        xmlr.require(7, null, null);
        eventType = xmlr.next();
        xmlr.require(1, null, "EnumerationResults");
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType != 1 && eventType != 2) continue;
            String name = xmlr.getName().toString();
            if (eventType == 1 && name.equals("MaxResults")) {
                tempParseString = Utility.readElementFromXMLReader(xmlr, "MaxResults");
                this.maxResults = Integer.parseInt(tempParseString);
                continue;
            }
            if (eventType == 1 && name.equals("Marker")) {
                this.marker = Utility.readElementFromXMLReader(xmlr, "Marker");
                continue;
            }
            if (eventType == 1 && name.equals("NextMarker")) {
                this.nextMarker = Utility.readElementFromXMLReader(xmlr, "NextMarker");
                continue;
            }
            if (eventType == 1 && name.equals("Prefix")) {
                this.prefix = Utility.readElementFromXMLReader(xmlr, "Prefix");
                continue;
            }
            if (eventType == 1 && name.equals("Queues")) {
                try {
                    this.queues = QueueDeserializationHelper.readQueues(xmlr, serviceClient);
                }
                catch (URISyntaxException e) {
                    throw new XMLStreamException(e);
                }
                catch (ParseException e) {
                    throw new XMLStreamException(e);
                }
                xmlr.require(2, null, "Queues");
                continue;
            }
            if (eventType != 2 || !"EnumerationResults".equals(name)) continue;
            break;
        }
        this.isParsed = true;
    }
}

