/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.queue.client;

import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.Base64;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import com.microsoft.windowsazure.services.queue.client.QueueMessageType;
import java.io.UnsupportedEncodingException;
import java.util.Date;

public class CloudQueueMessage {
    protected String id;
    protected String popReceipt;
    protected Date insertionTime;
    protected Date expirationTime;
    protected Date nextVisibleTime;
    protected String messageContent;
    protected int dequeueCount;
    protected QueueMessageType messageType;

    CloudQueueMessage() {
    }

    public CloudQueueMessage(byte[] content) {
        this.setMessageContent(content);
    }

    public CloudQueueMessage(String content) {
        this.setMessageContent(content);
    }

    public final int getDequeueCount() {
        return this.dequeueCount;
    }

    public final Date getExpirationTime() {
        return this.expirationTime;
    }

    public final String getId() {
        return this.id;
    }

    public final Date getInsertionTime() {
        return this.insertionTime;
    }

    public final byte[] getMessageContentAsByte() throws StorageException {
        if (Utility.isNullOrEmpty(this.messageContent)) {
            return new byte[0];
        }
        if (this.messageType == QueueMessageType.RAW_STRING) {
            try {
                return this.messageContent.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException e) {
                throw Utility.generateNewUnexpectedStorageException(e);
            }
        }
        return Base64.decode(this.messageContent);
    }

    public final String getMessageContentAsString() throws StorageException {
        if (this.messageType == QueueMessageType.RAW_STRING) {
            return this.messageContent;
        }
        if (Utility.isNullOrEmpty(this.messageContent)) {
            return null;
        }
        try {
            return new String(Base64.decode(this.messageContent), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw Utility.generateNewUnexpectedStorageException(e);
        }
    }

    protected final String getMessageContentForTransfer(boolean shouldEncodeMessage) throws StorageException {
        String result = null;
        result = this.messageType == QueueMessageType.RAW_STRING && shouldEncodeMessage ? Base64.encode(this.getMessageContentAsByte()) : this.messageContent;
        if (result != null && (long)result.length() > 65536L) {
            throw new IllegalArgumentException(String.format("The message size can't be larger than %s bytes. ", 65536L));
        }
        return result;
    }

    public final Date getNextVisibleTime() {
        return this.nextVisibleTime;
    }

    public final String getPopReceipt() {
        return this.popReceipt;
    }

    public final void setExpirationTime(Date expirationTime) {
        this.expirationTime = expirationTime;
    }

    public final void setMessageContent(byte[] content) {
        Utility.assertNotNull("content", content);
        this.messageContent = Base64.encode(content);
        this.messageType = QueueMessageType.BASE_64_ENCODED;
    }

    public final void setMessageContent(String content) {
        this.messageContent = content;
        this.messageType = QueueMessageType.RAW_STRING;
    }

    public final void setNextVisibleTime(Date nextVisibleTime) {
        this.nextVisibleTime = nextVisibleTime;
    }
}

