/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.queue.client;

import com.microsoft.windowsazure.services.core.storage.DoesServiceRequest;
import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.RequestOptions;
import com.microsoft.windowsazure.services.core.storage.ResultContinuation;
import com.microsoft.windowsazure.services.core.storage.ResultContinuationType;
import com.microsoft.windowsazure.services.core.storage.ResultSegment;
import com.microsoft.windowsazure.services.core.storage.ServiceClient;
import com.microsoft.windowsazure.services.core.storage.ServiceProperties;
import com.microsoft.windowsazure.services.core.storage.StorageCredentials;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.ExecutionEngine;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.LazySegmentedIterable;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.ListingContext;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.SegmentedStorageOperation;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.StorageOperation;
import com.microsoft.windowsazure.services.queue.client.CloudQueue;
import com.microsoft.windowsazure.services.queue.client.ListQueuesResponse;
import com.microsoft.windowsazure.services.queue.client.QueueListingDetails;
import com.microsoft.windowsazure.services.queue.client.QueueRequest;
import com.microsoft.windowsazure.services.queue.client.QueueRequestOptions;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import javax.xml.stream.XMLStreamException;

public final class CloudQueueClient
extends ServiceClient {
    public CloudQueueClient(URI baseUri, StorageCredentials credentials) {
        super(baseUri, credentials);
        this.setTimeoutInMs(30000);
        if (credentials == null) {
            throw new IllegalArgumentException("StorageCredentials can't be null for the queue service.");
        }
    }

    public CloudQueue getQueueReference(String queueAddress) throws URISyntaxException, StorageException {
        Utility.assertNotNullOrEmpty("queueAddress", queueAddress);
        return new CloudQueue(queueAddress, this);
    }

    @DoesServiceRequest
    public Iterable<CloudQueue> listQueues() {
        return this.listQueues(null, QueueListingDetails.NONE, null, null);
    }

    @DoesServiceRequest
    public Iterable<CloudQueue> listQueues(String prefix) {
        return this.listQueues(prefix, QueueListingDetails.NONE, null, null);
    }

    @DoesServiceRequest
    public Iterable<CloudQueue> listQueues(final String prefix, final QueueListingDetails detailsIncluded, QueueRequestOptions options, OperationContext opContext) {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new QueueRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this);
        SegmentedStorageOperation<CloudQueueClient, Void, ResultSegment<CloudQueue>> impl = new SegmentedStorageOperation<CloudQueueClient, Void, ResultSegment<CloudQueue>>((RequestOptions)options, null){

            @Override
            public ResultSegment<CloudQueue> execute(CloudQueueClient client, Void dontCare, OperationContext opContext) throws Exception {
                ResultSegment<CloudQueue> result = CloudQueueClient.this.listQueuesCore(prefix, detailsIncluded, -1, this.getToken(), this.getRequestOptions(), this, opContext);
                this.setToken(result.getContinuationToken());
                return result;
            }
        };
        return new LazySegmentedIterable<CloudQueueClient, Object, CloudQueue>(impl, this, null, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    ResultSegment<CloudQueue> listQueuesCore(String prefix, QueueListingDetails detailsIncluded, int maxResults, ResultContinuation continuationToken, RequestOptions options, StorageOperation<CloudQueueClient, Void, ResultSegment<CloudQueue>> taskReference, OperationContext opContext) throws IOException, URISyntaxException, XMLStreamException, InvalidKeyException, StorageException {
        Utility.assertContinuationType(continuationToken, ResultContinuationType.QUEUE);
        ListingContext listingContext = new ListingContext(prefix, maxResults);
        listingContext.setMarker(continuationToken != null ? continuationToken.getNextMarker() : null);
        HttpURLConnection listQueueRequest = QueueRequest.list(this.getEndpoint(), options.getTimeoutIntervalInMs(), listingContext, detailsIncluded, opContext);
        taskReference.setConnection(listQueueRequest);
        taskReference.signRequest(this, listQueueRequest, -1L, null);
        ExecutionEngine.processRequest(listQueueRequest, opContext, taskReference.getResult());
        if (taskReference.getResult().getStatusCode() != 200) {
            taskReference.setNonExceptionedRetryableFailure(true);
            return null;
        }
        ListQueuesResponse response = new ListQueuesResponse(listQueueRequest.getInputStream());
        response.parseResponse(this);
        ResultContinuation newToken = null;
        if (response.getNextMarker() != null) {
            newToken = new ResultContinuation();
            newToken.setNextMarker(response.getNextMarker());
            newToken.setContinuationType(ResultContinuationType.QUEUE);
        }
        ResultSegment<CloudQueue> resSegment = new ResultSegment<CloudQueue>(response.getQueues(this), maxResults, newToken);
        return resSegment;
    }

    @DoesServiceRequest
    public ResultSegment<CloudQueue> listQueuesSegmented() throws StorageException {
        return this.listQueuesSegmented(null, QueueListingDetails.NONE, 0, null, null, null);
    }

    @DoesServiceRequest
    public ResultSegment<CloudQueue> listQueuesSegmented(String prefix) throws StorageException {
        return this.listQueuesSegmented(prefix, QueueListingDetails.NONE, 0, null, null, null);
    }

    @DoesServiceRequest
    public ResultSegment<CloudQueue> listQueuesSegmented(final String prefix, final QueueListingDetails detailsIncluded, final int maxResults, final ResultContinuation continuationToken, QueueRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new QueueRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this);
        Utility.assertContinuationType(continuationToken, ResultContinuationType.QUEUE);
        StorageOperation<CloudQueueClient, Void, ResultSegment<CloudQueue>> impl = new StorageOperation<CloudQueueClient, Void, ResultSegment<CloudQueue>>((RequestOptions)options){

            @Override
            public ResultSegment<CloudQueue> execute(CloudQueueClient client, Void dontCare, OperationContext opContext) throws Exception {
                return CloudQueueClient.this.listQueuesCore(prefix, detailsIncluded, maxResults, continuationToken, this.getRequestOptions(), this, opContext);
            }
        };
        return ExecutionEngine.executeWithRetry(this, null, impl, options.getRetryPolicyFactory(), opContext);
    }

    @Override
    @DoesServiceRequest
    public void uploadServiceProperties(ServiceProperties properties) throws StorageException {
        this.uploadServiceProperties(properties, null, null);
    }

    @Override
    @DoesServiceRequest
    public void uploadServiceProperties(ServiceProperties properties, RequestOptions options, OperationContext opContext) throws StorageException {
        if (!Utility.isNullOrEmpty(properties.getDefaultServiceVersion())) {
            throw new IllegalArgumentException("DefaultServiceVersion can only be set for the Blob service and the request must be made using the 2011-08-18 version");
        }
        super.uploadServiceProperties(properties, options, opContext);
    }
}

