/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.queue.client;

import com.microsoft.windowsazure.services.blob.core.storage.SharedAccessSignatureHelper;
import com.microsoft.windowsazure.services.core.storage.DoesServiceRequest;
import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.RequestOptions;
import com.microsoft.windowsazure.services.core.storage.ServiceClient;
import com.microsoft.windowsazure.services.core.storage.StorageCredentialsSharedAccessSignature;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.StorageExtendedErrorInformation;
import com.microsoft.windowsazure.services.core.storage.utils.PathUtility;
import com.microsoft.windowsazure.services.core.storage.utils.UriQueryBuilder;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.BaseResponse;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.ExecutionEngine;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.StorageOperation;
import com.microsoft.windowsazure.services.queue.client.CloudQueueClient;
import com.microsoft.windowsazure.services.queue.client.CloudQueueMessage;
import com.microsoft.windowsazure.services.queue.client.MessageUpdateFields;
import com.microsoft.windowsazure.services.queue.client.QueueAccessPolicyResponse;
import com.microsoft.windowsazure.services.queue.client.QueueDeserializationHelper;
import com.microsoft.windowsazure.services.queue.client.QueuePermissions;
import com.microsoft.windowsazure.services.queue.client.QueueRequest;
import com.microsoft.windowsazure.services.queue.client.QueueRequestOptions;
import com.microsoft.windowsazure.services.queue.client.QueueResponse;
import com.microsoft.windowsazure.services.queue.client.SharedAccessQueuePolicy;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;

public final class CloudQueue {
    private String name;
    URI uri;
    CloudQueueClient queueServiceClient;
    HashMap<String, String> metadata;
    long approximateMessageCount;
    private URI messageRequestAddress;
    boolean shouldEncodeMessage;

    static CloudQueueMessage getFirstOrNull(Iterable<CloudQueueMessage> messages) {
        Iterator<CloudQueueMessage> i$ = messages.iterator();
        if (i$.hasNext()) {
            CloudQueueMessage m = i$.next();
            return m;
        }
        return null;
    }

    public CloudQueue(String queueAddress, CloudQueueClient client) throws URISyntaxException, StorageException {
        this(PathUtility.appendPathToUri(client.getEndpoint(), queueAddress), client);
    }

    public CloudQueue(URI uri, CloudQueueClient client) throws URISyntaxException, StorageException {
        this.uri = uri;
        this.name = PathUtility.getQueueNameFromUri(uri, client.isUsePathStyleUris());
        this.queueServiceClient = client;
        this.shouldEncodeMessage = true;
        this.parseQueryAndVerify(this.uri, client, client.isUsePathStyleUris());
    }

    @DoesServiceRequest
    public void addMessage(CloudQueueMessage message) throws StorageException {
        this.addMessage(message, 0, 0, null, null);
    }

    @DoesServiceRequest
    public void addMessage(CloudQueueMessage message, final int timeToLiveInSeconds, final int initialVisibilityDelayInSeconds, QueueRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("message", message);
        Utility.assertNotNull("messageContent", message.getMessageContentAsByte());
        Utility.assertInBounds("timeToLiveInSeconds", timeToLiveInSeconds, 0, 604800);
        int realTimeToLiveInSeconds = timeToLiveInSeconds == 0 ? 604800 : timeToLiveInSeconds;
        Utility.assertInBounds("initialVisibilityDelayInSeconds", initialVisibilityDelayInSeconds, 0, realTimeToLiveInSeconds - 1);
        final String stringToSend = message.getMessageContentForTransfer(this.shouldEncodeMessage);
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new QueueRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.queueServiceClient);
        StorageOperation<CloudQueueClient, CloudQueue, Void> impl = new StorageOperation<CloudQueueClient, CloudQueue, Void>((RequestOptions)options){

            @Override
            public Void execute(CloudQueueClient client, CloudQueue queue, OperationContext opContext) throws Exception {
                HttpURLConnection request = QueueRequest.putMessage(queue.getMessageRequestAddress(opContext), this.getRequestOptions().getTimeoutIntervalInMs(), initialVisibilityDelayInSeconds, timeToLiveInSeconds, opContext);
                this.setConnection(request);
                byte[] messageBytes = QueueRequest.generateMessageRequestBody(stringToSend);
                this.signRequest(client, request, messageBytes.length, null);
                OutputStream outStreamRef = request.getOutputStream();
                outStreamRef.write(messageBytes);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 201) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                return null;
            }
        };
        ExecutionEngine.executeWithRetry(this.queueServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public void clear() throws StorageException {
        this.clear(null, null);
    }

    @DoesServiceRequest
    public void clear(QueueRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new QueueRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.queueServiceClient);
        StorageOperation<CloudQueueClient, CloudQueue, Void> impl = new StorageOperation<CloudQueueClient, CloudQueue, Void>((RequestOptions)options){

            @Override
            public Void execute(CloudQueueClient client, CloudQueue queue, OperationContext opContext) throws Exception {
                HttpURLConnection request = QueueRequest.clearMessages(queue.getMessageRequestAddress(opContext), this.getRequestOptions().getTimeoutIntervalInMs(), opContext);
                this.setConnection(request);
                this.signRequest(client, request, -1L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 204) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }
        };
        ExecutionEngine.executeWithRetry(this.queueServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public void create() throws StorageException {
        this.create(null, null);
    }

    @DoesServiceRequest
    public void create(QueueRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new QueueRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.queueServiceClient);
        StorageOperation<CloudQueueClient, CloudQueue, Void> impl = new StorageOperation<CloudQueueClient, CloudQueue, Void>((RequestOptions)options){

            @Override
            public Void execute(CloudQueueClient client, CloudQueue queue, OperationContext opContext) throws Exception {
                HttpURLConnection request = QueueRequest.create(queue.getTransformedAddress(opContext), this.getRequestOptions().getTimeoutIntervalInMs(), opContext);
                this.setConnection(request);
                QueueRequest.addMetadata(request, queue.metadata, opContext);
                this.signRequest(client, request, 0L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 201 && this.getResult().getStatusCode() != 204) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }
        };
        ExecutionEngine.executeWithRetry(this.queueServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public boolean createIfNotExist() throws StorageException {
        return this.createIfNotExist(null, null);
    }

    @DoesServiceRequest
    public boolean createIfNotExist(QueueRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new QueueRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.queueServiceClient);
        StorageOperation<CloudQueueClient, CloudQueue, Boolean> impl = new StorageOperation<CloudQueueClient, CloudQueue, Boolean>((RequestOptions)options){

            @Override
            public Boolean execute(CloudQueueClient client, CloudQueue queue, OperationContext opContext) throws Exception {
                HttpURLConnection request = QueueRequest.create(queue.getTransformedAddress(opContext), this.getRequestOptions().getTimeoutIntervalInMs(), opContext);
                this.setConnection(request);
                QueueRequest.addMetadata(request, queue.metadata, opContext);
                this.signRequest(client, request, 0L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() == 201) {
                    return true;
                }
                if (this.getResult().getStatusCode() == 204) {
                    return false;
                }
                if (this.getResult().getStatusCode() == 409) {
                    StorageException potentialConflictException = StorageException.translateException(request, null, opContext);
                    StorageExtendedErrorInformation extendedInfo = potentialConflictException.getExtendedErrorInformation();
                    if (extendedInfo == null) {
                        throw potentialConflictException;
                    }
                    if (!extendedInfo.getErrorCode().equals("QueueAlreadyExists")) {
                        this.setException(potentialConflictException);
                        this.setNonExceptionedRetryableFailure(true);
                    }
                } else {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return false;
            }
        };
        return ExecutionEngine.executeWithRetry(this.queueServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public void delete() throws StorageException {
        this.delete(null, null);
    }

    @DoesServiceRequest
    public void delete(QueueRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new QueueRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.queueServiceClient);
        StorageOperation<CloudQueueClient, CloudQueue, Void> impl = new StorageOperation<CloudQueueClient, CloudQueue, Void>((RequestOptions)options){

            @Override
            public Void execute(CloudQueueClient client, CloudQueue queue, OperationContext opContext) throws Exception {
                HttpURLConnection request = QueueRequest.delete(queue.getTransformedAddress(opContext), this.getRequestOptions().getTimeoutIntervalInMs(), opContext);
                this.setConnection(request);
                this.signRequest(client, request, -1L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 204) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }
        };
        ExecutionEngine.executeWithRetry(this.queueServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public boolean deleteIfExists() throws StorageException {
        return this.deleteIfExists(null, null);
    }

    @DoesServiceRequest
    public boolean deleteIfExists(QueueRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new QueueRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.queueServiceClient);
        StorageOperation<CloudQueueClient, CloudQueue, Boolean> impl = new StorageOperation<CloudQueueClient, CloudQueue, Boolean>((RequestOptions)options){

            @Override
            public Boolean execute(CloudQueueClient client, CloudQueue queue, OperationContext opContext) throws Exception {
                HttpURLConnection request = QueueRequest.delete(queue.getTransformedAddress(opContext), this.getRequestOptions().getTimeoutIntervalInMs(), opContext);
                this.setConnection(request);
                this.signRequest(client, request, -1L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() == 204) {
                    return true;
                }
                if (this.getResult().getStatusCode() == 404) {
                    return false;
                }
                this.setNonExceptionedRetryableFailure(true);
                return false;
            }
        };
        return ExecutionEngine.executeWithRetry(this.queueServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public void deleteMessage(CloudQueueMessage message) throws StorageException {
        this.deleteMessage(message, null, null);
    }

    @DoesServiceRequest
    public void deleteMessage(CloudQueueMessage message, QueueRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("message", message);
        Utility.assertNotNullOrEmpty("messageId", message.id);
        Utility.assertNotNullOrEmpty("popReceipt", message.popReceipt);
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new QueueRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.queueServiceClient);
        final String messageId = message.getId();
        final String messagePopReceipt = message.getPopReceipt();
        StorageOperation<CloudQueueClient, CloudQueue, Void> impl = new StorageOperation<CloudQueueClient, CloudQueue, Void>((RequestOptions)options){

            @Override
            public Void execute(CloudQueueClient client, CloudQueue queue, OperationContext opContext) throws Exception {
                HttpURLConnection request = QueueRequest.deleteMessage(queue.getIndividualMessageAddress(messageId, opContext), this.getRequestOptions().getTimeoutIntervalInMs(), messagePopReceipt, opContext);
                this.setConnection(request);
                this.signRequest(client, request, -1L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 204) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }
        };
        ExecutionEngine.executeWithRetry(this.queueServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public void downloadAttributes() throws StorageException {
        this.downloadAttributes(null, null);
    }

    @DoesServiceRequest
    public void downloadAttributes(QueueRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new QueueRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.queueServiceClient);
        StorageOperation<CloudQueueClient, CloudQueue, Void> impl = new StorageOperation<CloudQueueClient, CloudQueue, Void>((RequestOptions)options){

            @Override
            public Void execute(CloudQueueClient client, CloudQueue queue, OperationContext opContext) throws Exception {
                HttpURLConnection request = QueueRequest.downloadAttributes(queue.getTransformedAddress(opContext), this.getRequestOptions().getTimeoutIntervalInMs(), opContext);
                this.setConnection(request);
                this.signRequest(client, request, -1L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                queue.metadata = BaseResponse.getMetadata(request);
                queue.approximateMessageCount = QueueResponse.getApproximateMessageCount(request);
                return null;
            }
        };
        ExecutionEngine.executeWithRetry(this.queueServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public boolean exists() throws StorageException {
        return this.exists(null, null);
    }

    @DoesServiceRequest
    public boolean exists(QueueRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new QueueRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.queueServiceClient);
        StorageOperation<CloudQueueClient, CloudQueue, Boolean> impl = new StorageOperation<CloudQueueClient, CloudQueue, Boolean>((RequestOptions)options){

            @Override
            public Boolean execute(CloudQueueClient client, CloudQueue queue, OperationContext opContext) throws Exception {
                HttpURLConnection request = QueueRequest.downloadAttributes(queue.getTransformedAddress(opContext), this.getRequestOptions().getTimeoutIntervalInMs(), opContext);
                this.setConnection(request);
                this.signRequest(client, request, -1L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() == 200) {
                    return true;
                }
                if (this.getResult().getStatusCode() == 404) {
                    return false;
                }
                this.setNonExceptionedRetryableFailure(true);
                return false;
            }
        };
        return ExecutionEngine.executeWithRetry(this.queueServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    public long getApproximateMessageCount() {
        return this.approximateMessageCount;
    }

    URI getIndividualMessageAddress(String messageId, OperationContext opContext) throws URISyntaxException, StorageException {
        return PathUtility.appendPathToUri(this.getMessageRequestAddress(opContext), messageId);
    }

    URI getMessageRequestAddress(OperationContext opContext) throws URISyntaxException, StorageException {
        if (this.messageRequestAddress == null) {
            this.messageRequestAddress = PathUtility.appendPathToUri(this.getTransformedAddress(opContext), "messages");
        }
        return this.messageRequestAddress;
    }

    public HashMap<String, String> getMetadata() {
        return this.metadata;
    }

    public String getName() {
        return this.name;
    }

    public CloudQueueClient getServiceClient() {
        return this.queueServiceClient;
    }

    public boolean getShouldEncodeMessage() {
        return this.shouldEncodeMessage;
    }

    public URI getUri() {
        return this.uri;
    }

    @DoesServiceRequest
    public CloudQueueMessage peekMessage() throws StorageException {
        return this.peekMessage(null, null);
    }

    @DoesServiceRequest
    public CloudQueueMessage peekMessage(QueueRequestOptions options, OperationContext opContext) throws StorageException {
        return CloudQueue.getFirstOrNull(this.peekMessages(1, null, null));
    }

    @DoesServiceRequest
    public Iterable<CloudQueueMessage> peekMessages(int numberOfMessages) throws StorageException {
        return this.peekMessages(numberOfMessages, null, null);
    }

    @DoesServiceRequest
    public Iterable<CloudQueueMessage> peekMessages(final int numberOfMessages, QueueRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertInBounds("numberOfMessages", numberOfMessages, 1, 32);
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new QueueRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.queueServiceClient);
        StorageOperation<CloudQueueClient, CloudQueue, ArrayList<CloudQueueMessage>> impl = new StorageOperation<CloudQueueClient, CloudQueue, ArrayList<CloudQueueMessage>>((RequestOptions)options){

            @Override
            public ArrayList<CloudQueueMessage> execute(CloudQueueClient client, CloudQueue queue, OperationContext opContext) throws Exception {
                HttpURLConnection request = QueueRequest.peekMessages(queue.getMessageRequestAddress(opContext), this.getRequestOptions().getTimeoutIntervalInMs(), numberOfMessages, opContext);
                this.setConnection(request);
                this.signRequest(client, request, -1L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                return QueueDeserializationHelper.readMessages(request.getInputStream(), queue.shouldEncodeMessage);
            }
        };
        return ExecutionEngine.executeWithRetry(this.queueServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public CloudQueueMessage retrieveMessage() throws StorageException {
        return this.retrieveMessage(30, null, null);
    }

    @DoesServiceRequest
    public CloudQueueMessage retrieveMessage(int visibilityTimeoutInSeconds, QueueRequestOptions options, OperationContext opContext) throws StorageException {
        return CloudQueue.getFirstOrNull(this.retrieveMessages(1, visibilityTimeoutInSeconds, options, opContext));
    }

    @DoesServiceRequest
    public Iterable<CloudQueueMessage> retrieveMessages(int numberOfMessages) throws StorageException {
        return this.retrieveMessages(numberOfMessages, 30, null, null);
    }

    @DoesServiceRequest
    public Iterable<CloudQueueMessage> retrieveMessages(final int numberOfMessages, final int visibilityTimeoutInSeconds, QueueRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertInBounds("numberOfMessages", numberOfMessages, 1, 32);
        Utility.assertInBounds("visibilityTimeoutInSeconds", visibilityTimeoutInSeconds, 0, 604800);
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new QueueRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.queueServiceClient);
        StorageOperation<CloudQueueClient, CloudQueue, ArrayList<CloudQueueMessage>> impl = new StorageOperation<CloudQueueClient, CloudQueue, ArrayList<CloudQueueMessage>>((RequestOptions)options){

            @Override
            public ArrayList<CloudQueueMessage> execute(CloudQueueClient client, CloudQueue queue, OperationContext opContext) throws Exception {
                HttpURLConnection request = QueueRequest.retrieveMessages(queue.getMessageRequestAddress(opContext), this.getRequestOptions().getTimeoutIntervalInMs(), numberOfMessages, visibilityTimeoutInSeconds, opContext);
                this.setConnection(request);
                this.signRequest(client, request, -1L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                return QueueDeserializationHelper.readMessages(request.getInputStream(), queue.shouldEncodeMessage);
            }
        };
        return ExecutionEngine.executeWithRetry(this.queueServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    public void setMetadata(HashMap<String, String> metadata) {
        this.metadata = metadata;
    }

    public void setShouldEncodeMessage(boolean shouldEncodeMessage) {
        this.shouldEncodeMessage = shouldEncodeMessage;
    }

    void setName(String name) {
        this.name = name;
    }

    public void updateMessage(CloudQueueMessage message, int visibilityTimeoutInSeconds) throws StorageException {
        this.updateMessage(message, visibilityTimeoutInSeconds, EnumSet.of(MessageUpdateFields.VISIBILITY), null, null);
    }

    @DoesServiceRequest
    public void updateMessage(final CloudQueueMessage message, final int visibilityTimeoutInSeconds, final EnumSet<MessageUpdateFields> messageUpdateFields, QueueRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("message", message);
        Utility.assertNotNullOrEmpty("messageId", message.id);
        Utility.assertNotNullOrEmpty("popReceipt", message.popReceipt);
        Utility.assertInBounds("visibilityTimeoutInSeconds", visibilityTimeoutInSeconds, 0, 604800);
        final String stringToSend = message.getMessageContentForTransfer(this.shouldEncodeMessage);
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new QueueRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.queueServiceClient);
        StorageOperation<CloudQueueClient, CloudQueue, Void> impl = new StorageOperation<CloudQueueClient, CloudQueue, Void>((RequestOptions)options){

            @Override
            public Void execute(CloudQueueClient client, CloudQueue queue, OperationContext opContext) throws Exception {
                HttpURLConnection request = QueueRequest.updateMessage(queue.getIndividualMessageAddress(message.getId(), opContext), this.getRequestOptions().getTimeoutIntervalInMs(), message.getPopReceipt(), visibilityTimeoutInSeconds, opContext);
                this.setConnection(request);
                if (messageUpdateFields.contains((Object)MessageUpdateFields.CONTENT)) {
                    byte[] messageBytes = QueueRequest.generateMessageRequestBody(stringToSend);
                    this.signRequest(client, request, messageBytes.length, null);
                    OutputStream outStreamRef = request.getOutputStream();
                    outStreamRef.write(messageBytes);
                } else {
                    request.setFixedLengthStreamingMode(0);
                    this.signRequest(client, request, 0L, null);
                }
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 204) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                message.popReceipt = request.getHeaderField("x-ms-popreceipt");
                message.nextVisibleTime = Utility.parseRFC1123DateFromStringInGMT(request.getHeaderField("x-ms-time-next-visible"));
                return null;
            }
        };
        ExecutionEngine.executeWithRetry(this.queueServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public void uploadMetadata() throws StorageException {
        this.uploadMetadata(null, null);
    }

    @DoesServiceRequest
    public void uploadMetadata(QueueRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new QueueRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.queueServiceClient);
        StorageOperation<CloudQueueClient, CloudQueue, Void> impl = new StorageOperation<CloudQueueClient, CloudQueue, Void>((RequestOptions)options){

            @Override
            public Void execute(CloudQueueClient client, CloudQueue queue, OperationContext opContext) throws Exception {
                HttpURLConnection request = QueueRequest.setMetadata(queue.getTransformedAddress(opContext), this.getRequestOptions().getTimeoutIntervalInMs(), opContext);
                this.setConnection(request);
                QueueRequest.addMetadata(request, queue.metadata, opContext);
                this.signRequest(client, request, 0L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 204) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }
        };
        ExecutionEngine.executeWithRetry(this.queueServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public void uploadPermissions(QueuePermissions permissions) throws StorageException {
        this.uploadPermissions(permissions, null, null);
    }

    @DoesServiceRequest
    public void uploadPermissions(final QueuePermissions permissions, QueueRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new QueueRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.queueServiceClient);
        StorageOperation<CloudQueueClient, CloudQueue, Void> impl = new StorageOperation<CloudQueueClient, CloudQueue, Void>((RequestOptions)options){

            @Override
            public Void execute(CloudQueueClient client, CloudQueue queue, OperationContext opContext) throws Exception {
                HttpURLConnection request = QueueRequest.setAcl(queue.getTransformedAddress(opContext), this.getRequestOptions().getTimeoutIntervalInMs(), opContext);
                this.setConnection(request);
                StringWriter outBuffer = new StringWriter();
                QueueRequest.writeSharedAccessIdentifiersToStream(permissions.getSharedAccessPolicies(), outBuffer);
                byte[] aclBytes = outBuffer.toString().getBytes("UTF8");
                this.signRequest(client, request, aclBytes.length, null);
                OutputStream outStreamRef = request.getOutputStream();
                outStreamRef.write(aclBytes);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 204) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }
        };
        ExecutionEngine.executeWithRetry(this.queueServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public QueuePermissions downloadPermissions() throws StorageException {
        return this.downloadPermissions(null, null);
    }

    @DoesServiceRequest
    public QueuePermissions downloadPermissions(QueueRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new QueueRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.queueServiceClient);
        StorageOperation<CloudQueueClient, CloudQueue, QueuePermissions> impl = new StorageOperation<CloudQueueClient, CloudQueue, QueuePermissions>((RequestOptions)options){

            @Override
            public QueuePermissions execute(CloudQueueClient client, CloudQueue queue, OperationContext opContext) throws Exception {
                HttpURLConnection request = QueueRequest.getAcl(queue.getTransformedAddress(opContext), this.getRequestOptions().getTimeoutIntervalInMs(), opContext);
                this.setConnection(request);
                this.signRequest(client, request, -1L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                QueuePermissions permissions = new QueuePermissions();
                QueueAccessPolicyResponse response = new QueueAccessPolicyResponse(request.getInputStream());
                for (String key : response.getAccessIdentifiers().keySet()) {
                    permissions.getSharedAccessPolicies().put(key, (SharedAccessQueuePolicy)response.getAccessIdentifiers().get(key));
                }
                return permissions;
            }
        };
        return ExecutionEngine.executeWithRetry(this.queueServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    public String generateSharedAccessSignature(SharedAccessQueuePolicy policy, String groupPolicyIdentifier) throws InvalidKeyException, StorageException {
        if (!this.queueServiceClient.getCredentials().canCredentialsSignRequest()) {
            String errorMessage = "Cannot create Shared Access Signature unless the Account Key credentials are used by the QueueServiceClient.";
            throw new IllegalArgumentException("Cannot create Shared Access Signature unless the Account Key credentials are used by the QueueServiceClient.");
        }
        String resourceName = this.getSharedAccessCanonicalName();
        String signature = SharedAccessSignatureHelper.generateSharedAccessSignatureHash(policy, groupPolicyIdentifier, resourceName, (ServiceClient)this.queueServiceClient, null);
        UriQueryBuilder builder = SharedAccessSignatureHelper.generateSharedAccessSignature(policy, groupPolicyIdentifier, signature);
        return builder.toString();
    }

    private String getSharedAccessCanonicalName() {
        if (this.queueServiceClient.isUsePathStyleUris()) {
            return this.getUri().getPath();
        }
        return PathUtility.getCanonicalPathFromCredentials(this.queueServiceClient.getCredentials(), this.getUri().getPath());
    }

    protected final URI getTransformedAddress(OperationContext opContext) throws URISyntaxException, StorageException {
        if (this.queueServiceClient.getCredentials().doCredentialsNeedTransformUri()) {
            if (this.getUri().isAbsolute()) {
                return this.queueServiceClient.getCredentials().transformUri(this.getUri(), opContext);
            }
            StorageException ex = Utility.generateNewUnexpectedStorageException(null);
            ex.getExtendedErrorInformation().setErrorMessage("Queue Object relative URIs not supported.");
            throw ex;
        }
        return this.getUri();
    }

    private void parseQueryAndVerify(URI completeUri, CloudQueueClient existingClient, boolean usePathStyleUris) throws URISyntaxException, StorageException {
        Utility.assertNotNull("completeUri", completeUri);
        if (!completeUri.isAbsolute()) {
            String errorMessage = String.format("Address '%s' is not an absolute address. Relative addresses are not permitted in here.", completeUri.toString());
            throw new IllegalArgumentException(errorMessage);
        }
        this.uri = PathUtility.stripURIQueryAndFragment(completeUri);
        HashMap<String, String[]> queryParameters = PathUtility.parseQueryString(completeUri.getQuery());
        StorageCredentialsSharedAccessSignature sasCreds = SharedAccessSignatureHelper.parseQuery(queryParameters);
        if (sasCreds == null) {
            return;
        }
        Boolean sameCredentials = existingClient == null ? false : Utility.areCredentialsEqual(sasCreds, existingClient.getCredentials());
        if (existingClient == null || !sameCredentials.booleanValue()) {
            this.queueServiceClient = new CloudQueueClient(new URI(PathUtility.getServiceClientBaseAddress(this.getUri(), usePathStyleUris)), sasCreds);
        }
        if (existingClient != null && !sameCredentials.booleanValue()) {
            this.queueServiceClient.setRetryPolicyFactory(existingClient.getRetryPolicyFactory());
            this.queueServiceClient.setTimeoutInMs(existingClient.getTimeoutInMs());
        }
    }
}

