/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.implementation;

import com.microsoft.windowsazure.services.core.IdempotentClientFilter;
import com.microsoft.windowsazure.services.core.ServiceException;
import com.microsoft.windowsazure.services.media.implementation.OAuthTokenManager;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import java.net.URISyntaxException;

public class OAuthFilter
extends IdempotentClientFilter {
    private final OAuthTokenManager oAuthTokenManager;

    public OAuthFilter(OAuthTokenManager oAuthTokenManager) {
        this.oAuthTokenManager = oAuthTokenManager;
    }

    @Override
    public ClientResponse doHandle(ClientRequest clientRequest) {
        String accessToken;
        try {
            accessToken = this.oAuthTokenManager.getAccessToken();
        }
        catch (ServiceException e) {
            throw new ClientHandlerException((Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new ClientHandlerException((Throwable)e);
        }
        clientRequest.getHeaders().add((Object)"Authorization", (Object)("Bearer " + accessToken));
        return this.getNext().handle(clientRequest);
    }
}

