/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.implementation;

import com.microsoft.windowsazure.services.core.ServiceFilter;
import com.microsoft.windowsazure.services.core.UserAgentFilter;
import com.microsoft.windowsazure.services.core.utils.pipeline.ClientConfigSettings;
import com.microsoft.windowsazure.services.media.MediaContract;
import com.microsoft.windowsazure.services.media.WritableBlobContainerContract;
import com.microsoft.windowsazure.services.media.entityoperations.EntityProxyData;
import com.microsoft.windowsazure.services.media.entityoperations.EntityRestProxy;
import com.microsoft.windowsazure.services.media.implementation.MediaBlobContainerWriter;
import com.microsoft.windowsazure.services.media.implementation.OAuthFilter;
import com.microsoft.windowsazure.services.media.implementation.RedirectFilter;
import com.microsoft.windowsazure.services.media.implementation.VersionHeadersFilter;
import com.microsoft.windowsazure.services.media.models.LocatorInfo;
import com.microsoft.windowsazure.services.media.models.LocatorType;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.net.URI;
import java.util.Arrays;
import javax.inject.Inject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MediaRestProxy
extends EntityRestProxy
implements MediaContract {
    static Log log = LogFactory.getLog(MediaContract.class);
    private RedirectFilter redirectFilter;
    private final ClientConfigSettings clientConfigSettings;

    @Inject
    public MediaRestProxy(Client channel, OAuthFilter authFilter, RedirectFilter redirectFilter, VersionHeadersFilter versionHeadersFilter, UserAgentFilter userAgentFilter, ClientConfigSettings clientConfigSettings) {
        super(channel, new ServiceFilter[0]);
        this.clientConfigSettings = clientConfigSettings;
        this.redirectFilter = redirectFilter;
        channel.addFilter((ClientFilter)redirectFilter);
        channel.addFilter((ClientFilter)authFilter);
        channel.addFilter((ClientFilter)versionHeadersFilter);
        channel.addFilter((ClientFilter)userAgentFilter);
    }

    private MediaRestProxy(Client channel, ServiceFilter[] filters, ClientConfigSettings clientConfigSettings) {
        super(channel, filters);
        this.clientConfigSettings = clientConfigSettings;
    }

    @Override
    public MediaContract withFilter(ServiceFilter filter) {
        ServiceFilter[] filters = this.getFilters();
        ServiceFilter[] newFilters = Arrays.copyOf(filters, filters.length + 1);
        newFilters[filters.length] = filter;
        return new MediaRestProxy(this.getChannel(), newFilters, this.clientConfigSettings);
    }

    @Override
    protected EntityProxyData createProxyData() {
        return new EntityProxyData(){

            @Override
            public URI getServiceUri() {
                return MediaRestProxy.this.redirectFilter.getBaseURI();
            }
        };
    }

    @Override
    public WritableBlobContainerContract createBlobWriter(LocatorInfo locator) {
        if (locator.getLocatorType() != LocatorType.SAS) {
            throw new IllegalArgumentException("Can only write to SAS locators");
        }
        LocatorParser p = new LocatorParser(locator);
        return new MediaBlobContainerWriter(this.createUploaderClient(), p.getAccountName(), p.getStorageUri(), p.getContainer(), p.getSASToken());
    }

    private Client createUploaderClient() {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        this.clientConfigSettings.applyConfig((ClientConfig)clientConfig);
        Client client = Client.create((ClientConfig)clientConfig);
        this.clientConfigSettings.applyConfig(client);
        return client;
    }

    private static class LocatorParser {
        URI locatorPath;

        LocatorParser(LocatorInfo locator) {
            this.locatorPath = URI.create(locator.getPath());
        }

        String getAccountName() {
            return this.locatorPath.getHost().split("\\.")[0];
        }

        String getStorageUri() {
            return this.locatorPath.getScheme() + "://" + this.locatorPath.getAuthority();
        }

        String getContainer() {
            return this.locatorPath.getPath().substring(1);
        }

        String getSASToken() {
            return this.locatorPath.getRawQuery();
        }
    }
}

