/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.management.implementation;

import com.microsoft.windowsazure.services.management.implementation.KeyStoreCredential;
import com.microsoft.windowsazure.services.management.implementation.KeyStoreType;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;

public class SSLContextFactory {
    public static SSLContext createSSLContext(KeyStoreCredential keyStoreCredential) throws GeneralSecurityException, IOException {
        if (keyStoreCredential == null) {
            throw new IllegalArgumentException("KeyStoreCredential cannot be null.");
        }
        return SSLContextFactory.create(keyStoreCredential.getKeyStorePath(), keyStoreCredential.getKeystorePassword(), keyStoreCredential.getKeyStoreType());
    }

    public static SSLContext create(String keyStorePath, String keyStorePassword, KeyStoreType keyStoreType) throws GeneralSecurityException, IOException {
        if (keyStorePath == null || keyStorePath.isEmpty()) {
            throw new IllegalArgumentException("The keystore path cannot be null or empty.");
        }
        if (keyStoreType == null) {
            throw new IllegalArgumentException("The type of the keystore cannot be null");
        }
        FileInputStream keyStoreInputStream = new FileInputStream(keyStorePath);
        KeyManager[] keyManagers = SSLContextFactory.getKeyManagers(keyStoreInputStream, keyStorePassword, keyStoreType);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, null, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        ((InputStream)keyStoreInputStream).close();
        return sslContext;
    }

    private static KeyManager[] getKeyManagers(InputStream keyStoreInputStream, String keyStorePassword, KeyStoreType keyStoreType) throws IOException, GeneralSecurityException {
        KeyStore keyStore = KeyStore.getInstance(keyStoreType.name());
        keyStore.load(keyStoreInputStream, keyStorePassword.toCharArray());
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, keyStorePassword.toCharArray());
        return keyManagerFactory.getKeyManagers();
    }
}

