/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.management.implementation;

import com.microsoft.windowsazure.services.core.RFC1123DateConverter;
import com.microsoft.windowsazure.services.core.ServiceFilter;
import com.microsoft.windowsazure.services.core.UserAgentFilter;
import com.microsoft.windowsazure.services.core.utils.pipeline.ClientFilterAdapter;
import com.microsoft.windowsazure.services.core.utils.pipeline.PipelineHelpers;
import com.microsoft.windowsazure.services.management.ManagementContract;
import com.microsoft.windowsazure.services.management.implementation.AffinityGroup;
import com.microsoft.windowsazure.services.management.implementation.AffinityGroups;
import com.microsoft.windowsazure.services.management.implementation.CreateAffinityGroup;
import com.microsoft.windowsazure.services.management.implementation.UpdateAffinityGroup;
import com.microsoft.windowsazure.services.management.models.AffinityGroupInfo;
import com.microsoft.windowsazure.services.management.models.AffinityGroupInfoFactory;
import com.microsoft.windowsazure.services.management.models.AffinityGroupInfoListFactory;
import com.microsoft.windowsazure.services.management.models.CreateAffinityGroupOptions;
import com.microsoft.windowsazure.services.management.models.CreateAffinityGroupResult;
import com.microsoft.windowsazure.services.management.models.DeleteAffinityGroupResult;
import com.microsoft.windowsazure.services.management.models.GetAffinityGroupResult;
import com.microsoft.windowsazure.services.management.models.ListResult;
import com.microsoft.windowsazure.services.management.models.UpdateAffinityGroupOptions;
import com.microsoft.windowsazure.services.management.models.UpdateAffinityGroupResult;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagementRestProxy
implements ManagementContract {
    private Client channel;
    private final String uri;
    private final String subscriptionId;
    private final RFC1123DateConverter rfc1123DateConvert = new RFC1123DateConverter();
    static Log log = LogFactory.getLog(ManagementContract.class);
    ServiceFilter[] filters;

    @Inject
    public ManagementRestProxy(Client channel, @Named(value="management.uri") String uri, @Named(value="management.subscription.id") String subscriptionId, UserAgentFilter userAgentFilter) {
        this.channel = channel;
        this.filters = new ServiceFilter[0];
        this.uri = uri;
        this.subscriptionId = subscriptionId;
        this.channel.addFilter((ClientFilter)userAgentFilter);
    }

    public ManagementRestProxy(Client channel, ServiceFilter[] serviceFilter, String uri, String subscriptionId) {
        this.channel = channel;
        this.filters = serviceFilter;
        this.uri = uri;
        this.subscriptionId = subscriptionId;
    }

    public Client getChannel() {
        return this.channel;
    }

    public void setChannel(Client channel) {
        this.channel = channel;
    }

    private WebResource getResource() {
        WebResource resource = this.getChannel().resource(this.uri);
        for (ServiceFilter filter : this.filters) {
            resource.addFilter((ClientFilter)new ClientFilterAdapter(filter));
        }
        return resource;
    }

    private String getRequestId(ClientResponse clientResponse) {
        return (String)clientResponse.getHeaders().getFirst((Object)"x-ms-request-id");
    }

    @Override
    public ManagementContract withFilter(ServiceFilter filter) {
        ServiceFilter[] newFilters = Arrays.copyOf(this.filters, this.filters.length + 1);
        newFilters[this.filters.length] = filter;
        return new ManagementRestProxy(this.channel, newFilters, this.uri, this.subscriptionId);
    }

    @Override
    public ListResult<AffinityGroupInfo> listAffinityGroups() {
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)this.getResource().path(this.subscriptionId).path("affinitygroups").header("x-ms-version", (Object)"2013-03-01").header("x-ms-client-request-id", (Object)UUID.randomUUID())).get(ClientResponse.class);
        PipelineHelpers.ThrowIfNotSuccess(clientResponse);
        String requestId = this.getRequestId(clientResponse);
        AffinityGroups affinityGroups = (AffinityGroups)clientResponse.getEntity(AffinityGroups.class);
        List<AffinityGroupInfo> affinityGroupInfoList = AffinityGroupInfoListFactory.getItem(affinityGroups);
        return new ListResult<AffinityGroupInfo>(clientResponse.getStatus(), requestId, affinityGroupInfoList);
    }

    @Override
    public CreateAffinityGroupResult createAffinityGroup(CreateAffinityGroupOptions createAffinityGroupOptions) {
        CreateAffinityGroup createAffinityGroup = new CreateAffinityGroup();
        createAffinityGroup.setName(createAffinityGroupOptions.getName());
        createAffinityGroup.setLabel(createAffinityGroupOptions.getLabel());
        createAffinityGroup.setLocation(createAffinityGroupOptions.getLocation());
        if (createAffinityGroupOptions != null) {
            createAffinityGroup.setDescription(createAffinityGroupOptions.getDescription());
        }
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)this.getResource().path(this.subscriptionId).path("affinitygroups").header("x-ms-version", (Object)"2013-03-01").header("x-ms-client-request-id", (Object)UUID.randomUUID().toString())).type("application/xml")).post(ClientResponse.class, (Object)createAffinityGroup);
        CreateAffinityGroupResult createAffinityGroupResult = new CreateAffinityGroupResult(clientResponse.getStatus(), this.getRequestId(clientResponse));
        MultivaluedMap headers = clientResponse.getHeaders();
        createAffinityGroupResult.setLocation((String)headers.getFirst((Object)"Location"));
        createAffinityGroupResult.setRegion((String)headers.getFirst((Object)"x-ms-servedbyregion"));
        createAffinityGroupResult.setServer((String)headers.getFirst((Object)"Server"));
        createAffinityGroupResult.setDate(this.rfc1123DateConvert.parse((String)headers.getFirst((Object)"Date")));
        return createAffinityGroupResult;
    }

    @Override
    public GetAffinityGroupResult getAffinityGroup(String name) {
        ClientResponse clientResponse = (ClientResponse)this.getResource().path(this.subscriptionId).path("affinitygroups").path(name).header("x-ms-version", (Object)"2013-03-01").get(ClientResponse.class);
        PipelineHelpers.ThrowIfError(clientResponse);
        GetAffinityGroupResult getAffinityGroupResult = new GetAffinityGroupResult(clientResponse.getStatus(), this.getRequestId(clientResponse));
        AffinityGroup affinityGroup = (AffinityGroup)clientResponse.getEntity(AffinityGroup.class);
        AffinityGroupInfo affinityGroupInfo = AffinityGroupInfoFactory.getItem(affinityGroup);
        getAffinityGroupResult.setValue(affinityGroupInfo);
        return getAffinityGroupResult;
    }

    @Override
    public DeleteAffinityGroupResult deleteAffinityGroup(String name) {
        ClientResponse clientResponse = (ClientResponse)this.getResource().path(this.subscriptionId).path("affinitygroups").path(name).header("x-ms-version", (Object)"2013-03-01").delete(ClientResponse.class);
        PipelineHelpers.ThrowIfError(clientResponse);
        DeleteAffinityGroupResult deleteAffinityGroupResult = new DeleteAffinityGroupResult(clientResponse.getStatus(), this.getRequestId(clientResponse));
        return deleteAffinityGroupResult;
    }

    @Override
    public UpdateAffinityGroupResult updateAffinityGroup(UpdateAffinityGroupOptions updateAffinityGroupOptions) {
        UpdateAffinityGroup updateAffinityGroup = new UpdateAffinityGroup();
        updateAffinityGroup.setLabel(updateAffinityGroupOptions.getLabel());
        if (updateAffinityGroupOptions != null) {
            updateAffinityGroup.setDescription(updateAffinityGroupOptions.getDescription());
        }
        ClientResponse clientResponse = (ClientResponse)this.getResource().path(this.subscriptionId).path("affinitygroups").path(updateAffinityGroupOptions.getName()).header("x-ms-version", (Object)"2011-02-25").put(ClientResponse.class, (Object)updateAffinityGroup);
        PipelineHelpers.ThrowIfError(clientResponse);
        UpdateAffinityGroupResult updateAffinityGroupResult = new UpdateAffinityGroupResult(clientResponse.getStatus(), this.getRequestId(clientResponse));
        MultivaluedMap headers = clientResponse.getHeaders();
        updateAffinityGroupResult.setRegion((String)headers.getFirst((Object)"x-ms-servedbyregion"));
        updateAffinityGroupResult.setDate(this.rfc1123DateConvert.parse((String)headers.getFirst((Object)"Date")));
        return updateAffinityGroupResult;
    }
}

