/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.management.implementation;

import com.microsoft.windowsazure.services.core.ServiceException;
import com.microsoft.windowsazure.services.core.ServiceFilter;
import com.microsoft.windowsazure.services.core.utils.ServiceExceptionFactory;
import com.microsoft.windowsazure.services.management.ManagementContract;
import com.microsoft.windowsazure.services.management.implementation.ManagementRestProxy;
import com.microsoft.windowsazure.services.management.models.AffinityGroupInfo;
import com.microsoft.windowsazure.services.management.models.CreateAffinityGroupOptions;
import com.microsoft.windowsazure.services.management.models.CreateAffinityGroupResult;
import com.microsoft.windowsazure.services.management.models.DeleteAffinityGroupResult;
import com.microsoft.windowsazure.services.management.models.GetAffinityGroupResult;
import com.microsoft.windowsazure.services.management.models.ListResult;
import com.microsoft.windowsazure.services.management.models.UpdateAffinityGroupOptions;
import com.microsoft.windowsazure.services.management.models.UpdateAffinityGroupResult;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterfaceException;
import javax.inject.Inject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagementExceptionProcessor
implements ManagementContract {
    private final ManagementContract next;
    static Log log = LogFactory.getLog(ManagementContract.class);

    public ManagementExceptionProcessor(ManagementContract next) {
        this.next = next;
    }

    @Inject
    public ManagementExceptionProcessor(ManagementRestProxy next) {
        this.next = next;
    }

    @Override
    public ManagementContract withFilter(ServiceFilter filter) {
        return new ManagementExceptionProcessor((ManagementContract)this.next.withFilter(filter));
    }

    private ServiceException processCatch(ServiceException e) {
        log.warn((Object)e.getMessage(), e.getCause());
        return ServiceExceptionFactory.process("serviceBus", e);
    }

    @Override
    public ListResult<AffinityGroupInfo> listAffinityGroups() throws ServiceException {
        try {
            return this.next.listAffinityGroups();
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException(e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException(e));
        }
    }

    @Override
    public GetAffinityGroupResult getAffinityGroup(String name) throws ServiceException {
        try {
            return this.next.getAffinityGroup(name);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException(e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException(e));
        }
    }

    @Override
    public DeleteAffinityGroupResult deleteAffinityGroup(String name) throws ServiceException {
        try {
            return this.next.deleteAffinityGroup(name);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException(e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException(e));
        }
    }

    @Override
    public CreateAffinityGroupResult createAffinityGroup(CreateAffinityGroupOptions createAffinityGroupOptions) throws ServiceException {
        try {
            return this.next.createAffinityGroup(createAffinityGroupOptions);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException(e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException(e));
        }
    }

    @Override
    public UpdateAffinityGroupResult updateAffinityGroup(UpdateAffinityGroupOptions updateAffinityGroupOptions) throws ServiceException {
        try {
            return this.next.updateAffinityGroup(updateAffinityGroupOptions);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException(e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException(e));
        }
    }
}

