/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.management;

import com.microsoft.windowsazure.services.core.Configuration;

public class ManagementConfiguration {
    public static final String KEYSTORE_PATH = "management.keystore.path";
    public static final String KEYSTORE_PASSWORD = "management.keystore.password";
    public static final String KEYSTORE_TYPE = "management.keystore.type";
    public static final String URI = "management.uri";
    public static final String SUBSCRIPTION_ID = "management.subscription.id";

    public static Configuration configure(String uri, String subscriptionId) {
        return ManagementConfiguration.configure(null, Configuration.getInstance(), uri, subscriptionId, null, null);
    }

    public static Configuration configure(String profile, Configuration configuration, String uri, String subscriptionId, String keyStoreLocation, String keyStorePassword) {
        if (profile == null) {
            profile = "";
        } else if (profile.length() != 0 && !profile.endsWith(".")) {
            profile = profile + ".";
        }
        configuration.setProperty(profile + URI, "https://" + uri);
        configuration.setProperty(profile + SUBSCRIPTION_ID, subscriptionId);
        configuration.setProperty(profile + KEYSTORE_PATH, keyStoreLocation);
        configuration.setProperty(profile + KEYSTORE_PASSWORD, keyStorePassword);
        return configuration;
    }
}

