/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.management;

import com.microsoft.windowsazure.services.core.Builder;
import com.microsoft.windowsazure.services.core.UserAgentFilter;
import com.microsoft.windowsazure.services.core.utils.ExportUtils;
import com.microsoft.windowsazure.services.management.ManagementContract;
import com.microsoft.windowsazure.services.management.implementation.KeyStoreCredential;
import com.microsoft.windowsazure.services.management.implementation.KeyStoreType;
import com.microsoft.windowsazure.services.management.implementation.ManagementExceptionProcessor;
import com.microsoft.windowsazure.services.management.implementation.ManagementRestProxy;
import com.microsoft.windowsazure.services.management.implementation.SSLContextFactory;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;

public class Exports
implements Builder.Exports {
    @Override
    public void register(Builder.Registry registry) {
        registry.add(ManagementContract.class, ManagementExceptionProcessor.class);
        registry.add(ManagementRestProxy.class);
        registry.add(UserAgentFilter.class);
        registry.alter(ManagementContract.class, ClientConfig.class, new Builder.Alteration<ClientConfig>(){

            @Override
            public ClientConfig alter(String profile, ClientConfig clientConfig, Builder builder, Map<String, Object> properties) {
                String keyStorePath = (String)ExportUtils.getPropertyIfExists(profile, properties, "management.keystore.path");
                String keyStorePass = (String)ExportUtils.getPropertyIfExists(profile, properties, "management.keystore.password");
                KeyStoreType keyStoreType = KeyStoreType.valueOf((String)ExportUtils.getPropertyIfExists(profile, properties, "management.keystore.type"));
                KeyStoreCredential keyStoreCredential = null;
                try {
                    keyStoreCredential = new KeyStoreCredential(keyStorePath, keyStorePass, keyStoreType);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                SSLContext sslContext = null;
                try {
                    sslContext = SSLContextFactory.createSSLContext(keyStoreCredential);
                }
                catch (GeneralSecurityException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                clientConfig.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", new HTTPSProperties(new HostnameVerifier(){

                    @Override
                    public boolean verify(String arg0, SSLSession arg1) {
                        return true;
                    }
                }, sslContext));
                return clientConfig;
            }
        });
    }
}

